/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatDropShadowBorder;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatNativeMacLibrary;
import com.formdev.flatlaf.ui.FlatNativeWindowsLibrary;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.MouseInfo;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowFocusListener;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.plaf.basic.BasicComboPopup;

public class FlatPopupFactory
extends PopupFactory {
    static final String KEY_POPUP_USES_NATIVE_BORDER = "FlatLaf.internal.FlatPopupFactory.popupUsesNativeBorder";
    private MethodHandle java8getPopupMethod;
    private MethodHandle java9getPopupMethod;
    private final ArrayList<NonFlashingPopup> stillShownHeavyWeightPopups = new ArrayList();

    @Override
    public Popup getPopup(Component component, Component component2, int n2, int n3) throws IllegalArgumentException {
        Popup popup2;
        Point point = this.fixToolTipLocation(component, component2, n2, n3);
        if (point != null) {
            n2 = point.x;
            n3 = point.y;
        }
        FlatPopupFactory.fixLinuxWaylandJava21focusIssue(component);
        for (Popup popup2 : this.stillShownHeavyWeightPopups) {
            if (((NonFlashingPopup)popup2).delegate == null || popup2.owner != component || ((NonFlashingPopup)popup2).contents != component2 && (!(((NonFlashingPopup)popup2).contents instanceof JToolTip) || !(component2 instanceof JToolTip))) continue;
            this.stillShownHeavyWeightPopups.remove(popup2);
            return FlatPopupFactory.reuseStillShownHeavyWeightPopups(popup2, component2, n2, n3);
        }
        boolean bl2 = FlatPopupFactory.isOptionEnabled(component, component2, "Popup.forceHeavyWeight", "Popup.forceHeavyWeight");
        if (!FlatPopupFactory.isOptionEnabled(component, component2, "Popup.dropShadowPainted", "Popup.dropShadowPainted") || SystemInfo.isProjector || SystemInfo.isWebswing) {
            return new NonFlashingPopup(this.getPopupForScreenOfOwner(component, component2, n2, n3, bl2), component, component2);
        }
        if (SystemInfo.isMacOS || SystemInfo.isLinux) {
            popup2 = new NonFlashingPopup(this.getPopupForScreenOfOwner(component, component2, n2, n3, true), component, component2);
            if (popup2.popupWindow != null && SystemInfo.isMacOS && SystemInfo.osVersion < SystemInfo.toVersion(14, 4, 0, 0) && FlatNativeMacLibrary.isLoaded()) {
                FlatPopupFactory.setupRoundedBorder(popup2.popupWindow, component, component2);
            }
            return popup2;
        }
        if (FlatPopupFactory.isWindows11BorderSupported() && FlatPopupFactory.getBorderCornerRadius(component, component2) > 0) {
            popup2 = new NonFlashingPopup(this.getPopupForScreenOfOwner(component, component2, n2, n3, true), component, component2);
            if (popup2.popupWindow != null) {
                FlatPopupFactory.setupRoundedBorder(popup2.popupWindow, component, component2);
            }
            return popup2;
        }
        if (!bl2 && FlatPopupFactory.overlapsHeavyWeightComponent(component, component2, n2, n3)) {
            bl2 = true;
        }
        popup2 = this.getPopupForScreenOfOwner(component, component2, n2, n3, bl2);
        return component.getGraphicsConfiguration().isTranslucencyCapable() ? new DropShadowPopup(popup2, component, component2) : new NonFlashingPopup(popup2, component, component2);
    }

    private Popup getPopupForScreenOfOwner(Component component, Component component2, int n2, int n3, boolean bl2) throws IllegalArgumentException {
        int n4 = 0;
        while (true) {
            Popup popup = bl2 ? this.getHeavyWeightPopup(component, component2, n2, n3) : super.getPopup(component, component2, n2, n3);
            Window window = SwingUtilities.windowForComponent(component2);
            if (window == null || component == null || window.getGraphicsConfiguration() == component.getGraphicsConfiguration()) {
                return popup;
            }
            if (++n4 > 10) {
                return popup;
            }
            if (window instanceof JWindow) {
                ((JWindow)window).getContentPane().removeAll();
            }
            window.dispose();
        }
    }

    private Popup getHeavyWeightPopup(Component component, Component component2, int n2, int n3) throws IllegalArgumentException {
        try {
            if (SystemInfo.isJava_9_orLater) {
                if (this.java9getPopupMethod == null) {
                    MethodType methodType = MethodType.methodType(Popup.class, Component.class, Component.class, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
                    this.java9getPopupMethod = MethodHandles.lookup().findVirtual(PopupFactory.class, "getPopup", methodType);
                }
                return this.java9getPopupMethod.invoke(this, component, component2, n2, n3, true);
            }
            if (this.java8getPopupMethod == null) {
                Method method = PopupFactory.class.getDeclaredMethod("getPopup", Component.class, Component.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                method.setAccessible(true);
                this.java8getPopupMethod = MethodHandles.lookup().unreflect(method);
            }
            return this.java8getPopupMethod.invoke(this, component, component2, n2, n3, 2);
        }
        catch (Throwable throwable) {
            return super.getPopup(component, component2, n2, n3);
        }
    }

    private static boolean isOptionEnabled(Component component, Component component2, String string, String string2) {
        Object object = FlatPopupFactory.getOption(component, component2, string, string2);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    private static Object getOption(Component component, Component component2, String string, String string2) {
        for (Component component3 : new Component[]{component, component2}) {
            Object object;
            if (!(component3 instanceof JComponent) || (object = ((JComponent)component3).getClientProperty(string)) == null) continue;
            return object;
        }
        return UIManager.get(string2);
    }

    private static NonFlashingPopup reuseStillShownHeavyWeightPopups(NonFlashingPopup nonFlashingPopup, Component component, int n2, int n3) {
        NonFlashingPopup nonFlashingPopup2 = nonFlashingPopup.cloneForReuse();
        nonFlashingPopup2.reset(component, n2, n3);
        return nonFlashingPopup2;
    }

    private Point fixToolTipLocation(Component component, Component component2, int n2, int n3) {
        if (!(component2 instanceof JToolTip) || !this.wasInvokedFromToolTipManager() || this.hasTipLocation(component)) {
            return null;
        }
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo == null) {
            return null;
        }
        Point point = pointerInfo.getLocation();
        Dimension dimension = component2.getPreferredSize();
        Rectangle rectangle = new Rectangle(n2, n3, dimension.width, dimension.height);
        if (!rectangle.contains(point)) {
            return null;
        }
        GraphicsConfiguration graphicsConfiguration = null;
        for (GraphicsDevice n5 : GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration graphicsConfiguration2 = n5.getDefaultConfiguration();
            if (!graphicsConfiguration2.getBounds().contains(point)) continue;
            graphicsConfiguration = graphicsConfiguration2;
            break;
        }
        if (graphicsConfiguration == null) {
            graphicsConfiguration = component.getGraphicsConfiguration();
        }
        if (graphicsConfiguration == null) {
            return null;
        }
        Rectangle rectangle2 = graphicsConfiguration.getBounds();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        int n4 = rectangle2.y + insets.top;
        int n5 = point.y - dimension.height - UIScale.scale(20);
        if (n5 < n4) {
            return null;
        }
        return new Point(n2, n5);
    }

    private boolean wasInvokedFromToolTipManager() {
        return StackUtils.wasInvokedFrom(ToolTipManager.class.getName(), "showTipWindow", 8);
    }

    private boolean hasTipLocation(Component component) {
        MouseEvent mouseEvent;
        if (!(component instanceof JComponent)) {
            return false;
        }
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        if (aWTEvent instanceof MouseEvent) {
            mouseEvent = (MouseEvent)aWTEvent;
        } else {
            PointerInfo pointerInfo = MouseInfo.getPointerInfo();
            if (pointerInfo == null) {
                return false;
            }
            Point point = new Point(pointerInfo.getLocation());
            SwingUtilities.convertPointFromScreen(point, component);
            mouseEvent = new MouseEvent(component, 503, System.currentTimeMillis(), 0, point.x, point.y, 0, false);
        }
        return mouseEvent.getSource() == component && ((JComponent)component).getToolTipLocation(mouseEvent) != null;
    }

    private static boolean isWindows11BorderSupported() {
        return SystemInfo.isWindows_11_orLater && FlatNativeWindowsLibrary.isLoaded();
    }

    private static void setupRoundedBorder(Window window, Component component, Component component2) {
        if (!window.isDisplayable()) {
            window.addNotify();
        }
        int n2 = FlatPopupFactory.getBorderCornerRadius(component, component2);
        float f2 = FlatPopupFactory.getRoundedBorderWidth(component, component2);
        Color color = null;
        if (component2 instanceof JComponent) {
            Border border = ((JComponent)component2).getBorder();
            if ((border = FlatUIUtils.unwrapNonUIResourceBorder(border)) instanceof FlatLineBorder) {
                color = ((FlatLineBorder)border).getLineColor();
            } else if (border instanceof LineBorder) {
                color = ((LineBorder)border).getLineColor();
            } else if (border instanceof EmptyBorder) {
                color = FlatNativeWindowsLibrary.COLOR_NONE;
            }
            ((JComponent)component2).putClientProperty(KEY_POPUP_USES_NATIVE_BORDER, true);
        }
        if (SystemInfo.isWindows) {
            long l2 = FlatNativeWindowsLibrary.getHWND(window);
            int n3 = n2 <= 4 ? 3 : 2;
            FlatNativeWindowsLibrary.setWindowCornerPreference(l2, n3);
            FlatNativeWindowsLibrary.dwmSetWindowAttributeCOLORREF(l2, 34, color);
        } else if (SystemInfo.isMacOS) {
            if (color == null || color == FlatNativeWindowsLibrary.COLOR_NONE) {
                f2 = 0.0f;
            }
            FlatNativeMacLibrary.setWindowRoundedBorder(window, n2, f2, color != null ? color.getRGB() : 0);
        }
    }

    private static void resetWindows11Border(Window window) {
        long l2 = FlatNativeWindowsLibrary.getHWND(window);
        if (l2 == 0L) {
            return;
        }
        FlatNativeWindowsLibrary.setWindowCornerPreference(l2, 1);
    }

    private static int getBorderCornerRadius(Component component, Component component2) {
        String string = component2 instanceof BasicComboPopup ? "ComboBox.borderCornerRadius" : (component2 instanceof JPopupMenu ? "PopupMenu.borderCornerRadius" : (component2 instanceof JToolTip ? "ToolTip.borderCornerRadius" : "Popup.borderCornerRadius"));
        Object object = FlatPopupFactory.getOption(component, component2, "Popup.borderCornerRadius", string);
        return object instanceof Integer ? (Integer)object : 0;
    }

    private static float getRoundedBorderWidth(Component component, Component component2) {
        String string = component2 instanceof BasicComboPopup ? "ComboBox.roundedBorderWidth" : (component2 instanceof JPopupMenu ? "PopupMenu.roundedBorderWidth" : (component2 instanceof JToolTip ? "ToolTip.roundedBorderWidth" : "Popup.roundedBorderWidth"));
        Object object = FlatPopupFactory.getOption(component, component2, "Popup.roundedBorderWidth", string);
        return object instanceof Number ? ((Number)object).floatValue() : 0.0f;
    }

    private static boolean overlapsHeavyWeightComponent(Component component, Component component2, int n2, int n3) {
        if (component == null) {
            return false;
        }
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            return false;
        }
        Rectangle rectangle = new Rectangle(new Point(n2, n3), component2.getPreferredSize());
        return FlatPopupFactory.overlapsHeavyWeightComponent(window, rectangle);
    }

    private static boolean overlapsHeavyWeightComponent(Component component, Rectangle rectangle) {
        if (!component.isVisible() || !rectangle.intersects(component.getBounds())) {
            return false;
        }
        if (!component.isLightweight() && !(component instanceof Window)) {
            return true;
        }
        if (component instanceof Container) {
            Rectangle rectangle2 = new Rectangle(rectangle.x - component.getX(), rectangle.y - component.getY(), rectangle.width, rectangle.height);
            for (Component component2 : ((Container)component).getComponents()) {
                if (!FlatPopupFactory.overlapsHeavyWeightComponent(component2, rectangle2)) continue;
                return true;
            }
        }
        return false;
    }

    private static void fixLinuxWaylandJava21focusIssue(Component component) {
        if (component == null || !SystemInfo.isLinux || SystemInfo.javaVersion < SystemInfo.toVersion(21, 0, 0, 0)) {
            return;
        }
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window == null) {
            return;
        }
        for (WindowFocusListener windowFocusListener : window.getWindowFocusListeners()) {
            if (!"sun.awt.UNIXToolkit$1".equals(windowFocusListener.getClass().getName())) continue;
            window.removeWindowFocusListener(windowFocusListener);
            break;
        }
    }

    private static void showPopupAndFixLocation(Popup popup, Window window) {
        if (window != null) {
            int n2 = window.getX();
            int n3 = window.getY();
            popup.show();
            if (window.getX() != n2 || window.getY() != n3) {
                window.setLocation(n2, n3);
            }
        } else {
            popup.show();
        }
    }

    private class DropShadowPopup
    extends NonFlashingPopup {
        private JComponent lightComp;
        private Border oldBorder;
        private boolean oldOpaque;
        private boolean mediumWeightShown;
        private Panel mediumWeightPanel;
        private JPanel dropShadowPanel;
        private ComponentListener mediumPanelListener;
        private Popup dropShadowDelegate;
        private Window dropShadowWindow;
        private JPanel dropShadowPanel2;
        private Color oldDropShadowWindowBackground;

        DropShadowPopup(Popup popup, Component component, Component component2) {
            super(popup, component, component2);
            Dimension dimension = component2.getPreferredSize();
            if (dimension.width <= 0 || dimension.height <= 0) {
                return;
            }
            if (this.popupWindow != null) {
                this.dropShadowPanel2 = new JPanel();
                this.dropShadowPanel2.setBorder(this.createDropShadowBorder());
                this.dropShadowPanel2.setOpaque(false);
                Dimension dimension2 = this.popupWindow.getPreferredSize();
                Insets insets = this.dropShadowPanel2.getInsets();
                this.dropShadowPanel2.setPreferredSize(new Dimension(dimension2.width + insets.left + insets.right, dimension2.height + insets.top + insets.bottom));
                int n2 = this.popupWindow.getX() - insets.left;
                int n3 = this.popupWindow.getY() - insets.top;
                this.dropShadowDelegate = FlatPopupFactory.this.getPopupForScreenOfOwner(component, this.dropShadowPanel2, n2, n3, true);
                this.dropShadowWindow = SwingUtilities.windowForComponent(this.dropShadowPanel2);
                if (this.dropShadowWindow != null) {
                    this.oldDropShadowWindowBackground = this.dropShadowWindow.getBackground();
                    this.dropShadowWindow.setBackground(new Color(0, true));
                }
                if (FlatPopupFactory.isWindows11BorderSupported()) {
                    FlatPopupFactory.resetWindows11Border(this.popupWindow);
                    if (this.dropShadowWindow != null) {
                        FlatPopupFactory.resetWindows11Border(this.dropShadowWindow);
                    }
                }
            } else {
                this.mediumWeightPanel = (Panel)SwingUtilities.getAncestorOfClass(Panel.class, component2);
                if (this.mediumWeightPanel != null) {
                    this.dropShadowPanel = new JPanel();
                    this.dropShadowPanel.setBorder(this.createDropShadowBorder());
                    this.dropShadowPanel.setOpaque(false);
                    this.dropShadowPanel.setSize(FlatUIUtils.addInsets(this.mediumWeightPanel.getSize(), this.dropShadowPanel.getInsets()));
                } else {
                    Container container = component2.getParent();
                    if (!(container instanceof JComponent)) {
                        return;
                    }
                    this.lightComp = (JComponent)container;
                    this.oldBorder = this.lightComp.getBorder();
                    this.oldOpaque = this.lightComp.isOpaque();
                    this.lightComp.setBorder(this.createDropShadowBorder());
                    this.lightComp.setOpaque(false);
                    this.lightComp.setSize(this.lightComp.getPreferredSize());
                }
            }
        }

        private DropShadowPopup(DropShadowPopup dropShadowPopup) {
            super(dropShadowPopup);
            this.dropShadowDelegate = dropShadowPopup.dropShadowDelegate;
            this.dropShadowWindow = dropShadowPopup.dropShadowWindow;
            this.dropShadowPanel2 = dropShadowPopup.dropShadowPanel2;
            this.oldDropShadowWindowBackground = dropShadowPopup.oldDropShadowWindowBackground;
        }

        @Override
        NonFlashingPopup cloneForReuse() {
            return new DropShadowPopup(this);
        }

        private Border createDropShadowBorder() {
            return new FlatDropShadowBorder(UIManager.getColor("Popup.dropShadowColor"), UIManager.getInsets("Popup.dropShadowInsets"), FlatUIUtils.getUIFloat("Popup.dropShadowOpacity", 0.5f));
        }

        @Override
        void showImpl() {
            if (this.dropShadowDelegate != null) {
                FlatPopupFactory.showPopupAndFixLocation(this.dropShadowDelegate, this.dropShadowWindow);
            }
            if (this.mediumWeightPanel != null) {
                this.showMediumWeightDropShadow();
            }
            super.showImpl();
            if (this.lightComp != null) {
                Insets insets = this.lightComp.getInsets();
                if (insets.left != 0 || insets.top != 0) {
                    this.lightComp.setLocation(this.lightComp.getX() - insets.left, this.lightComp.getY() - insets.top);
                }
            }
        }

        @Override
        void hideImpl() {
            if (this.dropShadowDelegate != null) {
                this.dropShadowDelegate.hide();
                this.dropShadowDelegate = null;
                this.dropShadowPanel2 = null;
            }
            if (this.mediumWeightPanel != null) {
                this.hideMediumWeightDropShadow();
                this.dropShadowPanel = null;
                this.mediumWeightPanel = null;
            }
            super.hideImpl();
            if (this.dropShadowWindow != null) {
                this.dropShadowWindow.setBackground(this.oldDropShadowWindowBackground);
                this.dropShadowWindow = null;
            }
            if (this.lightComp != null) {
                this.lightComp.setBorder(this.oldBorder);
                this.lightComp.setOpaque(this.oldOpaque);
                this.lightComp = null;
            }
        }

        private void showMediumWeightDropShadow() {
            if (this.mediumWeightShown) {
                return;
            }
            this.mediumWeightShown = true;
            if (this.owner == null) {
                return;
            }
            Window window = SwingUtilities.windowForComponent(this.owner);
            if (!(window instanceof RootPaneContainer)) {
                return;
            }
            this.dropShadowPanel.setVisible(false);
            JLayeredPane jLayeredPane = ((RootPaneContainer)((Object)window)).getLayeredPane();
            jLayeredPane.add(this.dropShadowPanel, JLayeredPane.POPUP_LAYER, 0);
            this.moveMediumWeightDropShadow();
            this.resizeMediumWeightDropShadow();
            this.mediumPanelListener = new ComponentListener(){

                @Override
                public void componentShown(ComponentEvent componentEvent) {
                    if (DropShadowPopup.this.dropShadowPanel != null) {
                        DropShadowPopup.this.dropShadowPanel.setVisible(true);
                    }
                }

                @Override
                public void componentHidden(ComponentEvent componentEvent) {
                    if (DropShadowPopup.this.dropShadowPanel != null) {
                        DropShadowPopup.this.dropShadowPanel.setVisible(false);
                    }
                }

                @Override
                public void componentMoved(ComponentEvent componentEvent) {
                    DropShadowPopup.this.moveMediumWeightDropShadow();
                }

                @Override
                public void componentResized(ComponentEvent componentEvent) {
                    DropShadowPopup.this.resizeMediumWeightDropShadow();
                }
            };
            this.mediumWeightPanel.addComponentListener(this.mediumPanelListener);
        }

        private void hideMediumWeightDropShadow() {
            this.mediumWeightPanel.removeComponentListener(this.mediumPanelListener);
            Container container = this.dropShadowPanel.getParent();
            if (container != null) {
                Rectangle rectangle = this.dropShadowPanel.getBounds();
                container.remove(this.dropShadowPanel);
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }

        private void moveMediumWeightDropShadow() {
            if (this.dropShadowPanel != null && this.mediumWeightPanel != null) {
                Point point = this.mediumWeightPanel.getLocation();
                Insets insets = this.dropShadowPanel.getInsets();
                this.dropShadowPanel.setLocation(point.x - insets.left, point.y - insets.top);
            }
        }

        private void resizeMediumWeightDropShadow() {
            if (this.dropShadowPanel != null && this.mediumWeightPanel != null) {
                this.dropShadowPanel.setSize(FlatUIUtils.addInsets(this.mediumWeightPanel.getSize(), this.dropShadowPanel.getInsets()));
            }
        }

        @Override
        void reset(Component component, int n2, int n3) {
            super.reset(component, n2, n3);
            if (this.dropShadowWindow != null) {
                Dimension dimension = this.popupWindow.getPreferredSize();
                Insets insets = this.dropShadowPanel2.getInsets();
                int n4 = dimension.width + insets.left + insets.right;
                int n5 = dimension.height + insets.top + insets.bottom;
                this.dropShadowPanel2.setPreferredSize(new Dimension(n4, n5));
                int n6 = this.popupWindow.getX() - insets.left;
                int n7 = this.popupWindow.getY() - insets.top;
                this.dropShadowWindow.setBounds(n6, n7, n4, n5);
                this.dropShadowWindow.pack();
            }
        }
    }

    private class NonFlashingPopup
    extends Popup {
        private Popup delegate;
        Component owner;
        private Component contents;
        Window popupWindow;
        private Color oldPopupWindowBackground;
        private boolean disposed;

        NonFlashingPopup(Popup popup, Component component, Component component2) {
            this.delegate = popup;
            this.owner = component;
            this.contents = component2;
            this.popupWindow = SwingUtilities.windowForComponent(component2);
            if (this.popupWindow != null) {
                this.oldPopupWindowBackground = this.popupWindow.getBackground();
                this.popupWindow.setBackground(component2.getBackground());
            }
        }

        private NonFlashingPopup(NonFlashingPopup nonFlashingPopup) {
            this.delegate = nonFlashingPopup.delegate;
            this.owner = nonFlashingPopup.owner;
            this.contents = nonFlashingPopup.contents;
            this.popupWindow = nonFlashingPopup.popupWindow;
            this.oldPopupWindowBackground = nonFlashingPopup.oldPopupWindowBackground;
        }

        NonFlashingPopup cloneForReuse() {
            return new NonFlashingPopup(this);
        }

        @Override
        public final void show() {
            if (this.disposed) {
                return;
            }
            this.showImpl();
        }

        void showImpl() {
            if (this.delegate != null) {
                Dimension dimension;
                Container container;
                FlatPopupFactory.showPopupAndFixLocation(this.delegate, this.popupWindow);
                if (this.contents instanceof JToolTip && this.popupWindow == null && (container = this.contents.getParent()) instanceof JPanel && !(dimension = container.getPreferredSize()).equals(container.getSize())) {
                    Container container2 = SwingUtilities.getAncestorOfClass(Panel.class, container);
                    Container container3 = container2 != null ? container2 : container;
                    container3.setSize(dimension);
                    container3.validate();
                }
            }
        }

        @Override
        public final void hide() {
            if (this.disposed) {
                return;
            }
            this.disposed = true;
            if (!(this.popupWindow instanceof JWindow) || this.contents instanceof BasicComboPopup) {
                this.hideImpl();
                return;
            }
            ((JWindow)this.popupWindow).getContentPane().removeAll();
            FlatPopupFactory.this.stillShownHeavyWeightPopups.add(this);
            EventQueue.invokeLater(() -> {
                if (FlatPopupFactory.this.stillShownHeavyWeightPopups.remove(this)) {
                    this.hideImpl();
                }
            });
        }

        void hideImpl() {
            if (this.contents instanceof JComponent) {
                ((JComponent)this.contents).putClientProperty(FlatPopupFactory.KEY_POPUP_USES_NATIVE_BORDER, null);
            }
            if (this.delegate != null) {
                this.delegate.hide();
                this.delegate = null;
                this.owner = null;
                this.contents = null;
            }
            if (this.popupWindow != null) {
                this.popupWindow.setBackground(this.oldPopupWindowBackground);
                this.popupWindow = null;
            }
        }

        void reset(Component component, int n2, int n3) {
            this.popupWindow.setLocation(n2, n3);
            Container container = ((JWindow)this.popupWindow).getContentPane();
            container.removeAll();
            container.add(component, "Center");
            this.popupWindow.invalidate();
            this.popupWindow.validate();
            this.popupWindow.pack();
            if (this.contents != component) {
                Object object;
                Object object2 = object = this.contents instanceof JComponent ? ((JComponent)this.contents).getClientProperty(FlatPopupFactory.KEY_POPUP_USES_NATIVE_BORDER) : null;
                if (component instanceof JComponent) {
                    ((JComponent)component).putClientProperty(FlatPopupFactory.KEY_POPUP_USES_NATIVE_BORDER, object);
                }
                this.contents = component;
            }
        }
    }
}

