/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class FlatProgressBarUI
extends BasicProgressBarUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int arc;
    @FlatStylingSupport.Styleable
    protected Dimension horizontalSize;
    @FlatStylingSupport.Styleable
    protected Dimension verticalSize;
    @FlatStylingSupport.Styleable
    protected boolean largeHeight;
    @FlatStylingSupport.Styleable
    protected boolean square;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatProgressBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        if (!EventQueue.isDispatchThread() && this.progressBar.isIndeterminate()) {
            LoggingFacade.INSTANCE.logSevere("FlatLaf: Uninstalling indeterminate progress bar UI not on AWT thread may throw NPE in FlatProgressBarUI.paint(). Use SwingUtilities.invokeLater().", new IllegalStateException());
        }
        super.uninstallUI(jComponent);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installProperty(this.progressBar, "opaque", false);
        this.arc = UIManager.getInt("ProgressBar.arc");
        this.horizontalSize = UIManager.getDimension("ProgressBar.horizontalSize");
        this.verticalSize = UIManager.getDimension("ProgressBar.verticalSize");
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = propertyChangeEvent -> {
            switch (propertyChangeEvent.getPropertyName()) {
                case "indeterminate": {
                    if (EventQueue.isDispatchThread() || this.progressBar.isIndeterminate()) break;
                    LoggingFacade.INSTANCE.logSevere("FlatLaf: Using JProgressBar.setIndeterminate(false) not on AWT thread may throw NPE in FlatProgressBarUI.paint(). Use SwingUtilities.invokeLater().", new IllegalStateException());
                    break;
                }
                case "JProgressBar.largeHeight": 
                case "JProgressBar.square": {
                    this.progressBar.revalidate();
                    HiDPIUtils.repaint(this.progressBar);
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.progressBar.revalidate();
                    HiDPIUtils.repaint(this.progressBar);
                }
            }
        };
        this.progressBar.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.progressBar.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.progressBar, "ProgressBar"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.progressBar, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (this.progressBar.isStringPainted() || FlatClientProperties.clientPropertyBoolean(jComponent, "JProgressBar.largeHeight", this.largeHeight)) {
            Insets insets = this.progressBar.getInsets();
            FontMetrics fontMetrics = this.progressBar.getFontMetrics(this.progressBar.getFont());
            if (this.progressBar.getOrientation() == 0) {
                dimension.height = Math.max(fontMetrics.getHeight() + insets.top + insets.bottom, this.getPreferredInnerHorizontal().height);
            } else {
                dimension.width = Math.max(fontMetrics.getHeight() + insets.left + insets.right, this.getPreferredInnerVertical().width);
            }
        }
        return dimension;
    }

    @Override
    protected Dimension getPreferredInnerHorizontal() {
        return UIScale.scale(this.horizontalSize);
    }

    @Override
    protected Dimension getPreferredInnerVertical() {
        return UIScale.scale(this.verticalSize);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque()) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        boolean bl2;
        Insets insets = this.progressBar.getInsets();
        int n2 = insets.left;
        int n3 = insets.top;
        int n4 = this.progressBar.getWidth() - (insets.right + insets.left);
        int n5 = this.progressBar.getHeight() - (insets.top + insets.bottom);
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        boolean bl3 = bl2 = this.progressBar.getOrientation() == 0;
        int n6 = FlatClientProperties.clientPropertyBoolean(jComponent, "JProgressBar.square", this.square) ? 0 : Math.min(UIScale.scale(this.arc), bl2 ? n5 : n4);
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        RoundRectangle2D.Float float_ = new RoundRectangle2D.Float(n2, n3, n4, n5, n6, n6);
        graphics.setColor(this.progressBar.getBackground());
        ((Graphics2D)graphics).fill(float_);
        int n7 = 0;
        if (this.progressBar.isIndeterminate()) {
            this.boxRect = this.getBox(this.boxRect);
            if (this.boxRect != null) {
                graphics.setColor(this.progressBar.getForeground());
                ((Graphics2D)graphics).fill(new RoundRectangle2D.Float(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, n6, n6));
            }
        } else {
            n7 = this.getAmountFull(insets, n4, n5);
            RoundRectangle2D.Float float_2 = bl2 ? new RoundRectangle2D.Float(jComponent.getComponentOrientation().isLeftToRight() ? (float)n2 : (float)(n2 + (n4 - n7)), n3, n7, n5, n6, n6) : new RoundRectangle2D.Float(n2, n3 + (n5 - n7), n4, n7, n6, n6);
            graphics.setColor(this.progressBar.getForeground());
            if (n7 < (bl2 ? n5 : n4)) {
                Area area = new Area(float_);
                area.intersect(new Area(float_2));
                ((Graphics2D)graphics).fill(area);
            } else {
                ((Graphics2D)graphics).fill(float_2);
            }
        }
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
        if (this.progressBar.isStringPainted()) {
            this.paintString(graphics, n2, n3, n4, n5, n7, insets);
        }
    }

    @Override
    protected void paintString(Graphics graphics, int n2, int n3, int n4, int n5, int n6, Insets insets) {
        super.paintString(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics), n2, n3, n4, n5, n6, insets);
    }

    @Override
    protected void setAnimationIndex(int n2) {
        super.setAnimationIndex(n2);
        double d2 = UIScale.getSystemScaleFactor(this.progressBar.getGraphicsConfiguration());
        if ((double)((int)d2) != d2) {
            HiDPIUtils.repaint(this.progressBar);
        }
    }
}

