/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatButtonBorder;
import com.formdev.flatlaf.ui.FlatScrollPaneBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.ScrollPaneLayout;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollPaneUI;

public class FlatScrollPaneUI
extends BasicScrollPaneUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Boolean showButtons;
    private Handler handler;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatScrollPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        int n2 = UIManager.getInt("Component.focusWidth");
        int n3 = UIManager.getInt("ScrollPane.arc");
        LookAndFeel.installProperty(jComponent, "opaque", n2 == 0 && n3 == 0);
        LayoutManager layoutManager = jComponent.getLayout();
        if (layoutManager != null && layoutManager.getClass() == ScrollPaneLayout.UIResource.class) {
            jComponent.setLayout(this.createScrollPaneLayout());
        }
        this.installStyle();
        MigLayoutVisualPadding.install(this.scrollpane);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        MigLayoutVisualPadding.uninstall(this.scrollpane);
        if (jComponent.getLayout() instanceof FlatScrollPaneLayout) {
            jComponent.setLayout(new ScrollPaneLayout.UIResource());
        }
        super.uninstallUI(jComponent);
        this.oldStyleValues = null;
        this.borderShared = null;
    }

    @Override
    protected void installListeners(JScrollPane jScrollPane) {
        super.installListeners(jScrollPane);
        this.addViewportListeners(this.scrollpane.getViewport());
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        this.removeViewportListeners(this.scrollpane.getViewport());
        this.handler = null;
    }

    protected FlatScrollPaneLayout createScrollPaneLayout() {
        return new FlatScrollPaneLayout();
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        MouseWheelListener mouseWheelListener = super.createMouseWheelListener();
        return mouseWheelEvent -> {
            if (this.isSmoothScrollingEnabled() && this.scrollpane.isWheelScrollingEnabled() && mouseWheelEvent.getScrollType() == 0 && mouseWheelEvent.getPreciseWheelRotation() != 0.0 && mouseWheelEvent.getPreciseWheelRotation() != (double)mouseWheelEvent.getWheelRotation()) {
                this.mouseWheelMovedSmooth(mouseWheelEvent);
            } else {
                mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
            }
        };
    }

    protected boolean isSmoothScrollingEnabled() {
        Object object = this.scrollpane.getClientProperty("JScrollPane.smoothScrolling");
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return UIManager.getBoolean("ScrollPane.smoothScrolling");
    }

    private void mouseWheelMovedSmooth(MouseWheelEvent mouseWheelEvent) {
        int n2;
        int n3;
        JViewport jViewport = this.scrollpane.getViewport();
        if (jViewport == null) {
            return;
        }
        JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
        if (!(jScrollBar != null && jScrollBar.isVisible() && !mouseWheelEvent.isShiftDown() || (jScrollBar = this.scrollpane.getHorizontalScrollBar()) != null && jScrollBar.isVisible())) {
            return;
        }
        mouseWheelEvent.consume();
        double d2 = mouseWheelEvent.getPreciseWheelRotation();
        int n4 = jScrollBar.getOrientation();
        Component component = jViewport.getView();
        if (component instanceof Scrollable) {
            Scrollable scrollable = (Scrollable)((Object)component);
            Rectangle rectangle = new Rectangle(jViewport.getViewSize());
            n3 = scrollable.getScrollableUnitIncrement(rectangle, n4, 1);
            if (n3 > 0) {
                if (n4 == 1) {
                    rectangle.y += n3;
                    rectangle.height -= n3;
                } else {
                    rectangle.x += n3;
                    rectangle.width -= n3;
                }
                int n5 = scrollable.getScrollableUnitIncrement(rectangle, n4, 1);
                if (n5 > 0) {
                    n3 = Math.min(n3, n5);
                }
            }
        } else {
            int n6 = d2 < 0.0 ? -1 : 1;
            n3 = jScrollBar.getUnitIncrement(n6);
        }
        int n7 = n4 == 1 ? jViewport.getHeight() : jViewport.getWidth();
        int n8 = Math.min(n3 * mouseWheelEvent.getScrollAmount(), n7);
        double d3 = d2 * (double)n8;
        int n9 = (int)Math.round(d3);
        if (n9 == 0) {
            if (d2 > 0.0) {
                n9 = 1;
            } else if (d2 < 0.0) {
                n9 = -1;
            }
        }
        int n10 = jScrollBar.getValue();
        int n11 = jScrollBar.getMinimum();
        int n12 = Math.max(n11, Math.min(n10 + n9, n2 = jScrollBar.getMaximum() - jScrollBar.getModel().getExtent()));
        if (n12 != n10) {
            jScrollBar.setValue(n12);
        }
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            switch (propertyChangeEvent.getPropertyName()) {
                case "JScrollBar.showButtons": {
                    JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
                    JScrollBar jScrollBar2 = this.scrollpane.getHorizontalScrollBar();
                    if (jScrollBar != null) {
                        jScrollBar.revalidate();
                        HiDPIUtils.repaint(jScrollBar);
                    }
                    if (jScrollBar2 == null) break;
                    jScrollBar2.revalidate();
                    HiDPIUtils.repaint(jScrollBar2);
                    break;
                }
                case "LOWER_LEFT_CORNER": 
                case "LOWER_RIGHT_CORNER": 
                case "UPPER_LEFT_CORNER": 
                case "UPPER_RIGHT_CORNER": {
                    Object object = propertyChangeEvent.getNewValue();
                    if (!(object instanceof JButton) || !(((JButton)object).getBorder() instanceof FlatButtonBorder) || !(FlatScrollPaneUI.getView(this.scrollpane) instanceof JTable)) break;
                    ((JButton)object).setBorder(BorderFactory.createEmptyBorder());
                    ((JButton)object).setFocusable(false);
                    break;
                }
                case "JComponent.outline": {
                    HiDPIUtils.repaint(this.scrollpane);
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.scrollpane.revalidate();
                    HiDPIUtils.repaint(this.scrollpane);
                    break;
                }
                case "border": {
                    Object object = propertyChangeEvent.getNewValue();
                    if (object == null || object != UIManager.getBorder("Table.scrollPaneBorder")) break;
                    this.borderShared = null;
                    this.installStyle();
                    this.scrollpane.revalidate();
                    HiDPIUtils.repaint(this.scrollpane);
                }
            }
        };
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.scrollpane, "ScrollPane"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.equals("focusWidth") || string.equals("arc")) {
            int n2 = object instanceof Integer ? (Integer)object : UIManager.getInt("Component.focusWidth");
            int n3 = object instanceof Integer ? (Integer)object : UIManager.getInt("ScrollPane.arc");
            LookAndFeel.installProperty(this.scrollpane, "opaque", n2 == 0 && n3 == 0);
        }
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.scrollpane, this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.scrollpane.getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.scrollpane.getBorder(), string);
    }

    @Override
    protected void updateViewport(PropertyChangeEvent propertyChangeEvent) {
        super.updateViewport(propertyChangeEvent);
        JViewport jViewport = (JViewport)propertyChangeEvent.getOldValue();
        JViewport jViewport2 = (JViewport)propertyChangeEvent.getNewValue();
        this.removeViewportListeners(jViewport);
        this.addViewportListeners(jViewport2);
    }

    private void addViewportListeners(JViewport jViewport) {
        if (jViewport == null) {
            return;
        }
        jViewport.addContainerListener(this.getHandler());
        Component component = jViewport.getView();
        if (component != null) {
            component.addFocusListener(this.getHandler());
        }
    }

    private void removeViewportListeners(JViewport jViewport) {
        if (jViewport == null) {
            return;
        }
        jViewport.removeContainerListener(this.getHandler());
        Component component = jViewport.getView();
        if (component != null) {
            component.removeFocusListener(this.getHandler());
        }
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        float f2;
        Serializable serializable;
        if (jComponent.isOpaque()) {
            FlatUIUtils.paintParentBackground(graphics, jComponent);
            serializable = jComponent.getInsets();
            graphics.setColor(jComponent.getBackground());
            graphics.fillRect(((Insets)serializable).left, ((Insets)serializable).top, jComponent.getWidth() - ((Insets)serializable).left - ((Insets)serializable).right, jComponent.getHeight() - ((Insets)serializable).top - ((Insets)serializable).bottom);
        }
        if ((f2 = FlatScrollPaneUI.getBorderArc(this.scrollpane)) > 0.0f && (serializable = FlatScrollPaneUI.getView(this.scrollpane)) != null) {
            float f3 = FlatUIUtils.getBorderFocusWidth(jComponent);
            graphics.setColor(((Component)serializable).getBackground());
            Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight(), f3, f2);
            FlatUIUtils.resetRenderingHints(graphics, objectArray);
        }
        this.paint(graphics, jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Border border = this.scrollpane.getViewportBorder();
        if (border != null) {
            Rectangle rectangle = this.scrollpane.getViewportBorderBounds();
            int n2 = FlatScrollPaneUI.getBorderLeftRightPadding(this.scrollpane);
            JScrollBar jScrollBar = this.scrollpane.getVerticalScrollBar();
            if (n2 > 0 && jScrollBar != null && jScrollBar.isVisible() && this.scrollpane.getLayout() instanceof FlatScrollPaneLayout && ((FlatScrollPaneLayout)this.scrollpane.getLayout()).canIncreaseViewportWidth(this.scrollpane)) {
                boolean bl2 = this.scrollpane.getComponentOrientation().isLeftToRight();
                int n3 = Math.min(n2, jScrollBar.getWidth());
                border.paintBorder(this.scrollpane, graphics, rectangle.x - (bl2 ? 0 : n3), rectangle.y, rectangle.width + n3, rectangle.height);
            } else {
                border.paintBorder(this.scrollpane, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
    }

    public static boolean isPermanentFocusOwner(JScrollPane jScrollPane) {
        Component component;
        Component component2 = FlatScrollPaneUI.getView(jScrollPane);
        if (component2 == null) {
            return false;
        }
        if (FlatUIUtils.isPermanentFocusOwner(component2)) {
            return true;
        }
        if ((component2 instanceof JTable && ((JTable)component2).isEditing() || component2 instanceof JTree && ((JTree)component2).isEditing()) && (component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner()) != null) {
            return SwingUtilities.isDescendingFrom(component, component2);
        }
        return false;
    }

    static Component getView(JScrollPane jScrollPane) {
        JViewport jViewport = jScrollPane.getViewport();
        return jViewport != null ? jViewport.getView() : null;
    }

    private static float getBorderArc(JScrollPane jScrollPane) {
        Border border = jScrollPane.getBorder();
        return border instanceof FlatScrollPaneBorder ? UIScale.scale((float)((FlatScrollPaneBorder)border).getArc(jScrollPane)) : 0.0f;
    }

    private static int getBorderLeftRightPadding(JScrollPane jScrollPane) {
        Border border = jScrollPane.getBorder();
        return border instanceof FlatScrollPaneBorder ? ((FlatScrollPaneBorder)border).getLeftRightPadding(jScrollPane) : 0;
    }

    protected static class FlatScrollPaneLayout
    extends ScrollPaneLayout.UIResource {
        protected FlatScrollPaneLayout() {
        }

        @Override
        public void layoutContainer(Container container) {
            super.layoutContainer(container);
            JScrollPane jScrollPane = (JScrollPane)container;
            int n2 = FlatScrollPaneUI.getBorderLeftRightPadding(jScrollPane);
            if (n2 > 0 && this.vsb != null && this.vsb.isVisible()) {
                Insets insets = jScrollPane.getInsets();
                Rectangle rectangle = this.vsb.getBounds();
                int n3 = Math.max(rectangle.y, insets.top + n2);
                int n4 = Math.min(rectangle.y + rectangle.height, jScrollPane.getHeight() - insets.bottom - n2);
                boolean bl2 = jScrollPane.getComponentOrientation().isLeftToRight();
                this.vsb.setBounds(rectangle.x + (bl2 ? n2 : -n2), n3, rectangle.width, n4 - n3);
                if (this.canIncreaseViewportWidth(jScrollPane)) {
                    int n5 = Math.min(n2, this.vsb.getWidth());
                    FlatScrollPaneLayout.resizeViewport(this.viewport, n5, bl2);
                    FlatScrollPaneLayout.resizeViewport(this.colHead, n5, bl2);
                    FlatScrollPaneLayout.resizeViewport(this.hsb, n5, bl2);
                }
            }
        }

        boolean canIncreaseViewportWidth(JScrollPane jScrollPane) {
            return jScrollPane.getComponentOrientation().isLeftToRight() ? !FlatScrollPaneLayout.isCornerVisible(this.upperRight) && !FlatScrollPaneLayout.isCornerVisible(this.lowerRight) : !FlatScrollPaneLayout.isCornerVisible(this.upperLeft) && !FlatScrollPaneLayout.isCornerVisible(this.lowerLeft);
        }

        private static boolean isCornerVisible(Component component) {
            return component != null && component.getWidth() > 0 && component.getHeight() > 0 && component.isVisible();
        }

        private static void resizeViewport(Component component, int n2, boolean bl2) {
            if (component == null) {
                return;
            }
            Rectangle rectangle = component.getBounds();
            component.setBounds(rectangle.x - (bl2 ? 0 : n2), rectangle.y, rectangle.width + n2, rectangle.height);
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener {
        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            containerEvent.getChild().addFocusListener(this);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            containerEvent.getChild().removeFocusListener(this);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (FlatScrollPaneUI.this.scrollpane.getBorder() instanceof FlatBorder) {
                HiDPIUtils.repaint(FlatScrollPaneUI.this.scrollpane);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (FlatScrollPaneUI.this.scrollpane.getBorder() instanceof FlatBorder) {
                HiDPIUtils.repaint(FlatScrollPaneUI.this.scrollpane);
            }
        }
    }
}

