/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSeparatorUI;

public class FlatSeparatorUI
extends BasicSeparatorUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    @FlatStylingSupport.Styleable
    protected int height;
    @FlatStylingSupport.Styleable
    protected int stripeWidth;
    @FlatStylingSupport.Styleable
    protected int stripeIndent;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.canUseSharedUI(jComponent) ? FlatUIUtils.createSharedUI(FlatSeparatorUI.class, () -> new FlatSeparatorUI(true)) : new FlatSeparatorUI(false);
    }

    protected FlatSeparatorUI(boolean bl2) {
        this.shared = bl2;
    }

    protected String getPropertyPrefix() {
        return "Separator";
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((JSeparator)jComponent);
    }

    @Override
    protected void installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
        if (!this.defaults_initialized) {
            String string = this.getPropertyPrefix();
            this.height = UIManager.getInt(string + ".height");
            this.stripeWidth = UIManager.getInt(string + ".stripeWidth");
            this.stripeIndent = UIManager.getInt(string + ".stripeIndent");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(JSeparator jSeparator) {
        super.uninstallDefaults(jSeparator);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners(JSeparator jSeparator) {
        super.installListeners(jSeparator);
        jSeparator.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator jSeparator) {
        super.uninstallListeners(jSeparator);
        jSeparator.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        switch (propertyChangeEvent.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JSeparator jSeparator = (JSeparator)propertyChangeEvent.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(jSeparator)) {
                    jSeparator.updateUI();
                } else {
                    this.installStyle(jSeparator);
                }
                jSeparator.revalidate();
                HiDPIUtils.repaint(jSeparator);
            }
        }
    }

    protected void installStyle(JSeparator jSeparator) {
        try {
            this.applyStyle(jSeparator, FlatStylingSupport.getResolvedStyle(jSeparator, this.getStyleType()));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    String getStyleType() {
        return "Separator";
    }

    protected void applyStyle(JSeparator jSeparator, Object object2) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object2, (string, object) -> this.applyStyleProperty(jSeparator, (String)string, object));
    }

    protected Object applyStyleProperty(JSeparator jSeparator, String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, jSeparator, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            graphics2D.setColor(jComponent.getForeground());
            float f2 = UIScale.scale((float)this.stripeWidth);
            float f3 = UIScale.scale((float)this.stripeIndent);
            if (((JSeparator)jComponent).getOrientation() == 1) {
                graphics2D.fill(new Rectangle2D.Float(f3, 0.0f, f2, jComponent.getHeight()));
            } else {
                graphics2D.fill(new Rectangle2D.Float(0.0f, f3, jComponent.getWidth(), f2));
            }
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (((JSeparator)jComponent).getOrientation() == 1) {
            return new Dimension(UIScale.scale(this.height), 0);
        }
        return new Dimension(0, UIScale.scale(this.height));
    }
}

