/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.RoundRectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class FlatSliderUI
extends BasicSliderUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int trackWidth;
    @FlatStylingSupport.Styleable
    protected Dimension thumbSize;
    @FlatStylingSupport.Styleable
    protected int focusWidth;
    @FlatStylingSupport.Styleable
    protected float thumbBorderWidth;
    @FlatStylingSupport.Styleable
    protected Color trackValueColor;
    @FlatStylingSupport.Styleable
    protected Color trackColor;
    @FlatStylingSupport.Styleable
    protected Color thumbColor;
    @FlatStylingSupport.Styleable
    protected Color thumbBorderColor;
    protected Color focusBaseColor;
    @FlatStylingSupport.Styleable
    protected Color focusedColor;
    @FlatStylingSupport.Styleable
    protected Color focusedThumbBorderColor;
    @FlatStylingSupport.Styleable
    protected Color hoverThumbColor;
    @FlatStylingSupport.Styleable
    protected Color pressedThumbColor;
    @FlatStylingSupport.Styleable
    protected Color disabledTrackColor;
    @FlatStylingSupport.Styleable
    protected Color disabledThumbColor;
    @FlatStylingSupport.Styleable
    protected Color disabledThumbBorderColor;
    @FlatStylingSupport.Styleable
    protected Color tickColor;
    private Color defaultBackground;
    private Color defaultForeground;
    protected boolean thumbHover;
    protected boolean thumbPressed;
    private Object[] oldRenderingHints;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatSliderUI();
    }

    public FlatSliderUI() {
        super(null);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        LookAndFeel.installProperty(jSlider, "opaque", false);
        this.trackWidth = UIManager.getInt("Slider.trackWidth");
        this.thumbSize = UIManager.getDimension("Slider.thumbSize");
        if (this.thumbSize == null) {
            int n2 = UIManager.getInt("Slider.thumbWidth");
            this.thumbSize = new Dimension(n2, n2);
        }
        this.focusWidth = FlatUIUtils.getUIInt("Slider.focusWidth", 4);
        this.thumbBorderWidth = FlatUIUtils.getUIFloat("Slider.thumbBorderWidth", 1.0f);
        this.trackValueColor = FlatUIUtils.getUIColor("Slider.trackValueColor", "Slider.thumbColor");
        this.trackColor = UIManager.getColor("Slider.trackColor");
        this.thumbColor = UIManager.getColor("Slider.thumbColor");
        this.thumbBorderColor = UIManager.getColor("Slider.thumbBorderColor");
        this.focusBaseColor = UIManager.getColor("Component.focusColor");
        this.focusedColor = FlatUIUtils.getUIColor("Slider.focusedColor", this.focusBaseColor);
        this.focusedThumbBorderColor = FlatUIUtils.getUIColor("Slider.focusedThumbBorderColor", "Component.focusedBorderColor");
        this.hoverThumbColor = UIManager.getColor("Slider.hoverThumbColor");
        this.pressedThumbColor = UIManager.getColor("Slider.pressedThumbColor");
        this.disabledTrackColor = UIManager.getColor("Slider.disabledTrackColor");
        this.disabledThumbColor = UIManager.getColor("Slider.disabledThumbColor");
        this.disabledThumbBorderColor = FlatUIUtils.getUIColor("Slider.disabledThumbBorderColor", "Component.disabledBorderColor");
        this.tickColor = FlatUIUtils.getUIColor("Slider.tickColor", Color.BLACK);
        this.defaultBackground = UIManager.getColor("Slider.background");
        this.defaultForeground = UIManager.getColor("Slider.foreground");
    }

    @Override
    protected void uninstallDefaults(JSlider jSlider) {
        super.uninstallDefaults(jSlider);
        this.trackValueColor = null;
        this.trackColor = null;
        this.thumbColor = null;
        this.thumbBorderColor = null;
        this.focusBaseColor = null;
        this.focusedColor = null;
        this.focusedThumbBorderColor = null;
        this.hoverThumbColor = null;
        this.pressedThumbColor = null;
        this.disabledTrackColor = null;
        this.disabledThumbColor = null;
        this.disabledThumbBorderColor = null;
        this.tickColor = null;
        this.defaultBackground = null;
        this.defaultForeground = null;
        this.oldStyleValues = null;
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new FlatTrackListener();
    }

    @Override
    protected FocusListener createFocusListener(final JSlider jSlider) {
        return new BasicSliderUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                HiDPIUtils.repaint(jSlider);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                HiDPIUtils.repaint(jSlider);
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener(JSlider jSlider) {
        return FlatStylingSupport.createPropertyChangeListener(jSlider, this::installStyle, super.createPropertyChangeListener(jSlider));
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.slider, "Slider"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.slider, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public int getBaseline(JComponent jComponent, int n2, int n3) {
        if (jComponent == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException();
        }
        if (this.slider.getOrientation() == 1) {
            return -1;
        }
        Font font = UIManager.getFont("defaultFont");
        if (font == null) {
            font = this.slider.getFont();
        }
        FontMetrics fontMetrics = this.slider.getFontMetrics(font);
        Insets insets = this.slider.getInsets();
        int n4 = this.getThumbSize().height;
        int n5 = n3 - insets.top - insets.bottom - this.focusInsets.top - this.focusInsets.bottom;
        int n6 = n4 + (this.slider.getPaintTicks() ? this.getTickLength() : 0) + (this.slider.getPaintLabels() ? this.getHeightOfTallestLabel() : 0);
        int n7 = insets.top + this.focusInsets.top + (n5 - n6 - 1) / 2;
        int n8 = n4;
        return n7 + Math.round((float)(n8 - fontMetrics.getHeight()) / 2.0f) + fontMetrics.getAscent() - 1;
    }

    @Override
    public Dimension getPreferredHorizontalSize() {
        return UIScale.scale(super.getPreferredHorizontalSize());
    }

    @Override
    public Dimension getPreferredVerticalSize() {
        return UIScale.scale(super.getPreferredVerticalSize());
    }

    @Override
    public Dimension getMinimumHorizontalSize() {
        return UIScale.scale(super.getMinimumHorizontalSize());
    }

    @Override
    public Dimension getMinimumVerticalSize() {
        return UIScale.scale(super.getMinimumVerticalSize());
    }

    @Override
    protected int getTickLength() {
        return UIScale.scale(super.getTickLength());
    }

    @Override
    protected Dimension getThumbSize() {
        return FlatSliderUI.calcThumbSize(this.slider, this.thumbSize, this.focusWidth);
    }

    public static Dimension calcThumbSize(JSlider jSlider, Dimension dimension, int n2) {
        int n3 = UIScale.scale(n2);
        int n4 = UIScale.scale(dimension.width) + n3 + n3;
        int n5 = UIScale.scale(dimension.height) + n3 + n3;
        return jSlider.getOrientation() == 0 ? new Dimension(n4, n5) : new Dimension(n5, n4);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(graphics);
        super.paint(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paintLabels(Graphics graphics) {
        FlatUIUtils.runWithoutRenderingHints(graphics, this.oldRenderingHints, () -> super.paintLabels(graphics));
    }

    @Override
    public void paintFocus(Graphics graphics) {
    }

    @Override
    public void paintTrack(Graphics graphics) {
        RoundRectangle2D.Float float_;
        float f2;
        float f3;
        boolean bl2 = this.slider.isEnabled();
        float f4 = f3 = UIScale.scale((float)this.trackWidth);
        RoundRectangle2D.Float float_2 = null;
        if (this.slider.getOrientation() == 0) {
            f2 = (float)this.trackRect.y + ((float)this.trackRect.height - f3) / 2.0f;
            if (bl2 && this.isRoundThumb()) {
                if (this.slider.getComponentOrientation().isLeftToRight()) {
                    int n2 = this.thumbRect.x + this.thumbRect.width / 2 - this.trackRect.x;
                    float_2 = new RoundRectangle2D.Float(this.trackRect.x, f2, n2, f3, f4, f4);
                    float_ = new RoundRectangle2D.Float(this.trackRect.x + n2, f2, this.trackRect.width - n2, f3, f4, f4);
                } else {
                    int n3 = this.trackRect.x + this.trackRect.width - this.thumbRect.x - this.thumbRect.width / 2;
                    float_2 = new RoundRectangle2D.Float(this.trackRect.x + this.trackRect.width - n3, f2, n3, f3, f4, f4);
                    float_ = new RoundRectangle2D.Float(this.trackRect.x, f2, this.trackRect.width - n3, f3, f4, f4);
                }
            } else {
                float_ = new RoundRectangle2D.Float(this.trackRect.x, f2, this.trackRect.width, f3, f4, f4);
            }
        } else {
            f2 = (float)this.trackRect.x + ((float)this.trackRect.width - f3) / 2.0f;
            if (bl2 && this.isRoundThumb()) {
                int n4 = this.thumbRect.y + this.thumbRect.height / 2 - this.trackRect.y;
                float_ = new RoundRectangle2D.Float(f2, this.trackRect.y, f3, n4, f4, f4);
                float_2 = new RoundRectangle2D.Float(f2, this.trackRect.y + n4, f3, this.trackRect.height - n4, f4, f4);
            } else {
                float_ = new RoundRectangle2D.Float(f2, this.trackRect.y, f3, this.trackRect.height, f4, f4);
            }
        }
        if (float_2 != null) {
            if (this.slider.getInverted()) {
                RoundRectangle2D.Float float_3 = float_;
                float_ = float_2;
                float_2 = float_3;
            }
            graphics.setColor(this.getTrackValueColor());
            ((Graphics2D)graphics).fill(float_2);
        }
        graphics.setColor(bl2 ? this.getTrackColor() : this.disabledTrackColor);
        ((Graphics2D)graphics).fill(float_);
    }

    @Override
    public void paintTicks(Graphics graphics) {
        super.paintTicks(new Graphics2DProxy((Graphics2D)graphics){

            @Override
            public void setColor(Color color) {
                super.setColor(FlatSliderUI.this.tickColor);
            }
        });
    }

    @Override
    public void paintThumb(Graphics graphics) {
        Color color = this.getThumbColor();
        Color color2 = FlatSliderUI.stateColor(this.slider, this.thumbHover, this.thumbPressed, color, this.disabledThumbColor, null, this.hoverThumbColor, this.pressedThumbColor);
        color2 = FlatUIUtils.deriveColor(color2, color);
        Color color3 = this.slider.getForeground();
        Color color4 = this.thumbBorderColor != null && color3 == this.defaultForeground ? FlatSliderUI.stateColor(this.slider, false, false, this.thumbBorderColor, this.disabledThumbBorderColor, this.focusedThumbBorderColor, null, null) : null;
        Color color5 = FlatUIUtils.deriveColor(this.focusedColor, color3 != this.defaultForeground ? color3 : this.focusBaseColor);
        FlatSliderUI.paintThumb(graphics, this.slider, this.thumbRect, this.isRoundThumb(), color2, color4, color5, this.thumbBorderWidth, this.focusWidth);
    }

    public static void paintThumb(Graphics graphics, JSlider jSlider, Rectangle rectangle, boolean bl2, Color color, Color color2, Color color3, float f2, int n2) {
        double d3 = UIScale.getSystemScaleFactor((Graphics2D)graphics);
        if (d3 != (double)((int)d3)) {
            HiDPIUtils.paintAtScale1x((Graphics2D)graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, (graphics2D, n3, n4, n5, n6, d2) -> FlatSliderUI.paintThumbImpl(graphics, jSlider, n3, n4, n5, n6, bl2, color, color2, color3, (float)((double)f2 * d2), (float)((double)n2 * d2)));
            return;
        }
        FlatSliderUI.paintThumbImpl(graphics, jSlider, rectangle.x, rectangle.y, rectangle.width, rectangle.height, bl2, color, color2, color3, f2, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintThumbImpl(Graphics graphics, JSlider jSlider, int n2, int n3, int n4, int n5, boolean bl2, Color color, Color color2, Color color3, float f2, float f3) {
        int n6 = Math.round(UIScale.scale(f3));
        int n7 = n2 + n6;
        int n8 = n3 + n6;
        int n9 = n4 - n6 - n6;
        int n10 = n5 - n6 - n6;
        boolean bl3 = FlatUIUtils.isPermanentFocusOwner(jSlider);
        if (bl2) {
            if (bl3) {
                graphics.setColor(color3);
                ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape(n2, n3, n4, n5));
            }
            if (color2 != null) {
                graphics.setColor(color2);
                ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape(n7, n8, n9, n10));
                float f4 = UIScale.scale(f2);
                graphics.setColor(color);
                ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape((float)n7 + f4, (float)n8 + f4, (float)n9 - f4 - f4, (float)n10 - f4 - f4));
            } else {
                graphics.setColor(color);
                ((Graphics2D)graphics).fill(FlatSliderUI.createRoundThumbShape(n7, n8, n9, n10));
            }
        } else {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                graphics2D.translate(n2, n3);
                if (jSlider.getOrientation() == 1) {
                    if (jSlider.getComponentOrientation().isLeftToRight()) {
                        graphics2D.translate(0, n5);
                        graphics2D.rotate(Math.toRadians(270.0));
                    } else {
                        graphics2D.translate(n4, 0);
                        graphics2D.rotate(Math.toRadians(90.0));
                    }
                    int n11 = n9;
                    n9 = n10;
                    n10 = n11;
                }
                if (bl3) {
                    graphics2D.setColor(color3);
                    graphics2D.fill(FlatSliderUI.createDirectionalThumbShape(0.0f, 0.0f, n9 + n6 + n6, (float)(n10 + n6 + n6) + (float)n6 * 0.4142f, n6));
                }
                if (color2 != null) {
                    graphics2D.setColor(color2);
                    graphics2D.fill(FlatSliderUI.createDirectionalThumbShape(n6, n6, n9, n10, 0.0f));
                    float f5 = UIScale.scale(f2);
                    graphics2D.setColor(color);
                    graphics2D.fill(FlatSliderUI.createDirectionalThumbShape((float)n6 + f5, (float)n6 + f5, (float)n9 - f5 - f5, (float)n10 - f5 - f5 - f5 * 0.4142f, 0.0f));
                } else {
                    graphics2D.setColor(color);
                    graphics2D.fill(FlatSliderUI.createDirectionalThumbShape(n6, n6, n9, n10, 0.0f));
                }
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    public static Shape createRoundThumbShape(float f2, float f3, float f4, float f5) {
        if (f4 == f5) {
            return new Ellipse2D.Float(f2, f3, f4, f5);
        }
        float f6 = Math.min(f4, f5);
        return new RoundRectangle2D.Float(f2, f3, f4, f5, f6, f6);
    }

    public static Shape createDirectionalThumbShape(float f2, float f3, float f4, float f5, float f6) {
        float f7 = f4 / 2.0f;
        Path2D.Float float_ = new Path2D.Float(1, 9);
        ((Path2D)float_).moveTo(f2 + f7, f3 + f5);
        ((Path2D)float_).lineTo(f2, f3 + (f5 - f7));
        ((Path2D)float_).lineTo(f2, f3 + f6);
        ((Path2D)float_).quadTo(f2, f3, f2 + f6, f3);
        ((Path2D)float_).lineTo(f2 + (f4 - f6), f3);
        ((Path2D)float_).quadTo(f2 + f4, f3, f2 + f4, f3 + f6);
        ((Path2D)float_).lineTo(f2 + f4, f3 + (f5 - f7));
        float_.closePath();
        return float_;
    }

    protected Color getTrackValueColor() {
        Color color = this.slider.getForeground();
        return color != this.defaultForeground ? color : this.trackValueColor;
    }

    protected Color getTrackColor() {
        Color color = this.slider.getBackground();
        return color != this.defaultBackground ? color : this.trackColor;
    }

    protected Color getThumbColor() {
        Color color = this.slider.getForeground();
        return color != this.defaultForeground ? color : this.thumbColor;
    }

    public static Color stateColor(JSlider jSlider, boolean bl2, boolean bl3, Color color, Color color2, Color color3, Color color4, Color color5) {
        if (color2 != null && !jSlider.isEnabled()) {
            return color2;
        }
        if (color5 != null && bl3) {
            return color5;
        }
        if (color4 != null && bl2) {
            return color4;
        }
        if (color3 != null && FlatUIUtils.isPermanentFocusOwner(jSlider)) {
            return color3;
        }
        return color;
    }

    protected boolean isRoundThumb() {
        return !this.slider.getPaintTicks() && !this.slider.getPaintLabels();
    }

    @Override
    public void setThumbLocation(int n2, int n3) {
        Rectangle rectangle = new Rectangle(this.thumbRect);
        this.thumbRect.setLocation(n2, n3);
        SwingUtilities.computeUnion(this.thumbRect.x, this.thumbRect.y, this.thumbRect.width, this.thumbRect.height, rectangle);
        if (!this.isRoundThumb()) {
            int n4 = (int)Math.ceil((float)UIScale.scale(this.focusWidth) * 0.4142f);
            if (this.slider.getOrientation() == 0) {
                rectangle.height += n4;
            } else {
                rectangle.width += n4;
                if (!this.slider.getComponentOrientation().isLeftToRight()) {
                    rectangle.x -= n4;
                }
            }
        }
        HiDPIUtils.repaint(this.slider, rectangle);
    }

    protected class FlatTrackListener
    extends BasicSliderUI.TrackListener {
        protected FlatTrackListener() {
            super(FlatSliderUI.this);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.setThumbHover(this.isOverThumb(mouseEvent));
            super.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.setThumbHover(false);
            super.mouseExited(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.setThumbHover(this.isOverThumb(mouseEvent));
            super.mouseMoved(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.setThumbPressed(this.isOverThumb(mouseEvent));
            if (!FlatSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (UIManager.getBoolean("Slider.scrollOnTrackClick")) {
                super.mousePressed(mouseEvent);
                return;
            }
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            FlatSliderUI.this.calculateGeometry();
            if (FlatSliderUI.this.thumbRect.contains(n2, n3)) {
                super.mousePressed(mouseEvent);
                return;
            }
            if (UIManager.getBoolean("Slider.onlyLeftMouseButtonDrag") && !SwingUtilities.isLeftMouseButton(mouseEvent)) {
                return;
            }
            int n4 = ((FlatSliderUI)FlatSliderUI.this).thumbRect.x + ((FlatSliderUI)FlatSliderUI.this).thumbRect.width / 2 - n2;
            int n5 = ((FlatSliderUI)FlatSliderUI.this).thumbRect.y + ((FlatSliderUI)FlatSliderUI.this).thumbRect.height / 2 - n3;
            mouseEvent.translatePoint(n4, n5);
            super.mousePressed(mouseEvent);
            mouseEvent.translatePoint(-n4, -n5);
            this.mouseDragged(mouseEvent);
            this.setThumbPressed(true);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.setThumbPressed(false);
            super.mouseReleased(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            super.mouseDragged(mouseEvent);
            if (FlatSliderUI.this.isDragging() && FlatSliderUI.this.slider.getSnapToTicks() && FlatSliderUI.this.slider.isEnabled() && !UIManager.getBoolean("Slider.snapToTicksOnReleased")) {
                FlatSliderUI.this.calculateThumbLocation();
                HiDPIUtils.repaint(FlatSliderUI.this.slider);
            }
        }

        protected void setThumbHover(boolean bl2) {
            if (bl2 != FlatSliderUI.this.thumbHover) {
                FlatSliderUI.this.thumbHover = bl2;
                HiDPIUtils.repaint(FlatSliderUI.this.slider, FlatSliderUI.this.thumbRect);
            }
        }

        protected void setThumbPressed(boolean bl2) {
            if (bl2 != FlatSliderUI.this.thumbPressed) {
                FlatSliderUI.this.thumbPressed = bl2;
                HiDPIUtils.repaint(FlatSliderUI.this.slider, FlatSliderUI.this.thumbRect);
            }
        }

        protected boolean isOverThumb(MouseEvent mouseEvent) {
            return mouseEvent != null && FlatSliderUI.this.slider.isEnabled() && FlatSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY());
        }
    }
}

