/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.beans.PropertyChangeListener;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FlatStylingSupport {
    public static Object getStyle(JComponent jComponent) {
        return jComponent.getClientProperty("FlatLaf.style");
    }

    public static Object getStyleClass(JComponent jComponent) {
        return jComponent.getClientProperty("FlatLaf.styleClass");
    }

    static boolean hasStyleProperty(JComponent jComponent) {
        return FlatStylingSupport.getStyle(jComponent) != null || FlatStylingSupport.getStyleClass(jComponent) != null;
    }

    public static Object getResolvedStyle(JComponent jComponent, String string) throws IllegalArgumentException {
        Object object = FlatStylingSupport.getStyle(jComponent);
        Object object2 = FlatStylingSupport.getStyleClass(jComponent);
        Object object3 = FlatStylingSupport.getStyleForClasses(object2, string);
        return FlatStylingSupport.joinStyles(object3, object);
    }

    public static Object getStyleForClasses(Object list, String string) throws IllegalArgumentException {
        if (list == null) {
            return null;
        }
        if (list instanceof String && ((String)((Object)list)).indexOf(32) >= 0) {
            list = StringUtils.split((String)((Object)list), ' ', true, true);
        }
        if (list instanceof String) {
            return FlatStylingSupport.getStyleForClass(((String)((Object)list)).trim(), string);
        }
        if (list instanceof String[]) {
            Object object = null;
            for (String string2 : (String[])list) {
                object = FlatStylingSupport.joinStyles(object, FlatStylingSupport.getStyleForClass(string2, string));
            }
            return object;
        }
        if (list instanceof List) {
            Object object = null;
            for (String string3 : list) {
                object = FlatStylingSupport.joinStyles(object, FlatStylingSupport.getStyleForClass(string3, string));
            }
            return object;
        }
        return null;
    }

    private static Object getStyleForClass(String string, String string2) throws IllegalArgumentException {
        return FlatStylingSupport.joinStyles(UIManager.get("[style]." + string), UIManager.get("[style]" + string2 + '.' + string));
    }

    public static Object joinStyles(Object object, Object object2) throws IllegalArgumentException {
        Map<String, Object> map;
        Map<String, Object> map2;
        if (object == null) {
            return object2;
        }
        if (object2 == null) {
            return object;
        }
        if (object instanceof String && object2 instanceof String) {
            return object + "; " + object2;
        }
        Map<String, Object> map3 = map2 = object instanceof String ? FlatStylingSupport.parse((String)object) : (Map<String, Object>)object;
        if (map2 == null) {
            return object2;
        }
        Map<String, Object> map4 = map = object2 instanceof String ? FlatStylingSupport.parse((String)object2) : (Map<String, Object>)object2;
        if (map == null) {
            return object;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map2);
        hashMap.putAll(map);
        return hashMap;
    }

    public static String concatStyles(String string, String string2) {
        if (string == null) {
            return string2;
        }
        if (string2 == null) {
            return string;
        }
        return string + "; " + string2;
    }

    public static Map<String, Object> parseAndApply(Map<String, Object> map, Object object, BiFunction<String, Object, Object> biFunction) throws UnknownStyleException, IllegalArgumentException {
        Object object2;
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                biFunction.apply(entry.getKey(), entry.getValue());
            }
        }
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            object2 = (String)object;
            if (StringUtils.isTrimmedEmpty((String)object2)) {
                return null;
            }
            return FlatStylingSupport.applyStyle(FlatStylingSupport.parse((String)object2), biFunction);
        }
        if (object instanceof Map) {
            object2 = (Map)object;
            return FlatStylingSupport.applyStyle((Map<String, Object>)object2, biFunction);
        }
        return null;
    }

    private static Map<String, Object> applyStyle(Map<String, Object> map, BiFunction<String, Object, Object> biFunction) {
        if (map.isEmpty()) {
            return null;
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String string = entry.getKey();
            Object object = entry.getValue();
            if (string.startsWith("[")) {
                if (!(SystemInfo.isWindows && string.startsWith("[win]") || SystemInfo.isMacOS && string.startsWith("[mac]") || SystemInfo.isLinux && string.startsWith("[linux]") || string.startsWith("[light]") && !FlatLaf.isLafDark()) && (!string.startsWith("[dark]") || !FlatLaf.isLafDark())) continue;
                string = string.substring(string.indexOf(93) + 1);
            }
            Object object2 = biFunction.apply(string, object);
            hashMap.put(string, object2);
        }
        return hashMap;
    }

    public static Map<String, Object> parse(String string) throws IllegalArgumentException {
        if (string == null || StringUtils.isTrimmedEmpty(string)) {
            return null;
        }
        LinkedHashMap<String, Object> linkedHashMap = null;
        for (String string2 : StringUtils.split(string, ';', true, true)) {
            int n2 = string2.indexOf(58);
            if (n2 < 0) {
                throw new IllegalArgumentException("missing colon in '" + string2 + "'");
            }
            String string3 = StringUtils.substringTrimmed(string2, 0, n2);
            String string4 = StringUtils.substringTrimmed(string2, n2 + 1);
            if (string3.isEmpty()) {
                throw new IllegalArgumentException("missing key in '" + string2 + "'");
            }
            if (string4.isEmpty()) {
                throw new IllegalArgumentException("missing value in '" + string2 + "'");
            }
            if (linkedHashMap == null) {
                linkedHashMap = new LinkedHashMap<String, Object>();
            }
            linkedHashMap.put(string3, FlatStylingSupport.parseValue(string3, string4));
        }
        return linkedHashMap;
    }

    private static Object parseValue(String string, String string2) throws IllegalArgumentException {
        if (string2.startsWith("$")) {
            return UIManager.get(string2.substring(1));
        }
        if (string.startsWith("[")) {
            string = string.substring(string.indexOf(93) + 1);
        }
        return FlatLaf.parseDefaultsValue(string, string2, null);
    }

    public static Object applyToAnnotatedObject(Object object, String string, Object object2) throws UnknownStyleException, IllegalArgumentException {
        String string2 = FlatStylingSupport.keyToFieldName(string);
        return FlatStylingSupport.applyToField(object, string2, string, object2, field -> {
            Styleable styleable = field.getAnnotation(Styleable.class);
            return styleable != null && styleable.dot() == (string2 != string);
        });
    }

    private static String keyToFieldName(String string) {
        int n2 = string.indexOf(46);
        if (n2 < 0) {
            return string;
        }
        return string.substring(0, n2) + Character.toUpperCase(string.charAt(n2 + 1)) + string.substring(n2 + 2);
    }

    static Object applyToField(Object object, String string, String string2, Object object2) throws UnknownStyleException, IllegalArgumentException {
        return FlatStylingSupport.applyToField(object, string, string2, object2, null);
    }

    private static Object applyToField(Object object, String string, String string2, Object object2, Predicate<Field> predicate) throws UnknownStyleException, IllegalArgumentException {
        Object object3;
        Class<?> clazz = object.getClass();
        do {
            try {
                object3 = clazz.getDeclaredField(string);
                if (predicate == null || predicate.test((Field)object3)) {
                    return FlatStylingSupport.applyToField((Field)object3, object, object2, false);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            object3 = (StyleableField[])clazz.getAnnotationsByType(StyleableField.class);
            int n2 = ((StyleableField[])object3).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleableField styleableField = object3[i2];
                if (!string2.equals(styleableField.key())) continue;
                return FlatStylingSupport.applyToField(FlatStylingSupport.getStyleableField(styleableField), object, object2, true);
            }
            if ((clazz = clazz.getSuperclass()) != null) continue;
            throw new UnknownStyleException(string2);
        } while (predicate == null || !((String)(object3 = clazz.getName())).startsWith("java.") && !((String)object3).startsWith("javax."));
        throw new UnknownStyleException(string2);
    }

    private static Object applyToField(Field field, Object object, Object object2, boolean bl2) throws IllegalArgumentException {
        FlatStylingSupport.checkValidField(field);
        if (bl2 && object instanceof StyleableLookupProvider) {
            try {
                MethodHandles.Lookup lookup = ((StyleableLookupProvider)object).getLookupForStyling();
                Object object3 = lookup.unreflectGetter(field).invoke(object);
                lookup.unreflectSetter(field).invoke(object, FlatStylingSupport.convertToEnum(object2, field.getType()));
                return object3;
            }
            catch (Throwable throwable) {
                throw FlatStylingSupport.newFieldAccessFailed(field, throwable);
            }
        }
        try {
            field.setAccessible(true);
            Object object4 = field.get(object);
            field.set(object, FlatStylingSupport.convertToEnum(object2, field.getType()));
            return object4;
        }
        catch (IllegalAccessException illegalAccessException) {
            throw FlatStylingSupport.newFieldAccessFailed(field, illegalAccessException);
        }
    }

    private static Object getFieldValue(Field field, Object object, boolean bl2) throws IllegalArgumentException {
        FlatStylingSupport.checkValidField(field);
        if (bl2 && object instanceof StyleableLookupProvider) {
            try {
                MethodHandles.Lookup lookup = ((StyleableLookupProvider)object).getLookupForStyling();
                return lookup.unreflectGetter(field).invoke(object);
            }
            catch (Throwable throwable) {
                throw FlatStylingSupport.newFieldAccessFailed(field, throwable);
            }
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw FlatStylingSupport.newFieldAccessFailed(field, illegalAccessException);
        }
    }

    private static IllegalArgumentException newFieldAccessFailed(Field field, Throwable throwable) {
        return new IllegalArgumentException("failed to access field '" + field.getDeclaringClass().getName() + "." + field.getName() + "'", throwable);
    }

    private static void checkValidField(Field field) throws IllegalArgumentException {
        if (!FlatStylingSupport.isValidField(field)) {
            throw new IllegalArgumentException("field '" + field.getDeclaringClass().getName() + "." + field.getName() + "' is final or static");
        }
    }

    private static boolean isValidField(Field field) {
        int n2 = field.getModifiers();
        return (n2 & 0x18) == 0 && !field.isSynthetic();
    }

    private static Field getStyleableField(StyleableField styleableField) throws IllegalArgumentException {
        String string = styleableField.fieldName();
        if (string.isEmpty()) {
            string = styleableField.key();
        }
        try {
            return styleableField.cls().getDeclaredField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new IllegalArgumentException("field '" + styleableField.cls().getName() + "." + string + "' not found", noSuchFieldException);
        }
    }

    private static Object applyToProperty(Object object, String string, Object object2) throws UnknownStyleException, IllegalArgumentException {
        Class<?> clazz = object.getClass();
        String string2 = FlatStylingSupport.buildMethodName("get", string);
        String string3 = FlatStylingSupport.buildMethodName("set", string);
        try {
            Method method;
            try {
                method = clazz.getMethod(string2, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                method = clazz.getMethod(FlatStylingSupport.buildMethodName("is", string), new Class[0]);
            }
            Method method2 = clazz.getMethod(string3, method.getReturnType());
            Object object3 = method.invoke(object, new Object[0]);
            method2.invoke(object, FlatStylingSupport.convertToEnum(object2, method.getReturnType()));
            return object3;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new UnknownStyleException(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("failed to invoke property methods '" + clazz.getName() + "." + string2 + "()' or '" + string3 + "(...)'", exception);
        }
    }

    private static String buildMethodName(String string, String string2) {
        int n2 = string.length();
        int n3 = string2.length();
        char[] cArray = new char[n2 + n3];
        string.getChars(0, n2, cArray, 0);
        string2.getChars(0, n3, cArray, n2);
        cArray[n2] = Character.toUpperCase(cArray[n2]);
        return new String(cArray);
    }

    private static Object convertToEnum(Object object, Class<?> clazz) throws IllegalArgumentException {
        if (Enum.class.isAssignableFrom(clazz) && object instanceof String) {
            try {
                object = Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("unknown enum value '" + object + "' in enum '" + clazz.getName() + "'", illegalArgumentException);
            }
        }
        return object;
    }

    public static Object applyToAnnotatedObjectOrComponent(Object object, Object object2, String string, Object object3) throws UnknownStyleException, IllegalArgumentException {
        try {
            return FlatStylingSupport.applyToAnnotatedObject(object, string, object3);
        }
        catch (UnknownStyleException unknownStyleException) {
            try {
                if (object2 != null) {
                    return FlatStylingSupport.applyToProperty(object2, string, object3);
                }
            }
            catch (UnknownStyleException unknownStyleException2) {
                // empty catch block
            }
            throw unknownStyleException;
        }
    }

    static Object applyToAnnotatedObjectOrBorder(Object object, String string, Object object2, JComponent jComponent, AtomicBoolean atomicBoolean) throws IllegalArgumentException {
        try {
            return FlatStylingSupport.applyToAnnotatedObject(object, string, object2);
        }
        catch (UnknownStyleException unknownStyleException) {
            Border border = jComponent.getBorder();
            if (border instanceof StyleableBorder) {
                if (atomicBoolean.get()) {
                    border = FlatStylingSupport.cloneBorder(border);
                    jComponent.setBorder(border);
                    atomicBoolean.set(false);
                }
                try {
                    return ((StyleableBorder)((Object)border)).applyStyleProperty(string, object2);
                }
                catch (UnknownStyleException unknownStyleException2) {
                    // empty catch block
                }
            }
            try {
                return FlatStylingSupport.applyToProperty(jComponent, string, object2);
            }
            catch (UnknownStyleException unknownStyleException3) {
                throw unknownStyleException;
            }
        }
    }

    static PropertyChangeListener createPropertyChangeListener(JComponent jComponent, Runnable runnable, PropertyChangeListener propertyChangeListener) {
        return propertyChangeEvent -> {
            if (propertyChangeListener != null) {
                propertyChangeListener.propertyChange(propertyChangeEvent);
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    runnable.run();
                    jComponent.revalidate();
                    HiDPIUtils.repaint(jComponent);
                }
            }
        };
    }

    static Border cloneBorder(Border border) throws IllegalArgumentException {
        Class<?> clazz = border.getClass();
        try {
            return (Border)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("failed to clone border '" + clazz.getName() + "'", exception);
        }
    }

    static Icon cloneIcon(Icon icon) throws IllegalArgumentException {
        Class<?> clazz = icon.getClass();
        try {
            return (Icon)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("failed to clone icon '" + clazz.getName() + "'", exception);
        }
    }

    public static Map<String, Class<?>> getAnnotatedStyleableInfos(Object object) throws IllegalArgumentException {
        return FlatStylingSupport.getAnnotatedStyleableInfos(object, null);
    }

    public static Map<String, Class<?>> getAnnotatedStyleableInfos(Object object, Border border) throws IllegalArgumentException {
        StyleableInfosMap styleableInfosMap = new StyleableInfosMap();
        FlatStylingSupport.collectAnnotatedStyleableInfos(object, styleableInfosMap);
        FlatStylingSupport.collectStyleableInfos(border, styleableInfosMap);
        return styleableInfosMap;
    }

    public static void collectAnnotatedStyleableInfos(Object object, Map<String, Class<?>> map) throws IllegalArgumentException {
        Object object2;
        HashSet<Object> hashSet = new HashSet<Object>();
        Class<?> clazz = object.getClass();
        do {
            Object object3;
            Object object4;
            for (Field field : clazz.getDeclaredFields()) {
                if (!FlatStylingSupport.isValidField(field) || (object4 = field.getAnnotation(Styleable.class)) == null) continue;
                object3 = field.getName();
                Class<?> clazz2 = field.getType();
                if (hashSet.contains(object3)) continue;
                hashSet.add(object3);
                if (object4.dot()) {
                    int n2 = ((String)object3).length();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!Character.isUpperCase(((String)object3).charAt(i2))) continue;
                        object3 = ((String)object3).substring(0, i2) + '.' + Character.toLowerCase(((String)object3).charAt(i2)) + ((String)object3).substring(i2 + 1);
                        break;
                    }
                }
                if (object4.type() != Void.class) {
                    clazz2 = object4.type();
                }
                map.put((String)object3, clazz2);
            }
            object2 = (StyleableField[])clazz.getAnnotationsByType(StyleableField.class);
            int n3 = ((Object[])object2).length;
            for (int i3 = 0; i3 < n3; ++i3) {
                Object object5 = object2[i3];
                object4 = object5.key();
                if (hashSet.contains(object4)) continue;
                hashSet.add(object4);
                object3 = FlatStylingSupport.getStyleableField((StyleableField)object5);
                map.put((String)object4, ((Field)object3).getType());
            }
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return;
        } while (!((String)(object2 = clazz.getName())).startsWith("java.") && !((String)object2).startsWith("javax."));
    }

    public static void collectStyleableInfos(Border border, Map<String, Class<?>> map) {
        if (border instanceof StyleableBorder) {
            map.putAll(((StyleableBorder)((Object)border)).getStyleableInfos());
        }
    }

    public static void putAllPrefixKey(Map<String, Class<?>> map, String string, Map<String, Class<?>> map2) {
        for (Map.Entry<String, Class<?>> entry : map2.entrySet()) {
            map.put(string.concat(entry.getKey()), entry.getValue());
        }
    }

    public static Object getAnnotatedStyleableValue(Object object, String string) throws IllegalArgumentException {
        Object object2;
        String string2 = FlatStylingSupport.keyToFieldName(string);
        Class<?> clazz = object.getClass();
        do {
            try {
                object2 = clazz.getDeclaredField(string2);
                Styleable styleable = ((Field)object2).getAnnotation(Styleable.class);
                if (styleable != null) {
                    if (styleable.dot() != (string2 != string)) {
                        throw new IllegalArgumentException("'Styleable.dot' on field '" + string2 + "' does not match key '" + string + "'");
                    }
                    if (styleable.type() != Void.class) {
                        throw new IllegalArgumentException("'Styleable.type' on field '" + string2 + "' not supported");
                    }
                    return FlatStylingSupport.getFieldValue((Field)object2, object, false);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            object2 = (StyleableField[])clazz.getAnnotationsByType(StyleableField.class);
            int n2 = ((StyleableField[])object2).length;
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleableField styleableField = object2[i2];
                if (!string.equals(styleableField.key())) continue;
                return FlatStylingSupport.getFieldValue(FlatStylingSupport.getStyleableField(styleableField), object, true);
            }
            if ((clazz = clazz.getSuperclass()) != null) continue;
            return null;
        } while (!((String)(object2 = clazz.getName())).startsWith("java.") && !((String)object2).startsWith("javax."));
        return null;
    }

    public static Object getAnnotatedStyleableValue(Object object, Border border, String string) {
        Object object2;
        if (border instanceof StyleableBorder && (object2 = ((StyleableBorder)((Object)border)).getStyleableValue(string)) != null) {
            return object2;
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(object, string);
    }

    static class StyleableInfosMap<K, V>
    extends LinkedHashMap<K, V> {
        StyleableInfosMap() {
        }

        @Override
        public V put(K k2, V v2) throws IllegalArgumentException {
            V v3 = super.put(k2, v2);
            if (v3 != null) {
                throw new IllegalArgumentException("duplicate key '" + k2 + "'");
            }
            return v3;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }
    }

    public static class UnknownStyleException
    extends IllegalArgumentException {
        public UnknownStyleException(String string) {
            super(string);
        }

        @Override
        public String getMessage() {
            return "unknown style '" + super.getMessage() + "'";
        }
    }

    public static interface StyleableLookupProvider {
        public MethodHandles.Lookup getLookupForStyling();
    }

    public static interface StyleableBorder {
        public Object applyStyleProperty(String var1, Object var2);

        public Map<String, Class<?>> getStyleableInfos() throws IllegalArgumentException;

        public Object getStyleableValue(String var1) throws IllegalArgumentException;
    }

    public static interface StyleableUI {
        public Map<String, Class<?>> getStyleableInfos(JComponent var1) throws IllegalArgumentException;

        public Object getStyleableValue(JComponent var1, String var2) throws IllegalArgumentException;
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StyleableFields {
        public StyleableField[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=StyleableFields.class)
    public static @interface StyleableField {
        public Class<?> cls();

        public String key();

        public String fieldName() default "";
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Styleable {
        public boolean dot() default false;

        public Class<?> type() default Void.class;
    }
}

