/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.icons.FlatTabbedPaneCloseIcon;
import com.formdev.flatlaf.ui.FlatArrowButton;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIAction;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.Animator;
import com.formdev.flatlaf.util.CubicBezierEasing;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.StringUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class FlatTabbedPaneUI
extends BasicTabbedPaneUI
implements FlatStylingSupport.StyleableUI,
FlatTitlePane.TitleBarCaptionHitTest {
    protected static final int TAB_TYPE_UNDERLINED = 0;
    protected static final int TAB_TYPE_CARD = 1;
    protected static final int NEVER = 0;
    protected static final int AS_NEEDED = 2;
    protected static final int AS_NEEDED_SINGLE = 3;
    protected static final int BOTH = 100;
    protected static final int FILL = 100;
    protected static final int WIDTH_MODE_PREFERRED = 0;
    protected static final int WIDTH_MODE_EQUAL = 1;
    protected static final int WIDTH_MODE_COMPACT = 2;
    protected static final int NONE = -1;
    protected static final int AUTO = -2;
    private static Set<KeyStroke> focusForwardTraversalKeys;
    private static Set<KeyStroke> focusBackwardTraversalKeys;
    protected Color foreground;
    @FlatStylingSupport.Styleable
    protected Color disabledForeground;
    @FlatStylingSupport.Styleable
    protected Color selectedBackground;
    @FlatStylingSupport.Styleable
    protected Color selectedForeground;
    @FlatStylingSupport.Styleable
    protected Color underlineColor;
    @FlatStylingSupport.Styleable
    protected Color inactiveUnderlineColor;
    @FlatStylingSupport.Styleable
    protected Color disabledUnderlineColor;
    @FlatStylingSupport.Styleable
    protected Color hoverColor;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color focusColor;
    @FlatStylingSupport.Styleable
    protected Color focusForeground;
    @FlatStylingSupport.Styleable
    protected Color tabSeparatorColor;
    @FlatStylingSupport.Styleable
    protected Color contentAreaColor;
    private int textIconGapUnscaled;
    @FlatStylingSupport.Styleable
    protected int minimumTabWidth;
    @FlatStylingSupport.Styleable
    protected int maximumTabWidth;
    @FlatStylingSupport.Styleable
    protected int tabHeight;
    @FlatStylingSupport.Styleable
    protected int tabSelectionHeight;
    @FlatStylingSupport.Styleable
    protected int cardTabSelectionHeight;
    @FlatStylingSupport.Styleable
    protected int tabArc;
    @FlatStylingSupport.Styleable
    protected int tabSelectionArc;
    @FlatStylingSupport.Styleable
    protected int cardTabArc;
    @FlatStylingSupport.Styleable
    protected Insets selectedInsets;
    @FlatStylingSupport.Styleable
    protected Insets tabSelectionInsets;
    @FlatStylingSupport.Styleable
    protected int contentSeparatorHeight;
    @FlatStylingSupport.Styleable
    protected boolean showTabSeparators;
    @FlatStylingSupport.Styleable
    protected boolean tabSeparatorsFullHeight;
    @FlatStylingSupport.Styleable
    protected boolean hasFullBorder;
    @FlatStylingSupport.Styleable
    protected boolean tabsOpaque = true;
    @FlatStylingSupport.Styleable
    protected boolean rotateTabRuns = true;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabType;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabsPopupPolicy;
    @FlatStylingSupport.Styleable(type=String.class)
    private int scrollButtonsPolicy;
    @FlatStylingSupport.Styleable(type=String.class)
    private int scrollButtonsPlacement;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabAreaAlignment;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabAlignment;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabWidthMode;
    @FlatStylingSupport.Styleable(type=String.class)
    private int tabRotation;
    protected Icon closeIcon;
    @FlatStylingSupport.Styleable
    protected String arrowType;
    @FlatStylingSupport.Styleable
    protected Insets buttonInsets;
    @FlatStylingSupport.Styleable
    protected int buttonArc;
    @FlatStylingSupport.Styleable
    protected Color buttonHoverBackground;
    @FlatStylingSupport.Styleable
    protected Color buttonPressedBackground;
    @FlatStylingSupport.Styleable
    protected String moreTabsButtonToolTipText;
    @FlatStylingSupport.Styleable
    protected String tabCloseToolTipText;
    @FlatStylingSupport.Styleable
    protected boolean showContentSeparator = true;
    @FlatStylingSupport.Styleable
    protected boolean hideTabAreaWithOneTab;
    @FlatStylingSupport.Styleable
    protected boolean tabClosable;
    @FlatStylingSupport.Styleable
    protected int tabIconPlacement = 10;
    protected JViewport tabViewport;
    protected FlatWheelTabScroller wheelTabScroller;
    private JButton tabCloseButton;
    private JButton moreTabsButton;
    private Container leadingComponent;
    private Container trailingComponent;
    private Dimension scrollBackwardButtonPrefSize;
    private Handler handler;
    private boolean blockRollover;
    private boolean rolloverTabClose;
    private boolean pressedTabClose;
    private boolean inBasicLayoutContainer;
    private Object[] oldRenderingHints;
    private Map<String, Object> oldStyleValues;
    private boolean closeIconShared = true;
    private boolean repaintRolloverPending;
    private boolean inCalculateEqual;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTabbedPaneUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        String string = UIManager.getString("TabbedPane.tabLayoutPolicy");
        if (string != null) {
            int n2;
            switch (string) {
                default: {
                    n2 = 0;
                    break;
                }
                case "scroll": {
                    n2 = 1;
                }
            }
            ((JTabbedPane)jComponent).setTabLayoutPolicy(n2);
        }
        this.arrowType = UIManager.getString("TabbedPane.arrowType");
        this.foreground = UIManager.getColor("TabbedPane.foreground");
        this.disabledForeground = UIManager.getColor("TabbedPane.disabledForeground");
        this.buttonHoverBackground = UIManager.getColor("TabbedPane.buttonHoverBackground");
        this.buttonPressedBackground = UIManager.getColor("TabbedPane.buttonPressedBackground");
        super.installUI(jComponent);
        FlatSelectedTabRepainter.install();
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        Object object;
        if (UIManager.getBoolean("TabbedPane.tabsOverlapBorder")) {
            object = UIManager.put("TabbedPane.tabsOverlapBorder", false);
            super.installDefaults();
            UIManager.put("TabbedPane.tabsOverlapBorder", object);
        } else {
            super.installDefaults();
        }
        this.selectedBackground = UIManager.getColor("TabbedPane.selectedBackground");
        this.selectedForeground = UIManager.getColor("TabbedPane.selectedForeground");
        this.underlineColor = UIManager.getColor("TabbedPane.underlineColor");
        this.inactiveUnderlineColor = FlatUIUtils.getUIColor("TabbedPane.inactiveUnderlineColor", this.underlineColor);
        this.disabledUnderlineColor = UIManager.getColor("TabbedPane.disabledUnderlineColor");
        this.hoverColor = UIManager.getColor("TabbedPane.hoverColor");
        this.hoverForeground = UIManager.getColor("TabbedPane.hoverForeground");
        this.focusColor = UIManager.getColor("TabbedPane.focusColor");
        this.focusForeground = UIManager.getColor("TabbedPane.focusForeground");
        this.tabSeparatorColor = UIManager.getColor("TabbedPane.tabSeparatorColor");
        this.contentAreaColor = UIManager.getColor("TabbedPane.contentAreaColor");
        this.textIconGapUnscaled = UIManager.getInt("TabbedPane.textIconGap");
        this.minimumTabWidth = UIManager.getInt("TabbedPane.minimumTabWidth");
        this.maximumTabWidth = UIManager.getInt("TabbedPane.maximumTabWidth");
        this.tabHeight = UIManager.getInt("TabbedPane.tabHeight");
        this.tabSelectionHeight = UIManager.getInt("TabbedPane.tabSelectionHeight");
        this.cardTabSelectionHeight = UIManager.getInt("TabbedPane.cardTabSelectionHeight");
        this.tabArc = UIManager.getInt("TabbedPane.tabArc");
        this.tabSelectionArc = UIManager.getInt("TabbedPane.tabSelectionArc");
        this.cardTabArc = UIManager.getInt("TabbedPane.cardTabArc");
        this.selectedInsets = UIManager.getInsets("TabbedPane.selectedInsets");
        this.tabSelectionInsets = UIManager.getInsets("TabbedPane.tabSelectionInsets");
        this.contentSeparatorHeight = UIManager.getInt("TabbedPane.contentSeparatorHeight");
        this.showTabSeparators = UIManager.getBoolean("TabbedPane.showTabSeparators");
        this.tabSeparatorsFullHeight = UIManager.getBoolean("TabbedPane.tabSeparatorsFullHeight");
        this.hasFullBorder = UIManager.getBoolean("TabbedPane.hasFullBorder");
        this.tabsOpaque = UIManager.getBoolean("TabbedPane.tabsOpaque");
        this.rotateTabRuns = FlatUIUtils.getUIBoolean("TabbedPane.rotateTabRuns", true);
        this.tabType = FlatTabbedPaneUI.parseTabType(UIManager.getString("TabbedPane.tabType"));
        this.tabsPopupPolicy = FlatTabbedPaneUI.parseTabsPopupPolicy(UIManager.getString("TabbedPane.tabsPopupPolicy"));
        this.scrollButtonsPolicy = FlatTabbedPaneUI.parseScrollButtonsPolicy(UIManager.getString("TabbedPane.scrollButtonsPolicy"));
        this.scrollButtonsPlacement = FlatTabbedPaneUI.parseScrollButtonsPlacement(UIManager.getString("TabbedPane.scrollButtonsPlacement"));
        this.tabAreaAlignment = FlatTabbedPaneUI.parseAlignment(UIManager.getString("TabbedPane.tabAreaAlignment"), 10);
        this.tabAlignment = FlatTabbedPaneUI.parseAlignment(UIManager.getString("TabbedPane.tabAlignment"), 0);
        this.tabWidthMode = FlatTabbedPaneUI.parseTabWidthMode(UIManager.getString("TabbedPane.tabWidthMode"));
        this.tabRotation = FlatTabbedPaneUI.parseTabRotation(UIManager.getString("TabbedPane.tabRotation"));
        this.closeIcon = UIManager.getIcon("TabbedPane.closeIcon");
        this.closeIconShared = true;
        this.buttonInsets = UIManager.getInsets("TabbedPane.buttonInsets");
        this.buttonArc = UIManager.getInt("TabbedPane.buttonArc");
        object = this.tabPane.getLocale();
        this.moreTabsButtonToolTipText = UIManager.getString((Object)"TabbedPane.moreTabsButtonToolTipText", (Locale)object);
        this.tabCloseToolTipText = UIManager.getString((Object)"TabbedPane.tabCloseToolTipText", (Locale)object);
        this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
        if (focusForwardTraversalKeys == null) {
            focusForwardTraversalKeys = Collections.singleton(KeyStroke.getKeyStroke(9, 0));
            focusBackwardTraversalKeys = Collections.singleton(KeyStroke.getKeyStroke(9, 64));
        }
        this.tabPane.setFocusTraversalKeys(0, focusForwardTraversalKeys);
        this.tabPane.setFocusTraversalKeys(1, focusBackwardTraversalKeys);
        MigLayoutVisualPadding.install(this.tabPane, null);
    }

    @Override
    protected void uninstallDefaults() {
        this.tabPane.setFocusTraversalKeys(0, null);
        this.tabPane.setFocusTraversalKeys(1, null);
        super.uninstallDefaults();
        this.foreground = null;
        this.disabledForeground = null;
        this.selectedBackground = null;
        this.selectedForeground = null;
        this.underlineColor = null;
        this.inactiveUnderlineColor = null;
        this.disabledUnderlineColor = null;
        this.hoverColor = null;
        this.hoverForeground = null;
        this.focusColor = null;
        this.focusForeground = null;
        this.tabSeparatorColor = null;
        this.contentAreaColor = null;
        this.closeIcon = null;
        this.buttonHoverBackground = null;
        this.buttonPressedBackground = null;
        this.oldStyleValues = null;
        MigLayoutVisualPadding.uninstall(this.tabPane);
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        this.tabViewport = null;
        if (this.isScrollTabLayout()) {
            for (Component component : this.tabPane.getComponents()) {
                if (!(component instanceof JViewport) || !component.getClass().getName().equals("javax.swing.plaf.basic.BasicTabbedPaneUI$ScrollableTabViewport")) continue;
                this.tabViewport = (JViewport)component;
                break;
            }
        }
        this.installHiddenTabsNavigation();
        this.installLeadingComponent();
        this.installTrailingComponent();
    }

    @Override
    protected void uninstallComponents() {
        this.uninstallHiddenTabsNavigation();
        this.uninstallLeadingComponent();
        this.uninstallTrailingComponent();
        super.uninstallComponents();
        this.tabCloseButton = null;
        this.tabViewport = null;
    }

    protected void installHiddenTabsNavigation() {
        if (!this.isScrollTabLayout() || this.tabViewport == null) {
            return;
        }
        this.tabPane.setLayout(this.createScrollLayoutManager((BasicTabbedPaneUI.TabbedPaneLayout)this.tabPane.getLayout()));
        this.moreTabsButton = this.createMoreTabsButton();
        this.tabPane.add(this.moreTabsButton);
    }

    protected void uninstallHiddenTabsNavigation() {
        if (this.tabPane.getLayout() instanceof FlatTabbedPaneScrollLayout) {
            this.tabPane.setLayout(((FlatTabbedPaneScrollLayout)this.tabPane.getLayout()).delegate);
        }
        if (this.moreTabsButton != null) {
            this.tabPane.remove(this.moreTabsButton);
            this.moreTabsButton = null;
        }
    }

    protected void installLeadingComponent() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.leadingComponent");
        if (object instanceof Component) {
            this.leadingComponent = new ContainerUIResource((Component)object);
            this.tabPane.add(this.leadingComponent);
        }
    }

    protected void uninstallLeadingComponent() {
        if (this.leadingComponent != null) {
            this.tabPane.remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    protected void installTrailingComponent() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.trailingComponent");
        if (object instanceof Component) {
            this.trailingComponent = new ContainerUIResource((Component)object);
            this.tabPane.add(this.trailingComponent);
        }
    }

    protected void uninstallTrailingComponent() {
        if (this.trailingComponent != null) {
            this.tabPane.remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.getHandler().installListeners();
        if (this.tabViewport != null && (this.wheelTabScroller = this.createWheelTabScroller()) != null) {
            this.tabPane.addMouseWheelListener(this.wheelTabScroller);
            this.tabPane.addMouseMotionListener(this.wheelTabScroller);
            this.tabPane.addMouseListener(this.wheelTabScroller);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (this.handler != null) {
            this.handler.uninstallListeners();
            this.handler = null;
        }
        if (this.wheelTabScroller != null) {
            this.wheelTabScroller.uninstall();
            this.tabPane.removeMouseWheelListener(this.wheelTabScroller);
            this.tabPane.removeMouseMotionListener(this.wheelTabScroller);
            this.tabPane.removeMouseListener(this.wheelTabScroller);
            this.wheelTabScroller = null;
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.tabPane);
        if (actionMap != null) {
            RunWithOriginalLayoutManagerDelegateAction.install(actionMap, "scrollTabsForwardAction");
            RunWithOriginalLayoutManagerDelegateAction.install(actionMap, "scrollTabsBackwardAction");
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected FlatWheelTabScroller createWheelTabScroller() {
        return new FlatWheelTabScroller();
    }

    @Override
    protected MouseListener createMouseListener() {
        Handler handler = this.getHandler();
        handler.mouseDelegate = super.createMouseListener();
        return handler;
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        Handler handler = this.getHandler();
        handler.propertyChangeDelegate = super.createPropertyChangeListener();
        return handler;
    }

    @Override
    protected ChangeListener createChangeListener() {
        Handler handler = this.getHandler();
        handler.changeDelegate = super.createChangeListener();
        return handler;
    }

    @Override
    protected FocusListener createFocusListener() {
        Handler handler = this.getHandler();
        handler.focusDelegate = super.createFocusListener();
        return handler;
    }

    @Override
    protected LayoutManager createLayoutManager() {
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            return new FlatTabbedPaneLayout();
        }
        return super.createLayoutManager();
    }

    protected LayoutManager createScrollLayoutManager(BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout) {
        return new FlatTabbedPaneScrollLayout(tabbedPaneLayout);
    }

    protected JButton createMoreTabsButton() {
        return new FlatMoreTabsButton();
    }

    @Override
    protected JButton createScrollButton(int n2) {
        return new FlatScrollableTabButton(n2);
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.tabPane, "TabbedPane"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        for (Component component : this.tabPane.getComponents()) {
            if (!(component instanceof FlatTabAreaButton)) continue;
            ((FlatTabAreaButton)component).updateStyle();
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.startsWith("close")) {
            if (!(this.closeIcon instanceof FlatTabbedPaneCloseIcon)) {
                return new FlatStylingSupport.UnknownStyleException(string);
            }
            if (this.closeIconShared) {
                this.closeIcon = FlatStylingSupport.cloneIcon(this.closeIcon);
                this.closeIconShared = false;
            }
            return ((FlatTabbedPaneCloseIcon)this.closeIcon).applyStyleProperty(string, object);
        }
        if (object instanceof String) {
            switch (string) {
                case "tabType": {
                    object = FlatTabbedPaneUI.parseTabType((String)object);
                    break;
                }
                case "tabsPopupPolicy": {
                    object = FlatTabbedPaneUI.parseTabsPopupPolicy((String)object);
                    break;
                }
                case "scrollButtonsPolicy": {
                    object = FlatTabbedPaneUI.parseScrollButtonsPolicy((String)object);
                    break;
                }
                case "scrollButtonsPlacement": {
                    object = FlatTabbedPaneUI.parseScrollButtonsPlacement((String)object);
                    break;
                }
                case "tabAreaAlignment": {
                    object = FlatTabbedPaneUI.parseAlignment((String)object, 10);
                    break;
                }
                case "tabAlignment": {
                    object = FlatTabbedPaneUI.parseAlignment((String)object, 0);
                    break;
                }
                case "tabWidthMode": {
                    object = FlatTabbedPaneUI.parseTabWidthMode((String)object);
                    break;
                }
                case "tabRotation": {
                    object = FlatTabbedPaneUI.parseTabRotation((String)object);
                    break;
                }
                case "tabIconPlacement": {
                    object = FlatTabbedPaneUI.parseTabIconPlacement((String)object);
                }
            }
        } else {
            switch (string) {
                case "tabInsets": {
                    Insets insets = this.tabInsets;
                    this.tabInsets = (Insets)object;
                    return insets;
                }
                case "tabAreaInsets": {
                    Insets insets = this.tabAreaInsets;
                    this.tabAreaInsets = (Insets)object;
                    return insets;
                }
                case "textIconGap": {
                    Integer n2 = this.textIconGapUnscaled;
                    this.textIconGapUnscaled = (Integer)object;
                    this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
                    return n2;
                }
            }
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.tabPane, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        FlatStylingSupport.StyleableInfosMap styleableInfosMap = new FlatStylingSupport.StyleableInfosMap();
        styleableInfosMap.put("tabInsets", Insets.class);
        styleableInfosMap.put("tabAreaInsets", Insets.class);
        styleableInfosMap.put("textIconGap", Integer.TYPE);
        FlatStylingSupport.collectAnnotatedStyleableInfos(this, styleableInfosMap);
        if (this.closeIcon instanceof FlatTabbedPaneCloseIcon) {
            styleableInfosMap.putAll(((FlatTabbedPaneCloseIcon)this.closeIcon).getStyleableInfos());
        }
        return styleableInfosMap;
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.startsWith("close")) {
            return this.closeIcon instanceof FlatTabbedPaneCloseIcon ? ((FlatTabbedPaneCloseIcon)this.closeIcon).getStyleableValue(string) : null;
        }
        switch (string) {
            case "tabInsets": {
                return this.tabInsets;
            }
            case "tabAreaInsets": {
                return this.tabAreaInsets;
            }
            case "textIconGap": {
                return this.textIconGapUnscaled;
            }
            case "tabType": {
                switch (this.tabType) {
                    default: {
                        return "underlined";
                    }
                    case 1: 
                }
                return "card";
            }
            case "tabsPopupPolicy": {
                switch (this.tabsPopupPolicy) {
                    default: {
                        return "asNeeded";
                    }
                    case 0: 
                }
                return "never";
            }
            case "scrollButtonsPolicy": {
                switch (this.scrollButtonsPolicy) {
                    default: {
                        return "asNeededSingle";
                    }
                    case 2: {
                        return "asNeeded";
                    }
                    case 0: 
                }
                return "never";
            }
            case "scrollButtonsPlacement": {
                switch (this.scrollButtonsPlacement) {
                    default: {
                        return "both";
                    }
                    case 11: 
                }
                return "trailing";
            }
            case "tabAreaAlignment": {
                return FlatTabbedPaneUI.alignmentToString(this.tabAreaAlignment, "leading");
            }
            case "tabAlignment": {
                return FlatTabbedPaneUI.alignmentToString(this.tabAlignment, "center");
            }
            case "tabWidthMode": {
                switch (this.tabWidthMode) {
                    default: {
                        return "preferred";
                    }
                    case 1: {
                        return "equal";
                    }
                    case 2: 
                }
                return "compact";
            }
            case "tabRotation": {
                switch (this.tabRotation) {
                    default: {
                        return "none";
                    }
                    case -2: {
                        return "auto";
                    }
                    case 2: {
                        return "left";
                    }
                    case 4: 
                }
                return "right";
            }
            case "tabIconPlacement": {
                switch (this.tabIconPlacement) {
                    default: {
                        return "leading";
                    }
                    case 11: {
                        return "trailing";
                    }
                    case 1: {
                        return "top";
                    }
                    case 3: 
                }
                return "bottom";
            }
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    protected void setRolloverTab(int n2, int n3) {
        this.setRolloverTab(this.tabForCoordinate(this.tabPane, n2, n3));
    }

    @Override
    protected void setRolloverTab(int n2) {
        if (this.blockRollover) {
            return;
        }
        int n3 = this.getRolloverTab();
        super.setRolloverTab(n2);
        if (n2 != n3) {
            this.repaintRolloverLaterOnce(n3);
        }
    }

    private void repaintRolloverLaterOnce(int n2) {
        if (this.repaintRolloverPending) {
            return;
        }
        this.repaintRolloverPending = true;
        EventQueue.invokeLater(() -> {
            this.repaintRolloverPending = false;
            if (this.tabPane == null) {
                return;
            }
            int n3 = this.getRolloverTab();
            if (n3 != n2) {
                this.repaintTab(n2);
                this.repaintTab(n3);
            }
        });
    }

    protected boolean isRolloverTabClose() {
        return this.rolloverTabClose;
    }

    protected void setRolloverTabClose(boolean bl2) {
        if (this.rolloverTabClose == bl2) {
            return;
        }
        this.rolloverTabClose = bl2;
        this.repaintTab(this.getRolloverTab());
    }

    protected boolean isPressedTabClose() {
        return this.pressedTabClose;
    }

    protected void setPressedTabClose(boolean bl2) {
        if (this.pressedTabClose == bl2) {
            return;
        }
        this.pressedTabClose = bl2;
        this.repaintTab(this.getRolloverTab());
    }

    private void repaintTab(int n2) {
        if (n2 < 0 || n2 >= this.tabPane.getTabCount()) {
            return;
        }
        Rectangle rectangle = this.getTabBounds(this.tabPane, n2);
        if (rectangle == null) {
            return;
        }
        if (this.contentSeparatorHeight > 0 && FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", true)) {
            int n3 = UIScale.scale(this.contentSeparatorHeight);
            switch (this.tabPane.getTabPlacement()) {
                default: {
                    rectangle.height += n3;
                    break;
                }
                case 3: {
                    rectangle.height += n3;
                    rectangle.y -= n3;
                    break;
                }
                case 2: {
                    rectangle.width += n3;
                    break;
                }
                case 4: {
                    rectangle.width += n3;
                    rectangle.x -= n3;
                }
            }
        }
        HiDPIUtils.repaint(this.tabPane, rectangle);
    }

    @Override
    protected int calculateTabWidth(int n2, int n3, FontMetrics fontMetrics) {
        return this.getRealTabRotation(n2) == -1 ? this.calculateTabWidthImpl(n2, n3, fontMetrics, false) : this.calculateTabHeightImpl(n2, n3, fontMetrics.getHeight(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int calculateTabWidthImpl(int n2, int n3, FontMetrics fontMetrics, boolean bl2) {
        int n4;
        Icon icon;
        int n5 = this.getTabWidthMode();
        if (n5 == 1 && this.isHorizontalOrRotated(n2) && !this.inCalculateEqual) {
            this.inCalculateEqual = true;
            try {
                int n6 = this.isHorizontalTabPlacement(n2) ? this.calculateMaxTabWidth(n2) : this.calculateMaxTabHeight(n2);
                return n6;
            }
            finally {
                this.inCalculateEqual = false;
            }
        }
        this.textIconGap = UIScale.scale(this.textIconGapUnscaled);
        if (n5 == 2 && n3 != this.tabPane.getSelectedIndex() && this.isHorizontalOrRotated(n2) && this.tabPane.getTabComponentAt(n3) == null && (icon = this.getIconForTab(n3)) != null) {
            Insets insets = this.getTabInsets(n2, n3);
            n4 = icon.getIconWidth() + insets.left + insets.right;
        } else {
            Object object;
            int n7 = FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement);
            if ((n7 == 1 || n7 == 3) && this.tabPane.getTabComponentAt(n3) == null && (icon = this.getIconForTab(n3)) != null) {
                Object object2;
                n4 = icon.getIconWidth();
                object = this.getTextViewForTab(n3);
                if (object != null) {
                    n4 = Math.max(n4, (int)((View)object).getPreferredSpan(0));
                } else {
                    object2 = this.tabPane.getTitleAt(n3);
                    if (object2 != null) {
                        n4 = Math.max(n4, fontMetrics.stringWidth((String)object2));
                    }
                }
                object2 = this.getTabInsets(n2, n3);
                n4 += ((Insets)object2).left + ((Insets)object2).right;
            } else {
                n4 = super.calculateTabWidth(n2, n3, fontMetrics) - 3;
                if (bl2 && (object = this.tabPane.getTabComponentAt(n3)) != null) {
                    Dimension dimension = ((Component)object).getPreferredSize();
                    n4 = n4 - dimension.width + dimension.height;
                }
            }
        }
        if (this.isTabClosable(n3)) {
            n4 += this.closeIcon.getIconWidth();
        }
        int n8 = this.getTabClientPropertyInt(n3, "JTabbedPane.minimumTabWidth", this.minimumTabWidth);
        int n9 = this.getTabClientPropertyInt(n3, "JTabbedPane.maximumTabWidth", this.maximumTabWidth);
        if (n8 > 0) {
            n4 = Math.max(n4, UIScale.scale(n8));
        }
        if (n9 > 0 && this.tabPane.getTabComponentAt(n3) == null) {
            n4 = Math.min(n4, UIScale.scale(n9));
        }
        return n4;
    }

    @Override
    protected int calculateTabHeight(int n2, int n3, int n4) {
        return this.getRealTabRotation(n2) == -1 ? this.calculateTabHeightImpl(n2, n3, n4, false) : this.calculateTabWidthImpl(n2, n3, this.getFontMetrics(), true);
    }

    private int calculateTabHeightImpl(int n2, int n3, int n4, boolean bl2) {
        int n5;
        Icon icon;
        int n6 = FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement);
        if ((n6 == 1 || n6 == 3) && this.tabPane.getTabComponentAt(n3) == null && (icon = this.getIconForTab(n3)) != null) {
            n5 = icon.getIconHeight();
            View view = this.getTextViewForTab(n3);
            if (view != null) {
                n5 += (int)view.getPreferredSpan(1) + UIScale.scale(this.textIconGapUnscaled);
            } else if (this.tabPane.getTitleAt(n3) != null) {
                n5 += n4 + UIScale.scale(this.textIconGapUnscaled);
            }
            Insets insets = this.getTabInsets(n2, n3);
            n5 += insets.top + insets.bottom;
        } else {
            Component component;
            n5 = super.calculateTabHeight(n2, n3, n4) - 2;
            if (bl2 && (component = this.tabPane.getTabComponentAt(n3)) != null) {
                Dimension dimension = component.getPreferredSize();
                n5 = n5 - dimension.height + dimension.width;
            }
        }
        return Math.max(n5, UIScale.scale(FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabHeight", this.tabHeight)));
    }

    @Override
    protected int calculateMaxTabWidth(int n2) {
        return this.hideTabArea() ? 0 : super.calculateMaxTabWidth(n2);
    }

    @Override
    protected int calculateMaxTabHeight(int n2) {
        return this.hideTabArea() ? 0 : super.calculateMaxTabHeight(n2);
    }

    @Override
    protected int calculateTabAreaWidth(int n2, int n3, int n4) {
        return this.hideTabArea() ? 0 : super.calculateTabAreaWidth(n2, n3, n4);
    }

    @Override
    protected int calculateTabAreaHeight(int n2, int n3, int n4) {
        return this.hideTabArea() ? 0 : super.calculateTabAreaHeight(n2, n3, n4);
    }

    @Override
    protected Insets getTabInsets(int n2, int n3) {
        Object object = this.getTabClientProperty(n3, "JTabbedPane.tabInsets");
        return UIScale.scale(object instanceof Insets ? (Insets)object : super.getTabInsets(n2, n3));
    }

    protected Insets getTabInsetsRotated(int n2, int n3, int n4) {
        Insets insets = this.getTabInsets(n2, n3);
        switch (n4) {
            case 2: {
                return new Insets(insets.right, insets.top, insets.left, insets.bottom);
            }
            case 4: {
                return new Insets(insets.left, insets.bottom, insets.right, insets.top);
            }
        }
        return insets;
    }

    @Override
    protected Insets getSelectedTabPadInsets(int n2) {
        return new Insets(0, 0, 0, 0);
    }

    protected Insets getRealTabAreaInsets(int n2) {
        if (this.tabAreaInsets == null) {
            this.tabAreaInsets = new Insets(0, 0, 0, 0);
        }
        Insets insets = super.getTabAreaInsets(n2);
        Insets insets2 = (Insets)insets.clone();
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabAreaInsets");
        if (object instanceof Insets) {
            FlatTabbedPaneUI.rotateInsets((Insets)object, insets2, n2);
        }
        insets.left = -10000;
        insets.top = -10000;
        insets2 = UIScale.scale(insets2);
        return insets2;
    }

    @Override
    protected Insets getTabAreaInsets(int n2) {
        Insets insets = this.getRealTabAreaInsets(n2);
        if (this.tabPane.getTabLayoutPolicy() == 0) {
            if (this.isHorizontalTabPlacement(n2)) {
                insets.left += this.getLeadingPreferredWidth();
                insets.right += this.getTrailingPreferredWidth();
            } else {
                insets.top += this.getLeadingPreferredHeight();
                insets.bottom += this.getTrailingPreferredHeight();
            }
        }
        return insets;
    }

    @Override
    protected Insets getContentBorderInsets(int n2) {
        if (this.hideTabArea() || this.contentSeparatorHeight == 0 || !FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", this.showContentSeparator)) {
            return new Insets(0, 0, 0, 0);
        }
        boolean bl2 = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int n3 = UIScale.scale(this.contentSeparatorHeight);
        Insets insets = bl2 ? new Insets(n3, n3, n3, n3) : new Insets(n3, 0, 0, 0);
        Insets insets2 = new Insets(0, 0, 0, 0);
        FlatTabbedPaneUI.rotateInsets(insets, insets2, n2);
        return insets2;
    }

    @Override
    protected int getTabLabelShiftX(int n2, int n3, boolean bl2) {
        if (this.isTabClosable(n3) && this.getRealTabRotation(n2) == -1) {
            int n4 = this.closeIcon.getIconWidth() / 2;
            return this.isLeftToRight() ? -n4 : n4;
        }
        return 0;
    }

    @Override
    protected int getTabLabelShiftY(int n2, int n3, boolean bl2) {
        if (this.isTabClosable(n3) && this.getRealTabRotation(n2) != -1) {
            int n4 = this.closeIcon.getIconHeight() / 2;
            return this.isLeftToRight() ? n4 : -n4;
        }
        return 0;
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        this.oldRenderingHints = FlatUIUtils.setRenderingHints(graphics);
        super.update(graphics, jComponent);
        FlatUIUtils.resetRenderingHints(graphics, this.oldRenderingHints);
        this.oldRenderingHints = null;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.hideTabArea()) {
            return;
        }
        this.ensureCurrentLayout();
        int n2 = this.tabPane.getTabPlacement();
        int n3 = this.tabPane.getSelectedIndex();
        this.paintContentBorder(graphics, n2, n3);
        if (this.tabsOpaque && !this.tabPane.isOpaque() && this.tabPane.getTabCount() > 0) {
            Rectangle rectangle = null;
            if (this.isScrollTabLayout()) {
                rectangle = this.tabViewport.getBounds();
                for (Component component : this.tabPane.getComponents()) {
                    if (!(component instanceof FlatTabAreaButton) || !component.isVisible()) continue;
                    rectangle = rectangle.union(component.getBounds());
                }
            } else {
                for (Rectangle rectangle2 : this.rects) {
                    rectangle = rectangle != null ? rectangle.union(rectangle2) : rectangle2;
                }
            }
            if (rectangle != null) {
                graphics.setColor(this.tabPane.getBackground());
                if (this.getTabType() == 1 && this.cardTabArc > 0) {
                    ((Graphics2D)graphics).fill(this.createCardTabOuterPath(n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                } else {
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
        }
        if (!this.isScrollTabLayout()) {
            this.paintTabArea(graphics, n2, n3);
        }
    }

    @Override
    protected void paintTabArea(Graphics graphics, int n2, int n3) {
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        super.paintTabArea(graphics, n2, n3);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    @Override
    protected void paintTab(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2) {
        boolean bl2;
        boolean bl3;
        Rectangle rectangle3 = rectangleArray[n3];
        int n4 = rectangle3.x;
        int n5 = rectangle3.y;
        int n6 = rectangle3.width;
        int n7 = rectangle3.height;
        boolean bl4 = bl3 = n3 == this.tabPane.getSelectedIndex();
        if (this.tabsOpaque || this.tabPane.isOpaque()) {
            this.paintTabBackground(graphics, n2, n3, n4, n5, n6, n7, bl3);
        }
        this.paintTabBorder(graphics, n2, n3, n4, n5, n6, n7, bl3);
        if (this.isTabClosable(n3)) {
            this.paintTabCloseButton(graphics, n3, n4, n5, n6, n7);
        }
        if (bl3) {
            this.paintTabSelection(graphics, n2, n3, n4, n5, n6, n7);
        }
        if (this.tabPane.getTabComponentAt(n3) != null) {
            return;
        }
        String string = this.tabPane.getTitleAt(n3);
        Icon icon = this.getIconForTab(n3);
        Font font = this.tabPane.getFont();
        FontMetrics fontMetrics = this.tabPane.getFontMetrics(font);
        boolean bl5 = bl2 = icon != null && !bl3 && this.getTabWidthMode() == 2 && this.isHorizontalOrRotated(n2);
        if (bl2) {
            string = null;
        }
        String string2 = this.layoutAndClipLabel(n2, fontMetrics, n3, string, icon, rectangle3, rectangle, rectangle2, bl3);
        if (this.tabViewport != null && (n2 == 1 || n2 == 3)) {
            Rectangle rectangle4 = this.tabViewport.getViewRect();
            rectangle4.width -= 4;
            if (!rectangle4.contains(rectangle2)) {
                Rectangle rectangle5 = rectangle4.intersection(rectangle2);
                if (rectangle5.x > rectangle4.x) {
                    string2 = JavaCompatibility.getClippedString(null, fontMetrics, string, rectangle5.width);
                }
            }
        }
        if (!bl2) {
            this.paintText(graphics, n2, font, fontMetrics, n3, string2, rectangle2, bl3);
        }
        this.paintIcon(graphics, n2, n3, icon, rectangle, bl3);
    }

    @Override
    protected void paintText(Graphics graphics, int n2, Font font, FontMetrics fontMetrics, int n3, String string, Rectangle rectangle, boolean bl2) {
        graphics.setFont(font);
        FlatUIUtils.runWithoutRenderingHints(graphics, this.oldRenderingHints, () -> {
            View view = this.getTextViewForTab(n3);
            if (view != null) {
                AffineTransform affineTransform = this.rotateGraphics(graphics, n2, rectangle);
                Rectangle rectangle2 = affineTransform != null ? new Rectangle(rectangle.x, rectangle.y, rectangle.height, rectangle.width) : rectangle;
                view.paint(graphics, rectangle2);
                if (affineTransform != null) {
                    ((Graphics2D)graphics).setTransform(affineTransform);
                }
                return;
            }
            AffineTransform affineTransform = this.rotateGraphics(graphics, n2, rectangle);
            int n4 = FlatLaf.isShowMnemonics() ? this.tabPane.getDisplayedMnemonicIndexAt(n3) : -1;
            graphics.setColor(this.getTabForeground(n2, n3, bl2));
            FlatUIUtils.drawStringUnderlineCharAt(this.tabPane, graphics, string, n4, rectangle.x, rectangle.y + fontMetrics.getAscent());
            if (affineTransform != null) {
                ((Graphics2D)graphics).setTransform(affineTransform);
            }
        });
    }

    @Override
    protected void paintIcon(Graphics graphics, int n2, int n3, Icon icon, Rectangle rectangle, boolean bl2) {
        if (icon == null) {
            return;
        }
        Shape shape = graphics.getClip();
        ((Graphics2D)graphics).clip(rectangle);
        AffineTransform affineTransform = this.rotateGraphics(graphics, n2, rectangle);
        icon.paintIcon(this.tabPane, graphics, rectangle.x, rectangle.y);
        if (affineTransform != null) {
            ((Graphics2D)graphics).setTransform(affineTransform);
        }
        graphics.setClip(shape);
    }

    private AffineTransform rotateGraphics(Graphics graphics, int n2, Rectangle rectangle) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        AffineTransform affineTransform = null;
        int n3 = this.getRealTabRotation(n2);
        if (n3 == 2) {
            affineTransform = graphics2D.getTransform();
            graphics2D.translate(0, rectangle.height);
            graphics2D.rotate(Math.toRadians(270.0), rectangle.x, rectangle.y);
        } else if (n3 == 4) {
            affineTransform = graphics2D.getTransform();
            graphics2D.translate(rectangle.width, 0);
            graphics2D.rotate(Math.toRadians(90.0), rectangle.x, rectangle.y);
        }
        return affineTransform;
    }

    protected Color getTabForeground(int n2, int n3, boolean bl2) {
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n3)) {
            return this.disabledForeground;
        }
        if (this.hoverForeground != null && this.getRolloverTab() == n3) {
            return this.hoverForeground;
        }
        Color color = this.tabPane.getForegroundAt(n3);
        if (color != this.tabPane.getForeground()) {
            return color;
        }
        if (this.focusForeground != null && bl2 && FlatUIUtils.isPermanentFocusOwner(this.tabPane)) {
            return this.focusForeground;
        }
        if (this.selectedForeground != null && bl2) {
            return this.selectedForeground;
        }
        return color;
    }

    @Override
    protected void paintTabBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        Serializable serializable;
        boolean bl3;
        boolean bl4 = bl3 = this.getTabType() == 1;
        if (!bl3 && this.selectedInsets != null) {
            serializable = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(this.selectedInsets, (Insets)serializable, this.tabPane.getTabPlacement());
            n4 += UIScale.scale(((Insets)serializable).left);
            n5 += UIScale.scale(((Insets)serializable).top);
            n6 -= UIScale.scale(((Insets)serializable).left + ((Insets)serializable).right);
            n7 -= UIScale.scale(((Insets)serializable).top + ((Insets)serializable).bottom);
        }
        if ((serializable = this.getTabBackground(n2, n3, bl2)) != this.tabPane.getBackground()) {
            graphics.setColor(FlatUIUtils.deriveColor(serializable, this.tabPane.getBackground()));
            if (!bl3 && this.tabArc > 0) {
                float f2 = UIScale.scale((float)this.tabArc) / 2.0f;
                FlatUIUtils.paintSelection((Graphics2D)graphics, n4, n5, n6, n7, null, f2, f2, f2, f2, 0);
            } else if (bl3 && this.cardTabArc > 0) {
                ((Graphics2D)graphics).fill(this.createCardTabOuterPath(n2, n4, n5, n6, n7));
            } else {
                graphics.fillRect(n4, n5, n6, n7);
            }
        }
    }

    protected Color getTabBackground(int n2, int n3, boolean bl2) {
        Color color = this.tabPane.getBackgroundAt(n3);
        if (!this.tabPane.isEnabled() || !this.tabPane.isEnabledAt(n3)) {
            return color;
        }
        if (this.hoverColor != null && this.getRolloverTab() == n3) {
            return this.hoverColor;
        }
        if (color != this.tabPane.getBackground()) {
            return color;
        }
        if (this.focusColor != null && bl2 && FlatUIUtils.isPermanentFocusOwner(this.tabPane)) {
            return this.focusColor;
        }
        if (this.selectedBackground != null && bl2) {
            return this.selectedBackground;
        }
        return color;
    }

    @Override
    protected void paintTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl2) {
        if (FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showTabSeparators", this.showTabSeparators) && !this.isLastInRun(n3)) {
            if (this.getTabType() == 1) {
                int n8 = this.tabPane.getSelectedIndex();
                if (n3 != n8 - 1 && n3 != n8) {
                    this.paintTabSeparator(graphics, n2, n4, n5, n6, n7);
                }
            } else {
                this.paintTabSeparator(graphics, n2, n4, n5, n6, n7);
            }
        }
        if (bl2 && this.getTabType() == 1) {
            this.paintCardTabBorder(graphics, n2, n3, n4, n5, n6, n7);
        }
    }

    protected void paintCardTabBorder(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(this.createCardTabOuterPath(n2, n4, n5, n6, n7), false);
        float_.append(this.createCardTabInnerPath(n2, n4, n5, n6, n7), false);
        graphics.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
        graphics2D.fill(float_);
    }

    protected Shape createCardTabOuterPath(int n2, int n3, int n4, int n5, int n6) {
        float f2 = UIScale.scale((float)this.cardTabArc) / 2.0f;
        switch (n2) {
            default: {
                return FlatUIUtils.createRoundRectanglePath(n3, n4, n5, n6, f2, f2, 0.0f, 0.0f);
            }
            case 3: {
                return FlatUIUtils.createRoundRectanglePath(n3, n4, n5, n6, 0.0f, 0.0f, f2, f2);
            }
            case 2: {
                return FlatUIUtils.createRoundRectanglePath(n3, n4, n5, n6, f2, 0.0f, f2, 0.0f);
            }
            case 4: 
        }
        return FlatUIUtils.createRoundRectanglePath(n3, n4, n5, n6, 0.0f, f2, 0.0f, f2);
    }

    protected Shape createCardTabInnerPath(int n2, int n3, int n4, int n5, int n6) {
        float f2 = UIScale.scale((float)this.contentSeparatorHeight);
        float f3 = UIScale.scale((float)this.cardTabArc) / 2.0f - f2;
        switch (n2) {
            default: {
                return FlatUIUtils.createRoundRectanglePath((float)n3 + f2, (float)n4 + f2, (float)n5 - f2 * 2.0f, (float)n6 - f2, f3, f3, 0.0f, 0.0f);
            }
            case 3: {
                return FlatUIUtils.createRoundRectanglePath((float)n3 + f2, n4, (float)n5 - f2 * 2.0f, (float)n6 - f2, 0.0f, 0.0f, f3, f3);
            }
            case 2: {
                return FlatUIUtils.createRoundRectanglePath((float)n3 + f2, (float)n4 + f2, (float)n5 - f2, (float)n6 - f2 * 2.0f, f3, 0.0f, f3, 0.0f);
            }
            case 4: 
        }
        return FlatUIUtils.createRoundRectanglePath(n3, (float)n4 + f2, (float)n5 - f2, (float)n6 - f2 * 2.0f, 0.0f, f3, 0.0f, f3);
    }

    protected void paintTabCloseButton(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        if (this.tabCloseButton == null) {
            this.tabCloseButton = new TabCloseButton();
            this.tabCloseButton.setVisible(false);
        }
        boolean bl2 = n2 == this.getRolloverTab();
        ButtonModel buttonModel = this.tabCloseButton.getModel();
        buttonModel.setRollover(bl2 && this.isRolloverTabClose());
        buttonModel.setPressed(bl2 && this.isPressedTabClose());
        this.tabCloseButton.setBackground(this.tabPane.getBackground());
        this.tabCloseButton.setForeground(this.tabPane.getForeground());
        Rectangle rectangle = this.getTabCloseBounds(n2, n3, n4, n5, n6, this.calcRect);
        this.closeIcon.paintIcon(this.tabCloseButton, graphics, rectangle.x, rectangle.y);
    }

    protected void paintTabSeparator(Graphics graphics, int n2, int n3, int n4, int n5, int n6) {
        float f2 = UIScale.scale(1.0f);
        float f3 = this.tabSeparatorsFullHeight ? 0.0f : UIScale.scale(5.0f);
        graphics.setColor(this.tabSeparatorColor != null ? this.tabSeparatorColor : this.contentAreaColor);
        if (n2 == 2 || n2 == 4) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float((float)n3 + f3, (float)(n4 + n6) - f2, (float)n5 - f3 * 2.0f, f2));
        } else if (this.isLeftToRight()) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float((float)(n3 + n5) - f2, (float)n4 + f3, f2, (float)n6 - f3 * 2.0f));
        } else {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(n3, (float)n4 + f3, f2, (float)n6 - f3 * 2.0f));
        }
    }

    protected void paintTabSelection(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        Cloneable cloneable;
        boolean bl2;
        graphics.setColor(this.tabPane.isEnabled() ? (this.isTabbedPaneOrChildFocused() ? this.underlineColor : this.inactiveUnderlineColor) : this.disabledUnderlineColor);
        boolean bl3 = this.getTabType() == 1;
        boolean bl4 = bl2 = !bl3;
        Insets insets = bl2 ? (!this.rotateTabRuns && this.runCount > 1 && !this.isScrollTabLayout() && this.getRunForTab(this.tabPane.getTabCount(), n3) > 0 ? new Insets(0, 0, 0, 0) : this.getContentBorderInsets(n2)) : null;
        int n8 = UIScale.scale(bl3 ? this.cardTabSelectionHeight : this.tabSelectionHeight);
        float f2 = UIScale.scale((float)(bl3 ? this.cardTabArc : this.tabSelectionArc)) / 2.0f;
        int n9 = n4;
        int n10 = n5;
        int n11 = n6;
        int n12 = n7;
        switch (n2) {
            default: {
                n10 = bl2 ? n5 + n7 + insets.top - n8 : n5;
                n12 = n8;
                break;
            }
            case 3: {
                n10 = bl2 ? n5 - insets.bottom : n5 + n7 - n8;
                n12 = n8;
                break;
            }
            case 2: {
                n9 = bl2 ? n4 + n6 + insets.left - n8 : n4;
                n11 = n8;
                break;
            }
            case 4: {
                n9 = bl2 ? n4 - insets.right : n4 + n6 - n8;
                n11 = n8;
            }
        }
        if (!bl3 && this.tabSelectionInsets != null) {
            cloneable = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(this.tabSelectionInsets, (Insets)cloneable, this.tabPane.getTabPlacement());
            n9 += UIScale.scale(((Insets)cloneable).left);
            n10 += UIScale.scale(((Insets)cloneable).top);
            n11 -= UIScale.scale(((Insets)cloneable).left + ((Insets)cloneable).right);
            n12 -= UIScale.scale(((Insets)cloneable).top + ((Insets)cloneable).bottom);
        }
        if (f2 <= 0.0f) {
            graphics.fillRect(n9, n10, n11, n12);
        } else if (bl3) {
            cloneable = new Area(this.createCardTabOuterPath(n2, n4, n5, n6, n7));
            ((Area)cloneable).intersect(new Area(new Rectangle2D.Float(n9, n10, n11, n12)));
            ((Graphics2D)graphics).fill((Shape)((Object)cloneable));
        } else {
            FlatUIUtils.paintSelection((Graphics2D)graphics, n9, n10, n11, n12, null, f2, f2, f2, f2, 0);
        }
    }

    protected boolean isTabbedPaneOrChildFocused() {
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Object object = this.tabPane.getClientProperty("JComponent.focusOwner");
        if (object instanceof Predicate) {
            return ((Predicate)object).test(this.tabPane) && FlatUIUtils.isInActiveWindow(this.tabPane, keyboardFocusManager.getActiveWindow());
        }
        Component component = keyboardFocusManager.getPermanentFocusOwner();
        return component != null && SwingUtilities.isDescendingFrom(component, this.tabPane) && FlatUIUtils.isInActiveWindow(component, keyboardFocusManager.getActiveWindow());
    }

    @Override
    protected void paintContentBorder(Graphics graphics, int n2, int n3) {
        Rectangle2D rectangle2D;
        Shape shape;
        if (this.tabPane.getTabCount() <= 0 || this.contentSeparatorHeight == 0 || !FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.showContentSeparator", this.showContentSeparator)) {
            return;
        }
        Insets insets = this.tabPane.getInsets();
        Insets insets2 = this.getTabAreaInsets(n2);
        int n4 = insets.left;
        int n5 = insets.top;
        int n6 = this.tabPane.getWidth() - insets.right - insets.left;
        int n7 = this.tabPane.getHeight() - insets.top - insets.bottom;
        switch (n2) {
            default: {
                n5 += this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                n7 -= (n5 -= insets2.bottom) - insets.top;
                break;
            }
            case 3: {
                n7 -= this.calculateTabAreaHeight(n2, this.runCount, this.maxTabHeight);
                n7 += insets2.top;
                break;
            }
            case 2: {
                n4 += this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                n6 -= (n4 -= insets2.right) - insets.left;
                break;
            }
            case 4: {
                n6 -= this.calculateTabAreaWidth(n2, this.runCount, this.maxTabWidth);
                n6 += insets2.left;
            }
        }
        boolean bl2 = FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hasFullBorder", this.hasFullBorder);
        int n8 = UIScale.scale(this.contentSeparatorHeight * 100);
        Insets insets3 = new Insets(0, 0, 0, 0);
        FlatTabbedPaneUI.rotateInsets(bl2 ? new Insets(n8, n8, n8, n8) : new Insets(n8, 0, 0, 0), insets3, n2);
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(new Rectangle2D.Float(n4, n5, n6, n7), false);
        float_.append(new Rectangle2D.Float((float)n4 + (float)insets3.left / 100.0f, (float)n5 + (float)insets3.top / 100.0f, (float)n6 - (float)insets3.left / 100.0f - (float)insets3.right / 100.0f, (float)n7 - (float)insets3.top / 100.0f - (float)insets3.bottom / 100.0f), false);
        if (this.getTabType() == 1 && n3 >= 0) {
            float f2;
            float f3 = UIScale.scale((float)this.contentSeparatorHeight);
            shape = this.getTabBounds(this.tabPane, n3);
            rectangle2D = new Rectangle2D.Float((float)shape.x + f3, (float)shape.y + f3, (float)shape.width - f3 * 2.0f, (float)shape.height - f3 * 2.0f);
            if (this.tabViewport != null) {
                Rectangle2D.intersect(this.tabViewport.getBounds(), rectangle2D, rectangle2D);
            }
            Rectangle2D.Float float_2 = null;
            if (this.isHorizontalTabPlacement(n2)) {
                if (((Rectangle2D.Float)rectangle2D).width > 0.0f) {
                    f2 = n2 == 1 ? (float)n5 : (float)(n5 + n7) - f3;
                    float_2 = new Rectangle2D.Float(((Rectangle2D.Float)rectangle2D).x, f2, ((Rectangle2D.Float)rectangle2D).width, f3);
                }
            } else if (((Rectangle2D.Float)rectangle2D).height > 0.0f) {
                f2 = n2 == 2 ? (float)n4 : (float)(n4 + n6) - f3;
                float_2 = new Rectangle2D.Float(f2, ((Rectangle2D.Float)rectangle2D).y, f3, ((Rectangle2D.Float)rectangle2D).height);
            }
            if (float_2 != null) {
                float_.append(float_2, false);
                Color color = this.getTabBackground(n2, n3, true);
                graphics.setColor(FlatUIUtils.deriveColor(color, this.tabPane.getBackground()));
                ((Graphics2D)graphics).fill(float_2);
            }
        }
        graphics.setColor(this.contentAreaColor);
        ((Graphics2D)graphics).fill(float_);
        if (this.isScrollTabLayout() && n3 >= 0 && this.tabViewport != null) {
            Rectangle rectangle = this.getTabBounds(this.tabPane, n3);
            shape = graphics.getClip();
            rectangle2D = this.tabViewport.getBounds();
            if (this.isHorizontalTabPlacement(n2)) {
                graphics.clipRect(rectangle2D.x, 0, rectangle2D.width, this.tabPane.getHeight());
            } else {
                graphics.clipRect(0, rectangle2D.y, this.tabPane.getWidth(), rectangle2D.height);
            }
            this.paintTabSelection(graphics, n2, n3, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setClip(shape);
        }
    }

    @Override
    protected void paintFocusIndicator(Graphics graphics, int n2, Rectangle[] rectangleArray, int n3, Rectangle rectangle, Rectangle rectangle2, boolean bl2) {
    }

    protected String layoutAndClipLabel(int n2, FontMetrics fontMetrics, int n3, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, boolean bl2) {
        int n4;
        int n5;
        int n6 = this.getRealTabRotation(n2);
        boolean bl3 = this.isLeftToRight();
        rectangle = FlatUIUtils.subtractInsets(rectangle, this.getTabInsetsRotated(n2, n3, n6));
        if (this.isTabClosable(n3)) {
            if (n6 == -1) {
                n5 = this.closeIcon.getIconWidth();
                rectangle.width -= n5;
                if (!bl3) {
                    rectangle.x += n5;
                }
            } else {
                n5 = this.closeIcon.getIconHeight();
                rectangle.height -= n5;
                if (n6 == 2 && bl3 || n6 == 4 && !bl3) {
                    rectangle.y += n5;
                }
            }
        }
        switch (FlatClientProperties.clientPropertyInt(this.tabPane, "JTabbedPane.tabIconPlacement", this.tabIconPlacement)) {
            default: {
                n5 = 0;
                n4 = 11;
                break;
            }
            case 11: {
                n5 = 0;
                n4 = 10;
                break;
            }
            case 1: {
                n5 = 3;
                n4 = 0;
                break;
            }
            case 3: {
                n5 = 1;
                n4 = 0;
            }
        }
        rectangle3.setBounds(0, 0, 0, 0);
        rectangle2.setBounds(0, 0, 0, 0);
        View view = this.getTextViewForTab(n3);
        if (view != null) {
            this.tabPane.putClientProperty("html", view);
        }
        String string2 = n6 == -1 ? SwingUtilities.layoutCompoundLabel(this.tabPane, fontMetrics, string, icon, 0, this.getTabAlignment(n3), n5, n4, rectangle, rectangle2, rectangle3, UIScale.scale(this.textIconGapUnscaled)) : this.layoutVerticalCompoundLabel(n6, this.tabPane, fontMetrics, string, icon, 0, this.getTabAlignment(n3), n5, n4, rectangle, rectangle2, rectangle3, UIScale.scale(this.textIconGapUnscaled));
        this.tabPane.putClientProperty("html", null);
        return string2;
    }

    private String layoutVerticalCompoundLabel(int n2, JComponent jComponent, FontMetrics fontMetrics, String string, Icon icon, int n3, int n4, int n5, int n6, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n7) {
        Rectangle rectangle4 = new Rectangle(rectangle.height, rectangle.width);
        String string2 = SwingUtilities.layoutCompoundLabel(jComponent, fontMetrics, string, icon, n3, n4, n5, n6, rectangle4, rectangle2, rectangle3, n7);
        if (n2 == 2) {
            this.rotateLeft(rectangle, rectangle2);
            this.rotateLeft(rectangle, rectangle3);
        } else {
            this.rotateRight(rectangle, rectangle2);
            this.rotateRight(rectangle, rectangle3);
        }
        return string2;
    }

    private void rotateLeft(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = rectangle.x + rectangle2.y;
        int n3 = rectangle.y + (rectangle.height - (rectangle2.x + rectangle2.width));
        rectangle2.setBounds(n2, n3, rectangle2.height, rectangle2.width);
    }

    private void rotateRight(Rectangle rectangle, Rectangle rectangle2) {
        int n2 = rectangle.x + (rectangle.width - (rectangle2.y + rectangle2.height));
        int n3 = rectangle.y + rectangle2.x;
        rectangle2.setBounds(n2, n3, rectangle2.height, rectangle2.width);
    }

    protected int getRealTabRotation(int n2) {
        int n3;
        int n4 = this.getTabRotation();
        int n5 = n4 == -2 ? (n2 == 2 ? 2 : (n2 == 4 ? 4 : -1)) : (n3 = n4 == 2 || n4 == 4 ? n4 : -1);
        assert (n3 == -1 || n3 == 2 || n3 == 4);
        return n3;
    }

    @Override
    public int tabForCoordinate(JTabbedPane jTabbedPane, int n2, int n3) {
        if (this.moreTabsButton != null) {
            Point point = this.tabViewport.getViewPosition();
            n2 = n2 - this.tabViewport.getX() + point.x;
            n3 = n3 - this.tabViewport.getY() + point.y;
            if (!this.tabViewport.getViewRect().contains(n2, n3)) {
                return -1;
            }
        }
        return super.tabForCoordinate(jTabbedPane, n2, n3);
    }

    @Override
    protected Rectangle getTabBounds(int n2, Rectangle rectangle) {
        if (this.moreTabsButton != null) {
            rectangle.setBounds(this.rects[n2]);
            Point point = this.tabViewport.getViewPosition();
            rectangle.x = rectangle.x + this.tabViewport.getX() - point.x;
            rectangle.y = rectangle.y + this.tabViewport.getY() - point.y;
            return rectangle;
        }
        return super.getTabBounds(n2, rectangle);
    }

    protected Rectangle getTabCloseBounds(int n2, int n3, int n4, int n5, int n6, Rectangle rectangle) {
        int n7 = this.closeIcon.getIconWidth();
        int n8 = this.closeIcon.getIconHeight();
        int n9 = this.tabPane.getTabPlacement();
        int n10 = this.getRealTabRotation(n9);
        Insets insets = this.getTabInsetsRotated(n9, n2, n10);
        boolean bl2 = this.isLeftToRight();
        if (n10 == -1) {
            rectangle.x = bl2 ? n3 + n5 - insets.right / 3 * 2 - n7 : n3 + insets.left / 3 * 2;
            rectangle.y = n4 + (n6 - n8) / 2;
        } else {
            rectangle.x = n3 + (n5 - n7) / 2;
            rectangle.y = n10 == 4 && bl2 || n10 == 2 && !bl2 ? n4 + n6 - insets.bottom / 3 * 2 - n8 : n4 + insets.top / 3 * 2;
        }
        rectangle.width = n7;
        rectangle.height = n8;
        return rectangle;
    }

    protected Rectangle getTabCloseHitArea(int n2) {
        Rectangle rectangle = this.getTabBounds(this.tabPane, n2);
        Rectangle rectangle2 = this.getTabCloseBounds(n2, rectangle.x, rectangle.y, rectangle.width, rectangle.height, this.calcRect);
        return this.getRealTabRotation(this.tabPane.getTabPlacement()) == -1 ? new Rectangle(rectangle2.x, rectangle.y, rectangle2.width, rectangle.height) : new Rectangle(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height);
    }

    protected boolean isTabClosable(int n2) {
        if (n2 < 0) {
            return false;
        }
        Object object = this.getTabClientProperty(n2, "JTabbedPane.tabClosable");
        return object instanceof Boolean ? (Boolean)object : this.tabClosable;
    }

    protected void closeTab(int n2) {
        Object object = this.getTabClientProperty(n2, "JTabbedPane.tabCloseCallback");
        if (object instanceof IntConsumer) {
            ((IntConsumer)object).accept(n2);
        } else if (object instanceof BiConsumer) {
            ((BiConsumer)object).accept(this.tabPane, n2);
        } else {
            throw new RuntimeException("Missing tab close callback. Set client property 'JTabbedPane.tabCloseCallback' to a 'java.util.function.IntConsumer' or 'java.util.function.BiConsumer<JTabbedPane, Integer>'");
        }
    }

    protected Object getTabClientProperty(int n2, String string) {
        Object object;
        if (n2 < 0) {
            return null;
        }
        Component component = this.tabPane.getComponentAt(n2);
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty(string)) != null) {
            return object;
        }
        return this.tabPane.getClientProperty(string);
    }

    protected int getTabClientPropertyInt(int n2, String string, int n3) {
        Object object = this.getTabClientProperty(n2, string);
        return object instanceof Integer ? (Integer)object : n3;
    }

    protected void ensureCurrentLayout() {
        super.getTabRunCount(this.tabPane);
    }

    @Override
    protected boolean shouldRotateTabRuns(int n2) {
        return this.rotateTabRuns;
    }

    private boolean isLastInRun(int n2) {
        int n3 = this.getRunForTab(this.tabPane.getTabCount(), n2);
        return this.lastTabInRun(this.tabPane.getTabCount(), n3) == n2;
    }

    private boolean isScrollTabLayout() {
        return this.tabPane.getTabLayoutPolicy() == 1;
    }

    private boolean isLeftToRight() {
        return this.tabPane.getComponentOrientation().isLeftToRight();
    }

    protected boolean isHorizontalTabPlacement(int n2) {
        return n2 == 1 || n2 == 3;
    }

    private boolean isHorizontalOrRotated(int n2) {
        return this.isHorizontalTabPlacement(n2) == (this.getRealTabRotation(n2) == -1);
    }

    protected boolean isSmoothScrollingEnabled() {
        if (!Animator.useAnimation()) {
            return false;
        }
        return UIManager.getBoolean("ScrollPane.smoothScrolling");
    }

    protected boolean hideTabArea() {
        return this.tabPane.getTabCount() == 1 && this.leadingComponent == null && this.trailingComponent == null && FlatClientProperties.clientPropertyBoolean(this.tabPane, "JTabbedPane.hideTabAreaWithOneTab", this.hideTabAreaWithOneTab);
    }

    protected int getTabType() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabType");
        return object instanceof String ? FlatTabbedPaneUI.parseTabType((String)object) : this.tabType;
    }

    protected int getTabsPopupPolicy() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabsPopupPolicy");
        return object instanceof String ? FlatTabbedPaneUI.parseTabsPopupPolicy((String)object) : this.tabsPopupPolicy;
    }

    protected int getScrollButtonsPolicy() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.scrollButtonsPolicy");
        return object instanceof String ? FlatTabbedPaneUI.parseScrollButtonsPolicy((String)object) : this.scrollButtonsPolicy;
    }

    protected int getScrollButtonsPlacement() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.scrollButtonsPlacement");
        return object instanceof String ? FlatTabbedPaneUI.parseScrollButtonsPlacement((String)object) : this.scrollButtonsPlacement;
    }

    protected int getTabAreaAlignment() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabAreaAlignment");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return object instanceof String ? FlatTabbedPaneUI.parseAlignment((String)object, 10) : this.tabAreaAlignment;
    }

    protected int getTabAlignment(int n2) {
        Object object = this.getTabClientProperty(n2, "JTabbedPane.tabAlignment");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return object instanceof String ? FlatTabbedPaneUI.parseAlignment((String)object, 0) : this.tabAlignment;
    }

    protected int getTabWidthMode() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabWidthMode");
        return object instanceof String ? FlatTabbedPaneUI.parseTabWidthMode((String)object) : this.tabWidthMode;
    }

    protected int getTabRotation() {
        Object object = this.tabPane.getClientProperty("JTabbedPane.tabRotation");
        if (object instanceof Integer) {
            return (Integer)object;
        }
        return object instanceof String ? FlatTabbedPaneUI.parseTabRotation((String)object) : this.tabRotation;
    }

    protected static int parseTabType(String string) {
        if (string == null) {
            return 0;
        }
        switch (string) {
            default: {
                return 0;
            }
            case "card": 
        }
        return 1;
    }

    protected static int parseTabsPopupPolicy(String string) {
        if (string == null) {
            return 2;
        }
        switch (string) {
            default: {
                return 2;
            }
            case "never": 
        }
        return 0;
    }

    protected static int parseScrollButtonsPolicy(String string) {
        if (string == null) {
            return 3;
        }
        switch (string) {
            default: {
                return 3;
            }
            case "asNeeded": {
                return 2;
            }
            case "never": 
        }
        return 0;
    }

    protected static int parseScrollButtonsPlacement(String string) {
        if (string == null) {
            return 100;
        }
        switch (string) {
            default: {
                return 100;
            }
            case "trailing": 
        }
        return 11;
    }

    protected static int parseAlignment(String string, int n2) {
        if (string == null) {
            return n2;
        }
        switch (string) {
            case "leading": {
                return 10;
            }
            case "trailing": {
                return 11;
            }
            case "center": {
                return 0;
            }
            case "fill": {
                return 100;
            }
        }
        return n2;
    }

    private static String alignmentToString(int n2, String string) {
        switch (n2) {
            case 10: {
                return "leading";
            }
            case 11: {
                return "trailing";
            }
            case 0: {
                return "center";
            }
            case 100: {
                return "fill";
            }
        }
        return string;
    }

    protected static int parseTabWidthMode(String string) {
        if (string == null) {
            return 0;
        }
        switch (string) {
            default: {
                return 0;
            }
            case "equal": {
                return 1;
            }
            case "compact": 
        }
        return 2;
    }

    protected static int parseTabRotation(String string) {
        if (string == null) {
            return 0;
        }
        switch (string) {
            default: {
                return -1;
            }
            case "auto": {
                return -2;
            }
            case "left": {
                return 2;
            }
            case "right": 
        }
        return 4;
    }

    protected static int parseTabIconPlacement(String string) {
        if (string == null) {
            return 10;
        }
        switch (string) {
            default: {
                return 10;
            }
            case "trailing": {
                return 11;
            }
            case "top": {
                return 1;
            }
            case "bottom": 
        }
        return 3;
    }

    private void runWithOriginalLayoutManager(Runnable runnable) {
        LayoutManager layoutManager = this.tabPane.getLayout();
        if (layoutManager instanceof FlatTabbedPaneScrollLayout) {
            this.tabPane.setLayout(((FlatTabbedPaneScrollLayout)layoutManager).delegate);
            runnable.run();
            this.tabPane.setLayout(layoutManager);
        } else {
            runnable.run();
        }
    }

    protected void ensureSelectedTabIsVisibleLater() {
        if (!this.tabPane.isDisplayable() || !EventQueue.isDispatchThread()) {
            return;
        }
        EventQueue.invokeLater(() -> this.ensureSelectedTabIsVisible());
    }

    protected void ensureSelectedTabIsVisible() {
        if (this.tabPane == null || this.tabViewport == null || !this.tabPane.isDisplayable()) {
            return;
        }
        this.ensureCurrentLayout();
        int n2 = this.tabPane.getSelectedIndex();
        if (n2 < 0 || n2 >= this.rects.length) {
            return;
        }
        ((JComponent)this.tabViewport.getView()).scrollRectToVisible((Rectangle)this.rects[n2].clone());
    }

    private int getLeadingPreferredWidth() {
        return this.leadingComponent != null ? this.leadingComponent.getPreferredSize().width : 0;
    }

    private int getLeadingPreferredHeight() {
        return this.leadingComponent != null ? this.leadingComponent.getPreferredSize().height : 0;
    }

    private int getTrailingPreferredWidth() {
        return this.trailingComponent != null ? this.trailingComponent.getPreferredSize().width : 0;
    }

    private int getTrailingPreferredHeight() {
        return this.trailingComponent != null ? this.trailingComponent.getPreferredSize().height : 0;
    }

    private void shiftTabs(int n2, int n3) {
        if (n2 == 0 && n3 == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.rects.length; ++i2) {
            this.rects[i2].x += n2;
            this.rects[i2].y += n3;
        }
    }

    private void stretchTabsWidth(int n2, boolean bl2) {
        int n3;
        int n4 = n2 / this.rects.length;
        int n5 = this.rects[0].x - (bl2 ? 0 : n4);
        for (n3 = 0; n3 < this.rects.length; ++n3) {
            this.rects[n3].x = n5;
            this.rects[n3].width += n4;
            if (bl2) {
                n5 += this.rects[n3].width;
                continue;
            }
            if (n3 + 1 >= this.rects.length) continue;
            n5 = this.rects[n3].x - this.rects[n3 + 1].width - n4;
        }
        n3 = n2 - n4 * this.rects.length;
        this.rects[this.rects.length - 1].width += n3;
        if (!bl2) {
            this.rects[this.rects.length - 1].x -= n3;
        }
    }

    private void stretchTabsHeight(int n2) {
        int n3 = n2 / this.rects.length;
        int n4 = this.rects[0].y;
        for (int i2 = 0; i2 < this.rects.length; ++i2) {
            this.rects[i2].y = n4;
            this.rects[i2].height += n3;
            n4 += this.rects[i2].height;
        }
        this.rects[this.rects.length - 1].height += n2 - n3 * this.rects.length;
    }

    private int rectsTotalWidth(boolean bl2) {
        int n2 = this.rects.length - 1;
        return bl2 ? this.rects[n2].x + this.rects[n2].width - this.rects[0].x : this.rects[0].x + this.rects[0].width - this.rects[n2].x;
    }

    private int rectsTotalHeight() {
        int n2 = this.rects.length - 1;
        return this.rects[n2].y + this.rects[n2].height - this.rects[0].y;
    }

    @Override
    public Boolean isTitleBarCaptionAt(int n2, int n3) {
        if (this.tabForCoordinate(this.tabPane, n2, n3) >= 0) {
            return false;
        }
        return null;
    }

    private static class FlatSelectedTabRepainter
    implements PropertyChangeListener {
        private static FlatSelectedTabRepainter instance;
        private KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        static void install() {
            Class<FlatSelectedTabRepainter> clazz = FlatSelectedTabRepainter.class;
            synchronized (FlatSelectedTabRepainter.class) {
                if (instance != null) {
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return;
                }
                instance = new FlatSelectedTabRepainter();
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }

        FlatSelectedTabRepainter() {
            this.keyboardFocusManager.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void uninstall() {
            Class<FlatSelectedTabRepainter> clazz = FlatSelectedTabRepainter.class;
            synchronized (FlatSelectedTabRepainter.class) {
                if (instance == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                this.keyboardFocusManager.removePropertyChangeListener(this);
                this.keyboardFocusManager = null;
                instance = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!(UIManager.getLookAndFeel() instanceof FlatLaf)) {
                this.uninstall();
                return;
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "permanentFocusOwner": {
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object instanceof Component) {
                        this.repaintSelectedTabs((Component)object);
                    }
                    if (!(object2 instanceof Component)) break;
                    this.repaintSelectedTabs((Component)object2);
                    break;
                }
                case "activeWindow": {
                    Component component = this.keyboardFocusManager.getPermanentFocusOwner();
                    if (component == null) break;
                    this.repaintSelectedTabs(component);
                }
            }
        }

        private void repaintSelectedTabs(Component component) {
            EventQueue.invokeLater(() -> {
                if (!component.isDisplayable()) {
                    return;
                }
                if (component instanceof JTabbedPane) {
                    this.repaintSelectedTab((JTabbedPane)component);
                }
                Component component2 = component;
                while ((component2 = SwingUtilities.getAncestorOfClass(JTabbedPane.class, component2)) != null) {
                    this.repaintSelectedTab((JTabbedPane)component2);
                }
            });
        }

        private void repaintSelectedTab(JTabbedPane jTabbedPane) {
            TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
            if (tabbedPaneUI instanceof FlatTabbedPaneUI) {
                ((FlatTabbedPaneUI)tabbedPaneUI).repaintTab(jTabbedPane.getSelectedIndex());
            }
        }
    }

    private static class RunWithOriginalLayoutManagerDelegateAction
    extends FlatUIAction {
        static void install(ActionMap actionMap, String string) {
            Action action = actionMap.get(string);
            if (action == null || action instanceof RunWithOriginalLayoutManagerDelegateAction) {
                return;
            }
            actionMap.put(string, new RunWithOriginalLayoutManagerDelegateAction(action));
        }

        private RunWithOriginalLayoutManagerDelegateAction(Action action) {
            super(action);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTabbedPane jTabbedPane = (JTabbedPane)actionEvent.getSource();
            TabbedPaneUI tabbedPaneUI = jTabbedPane.getUI();
            if (tabbedPaneUI instanceof FlatTabbedPaneUI) {
                ((FlatTabbedPaneUI)tabbedPaneUI).runWithOriginalLayoutManager(() -> this.delegate.actionPerformed(actionEvent));
            } else {
                this.delegate.actionPerformed(actionEvent);
            }
        }
    }

    protected class FlatTabbedPaneScrollLayout
    extends FlatTabbedPaneLayout
    implements LayoutManager {
        private final BasicTabbedPaneUI.TabbedPaneLayout delegate;

        protected FlatTabbedPaneScrollLayout(BasicTabbedPaneUI.TabbedPaneLayout tabbedPaneLayout) {
            this.delegate = tabbedPaneLayout;
        }

        @Override
        public void calculateLayoutInfo() {
            this.delegate.calculateLayoutInfo();
        }

        @Override
        protected Dimension calculateTabAreaSize() {
            Dimension dimension = super.calculateTabAreaSize();
            if (FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement())) {
                dimension.width = Math.min(dimension.width, UIScale.scale(100));
            } else {
                dimension.height = Math.min(dimension.height, UIScale.scale(100));
            }
            return dimension;
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return this.delegate.preferredLayoutSize(container);
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return this.delegate.minimumLayoutSize(container);
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            this.delegate.addLayoutComponent(string, component);
        }

        @Override
        public void removeLayoutComponent(Component component) {
            this.delegate.removeLayoutComponent(component);
        }

        @Override
        protected void layoutContainerImpl() {
            int n2;
            Dimension dimension;
            int n3;
            int n4;
            int n5;
            int n6;
            Rectangle rectangle;
            int n7;
            int n8;
            int n9;
            Cloneable cloneable;
            Serializable serializable;
            int n10;
            this.layoutChildComponents();
            int n11 = FlatTabbedPaneUI.this.getTabsPopupPolicy();
            int n12 = FlatTabbedPaneUI.this.getScrollButtonsPolicy();
            int n13 = FlatTabbedPaneUI.this.getScrollButtonsPlacement();
            boolean bl2 = n11 == 2;
            boolean bl3 = n12 == 2 || n12 == 3;
            boolean bl4 = n12 == 3 && n13 == 100;
            boolean bl5 = n13 == 11;
            boolean bl6 = FlatTabbedPaneUI.this.isLeftToRight();
            if (!bl6 && FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement())) {
                bl2 = true;
                bl3 = false;
            }
            JButton jButton = null;
            JButton jButton2 = null;
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (!(component instanceof FlatScrollableTabButton)) continue;
                n10 = ((FlatScrollableTabButton)component).getDirection();
                if (n10 == 7 || n10) {
                    jButton = (JButton)component;
                    continue;
                }
                if (n10 != 3 && n10 != 5) continue;
                jButton2 = (JButton)component;
            }
            if (jButton == null || jButton2 == null) {
                return;
            }
            int n14 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n15 = FlatTabbedPaneUI.this.getTabAreaAlignment();
            Insets insets = FlatTabbedPaneUI.this.getRealTabAreaInsets(n14);
            boolean bl7 = false;
            n10 = 0;
            boolean bl8 = false;
            if (insets.left != 0 || insets.top != 0) {
                FlatTabbedPaneUI.this.shiftTabs(-insets.left, -insets.top);
                serializable = FlatTabbedPaneUI.this.tabViewport.getView();
                cloneable = ((Component)serializable).getPreferredSize();
                n9 = n14 == 1 || n14 == 3 ? 1 : 0;
                ((Component)serializable).setPreferredSize(new Dimension(cloneable.width - (n9 != 0 ? insets.left : 0), cloneable.height - (n9 != 0 ? 0 : insets.top)));
            }
            serializable = this.getTabAreaLayoutBounds(n14, insets);
            if (n14 == 1 || n14 == 3) {
                if (bl3 && bl4) {
                    cloneable = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                    if (((Point)cloneable).x <= jButton.getPreferredSize().width) {
                        FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(0, ((Point)cloneable).y));
                    }
                }
                n8 = ((Rectangle)serializable).width - FlatTabbedPaneUI.this.getLeadingPreferredWidth() - FlatTabbedPaneUI.this.getTrailingPreferredWidth() - insets.left - insets.right;
                n9 = FlatTabbedPaneUI.this.rects.length > 0 ? FlatTabbedPaneUI.this.rectsTotalWidth(bl6) : 0;
                n7 = n9 < n8 ? 1 : 0;
                rectangle = this.layoutLeftAndRightComponents((Rectangle)serializable, n15, insets, n7 != 0, false, bl6);
                if (FlatTabbedPaneUI.this.rects.length > 0) {
                    n6 = rectangle.x + (bl6 ? insets.left : insets.right);
                    n5 = rectangle.width - insets.left - insets.right;
                    n4 = rectangle.y;
                    n3 = rectangle.height;
                    if (n5 < n9) {
                        if (bl2) {
                            int n16 = ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).moreTabsButton.getPreferredSize().width;
                            FlatTabbedPaneUI.this.moreTabsButton.setBounds(bl6 ? n6 + n5 - n16 : n6, n4, n16, n3);
                            n6 += bl6 ? 0 : n16;
                            n5 -= n16;
                            bl7 = true;
                        }
                        if (bl3) {
                            Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                            dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
                            if (!bl4 || dimension.width - point.x > n5) {
                                n2 = jButton2.getPreferredSize().width;
                                jButton2.setBounds(n6 + n5 - n2, n4, n2, n3);
                                n5 -= n2;
                                bl8 = true;
                            }
                            if (!bl4 || point.x > 0) {
                                n2 = jButton.getPreferredSize().width;
                                if (bl5) {
                                    jButton.setBounds(n6 + n5 - n2, n4, n2, n3);
                                } else {
                                    jButton.setBounds(n6, n4, n2, n3);
                                    n6 += n2;
                                }
                                n5 -= n2;
                                n10 = 1;
                            }
                        }
                    }
                    FlatTabbedPaneUI.this.tabViewport.setBounds(n6, n4, n5, n3);
                    if (!bl6) {
                        FlatTabbedPaneUI.this.tabViewport.doLayout();
                        FlatTabbedPaneUI.this.shiftTabs(FlatTabbedPaneUI.this.tabViewport.getView().getWidth() - (((FlatTabbedPaneUI)FlatTabbedPaneUI.this).rects[0].x + ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).rects[0].width), 0);
                    }
                }
            } else {
                if (bl3 && bl4) {
                    cloneable = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                    if (((Point)cloneable).y <= jButton.getPreferredSize().height) {
                        FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(((Point)cloneable).x, 0));
                    }
                }
                n8 = ((Rectangle)serializable).height - FlatTabbedPaneUI.this.getLeadingPreferredHeight() - FlatTabbedPaneUI.this.getTrailingPreferredHeight() - insets.top - insets.bottom;
                n9 = FlatTabbedPaneUI.this.rects.length > 0 ? FlatTabbedPaneUI.this.rectsTotalHeight() : 0;
                n7 = n9 < n8 ? 1 : 0;
                rectangle = this.layoutTopAndBottomComponents((Rectangle)serializable, n15, insets, n7 != 0, false);
                if (FlatTabbedPaneUI.this.rects.length > 0) {
                    n6 = rectangle.y + insets.top;
                    n5 = rectangle.height - insets.top - insets.bottom;
                    n4 = rectangle.x;
                    n3 = rectangle.width;
                    if (n5 < n9) {
                        if (bl2) {
                            int n17 = ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).moreTabsButton.getPreferredSize().height;
                            FlatTabbedPaneUI.this.moreTabsButton.setBounds(n4, n6 + n5 - n17, n3, n17);
                            n5 -= n17;
                            bl7 = true;
                        }
                        if (bl3) {
                            Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                            dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
                            if (!bl4 || dimension.height - point.y > n5) {
                                n2 = jButton2.getPreferredSize().height;
                                jButton2.setBounds(n4, n6 + n5 - n2, n3, n2);
                                n5 -= n2;
                                bl8 = true;
                            }
                            if (!bl4 || point.y > 0) {
                                n2 = jButton.getPreferredSize().height;
                                if (bl5) {
                                    jButton.setBounds(n4, n6 + n5 - n2, n3, n2);
                                } else {
                                    jButton.setBounds(n4, n6, n3, n2);
                                    n6 += n2;
                                }
                                n5 -= n2;
                                n10 = 1;
                            }
                        }
                    }
                    FlatTabbedPaneUI.this.tabViewport.setBounds(n4, n6, n3, n5);
                }
            }
            Component component = FlatTabbedPaneUI.this.tabViewport.getView();
            if (component instanceof Container && ((Container)component).getComponentCount() > 0) {
                for (Component component2 : ((Container)component).getComponents()) {
                    if (!this.isTabContainer(component2)) continue;
                    this.layoutTabComponents(component2);
                    break;
                }
            }
            FlatTabbedPaneUI.this.tabViewport.setVisible(FlatTabbedPaneUI.this.rects.length > 0);
            FlatTabbedPaneUI.this.moreTabsButton.setVisible(bl7);
            jButton.setVisible(n10 != 0);
            jButton2.setVisible(bl8);
            FlatTabbedPaneUI.this.scrollBackwardButtonPrefSize = jButton.getPreferredSize();
        }

        @Override
        protected void layoutChildComponent(Component component, Rectangle rectangle) {
            if (component == FlatTabbedPaneUI.this.tabViewport || component instanceof FlatTabAreaButton || component == FlatTabbedPaneUI.this.leadingComponent || component == FlatTabbedPaneUI.this.trailingComponent) {
                return;
            }
            component.setBounds(rectangle);
        }
    }

    protected class FlatTabbedPaneLayout
    extends BasicTabbedPaneUI.TabbedPaneLayout {
        protected FlatTabbedPaneLayout() {
            super(FlatTabbedPaneUI.this);
        }

        @Override
        protected Dimension calculateSize(boolean bl2) {
            if (this.isContentEmpty()) {
                return this.calculateTabAreaSize();
            }
            return super.calculateSize(bl2);
        }

        protected boolean isContentEmpty() {
            int n2 = FlatTabbedPaneUI.this.tabPane.getTabCount();
            if (n2 == 0) {
                return false;
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = FlatTabbedPaneUI.this.tabPane.getComponentAt(i2);
                if (component == null) continue;
                Dimension dimension = component.getPreferredSize();
                if (dimension.width == 0 && dimension.height == 0) continue;
                return false;
            }
            return true;
        }

        protected Dimension calculateTabAreaSize() {
            int n2 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            boolean bl2 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n2);
            FontMetrics fontMetrics = FlatTabbedPaneUI.this.getFontMetrics();
            int n3 = fontMetrics.getHeight();
            int n4 = 0;
            int n5 = 0;
            int n6 = FlatTabbedPaneUI.this.tabPane.getTabCount();
            for (int i2 = 0; i2 < n6; ++i2) {
                if (bl2) {
                    n4 += FlatTabbedPaneUI.this.calculateTabWidth(n2, i2, fontMetrics);
                    n5 = Math.max(n5, FlatTabbedPaneUI.this.calculateTabHeight(n2, i2, n3));
                    continue;
                }
                n4 = Math.max(n4, FlatTabbedPaneUI.this.calculateTabWidth(n2, i2, fontMetrics));
                n5 += FlatTabbedPaneUI.this.calculateTabHeight(n2, i2, n3);
            }
            if (bl2) {
                n5 += UIScale.scale(FlatTabbedPaneUI.this.contentSeparatorHeight);
            } else {
                n4 += UIScale.scale(FlatTabbedPaneUI.this.contentSeparatorHeight);
            }
            Insets insets = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = FlatTabbedPaneUI.this.getTabAreaInsets(n2);
            return new Dimension(n4 + insets.left + insets.right + insets2.left + insets2.right, n5 + insets.bottom + insets.top + insets2.top + insets2.bottom);
        }

        @Override
        public void layoutContainer(Container container) {
            Object object;
            FlatTabbedPaneUI.this.setRolloverTab(-1);
            this.calculateLayoutInfo();
            boolean bl2 = false;
            int n2 = FlatTabbedPaneUI.this.tabPane.getSelectedIndex();
            if (n2 >= 0) {
                object = FlatTabbedPaneUI.this.getVisibleComponent();
                Component component = FlatTabbedPaneUI.this.tabPane.getComponentAt(n2);
                if (component != null && component != object) {
                    bl2 = SwingUtilities.findFocusOwner((Component)object) != null;
                    FlatTabbedPaneUI.this.setVisibleComponent(component);
                }
            } else {
                FlatTabbedPaneUI.this.setVisibleComponent(null);
            }
            this.layoutContainerImpl();
            if (bl2 && (object = FlatTabbedPaneUI.this.tabPane.getActionMap().get("requestFocusForVisibleComponent")) != null) {
                object.actionPerformed(new ActionEvent(FlatTabbedPaneUI.this.tabPane, 1001, null));
            }
        }

        protected void layoutContainerImpl() {
            int n2 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = FlatTabbedPaneUI.this.getTabAreaAlignment();
            Insets insets = FlatTabbedPaneUI.this.getRealTabAreaInsets(n2);
            boolean bl2 = FlatTabbedPaneUI.this.isLeftToRight();
            Rectangle rectangle = this.getTabAreaLayoutBounds(n2, insets);
            if (n2 == 1 || n2 == 3) {
                if (!bl2) {
                    FlatTabbedPaneUI.this.shiftTabs(((FlatTabbedPaneUI)FlatTabbedPaneUI.this).tabPane.getInsets().left + insets.right + FlatTabbedPaneUI.this.getTrailingPreferredWidth(), 0);
                }
                this.layoutLeftAndRightComponents(rectangle, n3, insets, FlatTabbedPaneUI.this.runCount == 1, true, bl2);
            } else {
                this.layoutTopAndBottomComponents(rectangle, n3, insets, FlatTabbedPaneUI.this.runCount == 1, true);
            }
            this.layoutChildComponents();
        }

        protected void layoutChildComponents() {
            if (FlatTabbedPaneUI.this.tabPane.getComponentCount() == 0) {
                return;
            }
            Rectangle rectangle = this.getContentAreaLayoutBounds(FlatTabbedPaneUI.this.tabPane.getTabPlacement(), FlatTabbedPaneUI.this.tabAreaInsets);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                this.layoutChildComponent(component, rectangle);
            }
        }

        protected void layoutChildComponent(Component component, Rectangle rectangle) {
            if (component == FlatTabbedPaneUI.this.leadingComponent || component == FlatTabbedPaneUI.this.trailingComponent) {
                return;
            }
            if (this.isTabContainer(component)) {
                this.layoutTabContainer(component);
            } else {
                component.setBounds(rectangle);
            }
        }

        boolean isTabContainer(Component component) {
            return component.getClass().getName().equals("javax.swing.plaf.basic.BasicTabbedPaneUI$TabContainer");
        }

        private void layoutTabContainer(Component component) {
            int n2 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            Rectangle rectangle = FlatTabbedPaneUI.this.tabPane.getBounds();
            Insets insets = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets2 = FlatTabbedPaneUI.this.getContentBorderInsets(n2);
            boolean bl2 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n2);
            int n3 = !bl2 ? FlatTabbedPaneUI.this.calculateTabAreaWidth(n2, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabWidth) : 0;
            int n4 = bl2 ? FlatTabbedPaneUI.this.calculateTabAreaHeight(n2, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabHeight) : 0;
            int n5 = n3 != 0 ? n3 + insets.left + insets.right + insets2.left + insets2.right : rectangle.width;
            int n6 = n4 != 0 ? n4 + insets.top + insets.bottom + insets2.top + insets2.bottom : rectangle.height;
            int n7 = n2 == 4 ? rectangle.width - n5 : 0;
            int n8 = n2 == 3 ? rectangle.height - n6 : 0;
            component.setBounds(n7, n8, n5, n6);
            this.layoutTabComponents(component);
        }

        void layoutTabComponents(Component component) {
            if (component instanceof Container && ((Container)component).getComponentCount() == 0) {
                return;
            }
            int n2 = FlatTabbedPaneUI.this.tabPane.getTabPlacement();
            int n3 = FlatTabbedPaneUI.this.tabPane.getSelectedIndex();
            Rectangle rectangle = new Rectangle();
            int n4 = -component.getX();
            int n5 = -component.getY();
            if (FlatTabbedPaneUI.this.isScrollTabLayout()) {
                Point point = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
                n4 = n4 - FlatTabbedPaneUI.this.tabViewport.getX() + point.x;
                n5 = n5 - FlatTabbedPaneUI.this.tabViewport.getY() + point.y;
            }
            int n6 = FlatTabbedPaneUI.this.tabPane.getTabCount();
            for (int i2 = 0; i2 < n6; ++i2) {
                Component component2 = FlatTabbedPaneUI.this.tabPane.getTabComponentAt(i2);
                if (component2 == null) continue;
                Rectangle rectangle2 = FlatTabbedPaneUI.this.getTabBounds(i2, rectangle);
                Insets insets = FlatTabbedPaneUI.this.getTabInsets(n2, i2);
                int n7 = rectangle2.x + insets.left + n4;
                int n8 = rectangle2.y + insets.top + n5;
                int n9 = rectangle2.width - insets.left - insets.right;
                int n10 = rectangle2.height - insets.top - insets.bottom;
                Dimension dimension = component2.getPreferredSize();
                int n11 = n7 + (n9 - dimension.width) / 2;
                int n12 = n8 + (n10 - dimension.height) / 2;
                boolean bl2 = i2 == n3;
                component2.setBounds(n11 += FlatTabbedPaneUI.this.getTabLabelShiftX(n2, i2, bl2), n12 += FlatTabbedPaneUI.this.getTabLabelShiftY(n2, i2, bl2), dimension.width, dimension.height);
            }
        }

        Rectangle getContentAreaLayoutBounds(int n2, Insets insets) {
            int n3 = FlatTabbedPaneUI.this.tabPane.getWidth();
            int n4 = FlatTabbedPaneUI.this.tabPane.getHeight();
            Insets insets2 = FlatTabbedPaneUI.this.tabPane.getInsets();
            Insets insets3 = FlatTabbedPaneUI.this.getContentBorderInsets(n2);
            boolean bl2 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(n2);
            int n5 = !bl2 ? FlatTabbedPaneUI.this.calculateTabAreaWidth(n2, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabWidth) : 0;
            int n6 = bl2 ? FlatTabbedPaneUI.this.calculateTabAreaHeight(n2, FlatTabbedPaneUI.this.runCount, FlatTabbedPaneUI.this.maxTabHeight) : 0;
            Rectangle rectangle = new Rectangle();
            rectangle.x = insets2.left + insets3.left;
            rectangle.y = insets2.top + insets3.top;
            rectangle.width = n3 - insets2.left - insets2.right - insets3.left - insets3.right - n5;
            rectangle.height = n4 - insets2.top - insets2.bottom - insets3.top - insets3.bottom - n6;
            if (n2 == 1) {
                rectangle.y += n6;
            } else if (n2 == 2) {
                rectangle.x += n5;
            }
            return rectangle;
        }

        Rectangle getTabAreaLayoutBounds(int n2, Insets insets) {
            int n3 = FlatTabbedPaneUI.this.tabPane.getWidth();
            int n4 = FlatTabbedPaneUI.this.tabPane.getHeight();
            Insets insets2 = FlatTabbedPaneUI.this.tabPane.getInsets();
            Rectangle rectangle = new Rectangle();
            if (n2 == 1 || n2 == 3) {
                int n5 = FlatTabbedPaneUI.this.maxTabHeight > 0 ? FlatTabbedPaneUI.this.maxTabHeight : Math.max(Math.max(FlatTabbedPaneUI.this.getLeadingPreferredHeight(), FlatTabbedPaneUI.this.getTrailingPreferredHeight()), UIScale.scale(FlatClientProperties.clientPropertyInt(FlatTabbedPaneUI.this.tabPane, "JTabbedPane.tabHeight", FlatTabbedPaneUI.this.tabHeight)));
                rectangle.x = insets2.left;
                rectangle.y = n2 == 1 ? insets2.top + insets.top : n4 - insets2.bottom - insets.bottom - n5;
                rectangle.width = n3 - insets2.left - insets2.right;
                rectangle.height = n5;
            } else {
                int n6 = FlatTabbedPaneUI.this.maxTabWidth > 0 ? FlatTabbedPaneUI.this.maxTabWidth : Math.max(FlatTabbedPaneUI.this.getLeadingPreferredWidth(), FlatTabbedPaneUI.this.getTrailingPreferredWidth());
                rectangle.x = n2 == 2 ? insets2.left + insets.left : n3 - insets2.right - insets.right - n6;
                rectangle.y = insets2.top;
                rectangle.width = n6;
                rectangle.height = n4 - insets2.top - insets2.bottom;
            }
            return rectangle;
        }

        Rectangle layoutLeftAndRightComponents(Rectangle rectangle, int n2, Insets insets, boolean bl2, boolean bl3, boolean bl4) {
            int n3;
            int n4;
            int n5 = FlatTabbedPaneUI.this.getLeadingPreferredWidth();
            int n6 = FlatTabbedPaneUI.this.getTrailingPreferredWidth();
            if (bl2 && FlatTabbedPaneUI.this.rects.length > 0) {
                int n7 = rectangle.width - n5 - n6 - insets.left - insets.right;
                n4 = FlatTabbedPaneUI.this.rectsTotalWidth(bl4);
                int n8 = n7 - n4;
                switch (n2) {
                    case 10: {
                        n6 += n8;
                        break;
                    }
                    case 11: {
                        if (bl3) {
                            FlatTabbedPaneUI.this.shiftTabs(bl4 ? n8 : -n8, 0);
                        }
                        n5 += n8;
                        break;
                    }
                    case 0: {
                        if (bl3) {
                            FlatTabbedPaneUI.this.shiftTabs((bl4 ? n8 : -n8) / 2, 0);
                        }
                        n5 += n8 / 2;
                        n6 += n8 - n8 / 2;
                        break;
                    }
                    case 100: {
                        FlatTabbedPaneUI.this.stretchTabsWidth(n8, bl4);
                    }
                }
            } else if (FlatTabbedPaneUI.this.rects.length == 0) {
                n6 = rectangle.width - n5;
            }
            Container container = bl4 ? FlatTabbedPaneUI.this.leadingComponent : FlatTabbedPaneUI.this.trailingComponent;
            int n9 = n4 = bl4 ? n5 : n6;
            if (container != null) {
                container.setBounds(rectangle.x, rectangle.y, n4, rectangle.height);
            }
            Container container2 = bl4 ? FlatTabbedPaneUI.this.trailingComponent : FlatTabbedPaneUI.this.leadingComponent;
            int n10 = n3 = bl4 ? n6 : n5;
            if (container2 != null) {
                container2.setBounds(rectangle.x + rectangle.width - n3, rectangle.y, n3, rectangle.height);
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.x += n4;
            rectangle2.width -= n4 + n3;
            return rectangle2;
        }

        Rectangle layoutTopAndBottomComponents(Rectangle rectangle, int n2, Insets insets, boolean bl2, boolean bl3) {
            int n3 = FlatTabbedPaneUI.this.getLeadingPreferredHeight();
            int n4 = FlatTabbedPaneUI.this.getTrailingPreferredHeight();
            if (bl2 && FlatTabbedPaneUI.this.rects.length > 0) {
                int n5 = rectangle.height - n3 - n4 - insets.top - insets.bottom;
                int n6 = FlatTabbedPaneUI.this.rectsTotalHeight();
                int n7 = n5 - n6;
                switch (n2) {
                    case 10: {
                        n4 += n7;
                        break;
                    }
                    case 11: {
                        if (bl3) {
                            FlatTabbedPaneUI.this.shiftTabs(0, n7);
                        }
                        n3 += n7;
                        break;
                    }
                    case 0: {
                        if (bl3) {
                            FlatTabbedPaneUI.this.shiftTabs(0, n7 / 2);
                        }
                        n3 += n7 / 2;
                        n4 += n7 - n7 / 2;
                        break;
                    }
                    case 100: {
                        FlatTabbedPaneUI.this.stretchTabsHeight(n7);
                    }
                }
            } else if (FlatTabbedPaneUI.this.rects.length == 0) {
                n4 = rectangle.height - n3;
            }
            if (FlatTabbedPaneUI.this.leadingComponent != null) {
                FlatTabbedPaneUI.this.leadingComponent.setBounds(rectangle.x, rectangle.y, rectangle.width, n3);
            }
            if (FlatTabbedPaneUI.this.trailingComponent != null) {
                FlatTabbedPaneUI.this.trailingComponent.setBounds(rectangle.x, rectangle.y + rectangle.height - n4, rectangle.width, n4);
            }
            Rectangle rectangle2 = new Rectangle(rectangle);
            rectangle2.y += n3;
            rectangle2.height -= n3 + n4;
            return rectangle2;
        }
    }

    private class Handler
    implements ComponentListener,
    ContainerListener,
    FocusListener,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    ChangeListener {
        MouseListener mouseDelegate;
        PropertyChangeListener propertyChangeDelegate;
        ChangeListener changeDelegate;
        FocusListener focusDelegate;
        private final PropertyChangeListener contentListener = this::contentPropertyChange;
        private int pressedTabIndex = -1;
        private int lastTipTabIndex = -1;
        private String lastTip;

        private Handler() {
        }

        void installListeners() {
            FlatTabbedPaneUI.this.tabPane.addMouseMotionListener(this);
            FlatTabbedPaneUI.this.tabPane.addComponentListener(this);
            FlatTabbedPaneUI.this.tabPane.addContainerListener(this);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (component instanceof UIResource) continue;
                component.addPropertyChangeListener(this.contentListener);
            }
        }

        void uninstallListeners() {
            FlatTabbedPaneUI.this.tabPane.removeMouseMotionListener(this);
            FlatTabbedPaneUI.this.tabPane.removeComponentListener(this);
            FlatTabbedPaneUI.this.tabPane.removeContainerListener(this);
            for (Component component : FlatTabbedPaneUI.this.tabPane.getComponents()) {
                if (component instanceof UIResource) continue;
                component.removePropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.mouseDelegate.mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
            if (!FlatTabbedPaneUI.this.isPressedTabClose() && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.mouseDelegate.mousePressed(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (FlatTabbedPaneUI.this.isPressedTabClose()) {
                this.updateRollover(mouseEvent);
                if (this.pressedTabIndex >= 0 && this.pressedTabIndex == FlatTabbedPaneUI.this.getRolloverTab()) {
                    this.restoreTabToolTip();
                    FlatTabbedPaneUI.this.closeTab(this.pressedTabIndex);
                }
            } else {
                this.mouseDelegate.mouseReleased(mouseEvent);
            }
            this.pressedTabIndex = -1;
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateRollover(mouseEvent);
        }

        private void updateRollover(MouseEvent mouseEvent) {
            boolean bl2;
            int n2 = mouseEvent.getX();
            int n3 = mouseEvent.getY();
            int n4 = FlatTabbedPaneUI.this.tabForCoordinate(FlatTabbedPaneUI.this.tabPane, n2, n3);
            FlatTabbedPaneUI.this.setRolloverTab(n4);
            boolean bl3 = bl2 = FlatTabbedPaneUI.this.isTabClosable(n4) && FlatTabbedPaneUI.this.getTabCloseHitArea(n4).contains(n2, n3);
            if (mouseEvent.getID() == 501 && SwingUtilities.isLeftMouseButton(mouseEvent)) {
                this.pressedTabIndex = bl2 ? n4 : -1;
            }
            FlatTabbedPaneUI.this.setRolloverTabClose(bl2);
            FlatTabbedPaneUI.this.setPressedTabClose(bl2 && n4 == this.pressedTabIndex);
            if (n4 >= 0 && bl2) {
                Object object = FlatTabbedPaneUI.this.getTabClientProperty(n4, "JTabbedPane.tabCloseToolTipText");
                if (object == null) {
                    object = FlatTabbedPaneUI.this.tabCloseToolTipText;
                }
                if (object instanceof String) {
                    this.setCloseToolTip(n4, (String)object);
                } else {
                    this.restoreTabToolTip();
                }
            } else {
                this.restoreTabToolTip();
            }
        }

        private void setCloseToolTip(int n2, String string) {
            if (n2 == this.lastTipTabIndex) {
                return;
            }
            this.restoreTabToolTip();
            this.lastTipTabIndex = n2;
            this.lastTip = FlatTabbedPaneUI.this.tabPane.getToolTipTextAt(this.lastTipTabIndex);
            FlatTabbedPaneUI.this.tabPane.setToolTipTextAt(this.lastTipTabIndex, string);
        }

        private void restoreTabToolTip() {
            if (this.lastTipTabIndex < 0) {
                return;
            }
            if (this.lastTipTabIndex < FlatTabbedPaneUI.this.tabPane.getTabCount()) {
                FlatTabbedPaneUI.this.tabPane.setToolTipTextAt(this.lastTipTabIndex, this.lastTip);
            }
            this.lastTip = null;
            this.lastTipTabIndex = -1;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "tabPlacement": 
                case "opaque": 
                case "background": 
                case "indexForTabComponent": {
                    FlatTabbedPaneUI.this.runWithOriginalLayoutManager(() -> this.propertyChangeDelegate.propertyChange(propertyChangeEvent));
                    break;
                }
                default: {
                    this.propertyChangeDelegate.propertyChange(propertyChangeEvent);
                }
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "tabPlacement": {
                    if (!(FlatTabbedPaneUI.this.moreTabsButton instanceof FlatMoreTabsButton)) break;
                    ((FlatMoreTabsButton)FlatTabbedPaneUI.this.moreTabsButton).updateDirection();
                    break;
                }
                case "componentOrientation": {
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    break;
                }
                case "JTabbedPane.showTabSeparators": 
                case "JTabbedPane.tabType": {
                    HiDPIUtils.repaint(FlatTabbedPaneUI.this.tabPane);
                    break;
                }
                case "JTabbedPane.showContentSeparator": 
                case "JTabbedPane.hasFullBorder": 
                case "JTabbedPane.hideTabAreaWithOneTab": 
                case "JTabbedPane.minimumTabWidth": 
                case "JTabbedPane.maximumTabWidth": 
                case "JTabbedPane.tabHeight": 
                case "JTabbedPane.tabInsets": 
                case "JTabbedPane.tabAreaInsets": 
                case "JTabbedPane.tabsPopupPolicy": 
                case "JTabbedPane.scrollButtonsPolicy": 
                case "JTabbedPane.scrollButtonsPlacement": 
                case "JTabbedPane.tabAreaAlignment": 
                case "JTabbedPane.tabAlignment": 
                case "JTabbedPane.tabWidthMode": 
                case "JTabbedPane.tabRotation": 
                case "JTabbedPane.tabIconPlacement": 
                case "JTabbedPane.tabClosable": {
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    HiDPIUtils.repaint(FlatTabbedPaneUI.this.tabPane);
                    break;
                }
                case "JTabbedPane.leadingComponent": {
                    FlatTabbedPaneUI.this.uninstallLeadingComponent();
                    FlatTabbedPaneUI.this.installLeadingComponent();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    HiDPIUtils.repaint(FlatTabbedPaneUI.this.tabPane);
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    break;
                }
                case "JTabbedPane.trailingComponent": {
                    FlatTabbedPaneUI.this.uninstallTrailingComponent();
                    FlatTabbedPaneUI.this.installTrailingComponent();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    HiDPIUtils.repaint(FlatTabbedPaneUI.this.tabPane);
                    FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    FlatTabbedPaneUI.this.installStyle();
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    HiDPIUtils.repaint(FlatTabbedPaneUI.this.tabPane);
                }
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeDelegate.stateChanged(changeEvent);
            if (FlatTabbedPaneUI.this.moreTabsButton != null) {
                FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
            }
        }

        protected void contentPropertyChange(PropertyChangeEvent propertyChangeEvent) {
            switch (propertyChangeEvent.getPropertyName()) {
                case "JTabbedPane.minimumTabWidth": 
                case "JTabbedPane.maximumTabWidth": 
                case "JTabbedPane.tabInsets": 
                case "JTabbedPane.tabAlignment": 
                case "JTabbedPane.tabClosable": {
                    FlatTabbedPaneUI.this.tabPane.revalidate();
                    HiDPIUtils.repaint(FlatTabbedPaneUI.this.tabPane);
                }
            }
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisibleLater();
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (!(component instanceof UIResource)) {
                component.addPropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (!(component instanceof UIResource)) {
                component.removePropertyChangeListener(this.contentListener);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            this.focusDelegate.focusGained(focusEvent);
            FlatTabbedPaneUI.this.repaintTab(FlatTabbedPaneUI.this.tabPane.getSelectedIndex());
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.focusDelegate.focusLost(focusEvent);
            FlatTabbedPaneUI.this.repaintTab(FlatTabbedPaneUI.this.tabPane.getSelectedIndex());
        }
    }

    protected class FlatWheelTabScroller
    extends MouseAdapter {
        private int lastMouseX;
        private int lastMouseY;
        private boolean inViewport;
        private boolean scrolled;
        private Timer rolloverTimer;
        private Timer exitedTimer;
        private Animator animator;
        private Point startViewPosition;
        private Point targetViewPosition;

        protected FlatWheelTabScroller() {
        }

        protected void uninstall() {
            if (this.rolloverTimer != null) {
                this.rolloverTimer.stop();
            }
            if (this.exitedTimer != null) {
                this.exitedTimer.stop();
            }
            if (this.animator != null) {
                this.animator.cancel();
            }
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            if (FlatTabbedPaneUI.this.tabPane.getMouseWheelListeners().length > 1) {
                return;
            }
            if (!this.isInViewport(mouseWheelEvent.getX(), mouseWheelEvent.getY())) {
                return;
            }
            this.lastMouseX = mouseWheelEvent.getX();
            this.lastMouseY = mouseWheelEvent.getY();
            double d2 = mouseWheelEvent.getPreciseWheelRotation();
            boolean bl2 = d2 != 0.0 && d2 != (double)mouseWheelEvent.getWheelRotation();
            int n2 = (int)((double)FlatTabbedPaneUI.this.maxTabHeight * d2);
            if (n2 == 0) {
                if (d2 > 0.0) {
                    n2 = 1;
                } else if (d2 < 0.0) {
                    n2 = -1;
                }
            }
            Point point = this.targetViewPosition != null ? this.targetViewPosition : FlatTabbedPaneUI.this.tabViewport.getViewPosition();
            Dimension dimension = FlatTabbedPaneUI.this.tabViewport.getViewSize();
            boolean bl3 = FlatTabbedPaneUI.this.isHorizontalTabPlacement(FlatTabbedPaneUI.this.tabPane.getTabPlacement());
            int n3 = point.x;
            int n4 = point.y;
            if (bl3) {
                n3 += FlatTabbedPaneUI.this.isLeftToRight() ? n2 : -n2;
            } else {
                n4 += n2;
            }
            if (bl2 && FlatTabbedPaneUI.this.getScrollButtonsPlacement() == 100 && FlatTabbedPaneUI.this.getScrollButtonsPolicy() == 3 && (FlatTabbedPaneUI.this.isLeftToRight() || !bl3) && FlatTabbedPaneUI.this.scrollBackwardButtonPrefSize != null) {
                if (bl3) {
                    if (point.x == 0 && n3 > 0) {
                        n3 += ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.width;
                    } else if (n2 < 0 && n3 <= ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.width) {
                        n3 = 0;
                    }
                } else if (point.y == 0 && n4 > 0) {
                    n4 += ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.height;
                } else if (n2 < 0 && n4 <= ((FlatTabbedPaneUI)FlatTabbedPaneUI.this).scrollBackwardButtonPrefSize.height) {
                    n4 = 0;
                }
            }
            if (bl3) {
                n3 = Math.min(Math.max(n3, 0), dimension.width - FlatTabbedPaneUI.this.tabViewport.getWidth());
            } else {
                n4 = Math.min(Math.max(n4, 0), dimension.height - FlatTabbedPaneUI.this.tabViewport.getHeight());
            }
            Point point2 = new Point(n3, n4);
            if (point2.equals(point)) {
                return;
            }
            if (bl2) {
                if (this.animator != null) {
                    this.animator.stop();
                }
                FlatTabbedPaneUI.this.tabViewport.setViewPosition(point2);
                this.updateRolloverDelayed();
            } else {
                this.setViewPositionAnimated(point2);
            }
            this.scrolled = true;
        }

        protected void setViewPositionAnimated(Point point) {
            if (point.equals(FlatTabbedPaneUI.this.tabViewport.getViewPosition())) {
                return;
            }
            if (!FlatTabbedPaneUI.this.isSmoothScrollingEnabled()) {
                FlatTabbedPaneUI.this.tabViewport.setViewPosition(point);
                this.updateRolloverDelayed();
                return;
            }
            this.startViewPosition = FlatTabbedPaneUI.this.tabViewport.getViewPosition();
            this.targetViewPosition = point;
            if (this.animator == null) {
                int n2 = 200;
                int n3 = 10;
                this.animator = new Animator(n2, f2 -> {
                    if (FlatTabbedPaneUI.this.tabViewport == null || !FlatTabbedPaneUI.this.tabViewport.isShowing()) {
                        this.animator.stop();
                        return;
                    }
                    int n2 = this.startViewPosition.x + Math.round((float)(this.targetViewPosition.x - this.startViewPosition.x) * f2);
                    int n3 = this.startViewPosition.y + Math.round((float)(this.targetViewPosition.y - this.startViewPosition.y) * f2);
                    FlatTabbedPaneUI.this.tabViewport.setViewPosition(new Point(n2, n3));
                }, () -> {
                    this.targetViewPosition = null;
                    this.startViewPosition = null;
                    if (FlatTabbedPaneUI.this.tabPane != null) {
                        FlatTabbedPaneUI.this.setRolloverTab(this.lastMouseX, this.lastMouseY);
                    }
                });
                this.animator.setResolution(n3);
                this.animator.setInterpolator(new CubicBezierEasing(0.5f, 0.5f, 0.5f, 1.0f));
            }
            this.animator.restart();
        }

        protected void updateRolloverDelayed() {
            int n2;
            FlatTabbedPaneUI.this.blockRollover = true;
            int n3 = FlatTabbedPaneUI.this.getRolloverTab();
            if (n3 >= 0 && (n2 = FlatTabbedPaneUI.this.tabForCoordinate(FlatTabbedPaneUI.this.tabPane, this.lastMouseX, this.lastMouseY)) >= 0 && n2 != n3) {
                FlatTabbedPaneUI.this.blockRollover = false;
                FlatTabbedPaneUI.this.setRolloverTab(-1);
                FlatTabbedPaneUI.this.blockRollover = true;
            }
            if (this.rolloverTimer == null) {
                this.rolloverTimer = new Timer(150, actionEvent -> {
                    FlatTabbedPaneUI.this.blockRollover = false;
                    if (FlatTabbedPaneUI.this.tabPane != null) {
                        FlatTabbedPaneUI.this.setRolloverTab(this.lastMouseX, this.lastMouseY);
                    }
                });
                this.rolloverTimer.setRepeats(false);
            }
            this.rolloverTimer.restart();
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.checkViewportExited(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.checkViewportExited(mouseEvent.getX(), mouseEvent.getY());
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            FlatTabbedPaneUI.this.setRolloverTab(mouseEvent.getX(), mouseEvent.getY());
        }

        protected boolean isInViewport(int n2, int n3) {
            return FlatTabbedPaneUI.this.tabViewport != null && FlatTabbedPaneUI.this.tabViewport.getBounds().contains(n2, n3);
        }

        protected void checkViewportExited(int n2, int n3) {
            this.lastMouseX = n2;
            this.lastMouseY = n3;
            boolean bl2 = this.inViewport;
            this.inViewport = this.isInViewport(n2, n3);
            if (this.inViewport != bl2) {
                if (!this.inViewport) {
                    this.viewportExited();
                } else if (this.exitedTimer != null) {
                    this.exitedTimer.stop();
                }
            }
        }

        protected void viewportExited() {
            if (!this.scrolled) {
                return;
            }
            if (this.exitedTimer == null) {
                this.exitedTimer = new Timer(500, actionEvent -> this.ensureSelectedTabVisible());
                this.exitedTimer.setRepeats(false);
            }
            this.exitedTimer.start();
        }

        protected void ensureSelectedTabVisible() {
            if (FlatTabbedPaneUI.this.tabPane == null || FlatTabbedPaneUI.this.tabViewport == null) {
                return;
            }
            if (!this.scrolled) {
                return;
            }
            this.scrolled = false;
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
        }
    }

    protected class FlatScrollableTabButton
    extends FlatTabAreaButton
    implements MouseListener {
        private Timer autoRepeatTimer;

        protected FlatScrollableTabButton(int n2) {
            super(n2);
            this.addMouseListener(this);
        }

        @Override
        protected void fireActionPerformed(ActionEvent actionEvent) {
            FlatTabbedPaneUI.this.runWithOriginalLayoutManager(() -> super.fireActionPerformed(actionEvent));
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (SwingUtilities.isLeftMouseButton(mouseEvent) && this.isEnabled()) {
                if (this.autoRepeatTimer == null) {
                    this.autoRepeatTimer = new Timer(60, actionEvent -> {
                        if (this.isEnabled()) {
                            this.doClick();
                        }
                    });
                    this.autoRepeatTimer.setInitialDelay(300);
                }
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null) {
                this.autoRepeatTimer.stop();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null && this.isPressed()) {
                this.autoRepeatTimer.start();
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (this.autoRepeatTimer != null) {
                this.autoRepeatTimer.stop();
            }
        }
    }

    protected class FlatMoreTabsButton
    extends FlatTabAreaButton
    implements ActionListener,
    PopupMenuListener {
        private boolean popupVisible;

        public FlatMoreTabsButton() {
            super(5);
            this.updateDirection();
            this.setToolTipText(FlatTabbedPaneUI.this.moreTabsButtonToolTipText);
            this.addActionListener(this);
        }

        protected void updateDirection() {
            int n2;
            switch (FlatTabbedPaneUI.this.tabPane.getTabPlacement()) {
                default: {
                    n2 = 5;
                    break;
                }
                case 3: {
                    n2 = 1;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 7;
                }
            }
            this.setDirection(n2);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            boolean bl2 = this.direction == 5 || this.direction == 1;
            int n2 = UIScale.scale(8);
            return new Dimension(dimension.width + (bl2 ? n2 : 0), dimension.height + (bl2 ? 0 : n2));
        }

        @Override
        public void paint(Graphics graphics) {
            if (this.direction == 3 || this.direction == 7) {
                int n2 = Math.max(UIScale.unscale((this.getWidth() - this.getHeight()) / 2) - 4, 0);
                this.setXOffset(this.direction == 3 ? (float)n2 : (float)(-n2));
            } else {
                this.setXOffset(0.0f);
            }
            super.paint(graphics);
        }

        @Override
        protected boolean isHover() {
            return super.isHover() || this.popupVisible;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n2;
            if (FlatTabbedPaneUI.this.tabViewport == null) {
                return;
            }
            JPopupMenu jPopupMenu = new JPopupMenu();
            jPopupMenu.addPopupMenuListener(this);
            Rectangle rectangle = FlatTabbedPaneUI.this.tabViewport.getViewRect();
            int n3 = -1;
            for (n2 = 0; n2 < FlatTabbedPaneUI.this.rects.length; ++n2) {
                if (rectangle.contains(FlatTabbedPaneUI.this.rects[n2])) continue;
                if (n3 >= 0 && n3 + 1 != n2) {
                    jPopupMenu.addSeparator();
                }
                n3 = n2;
                jPopupMenu.add(this.createTabMenuItem(n2));
            }
            n2 = this.getWidth();
            int n4 = this.getHeight();
            Dimension dimension = jPopupMenu.getPreferredSize();
            int n5 = FlatTabbedPaneUI.this.isLeftToRight() ? n2 - dimension.width : 0;
            int n6 = n4 - dimension.height;
            switch (FlatTabbedPaneUI.this.tabPane.getTabPlacement()) {
                default: {
                    n6 = n4;
                    break;
                }
                case 3: {
                    n6 = -dimension.height;
                    break;
                }
                case 2: {
                    n5 = n2;
                    break;
                }
                case 4: {
                    n5 = -dimension.width;
                }
            }
            jPopupMenu.show(this, n5, n6);
        }

        protected JMenuItem createTabMenuItem(int n2) {
            Color color;
            Component component;
            String string = FlatTabbedPaneUI.this.tabPane.getTitleAt(n2);
            if (StringUtils.isEmpty(string)) {
                component = FlatTabbedPaneUI.this.tabPane.getTabComponentAt(n2);
                if (component != null) {
                    string = this.findTabTitle(component);
                }
                if (StringUtils.isEmpty(string)) {
                    string = FlatTabbedPaneUI.this.tabPane.getAccessibleContext().getAccessibleChild(n2).getAccessibleContext().getAccessibleName();
                }
                if (StringUtils.isEmpty(string) && component instanceof Accessible) {
                    string = this.findTabTitleInAccessible((Accessible)((Object)component));
                }
                if (StringUtils.isEmpty(string)) {
                    string = n2 + 1 + ". Tab";
                }
            }
            component = new JMenuItem(string, FlatTabbedPaneUI.this.tabPane.getIconAt(n2));
            ((AbstractButton)component).setDisabledIcon(FlatTabbedPaneUI.this.tabPane.getDisabledIconAt(n2));
            ((JComponent)component).setToolTipText(FlatTabbedPaneUI.this.tabPane.getToolTipTextAt(n2));
            Color color2 = FlatTabbedPaneUI.this.tabPane.getForegroundAt(n2);
            if (color2 != FlatTabbedPaneUI.this.tabPane.getForeground()) {
                ((JComponent)component).setForeground(color2);
            }
            if ((color = FlatTabbedPaneUI.this.tabPane.getBackgroundAt(n2)) != FlatTabbedPaneUI.this.tabPane.getBackground()) {
                ((JComponent)component).setBackground(color);
                ((JComponent)component).setOpaque(true);
            }
            if (!FlatTabbedPaneUI.this.tabPane.isEnabled() || !FlatTabbedPaneUI.this.tabPane.isEnabledAt(n2)) {
                ((JMenuItem)component).setEnabled(false);
            }
            ((AbstractButton)component).addActionListener(actionEvent -> this.selectTab(n2));
            return component;
        }

        private String findTabTitle(Component component) {
            String string = null;
            if (component instanceof JLabel) {
                string = ((JLabel)component).getText();
            } else if (component instanceof JTextComponent) {
                string = ((JTextComponent)component).getText();
            }
            if (!StringUtils.isEmpty(string)) {
                return string;
            }
            if (component instanceof Container) {
                for (Component component2 : ((Container)component).getComponents()) {
                    string = this.findTabTitle(component2);
                    if (string == null) continue;
                    return string;
                }
            }
            return null;
        }

        private String findTabTitleInAccessible(Accessible accessible) {
            AccessibleContext accessibleContext = accessible.getAccessibleContext();
            if (accessibleContext == null) {
                return null;
            }
            String string = accessibleContext.getAccessibleName();
            if (!StringUtils.isEmpty(string)) {
                return string;
            }
            int n2 = accessibleContext.getAccessibleChildrenCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                string = this.findTabTitleInAccessible(accessibleContext.getAccessibleChild(i2));
                if (string == null) continue;
                return string;
            }
            return null;
        }

        protected void selectTab(int n2) {
            FlatTabbedPaneUI.this.tabPane.setSelectedIndex(n2);
            FlatTabbedPaneUI.this.ensureSelectedTabIsVisible();
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = true;
            HiDPIUtils.repaint(this);
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = false;
            HiDPIUtils.repaint(this);
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            this.popupVisible = false;
            HiDPIUtils.repaint(this);
        }
    }

    protected class FlatTabAreaButton
    extends FlatArrowButton {
        public FlatTabAreaButton(int n2) {
            super(n2, FlatTabbedPaneUI.this.arrowType, FlatTabbedPaneUI.this.foreground, FlatTabbedPaneUI.this.disabledForeground, null, FlatTabbedPaneUI.this.buttonHoverBackground, null, FlatTabbedPaneUI.this.buttonPressedBackground);
            this.setArrowWidth(11);
        }

        protected void updateStyle() {
            this.updateStyle(FlatTabbedPaneUI.this.arrowType, FlatTabbedPaneUI.this.foreground, FlatTabbedPaneUI.this.disabledForeground, null, FlatTabbedPaneUI.this.buttonHoverBackground, null, FlatTabbedPaneUI.this.buttonPressedBackground);
        }

        @Override
        protected Color deriveBackground(Color color) {
            return FlatUIUtils.deriveColor(color, FlatTabbedPaneUI.this.tabPane.getBackground());
        }

        @Override
        protected void paintBackground(Graphics2D graphics2D) {
            Insets insets = new Insets(0, 0, 0, 0);
            FlatTabbedPaneUI.rotateInsets(FlatTabbedPaneUI.this.buttonInsets, insets, FlatTabbedPaneUI.this.tabPane.getTabPlacement());
            int n2 = UIScale.scale2(insets.top);
            int n3 = UIScale.scale2(insets.left);
            int n4 = UIScale.scale2(insets.bottom);
            int n5 = UIScale.scale2(insets.right);
            FlatUIUtils.paintComponentBackground(graphics2D, n3, n2, this.getWidth() - n3 - n5, this.getHeight() - n2 - n4, 0.0f, UIScale.scale((float)FlatTabbedPaneUI.this.buttonArc));
        }
    }

    private class ContainerUIResource
    extends JPanel
    implements UIResource {
        private ContainerUIResource(Component component) {
            super(new BorderLayout());
            this.add(component);
        }

        @Override
        public void reshape(int n2, int n3, int n4, int n5) {
            if (FlatTabbedPaneUI.this.inBasicLayoutContainer) {
                return;
            }
            super.reshape(n2, n3, n4, n5);
        }
    }

    private static class TabCloseButton
    extends JButton
    implements UIResource {
        private TabCloseButton() {
        }
    }
}

