/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.ui.FlatTableUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.function.Function;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.TableUI;

public class FlatTableCellBorder
extends FlatLineBorder {
    protected boolean showCellFocusIndicator = UIManager.getBoolean("Table.showCellFocusIndicator");
    private Component c;

    protected FlatTableCellBorder() {
        super(UIManager.getInsets("Table.cellMargins"), UIManager.getColor("Table.cellFocusColor"));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Insets insets2 = FlatTableCellBorder.getStyleFromTableUI(component, flatTableUI -> flatTableUI.cellMargins);
        if (insets2 != null) {
            return FlatTableCellBorder.scaleInsets(component, insets, insets2.top, insets2.left, insets2.bottom, insets2.right);
        }
        return super.getBorderInsets(component, insets);
    }

    @Override
    public Color getLineColor() {
        Color color;
        if (this.c != null && (color = FlatTableCellBorder.getStyleFromTableUI(this.c, flatTableUI -> flatTableUI.cellFocusColor)) != null) {
            return color;
        }
        return super.getLineColor();
    }

    @Override
    public int getArc() {
        Integer n2;
        if (this.c != null && (n2 = FlatTableCellBorder.getStyleFromTableUI(this.c, flatTableUI -> flatTableUI.selectionArc)) != null) {
            return n2;
        }
        return super.getArc();
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Insets insets;
        if (component != null && (insets = FlatTableCellBorder.getStyleFromTableUI(component, flatTableUI -> flatTableUI.selectionInsets)) != null) {
            n2 += insets.left;
            n3 += insets.top;
            n4 -= insets.left + insets.right;
            n5 -= insets.top + insets.bottom;
        }
        this.c = component;
        super.paintBorder(component, graphics, n2, n3, n4, n5);
        this.c = null;
    }

    static <T> T getStyleFromTableUI(Component component, Function<FlatTableUI, T> function) {
        TableUI tableUI;
        JTable jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component);
        if (jTable != null && (tableUI = jTable.getUI()) instanceof FlatTableUI) {
            return function.apply((FlatTableUI)tableUI);
        }
        return null;
    }

    public static class Selected
    extends FlatTableCellBorder {
        public int maxCheckCellsEditable = 50;

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            JTable jTable;
            boolean bl2;
            Boolean bl3 = Selected.getStyleFromTableUI(component, flatTableUI -> flatTableUI.showCellFocusIndicator);
            boolean bl4 = bl2 = bl3 != null ? bl3 : this.showCellFocusIndicator;
            if (!bl2 && (jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component)) != null && !this.shouldShowCellFocusIndicator(jTable)) {
                return;
            }
            super.paintBorder(component, graphics, n2, n3, n4, n5);
        }

        protected boolean shouldShowCellFocusIndicator(JTable jTable) {
            block8: {
                boolean bl2;
                block7: {
                    boolean bl3 = jTable.getRowSelectionAllowed();
                    bl2 = jTable.getColumnSelectionAllowed();
                    if (bl3 && bl2) {
                        return false;
                    }
                    if (!bl3) break block7;
                    if (jTable.getSelectedRowCount() != 1) {
                        return false;
                    }
                    int n2 = jTable.getColumnCount();
                    if (n2 > this.maxCheckCellsEditable) {
                        return true;
                    }
                    int n3 = jTable.getSelectedRow();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        if (!jTable.isCellEditable(n3, i2)) continue;
                        return true;
                    }
                    break block8;
                }
                if (!bl2) break block8;
                if (jTable.getSelectedColumnCount() != 1) {
                    return false;
                }
                int n4 = jTable.getRowCount();
                if (n4 > this.maxCheckCellsEditable) {
                    return true;
                }
                int n5 = jTable.getSelectedColumn();
                for (int i3 = 0; i3 < n4; ++i3) {
                    if (!jTable.isCellEditable(i3, n5)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public static class Focused
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            Border border;
            JTable jTable;
            if (component != null && component.getClass().getName().equals("javax.swing.JTable$BooleanRenderer") && (jTable = (JTable)SwingUtilities.getAncestorOfClass(JTable.class, component)) != null && component.getForeground() == jTable.getSelectionForeground() && component.getBackground() == jTable.getSelectionBackground() && (border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder")) != null) {
                border.paintBorder(component, graphics, n2, n3, n4, n5);
                return;
            }
            super.paintBorder(component, graphics, n2, n3, n4, n5);
        }
    }

    public static class Default
    extends FlatTableCellBorder {
        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        }
    }
}

