/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatEmptyBorder;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Rectangle2D;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;

public class FlatTableHeaderBorder
extends FlatEmptyBorder {
    protected Color separatorColor = UIManager.getColor("TableHeader.separatorColor");
    protected Color bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
    protected boolean showTrailingVerticalLine = UIManager.getBoolean("TableHeader.showTrailingVerticalLine");

    public FlatTableHeaderBorder() {
        super(UIManager.getInsets("TableHeader.cellMargins"));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        JTableHeader jTableHeader = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, component);
        if (jTableHeader != null && jTableHeader.getUI() instanceof FlatTableHeaderUI) {
            FlatTableHeaderUI flatTableHeaderUI = (FlatTableHeaderUI)jTableHeader.getUI();
            if (flatTableHeaderUI.cellMargins != null) {
                Insets insets2 = flatTableHeaderUI.cellMargins;
                return FlatTableHeaderBorder.scaleInsets(component, insets, insets2.top, insets2.left, insets2.bottom, insets2.right);
            }
        }
        return super.getBorderInsets(component, insets);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Object object;
        JTableHeader jTableHeader = (JTableHeader)SwingUtilities.getAncestorOfClass(JTableHeader.class, component);
        boolean bl2 = (jTableHeader != null ? jTableHeader : component).getComponentOrientation().isLeftToRight();
        boolean bl3 = !bl2;
        boolean bl4 = bl2;
        Color color = this.separatorColor;
        Color color2 = this.bottomSeparatorColor;
        if (jTableHeader != null) {
            int n6 = SwingUtilities.convertPoint((Component)component, (int)n2, (int)n3, (Component)jTableHeader).x;
            if (this.isDraggedColumn(jTableHeader, n6)) {
                bl4 = true;
                bl3 = true;
            } else {
                if (n6 <= 0 && !bl2 && this.hideTrailingVerticalLine(jTableHeader)) {
                    bl3 = false;
                }
                if (n6 + n4 >= jTableHeader.getWidth() && bl2 && this.hideTrailingVerticalLine(jTableHeader)) {
                    bl4 = false;
                }
            }
            if (jTableHeader.getUI() instanceof FlatTableHeaderUI) {
                object = (FlatTableHeaderUI)jTableHeader.getUI();
                if (((FlatTableHeaderUI)object).separatorColor != null) {
                    color = ((FlatTableHeaderUI)object).separatorColor;
                }
                if (((FlatTableHeaderUI)object).bottomSeparatorColor != null) {
                    color2 = ((FlatTableHeaderUI)object).bottomSeparatorColor;
                }
            }
        }
        float f2 = UIScale.scale(1.0f);
        object = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints((Graphics)object);
            ((Graphics)object).setColor(color);
            if (bl3) {
                ((Graphics2D)object).fill(new Rectangle2D.Float(n2, n3, f2, (float)n5 - f2));
            }
            if (bl4) {
                ((Graphics2D)object).fill(new Rectangle2D.Float((float)(n2 + n4) - f2, n3, f2, (float)n5 - f2));
            }
            ((Graphics)object).setColor(color2);
            ((Graphics2D)object).fill(new Rectangle2D.Float(n2, (float)(n3 + n5) - f2, n4, f2));
        }
        finally {
            ((Graphics)object).dispose();
        }
    }

    protected boolean isDraggedColumn(JTableHeader jTableHeader, int n2) {
        TableColumn tableColumn = jTableHeader.getDraggedColumn();
        if (tableColumn == null) {
            return false;
        }
        int n3 = jTableHeader.getDraggedDistance();
        if (n3 == 0) {
            return false;
        }
        int n4 = jTableHeader.getColumnModel().getColumnCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            if (jTableHeader.getHeaderRect((int)i2).x + n3 != n2) continue;
            return true;
        }
        return false;
    }

    protected boolean hideTrailingVerticalLine(JTableHeader jTableHeader) {
        Container container;
        Object object;
        if (jTableHeader.getUI() instanceof FlatTableHeaderUI) {
            object = (FlatTableHeaderUI)jTableHeader.getUI();
            if (((FlatTableHeaderUI)object).showTrailingVerticalLine != null) {
                return ((FlatTableHeaderUI)object).showTrailingVerticalLine == false;
            }
        }
        if (this.showTrailingVerticalLine) {
            return false;
        }
        object = jTableHeader.getParent();
        Container container2 = container = object != null ? ((Component)object).getParent() : null;
        if (!(container instanceof JScrollPane)) {
            return false;
        }
        JScrollPane jScrollPane = (JScrollPane)container;
        JViewport jViewport = jScrollPane.getColumnHeader();
        if (object != jViewport) {
            return false;
        }
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        if (jScrollBar == null || !jScrollBar.isVisible()) {
            return true;
        }
        return jScrollBar.getY() == ((Component)object).getY();
    }
}

