/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTableHeaderUI;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class FlatTableHeaderUI
extends BasicTableHeaderUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color hoverBackground;
    @FlatStylingSupport.Styleable
    protected Color hoverForeground;
    @FlatStylingSupport.Styleable
    protected Color pressedBackground;
    @FlatStylingSupport.Styleable
    protected Color pressedForeground;
    @FlatStylingSupport.Styleable
    protected Color bottomSeparatorColor;
    @FlatStylingSupport.Styleable
    protected int height;
    @FlatStylingSupport.Styleable(type=String.class)
    protected int sortIconPosition;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    @FlatStylingSupport.Styleable
    protected Boolean showTrailingVerticalLine;
    @FlatStylingSupport.Styleable
    public String arrowType;
    @FlatStylingSupport.Styleable
    public Color sortIconColor;
    private PropertyChangeListener propertyChangeListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTableHeaderUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.header.remove(this.rendererPane);
        this.rendererPane = new FlatTableHeaderCellRendererPane();
        this.header.add(this.rendererPane);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.hoverBackground = UIManager.getColor("TableHeader.hoverBackground");
        this.hoverForeground = UIManager.getColor("TableHeader.hoverForeground");
        this.pressedBackground = UIManager.getColor("TableHeader.pressedBackground");
        this.pressedForeground = UIManager.getColor("TableHeader.pressedForeground");
        this.bottomSeparatorColor = UIManager.getColor("TableHeader.bottomSeparatorColor");
        this.height = UIManager.getInt("TableHeader.height");
        this.sortIconPosition = FlatTableHeaderUI.parseSortIconPosition(UIManager.getString("TableHeader.sortIconPosition"));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverBackground = null;
        this.hoverForeground = null;
        this.pressedBackground = null;
        this.pressedForeground = null;
        this.bottomSeparatorColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = FlatStylingSupport.createPropertyChangeListener(this.header, this::installStyle, null);
        this.header.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.header.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.header, "TableHeader"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (string.equals("sortIconPosition") && object instanceof String) {
            object = FlatTableHeaderUI.parseSortIconPosition((String)object);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.header, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        if (string.equals("sortIconPosition")) {
            switch (this.sortIconPosition) {
                default: {
                    return "right";
                }
                case 2: {
                    return "left";
                }
                case 1: {
                    return "top";
                }
                case 3: 
            }
            return "bottom";
        }
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    private static int parseSortIconPosition(String string) {
        if (string == null) {
            string = "";
        }
        switch (string) {
            default: {
                return 4;
            }
            case "left": {
                return 2;
            }
            case "top": {
                return 1;
            }
            case "bottom": 
        }
        return 3;
    }

    @Override
    protected MouseInputListener createMouseInputListener() {
        return new FlatMouseInputHandler();
    }

    @Override
    public int getRolloverColumn() {
        return super.getRolloverColumn();
    }

    @Override
    protected void rolloverColumnUpdated(int n2, int n3) {
        HiDPIUtils.repaint(this.header, this.header.getHeaderRect(n2));
        HiDPIUtils.repaint(this.header, this.header.getHeaderRect(n3));
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        FlatTableHeaderUI.fixDraggedAndResizingColumns(this.header);
        TableColumnModel tableColumnModel = this.header.getColumnModel();
        if (tableColumnModel.getColumnCount() <= 0) {
            return;
        }
        int n2 = tableColumnModel.getColumnCount();
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 += tableColumnModel.getColumn(i2).getWidth();
        }
        if (n3 < this.header.getWidth()) {
            TableCellRenderer tableCellRenderer = this.header.getDefaultRenderer();
            boolean bl2 = this.isSystemDefaultRenderer(tableCellRenderer);
            if (!bl2 && this.header.getTable() != null) {
                Component component = tableCellRenderer.getTableCellRendererComponent(this.header.getTable(), "", false, false, -1, 0);
                bl2 = this.isSystemDefaultRenderer(component);
            }
            if (bl2) {
                int n4 = jComponent.getWidth() - n3;
                int n5 = this.header.getComponentOrientation().isLeftToRight() ? jComponent.getWidth() - n4 : 0;
                this.paintBottomSeparator(graphics, jComponent, n5, n4);
            }
        }
        super.paint(graphics, jComponent);
    }

    private boolean isSystemDefaultRenderer(Object object) {
        String string = object.getClass().getName();
        return string.equals("sun.swing.table.DefaultTableCellHeaderRenderer") || string.equals("sun.swing.FilePane$AlignableTableHeaderRenderer");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBottomSeparator(Graphics graphics, JComponent jComponent, int n2, int n3) {
        float f2 = UIScale.scale(1.0f);
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            graphics2D.setColor(this.bottomSeparatorColor);
            graphics2D.fill(new Rectangle2D.Float(n2, (float)jComponent.getHeight() - f2, n3, f2));
        }
        finally {
            graphics2D.dispose();
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        if (dimension.height > 0) {
            dimension.height = Math.max(dimension.height, UIScale.scale(this.height));
        }
        return dimension;
    }

    static void fixDraggedAndResizingColumns(JTableHeader jTableHeader) {
        TableColumn tableColumn;
        if (jTableHeader == null) {
            return;
        }
        TableColumn tableColumn2 = jTableHeader.getDraggedColumn();
        if (tableColumn2 != null && !FlatTableHeaderUI.isValidColumn(jTableHeader.getColumnModel(), tableColumn2)) {
            jTableHeader.setDraggedColumn(null);
        }
        if ((tableColumn = jTableHeader.getResizingColumn()) != null && !FlatTableHeaderUI.isValidColumn(jTableHeader.getColumnModel(), tableColumn)) {
            jTableHeader.setResizingColumn(null);
        }
    }

    private static boolean isValidColumn(TableColumnModel tableColumnModel, TableColumn tableColumn) {
        int n2 = tableColumnModel.getColumnCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return true;
        }
        return false;
    }

    protected class FlatMouseInputHandler
    extends BasicTableHeaderUI.MouseInputHandler {
        Cursor oldCursor;

        protected FlatMouseInputHandler() {
            super(FlatTableHeaderUI.this);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            int n2;
            JTable jTable;
            if (this.oldCursor != null) {
                FlatTableHeaderUI.this.header.setCursor(this.oldCursor);
                this.oldCursor = null;
            }
            super.mouseMoved(mouseEvent);
            if (FlatTableHeaderUI.this.header.isEnabled() && (jTable = FlatTableHeaderUI.this.header.getTable()) != null && jTable.getAutoResizeMode() != 0 && FlatTableHeaderUI.this.header.getCursor() == Cursor.getPredefinedCursor(11) && (n2 = FlatTableHeaderUI.this.header.columnAtPoint(mouseEvent.getPoint())) >= 0 && n2 == FlatTableHeaderUI.this.header.getColumnModel().getColumnCount() - 1) {
                Rectangle rectangle = FlatTableHeaderUI.this.header.getHeaderRect(n2);
                rectangle.grow(-3, 0);
                if (!rectangle.contains(mouseEvent.getX(), mouseEvent.getY())) {
                    boolean bl2;
                    boolean bl3 = bl2 = mouseEvent.getX() >= rectangle.x + rectangle.width / 2;
                    if (!FlatTableHeaderUI.this.header.getComponentOrientation().isLeftToRight()) {
                        boolean bl4 = bl2 = !bl2;
                    }
                    if (bl2) {
                        this.oldCursor = FlatTableHeaderUI.this.header.getCursor();
                        FlatTableHeaderUI.this.header.setCursor(Cursor.getDefaultCursor());
                    }
                }
            }
        }
    }

    private class FlatTableHeaderCellRendererPane
    extends CellRendererPane {
        private final Icon ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
        private final Icon descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");

        @Override
        public void paintComponent(Graphics graphics, Component component, Container container, int n2, int n3, int n4, int n5, boolean bl2) {
            Icon icon;
            boolean bl3;
            if (!(component instanceof JLabel)) {
                super.paintComponent(graphics, component, container, n2, n3, n4, n5, bl2);
                return;
            }
            JLabel jLabel = (JLabel)component;
            Color color = null;
            Color color2 = null;
            boolean bl4 = false;
            Icon icon2 = null;
            int n6 = -1;
            TableColumn tableColumn = FlatTableHeaderUI.this.header.getDraggedColumn();
            Color color3 = null;
            Color color4 = null;
            if (tableColumn != null && FlatTableHeaderUI.this.header.getTable().convertColumnIndexToView(tableColumn.getModelIndex()) == this.getColumn(n2 - FlatTableHeaderUI.this.header.getDraggedDistance(), n4)) {
                color3 = FlatTableHeaderUI.this.pressedBackground;
                color4 = FlatTableHeaderUI.this.pressedForeground;
            } else if (FlatTableHeaderUI.this.getRolloverColumn() >= 0 && FlatTableHeaderUI.this.getRolloverColumn() == this.getColumn(n2, n4)) {
                color3 = FlatTableHeaderUI.this.hoverBackground;
                color4 = FlatTableHeaderUI.this.hoverForeground;
            }
            if (color3 != null) {
                color = jLabel.getBackground();
                bl4 = jLabel.isOpaque();
                jLabel.setBackground(FlatUIUtils.deriveColor(color3, FlatTableHeaderUI.this.header.getBackground()));
                jLabel.setOpaque(true);
            }
            if (color4 != null) {
                color2 = jLabel.getForeground();
                jLabel.setForeground(FlatUIUtils.deriveColor(color4, FlatTableHeaderUI.this.header.getForeground()));
            }
            boolean bl5 = bl3 = (icon = jLabel.getIcon()) != null && (icon == this.ascendingSortIcon || icon == this.descendingSortIcon);
            if (bl3) {
                if (FlatTableHeaderUI.this.sortIconPosition == 2) {
                    n6 = jLabel.getHorizontalTextPosition();
                    jLabel.setHorizontalTextPosition(4);
                } else if (FlatTableHeaderUI.this.sortIconPosition == 1 || FlatTableHeaderUI.this.sortIconPosition == 3) {
                    icon2 = icon;
                    jLabel.setIcon(null);
                }
            }
            super.paintComponent(graphics, component, container, n2, n3, n4, n5, bl2);
            if (bl3 && (FlatTableHeaderUI.this.sortIconPosition == 1 || FlatTableHeaderUI.this.sortIconPosition == 3)) {
                int n7 = n2 + (n4 - icon.getIconWidth()) / 2;
                int n8 = FlatTableHeaderUI.this.sortIconPosition == 1 ? n3 + UIScale.scale(1) : n3 + FlatTableHeaderUI.this.height - icon.getIconHeight() - 1 - (int)(1.0f * UIScale.getUserScaleFactor());
                icon.paintIcon(component, graphics, n7, n8);
            }
            if (color3 != null) {
                jLabel.setBackground(color);
                jLabel.setOpaque(bl4);
            }
            if (color4 != null) {
                jLabel.setForeground(color2);
            }
            if (icon2 != null) {
                jLabel.setIcon(icon2);
            }
            if (n6 >= 0) {
                jLabel.setHorizontalTextPosition(n6);
            }
        }

        private int getColumn(int n2, int n3) {
            TableColumnModel tableColumnModel = FlatTableHeaderUI.this.header.getColumnModel();
            int n4 = tableColumnModel.getColumnCount();
            boolean bl2 = FlatTableHeaderUI.this.header.getComponentOrientation().isLeftToRight();
            int n5 = bl2 ? 0 : this.getWidthInRightToLef();
            for (int i2 = 0; i2 < n4; ++i2) {
                int n6 = tableColumnModel.getColumn(i2).getWidth();
                if (n2 == n5 - (bl2 ? 0 : n6) && n3 == n6) {
                    return i2;
                }
                n5 += bl2 ? n6 : -n6;
            }
            return -1;
        }

        private int getWidthInRightToLef() {
            JTable jTable = FlatTableHeaderUI.this.header.getTable();
            return jTable != null && jTable.getAutoResizeMode() != 0 ? jTable.getWidth() : FlatTableHeaderUI.this.header.getWidth();
        }
    }
}

