/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.icons.FlatCheckBoxIcon;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTableHeaderUI;
import com.formdev.flatlaf.ui.FlatUIAction;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.FlatViewportUI;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class FlatTableUI
extends BasicTableUI
implements FlatStylingSupport.StyleableUI,
FlatViewportUI.ViewportPainter {
    protected boolean showHorizontalLines;
    protected boolean showVerticalLines;
    @FlatStylingSupport.Styleable
    protected boolean showTrailingVerticalLine;
    protected Dimension intercellSpacing;
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    @FlatStylingSupport.Styleable
    protected Insets cellMargins;
    @FlatStylingSupport.Styleable
    protected Color cellFocusColor;
    @FlatStylingSupport.Styleable
    protected Boolean showCellFocusIndicator;
    private boolean oldShowHorizontalLines;
    private boolean oldShowVerticalLines;
    private Dimension oldIntercellSpacing;
    private TableCellRenderer oldBooleanRenderer;
    private PropertyChangeListener propertyChangeListener;
    private ComponentListener outsideAlternateRowsListener;
    private ListSelectionListener rowSelectionListener;
    private TableColumnModelListener columnSelectionListener;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTableUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        FlatTablePropertyWatcher flatTablePropertyWatcher;
        super.installDefaults();
        this.showHorizontalLines = UIManager.getBoolean("Table.showHorizontalLines");
        this.showVerticalLines = UIManager.getBoolean("Table.showVerticalLines");
        this.showTrailingVerticalLine = UIManager.getBoolean("Table.showTrailingVerticalLine");
        this.intercellSpacing = UIManager.getDimension("Table.intercellSpacing");
        this.selectionBackground = UIManager.getColor("Table.selectionBackground");
        this.selectionForeground = UIManager.getColor("Table.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("Table.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("Table.selectionInactiveForeground");
        this.selectionInsets = UIManager.getInsets("Table.selectionInsets");
        this.selectionArc = UIManager.getInt("Table.selectionArc");
        this.toggleSelectionColors();
        int n2 = FlatUIUtils.getUIInt("Table.rowHeight", 16);
        if (n2 > 0) {
            LookAndFeel.installProperty(this.table, "rowHeight", UIScale.scale(n2));
        }
        if ((flatTablePropertyWatcher = FlatTablePropertyWatcher.get(this.table)) != null) {
            flatTablePropertyWatcher.enabled = false;
        }
        if (!(this.showHorizontalLines || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showHorizontalLinesChanged)) {
            this.oldShowHorizontalLines = this.table.getShowHorizontalLines();
            this.table.setShowHorizontalLines(false);
        }
        if (!(this.showVerticalLines || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showVerticalLinesChanged)) {
            this.oldShowVerticalLines = this.table.getShowVerticalLines();
            this.table.setShowVerticalLines(false);
        }
        if (!(this.intercellSpacing == null || flatTablePropertyWatcher != null && flatTablePropertyWatcher.intercellSpacingChanged)) {
            this.oldIntercellSpacing = this.table.getIntercellSpacing();
            this.table.setIntercellSpacing(this.intercellSpacing);
        }
        if (flatTablePropertyWatcher != null) {
            flatTablePropertyWatcher.enabled = true;
        } else {
            this.table.addPropertyChangeListener(new FlatTablePropertyWatcher());
        }
        this.oldBooleanRenderer = this.table.getDefaultRenderer(Boolean.class);
        if (this.oldBooleanRenderer instanceof UIResource) {
            this.table.setDefaultRenderer(Boolean.class, new FlatBooleanRenderer());
        } else {
            this.oldBooleanRenderer = null;
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.oldStyleValues = null;
        FlatTablePropertyWatcher flatTablePropertyWatcher = FlatTablePropertyWatcher.get(this.table);
        if (flatTablePropertyWatcher != null) {
            flatTablePropertyWatcher.enabled = false;
        }
        if (!(this.showHorizontalLines || !this.oldShowHorizontalLines || this.table.getShowHorizontalLines() || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showHorizontalLinesChanged)) {
            this.table.setShowHorizontalLines(true);
        }
        if (!(this.showVerticalLines || !this.oldShowVerticalLines || this.table.getShowVerticalLines() || flatTablePropertyWatcher != null && flatTablePropertyWatcher.showVerticalLinesChanged)) {
            this.table.setShowVerticalLines(true);
        }
        if (this.intercellSpacing != null && this.table.getIntercellSpacing().equals(this.intercellSpacing) && (flatTablePropertyWatcher == null || !flatTablePropertyWatcher.intercellSpacingChanged)) {
            this.table.setIntercellSpacing(this.oldIntercellSpacing);
        }
        if (flatTablePropertyWatcher != null) {
            flatTablePropertyWatcher.enabled = true;
        }
        if (this.table.getDefaultRenderer(Boolean.class) instanceof FlatBooleanRenderer) {
            if (this.oldBooleanRenderer instanceof Component) {
                SwingUtilities.updateComponentTreeUI((Component)((Object)this.oldBooleanRenderer));
            }
            this.table.setDefaultRenderer(Boolean.class, this.oldBooleanRenderer);
        }
        this.oldBooleanRenderer = null;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.propertyChangeListener = propertyChangeEvent -> {
            switch (propertyChangeEvent.getPropertyName()) {
                case "selectionModel": {
                    if (this.rowSelectionListener == null) break;
                    Object object = propertyChangeEvent.getOldValue();
                    Object object2 = propertyChangeEvent.getNewValue();
                    if (object != null) {
                        ((ListSelectionModel)object).removeListSelectionListener(this.rowSelectionListener);
                    }
                    if (object2 == null) break;
                    ((ListSelectionModel)object2).addListSelectionListener(this.rowSelectionListener);
                    break;
                }
                case "columnModel": {
                    if (this.columnSelectionListener == null) break;
                    Object object = propertyChangeEvent.getOldValue();
                    Object object3 = propertyChangeEvent.getNewValue();
                    if (object != null) {
                        ((TableColumnModel)object).removeColumnModelListener(this.columnSelectionListener);
                    }
                    if (object3 == null) break;
                    ((TableColumnModel)object3).addColumnModelListener(this.columnSelectionListener);
                    break;
                }
                case "JComponent.focusOwner": {
                    this.toggleSelectionColors();
                    break;
                }
                case "FlatLaf.style": 
                case "FlatLaf.styleClass": {
                    this.installStyle();
                    this.table.revalidate();
                    HiDPIUtils.repaint(this.table);
                }
            }
        };
        this.table.addPropertyChangeListener(this.propertyChangeListener);
        if (this.selectionArc > 0) {
            this.installRepaintRoundedSelectionListeners();
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        if (this.outsideAlternateRowsListener != null) {
            this.table.removeComponentListener(this.outsideAlternateRowsListener);
            this.outsideAlternateRowsListener = null;
        }
        if (this.rowSelectionListener != null) {
            this.table.getSelectionModel().removeListSelectionListener(this.rowSelectionListener);
            this.rowSelectionListener = null;
        }
        if (this.columnSelectionListener != null) {
            this.table.getColumnModel().removeColumnModelListener(this.columnSelectionListener);
            this.columnSelectionListener = null;
        }
    }

    @Override
    protected FocusListener createFocusListener() {
        return new BasicTableUI.FocusHandler(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                super.focusGained(focusEvent);
                FlatTableUI.this.toggleSelectionColors();
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                super.focusLost(focusEvent);
                EventQueue.invokeLater(() -> FlatTableUI.this.toggleSelectionColors());
            }
        };
    }

    @Override
    protected void installKeyboardActions() {
        ActionMap actionMap;
        super.installKeyboardActions();
        if (UIManager.getBoolean("Table.editorSelectAllOnStartEditing") && (actionMap = SwingUtilities.getUIActionMap(this.table)) != null) {
            StartEditingAction.install(actionMap, "startEditing");
        }
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.table, "Table"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        Color color;
        Color color2 = this.selectionBackground;
        Color color3 = this.selectionForeground;
        Color color4 = this.selectionInactiveBackground;
        Color color5 = this.selectionInactiveForeground;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.selectionBackground != color2) {
            color = this.table.getSelectionBackground();
            if (color == color2) {
                this.table.setSelectionBackground(this.selectionBackground);
            } else if (color == color4) {
                this.table.setSelectionBackground(this.selectionInactiveBackground);
            }
        }
        if (this.selectionForeground != color3) {
            color = this.table.getSelectionForeground();
            if (color == color3) {
                this.table.setSelectionForeground(this.selectionForeground);
            } else if (color == color5) {
                this.table.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if ("rowHeight".equals(string) && object instanceof Integer) {
            object = UIScale.scale((Integer)object);
        } else if ("selectionArc".equals(string) && object instanceof Integer && (Integer)object > 0) {
            this.installRepaintRoundedSelectionListeners();
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.table, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    private void toggleSelectionColors() {
        if (this.table == null) {
            return;
        }
        if (FlatUIUtils.isPermanentFocusOwner(this.table)) {
            if (this.table.getSelectionBackground() == this.selectionInactiveBackground) {
                this.table.setSelectionBackground(this.selectionBackground);
            }
            if (this.table.getSelectionForeground() == this.selectionInactiveForeground) {
                this.table.setSelectionForeground(this.selectionForeground);
            }
        } else {
            if (this.table.getSelectionBackground() == this.selectionBackground) {
                this.table.setSelectionBackground(this.selectionInactiveBackground);
            }
            if (this.table.getSelectionForeground() == this.selectionForeground) {
                this.table.setSelectionForeground(this.selectionInactiveForeground);
            }
        }
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        FlatTableHeaderUI.fixDraggedAndResizingColumns(this.table.getTableHeader());
        final boolean bl2 = this.table.getShowHorizontalLines();
        final boolean bl3 = this.table.getShowVerticalLines();
        if (bl2 || bl3) {
            final boolean bl4 = this.hideLastVerticalLine();
            final int n2 = this.table.getWidth();
            JTableHeader jTableHeader = this.table.getTableHeader();
            final boolean bl5 = jTableHeader != null && jTableHeader.getDraggedColumn() != null;
            double d2 = UIScale.getSystemScaleFactor((Graphics2D)graphics);
            final double d3 = 1.0 / d2 * (double)((int)d2);
            final double d4 = 1.0 - d3 + 0.05;
            graphics = new Graphics2DProxy((Graphics2D)graphics){

                @Override
                public void drawLine(int n22, int n3, int n4, int n5) {
                    if (bl4 && bl3 && n22 == n4 && n3 == 0 && n22 == n2 - 1 && this.wasInvokedFromPaintGrid()) {
                        return;
                    }
                    if (bl5 && SystemInfo.isJava_9_orLater && (bl2 && n3 == n5 || bl3 && n22 == n4) && this.wasInvokedFromMethod("paintDraggedArea")) {
                        if (n3 == n5) {
                            super.fill(new Rectangle2D.Double(n22, n3, n4 - n22 + 1, d3));
                        } else if (n22 == n4) {
                            super.fill(new Rectangle2D.Double(n22, n3, d3, n5 - n3 + 1));
                        }
                        return;
                    }
                    super.drawLine(n22, n3, n4, n5);
                }

                @Override
                public void fillRect(int n22, int n3, int n4, int n5) {
                    if (bl4 && bl3 && n4 == 1 && n3 == 0 && n22 == n2 - 1 && this.wasInvokedFromPaintGrid()) {
                        return;
                    }
                    if (d3 != 1.0) {
                        if (bl2 && n5 == 1 && this.wasInvokedFromPaintGrid()) {
                            super.fill(new Rectangle2D.Double(n22, (double)n3 + d4, n4, d3));
                            return;
                        }
                        if (bl3 && n4 == 1 && n3 == 0 && this.wasInvokedFromPaintGrid()) {
                            super.fill(new Rectangle2D.Double((double)n22 + d4, n3, d3, n5));
                            return;
                        }
                    }
                    super.fillRect(n22, n3, n4, n5);
                }

                private boolean wasInvokedFromPaintGrid() {
                    return this.wasInvokedFromMethod("paintGrid");
                }

                private boolean wasInvokedFromMethod(String string) {
                    return StackUtils.wasInvokedFrom(BasicTableUI.class.getName(), string, 8);
                }
            };
        }
        if (this.selectionArc > 0 || this.selectionInsets != null && !FlatUIUtils.isInsetsEmpty(this.selectionInsets)) {
            graphics = new RoundedSelectionGraphics(graphics, UIManager.getColor("Table.alternateRowColor"));
        }
        super.paint(graphics, jComponent);
    }

    protected boolean hideLastVerticalLine() {
        Container container;
        if (this.showTrailingVerticalLine) {
            return false;
        }
        Container container2 = SwingUtilities.getUnwrappedParent(this.table);
        Container container3 = container = container2 != null ? container2.getParent() : null;
        if (!(container instanceof JScrollPane)) {
            return false;
        }
        if (this.table.getX() + this.table.getWidth() < container2.getWidth()) {
            return false;
        }
        JScrollPane jScrollPane = (JScrollPane)container;
        JViewport jViewport = jScrollPane.getRowHeader();
        return jScrollPane.getComponentOrientation().isLeftToRight() ? container2 != jViewport : container2 == jViewport || jViewport == null;
    }

    @Override
    public void paintViewport(Graphics graphics, JComponent jComponent, JViewport jViewport) {
        Color color;
        boolean bl2;
        int n2 = jViewport.getWidth();
        int n3 = jViewport.getHeight();
        if (jViewport.isOpaque()) {
            graphics.setColor(this.table.getBackground());
            graphics.fillRect(0, 0, n2, n3);
        }
        if ((bl2 = UIManager.getBoolean("Table.paintOutsideAlternateRows")) && (color = UIManager.getColor("Table.alternateRowColor")) != null) {
            int n4 = this.table.getRowCount();
            int n5 = this.table.getHeight();
            if (n5 < n3) {
                int n6 = this.table.getWidth();
                int n7 = this.table.getRowHeight();
                graphics.setColor(color);
                int n8 = jViewport.getComponentOrientation().isLeftToRight() ? 0 : n2 - n6;
                int n9 = n5;
                int n10 = n4;
                while (n9 < n3) {
                    if (n10 % 2 != 0) {
                        this.paintAlternateRowBackground(graphics, -1, -1, n8, n9, n6, n7);
                    }
                    n9 += n7;
                    ++n10;
                }
                if (this.outsideAlternateRowsListener == null && this.table.getAutoResizeMode() == 0) {
                    this.outsideAlternateRowsListener = new FlatOutsideAlternateRowsListener();
                    this.table.addComponentListener(this.outsideAlternateRowsListener);
                }
            }
        }
    }

    protected void paintAlternateRowBackground(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2;
        Insets insets = this.selectionInsets != null ? (Insets)this.selectionInsets.clone() : null;
        float f3 = f2 = UIScale.scale((float)this.selectionArc / 2.0f);
        float f4 = f2;
        float f5 = f2;
        if (n3 >= 0) {
            if (n3 > 0) {
                if (insets != null) {
                    insets.left = 0;
                }
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    f3 = 0.0f;
                    f5 = 0.0f;
                } else {
                    f2 = 0.0f;
                    f4 = 0.0f;
                }
            }
            if (n3 < this.table.getColumnCount() - 1) {
                if (insets != null) {
                    insets.right = 0;
                }
                if (this.table.getComponentOrientation().isLeftToRight()) {
                    f2 = 0.0f;
                    f4 = 0.0f;
                } else {
                    f3 = 0.0f;
                    f5 = 0.0f;
                }
            }
        }
        FlatUIUtils.paintSelection((Graphics2D)graphics, n4, n5, n6, n7, UIScale.scale(insets), f5, f4, f3, f2, 0);
    }

    protected void paintCellSelection(Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2;
        Insets insets;
        boolean bl2;
        boolean bl3 = this.table.getRowSelectionAllowed();
        boolean bl4 = this.table.getColumnSelectionAllowed();
        boolean bl5 = bl3 && !bl4;
        boolean bl6 = bl4 && !bl3;
        boolean bl7 = bl3 && bl4;
        boolean bl8 = n3 > 0 && (bl5 || this.table.isCellSelected(n2, n3 - 1));
        boolean bl9 = n2 > 0 && (bl6 || this.table.isCellSelected(n2 - 1, n3));
        boolean bl10 = n3 < this.table.getColumnCount() - 1 && (bl5 || this.table.isCellSelected(n2, n3 + 1));
        boolean bl11 = bl2 = n2 < this.table.getRowCount() - 1 && (bl6 || this.table.isCellSelected(n2 + 1, n3));
        if (!this.table.getComponentOrientation().isLeftToRight()) {
            boolean bl12 = bl8;
            bl8 = bl10;
            bl10 = bl12;
        }
        Insets insets2 = insets = this.selectionInsets != null ? (Insets)this.selectionInsets.clone() : null;
        if (insets != null) {
            if (bl5 && bl8) {
                insets.left = 0;
            }
            if (bl5 && bl10) {
                insets.right = 0;
            }
            if (bl6 && bl9) {
                insets.top = 0;
            }
            if (bl6 && bl2) {
                insets.bottom = 0;
            }
        }
        float f3 = f2 = UIScale.scale((float)this.selectionArc / 2.0f);
        float f4 = f2;
        float f5 = f2;
        if (this.selectionArc > 0) {
            boolean bl13;
            boolean bl14 = !(!bl5 && !bl7 || insets == null || insets.top == 0 && insets.bottom == 0);
            boolean bl15 = bl13 = !(!bl6 && !bl7 || insets == null || insets.left == 0 && insets.right == 0);
            if (bl8 && !bl13) {
                f3 = 0.0f;
                f5 = 0.0f;
            }
            if (bl10 && !bl13) {
                f2 = 0.0f;
                f4 = 0.0f;
            }
            if (bl9 && !bl14) {
                f4 = 0.0f;
                f5 = 0.0f;
            }
            if (bl2 && !bl14) {
                f2 = 0.0f;
                f3 = 0.0f;
            }
        }
        FlatUIUtils.paintSelection((Graphics2D)graphics, n4, n5, n6, n7, UIScale.scale(insets), f5, f4, f3, f2, 0);
    }

    public static void paintCellSelection(JTable jTable, Graphics graphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        if (!(jTable.getUI() instanceof FlatTableUI)) {
            return;
        }
        FlatTableUI flatTableUI = (FlatTableUI)jTable.getUI();
        flatTableUI.paintCellSelection(graphics, n2, n3, n4, n5, n6, n7);
    }

    private void installRepaintRoundedSelectionListeners() {
        if (this.rowSelectionListener == null) {
            this.rowSelectionListener = this::repaintRoundedRowSelection;
            this.table.getSelectionModel().addListSelectionListener(this.rowSelectionListener);
        }
        if (this.columnSelectionListener == null) {
            this.columnSelectionListener = new TableColumnModelListener(){

                @Override
                public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
                    FlatTableUI.this.repaintRoundedColumnSelection(listSelectionEvent);
                }

                @Override
                public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
                }

                @Override
                public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
                }

                @Override
                public void columnMarginChanged(ChangeEvent changeEvent) {
                }

                @Override
                public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
                }
            };
            this.table.getColumnModel().addColumnModelListener(this.columnSelectionListener);
        }
    }

    private void repaintRoundedRowSelection(ListSelectionEvent listSelectionEvent) {
        if (this.selectionArc <= 0 || !this.table.getRowSelectionAllowed()) {
            return;
        }
        int n2 = this.table.getRowCount();
        int n3 = this.table.getColumnCount();
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        int n4 = Math.max(0, Math.min(listSelectionEvent.getFirstIndex() - 1, n2 - 1));
        int n5 = Math.max(0, Math.min(listSelectionEvent.getLastIndex() + 1, n2 - 1));
        Rectangle rectangle = this.table.getCellRect(n4, 0, false);
        Rectangle rectangle2 = this.table.getCellRect(n5, n3 - 1, false);
        this.table.repaint(rectangle.union(rectangle2));
    }

    private void repaintRoundedColumnSelection(ListSelectionEvent listSelectionEvent) {
        if (this.selectionArc <= 0 || !this.table.getColumnSelectionAllowed()) {
            return;
        }
        int n2 = this.table.getRowCount();
        int n3 = this.table.getColumnCount();
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        int n4 = 0;
        int n5 = n2 - 1;
        if (this.table.getRowSelectionAllowed()) {
            n4 = this.table.getSelectionModel().getMinSelectionIndex();
            n5 = this.table.getSelectionModel().getMaxSelectionIndex();
        }
        int n6 = Math.max(0, Math.min(listSelectionEvent.getFirstIndex() - 1, n3 - 1));
        int n7 = Math.max(0, Math.min(listSelectionEvent.getLastIndex() + 1, n3 - 1));
        Rectangle rectangle = this.table.getCellRect(n4, n6, false);
        Rectangle rectangle2 = this.table.getCellRect(n5, n7, false);
        this.table.repaint(rectangle.union(rectangle2));
    }

    private static class StartEditingAction
    extends FlatUIAction {
        static void install(ActionMap actionMap, String string) {
            Action action = actionMap.get(string);
            if (action == null || action instanceof StartEditingAction) {
                return;
            }
            actionMap.put(string, new StartEditingAction(action));
        }

        private StartEditingAction(Action action) {
            super(action);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            Component component = jTable.getEditorComponent();
            this.delegate.actionPerformed(actionEvent);
            Component component2 = jTable.getEditorComponent();
            if (component == null && component2 instanceof JTextField) {
                ((JTextField)component2).selectAll();
            }
        }
    }

    private static class FlatBooleanRenderer
    extends DefaultTableCellRenderer
    implements UIResource {
        private boolean selected;

        FlatBooleanRenderer() {
            this.setHorizontalAlignment(0);
            this.setIcon(new FlatCheckBoxIcon(){

                @Override
                protected boolean isSelected(Component component) {
                    return selected;
                }
            });
        }

        @Override
        protected void setValue(Object object) {
            this.selected = object != null && (Boolean)object != false;
        }
    }

    private static class FlatTablePropertyWatcher
    implements PropertyChangeListener {
        boolean enabled = true;
        boolean showHorizontalLinesChanged;
        boolean showVerticalLinesChanged;
        boolean intercellSpacingChanged;

        private FlatTablePropertyWatcher() {
        }

        static FlatTablePropertyWatcher get(JTable jTable) {
            for (PropertyChangeListener propertyChangeListener : jTable.getPropertyChangeListeners()) {
                if (!(propertyChangeListener instanceof FlatTablePropertyWatcher)) continue;
                return (FlatTablePropertyWatcher)propertyChangeListener;
            }
            return null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.enabled) {
                return;
            }
            switch (propertyChangeEvent.getPropertyName()) {
                case "showHorizontalLines": {
                    this.showHorizontalLinesChanged = true;
                    break;
                }
                case "showVerticalLines": {
                    this.showVerticalLinesChanged = true;
                    break;
                }
                case "rowMargin": {
                    this.intercellSpacingChanged = true;
                }
            }
        }
    }

    private class FlatOutsideAlternateRowsListener
    extends ComponentAdapter {
        private FlatOutsideAlternateRowsListener() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            Container container = SwingUtilities.getUnwrappedParent(FlatTableUI.this.table);
            if (container instanceof JViewport) {
                HiDPIUtils.repaint(container);
            }
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            this.repaintAreaBelowTable();
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            this.repaintAreaBelowTable();
        }

        private void repaintAreaBelowTable() {
            Container container = SwingUtilities.getUnwrappedParent(FlatTableUI.this.table);
            if (container instanceof JViewport) {
                int n2 = container.getHeight();
                int n3 = FlatTableUI.this.table.getHeight();
                if (n3 < n2) {
                    HiDPIUtils.repaint(container, 0, n3, container.getWidth(), n2 - n3);
                }
            }
        }
    }

    private class RoundedSelectionGraphics
    extends Graphics2DProxy {
        private final Color alternateRowColor;
        private boolean inPaintSelection;

        RoundedSelectionGraphics(Graphics graphics, Color color) {
            super((Graphics2D)graphics);
            this.alternateRowColor = color;
        }

        @Override
        public Graphics create() {
            return new RoundedSelectionGraphics(super.create(), this.alternateRowColor);
        }

        @Override
        public Graphics create(int n2, int n3, int n4, int n5) {
            return new RoundedSelectionGraphics(super.create(n2, n3, n4, n5), this.alternateRowColor);
        }

        @Override
        public void fillRect(int n2, int n3, int n4, int n5) {
            if (this.fillCellSelection(n2, n3, n4, n5)) {
                return;
            }
            super.fillRect(n2, n3, n4, n5);
        }

        @Override
        public void fill(Shape shape) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rectangle2D = (Rectangle2D)shape;
                double d2 = rectangle2D.getX();
                double d3 = rectangle2D.getY();
                double d4 = rectangle2D.getWidth();
                double d5 = rectangle2D.getHeight();
                if (d2 == (double)((int)d2) && d3 == (double)((int)d3) && d4 == (double)((int)d4) && d5 == (double)((int)d5) && this.fillCellSelection((int)d2, (int)d3, (int)d4, (int)d5)) {
                    return;
                }
            }
            super.fill(shape);
        }

        private boolean fillCellSelection(int n2, int n3, int n4, int n5) {
            Component component;
            Color color;
            if (this.inPaintSelection) {
                return false;
            }
            if (n2 == 0 && n3 == 0 && ((color = this.getColor()) == FlatTableUI.this.table.getSelectionBackground() || this.alternateRowColor != null && color == this.alternateRowColor) && (component = this.findActiveRendererComponent()) != null && n4 == component.getWidth() && n5 == component.getHeight()) {
                Point point = component.getLocation();
                int n6 = FlatTableUI.this.table.rowAtPoint(point);
                int n7 = FlatTableUI.this.table.columnAtPoint(point);
                if (n6 >= 0 && n7 >= 0) {
                    this.inPaintSelection = true;
                    if (color == FlatTableUI.this.table.getSelectionBackground()) {
                        FlatTableUI.this.paintCellSelection(this, n6, n7, n2, n3, n4, n5);
                    } else {
                        FlatTableUI.this.paintAlternateRowBackground(this, n6, n7, n2, n3, n4, n5);
                    }
                    this.inPaintSelection = false;
                    return true;
                }
            }
            return false;
        }

        private Component findActiveRendererComponent() {
            int n2 = FlatTableUI.this.rendererPane.getComponentCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = FlatTableUI.this.rendererPane.getComponent(i2);
                if (component.getWidth() <= 0 || component.getHeight() <= 0) continue;
                return component;
            }
            return null;
        }
    }
}

