/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatCaret;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextFieldUI;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class FlatTextFieldUI
extends BasicTextFieldUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected int minimumWidth;
    private Color background;
    @FlatStylingSupport.Styleable
    protected Color disabledBackground;
    @FlatStylingSupport.Styleable
    protected Color inactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color placeholderForeground;
    @FlatStylingSupport.Styleable
    protected Color focusedBackground;
    @FlatStylingSupport.Styleable
    protected int iconTextGap;
    @FlatStylingSupport.Styleable
    protected Icon leadingIcon;
    @FlatStylingSupport.Styleable
    protected Icon trailingIcon;
    protected JComponent leadingComponent;
    protected JComponent trailingComponent;
    protected JComponent clearButton;
    @FlatStylingSupport.Styleable
    protected boolean showClearButton;
    private Color oldDisabledBackground;
    private Color oldInactiveBackground;
    private Insets defaultMargin;
    private FocusListener focusListener;
    private DocumentListener documentListener;
    private Map<String, Object> oldStyleValues;
    private AtomicBoolean borderShared;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTextFieldUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        if (FlatUIUtils.needsLightAWTPeer(jComponent)) {
            FlatUIUtils.runWithLightAWTPeerUIDefaults(() -> this.installUIImpl(jComponent));
        } else {
            this.installUIImpl(jComponent);
        }
    }

    private void installUIImpl(JComponent jComponent) {
        super.installUI(jComponent);
        this.leadingIcon = FlatClientProperties.clientProperty(jComponent, "JTextField.leadingIcon", null, Icon.class);
        this.trailingIcon = FlatClientProperties.clientProperty(jComponent, "JTextField.trailingIcon", null, Icon.class);
        this.installLeadingComponent();
        this.installTrailingComponent();
        this.installClearButton();
        this.installStyle();
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallLeadingComponent();
        this.uninstallTrailingComponent();
        this.uninstallClearButton();
        super.uninstallUI(jComponent);
        this.leadingIcon = null;
        this.trailingIcon = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        String string = this.getPropertyPrefix();
        this.minimumWidth = UIManager.getInt("Component.minimumWidth");
        this.background = UIManager.getColor(string + ".background");
        this.disabledBackground = UIManager.getColor(string + ".disabledBackground");
        this.inactiveBackground = UIManager.getColor(string + ".inactiveBackground");
        this.placeholderForeground = UIManager.getColor(string + ".placeholderForeground");
        this.focusedBackground = UIManager.getColor(string + ".focusedBackground");
        this.iconTextGap = FlatUIUtils.getUIInt(string + ".iconTextGap", 4);
        this.defaultMargin = UIManager.getInsets(string + ".margin");
        LookAndFeel.installProperty(this.getComponent(), "opaque", false);
        MigLayoutVisualPadding.install(this.getComponent());
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.background = null;
        this.disabledBackground = null;
        this.inactiveBackground = null;
        this.placeholderForeground = null;
        this.focusedBackground = null;
        this.oldDisabledBackground = null;
        this.oldInactiveBackground = null;
        this.oldStyleValues = null;
        this.borderShared = null;
        MigLayoutVisualPadding.uninstall(this.getComponent());
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.focusListener = new FlatUIUtils.RepaintFocusListener(this.getComponent(), null);
        this.getComponent().addFocusListener(this.focusListener);
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        this.getComponent().removeFocusListener(this.focusListener);
        this.focusListener = null;
        if (this.documentListener != null) {
            this.getComponent().getDocument().removeDocumentListener(this.documentListener);
            this.documentListener = null;
        }
    }

    @Override
    protected Caret createCaret() {
        return new FlatCaret(UIManager.getString("TextComponent.selectAllOnFocusPolicy"), UIManager.getBoolean("TextComponent.selectAllOnMouseClick"));
    }

    @Override
    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("editable".equals(string) || "enabled".equals(string)) {
            this.updateBackground();
        } else {
            super.propertyChange(propertyChangeEvent);
        }
        JTextComponent jTextComponent = this.getComponent();
        switch (propertyChangeEvent.getPropertyName()) {
            case "JTextField.placeholderText": 
            case "JComponent.roundRect": 
            case "JComponent.outline": 
            case "JTextField.padding": {
                HiDPIUtils.repaint(jTextComponent);
                break;
            }
            case "JComponent.minimumWidth": {
                jTextComponent.revalidate();
                break;
            }
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                this.installStyle();
                jTextComponent.revalidate();
                HiDPIUtils.repaint(jTextComponent);
                break;
            }
            case "JTextField.leadingIcon": {
                this.leadingIcon = propertyChangeEvent.getNewValue() instanceof Icon ? (Icon)propertyChangeEvent.getNewValue() : null;
                HiDPIUtils.repaint(jTextComponent);
                break;
            }
            case "JTextField.trailingIcon": {
                this.trailingIcon = propertyChangeEvent.getNewValue() instanceof Icon ? (Icon)propertyChangeEvent.getNewValue() : null;
                HiDPIUtils.repaint(jTextComponent);
                break;
            }
            case "JTextField.leadingComponent": {
                this.uninstallLeadingComponent();
                this.installLeadingComponent();
                jTextComponent.revalidate();
                HiDPIUtils.repaint(jTextComponent);
                break;
            }
            case "JTextField.trailingComponent": {
                this.uninstallTrailingComponent();
                this.installTrailingComponent();
                jTextComponent.revalidate();
                HiDPIUtils.repaint(jTextComponent);
                break;
            }
            case "JTextField.showClearButton": {
                this.uninstallClearButton();
                this.installClearButton();
                jTextComponent.revalidate();
                HiDPIUtils.repaint(jTextComponent);
                break;
            }
            case "enabled": 
            case "editable": {
                this.updateClearButton();
                break;
            }
            case "document": {
                if (this.documentListener == null) break;
                if (propertyChangeEvent.getOldValue() instanceof Document) {
                    ((Document)propertyChangeEvent.getOldValue()).removeDocumentListener(this.documentListener);
                }
                if (propertyChangeEvent.getNewValue() instanceof Document) {
                    ((Document)propertyChangeEvent.getNewValue()).addDocumentListener(this.documentListener);
                }
                this.updateClearButton();
            }
        }
    }

    protected void installDocumentListener() {
        if (this.documentListener != null) {
            return;
        }
        this.documentListener = new FlatDocumentListener();
        this.getComponent().getDocument().addDocumentListener(this.documentListener);
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        if (this.clearButton != null) {
            this.updateClearButton();
        }
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.getComponent(), this.getStyleType()));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    String getStyleType() {
        return "TextField";
    }

    protected void applyStyle(Object object) {
        this.oldDisabledBackground = this.disabledBackground;
        this.oldInactiveBackground = this.inactiveBackground;
        boolean bl2 = this.showClearButton;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        this.updateBackground();
        if (this.showClearButton != bl2) {
            this.uninstallClearButton();
            this.installClearButton();
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        if (this.borderShared == null) {
            this.borderShared = new AtomicBoolean(true);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrBorder(this, string, object, this.getComponent(), this.borderShared);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this, this.getComponent().getBorder());
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, this.getComponent().getBorder(), string);
    }

    private void updateBackground() {
        FlatTextFieldUI.updateBackground(this.getComponent(), this.background, this.disabledBackground, this.inactiveBackground, this.oldDisabledBackground, this.oldInactiveBackground);
    }

    static void updateBackground(JTextComponent jTextComponent, Color color, Color color2, Color color3, Color color4, Color color5) {
        Color color6;
        Color color7 = jTextComponent.getBackground();
        if (!(color7 instanceof UIResource)) {
            return;
        }
        if (color7 != color && color7 != color2 && color7 != color3 && color7 != color4 && color7 != color5) {
            return;
        }
        Color color8 = !jTextComponent.isEnabled() ? color2 : (color6 = !jTextComponent.isEditable() ? color3 : color);
        if (color6 != color7) {
            jTextComponent.setBackground(color6);
        }
    }

    @Override
    protected void paintSafely(Graphics graphics) {
        FlatTextFieldUI.paintBackground(graphics, this.getComponent(), this.focusedBackground);
        this.paintPlaceholder(graphics);
        if (this.hasLeadingIcon() || this.hasTrailingIcon()) {
            this.paintIcons(graphics, new Rectangle(this.getIconsRect()));
        }
        super.paintSafely(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics));
    }

    @Override
    protected void paintBackground(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintBackground(Graphics graphics, JTextComponent jTextComponent, Color color) {
        if (!jTextComponent.isOpaque() && FlatUIUtils.getOutsideFlatBorder(jTextComponent) == null && FlatUIUtils.hasOpaqueBeenExplicitlySet(jTextComponent)) {
            return;
        }
        float f2 = FlatUIUtils.getBorderFocusWidth(jTextComponent);
        float f3 = FlatUIUtils.getBorderArc(jTextComponent);
        if (jTextComponent.isOpaque() && (f2 > 0.0f || f3 > 0.0f)) {
            FlatUIUtils.paintParentBackground(graphics, jTextComponent);
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            graphics2D.setColor(FlatTextFieldUI.getBackground(jTextComponent, color));
            FlatUIUtils.paintComponentBackground(graphics2D, 0, 0, jTextComponent.getWidth(), jTextComponent.getHeight(), f2, f3);
        }
        finally {
            graphics2D.dispose();
        }
    }

    static Color getBackground(JTextComponent jTextComponent, Color color) {
        Color color2 = jTextComponent.getBackground();
        if (!(color2 instanceof UIResource)) {
            return color2;
        }
        if (color != null && FlatUIUtils.isPermanentFocusOwner(jTextComponent)) {
            return color;
        }
        return color2;
    }

    protected void paintPlaceholder(Graphics graphics) {
        int n2;
        JTextComponent jTextComponent = this.getComponent();
        if (jTextComponent.getDocument().getLength() > 0) {
            return;
        }
        Container container = jTextComponent.getParent();
        JComponent jComponent = container instanceof JComboBox ? (JComboBox)container : jTextComponent;
        String string = FlatClientProperties.clientProperty(jComponent, "JTextField.placeholderText", null, String.class);
        if (string == null) {
            return;
        }
        Rectangle rectangle = this.getVisibleEditorRect();
        FontMetrics fontMetrics = jTextComponent.getFontMetrics(jTextComponent.getFont());
        int n3 = rectangle.x;
        int n4 = rectangle.y + fontMetrics.getAscent() + (rectangle.height - fontMetrics.getHeight()) / 2;
        String string2 = JavaCompatibility.getClippedString(jTextComponent, fontMetrics, string, rectangle.width);
        int n5 = fontMetrics.stringWidth(string2);
        int n6 = n2 = jTextComponent instanceof JTextField ? ((JTextField)jTextComponent).getHorizontalAlignment() : 10;
        if (n2 == 10) {
            n2 = this.isLeftToRight() ? 2 : 4;
        } else if (n2 == 11) {
            int n7 = n2 = this.isLeftToRight() ? 4 : 2;
        }
        if (n2 == 4) {
            n3 += rectangle.width - n5;
        } else if (n2 == 0) {
            n3 = Math.max(0, n3 + rectangle.width / 2 - n5 / 2);
        }
        graphics.setColor(this.placeholderForeground);
        FlatUIUtils.drawString(jTextComponent, graphics, string2, n3, n4);
    }

    protected void paintIcons(Graphics graphics, Rectangle rectangle) {
        int n2;
        int n3;
        int n4;
        Icon icon;
        boolean bl2 = this.isLeftToRight();
        Icon icon2 = bl2 ? this.leadingIcon : this.trailingIcon;
        Icon icon3 = icon = bl2 ? this.trailingIcon : this.leadingIcon;
        if (icon2 != null) {
            n4 = rectangle.x;
            n3 = rectangle.y + Math.round((float)(rectangle.height - icon2.getIconHeight()) / 2.0f);
            icon2.paintIcon(this.getComponent(), graphics, n4, n3);
            n2 = icon2.getIconWidth() + UIScale.scale(this.iconTextGap);
            rectangle.x += n2;
            rectangle.width -= n2;
        }
        if (icon != null) {
            n4 = icon.getIconWidth();
            n3 = rectangle.x + rectangle.width - n4;
            n2 = rectangle.y + Math.round((float)(rectangle.height - icon.getIconHeight()) / 2.0f);
            icon.paintIcon(this.getComponent(), graphics, n3, n2);
            rectangle.width -= n4 + UIScale.scale(this.iconTextGap);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        return this.applyMinimumWidth(jComponent, this.applyExtraSize(super.getPreferredSize(jComponent)), this.minimumWidth);
    }

    @Override
    public Dimension getMinimumSize(JComponent jComponent) {
        return this.applyMinimumWidth(jComponent, this.applyExtraSize(super.getMinimumSize(jComponent)), this.minimumWidth);
    }

    private Dimension applyExtraSize(Dimension dimension) {
        dimension.width += this.getLeadingIconWidth() + this.getTrailingIconWidth();
        for (JComponent jComponent : this.getLeadingComponents()) {
            if (jComponent == null || !jComponent.isVisible()) continue;
            dimension.width += jComponent.getPreferredSize().width;
        }
        for (JComponent jComponent : this.getTrailingComponents()) {
            if (jComponent == null || !jComponent.isVisible()) continue;
            dimension.width += jComponent.getPreferredSize().width;
        }
        return dimension;
    }

    private Dimension applyMinimumWidth(JComponent jComponent, Dimension dimension, int n2) {
        if (jComponent instanceof JTextField && ((JTextField)jComponent).getColumns() > 0) {
            return dimension;
        }
        if (!FlatTextFieldUI.hasDefaultMargins(jComponent, this.defaultMargin)) {
            return dimension;
        }
        Container container = jComponent.getParent();
        if (container instanceof JComboBox || container instanceof JSpinner || container != null && container.getParent() instanceof JSpinner) {
            return dimension;
        }
        n2 = FlatUIUtils.minimumWidth(jComponent, n2);
        float f2 = FlatUIUtils.getBorderFocusWidth(jComponent);
        dimension.width = Math.max(dimension.width, UIScale.scale(n2) + Math.round(f2 * 2.0f));
        return dimension;
    }

    static boolean hasDefaultMargins(JComponent jComponent, Insets insets) {
        Insets insets2 = ((JTextComponent)jComponent).getMargin();
        return insets2 instanceof UIResource && Objects.equals(insets2, insets);
    }

    @Override
    protected Rectangle getVisibleEditorRect() {
        Insets insets;
        Rectangle rectangle = this.getIconsRect();
        if (rectangle == null) {
            return null;
        }
        int n2 = this.getLeadingIconWidth();
        int n3 = this.getTrailingIconWidth();
        if (n2 != 0 || n3 != 0) {
            boolean bl2 = this.isLeftToRight();
            int n4 = bl2 ? n2 : n3;
            int n5 = bl2 ? n3 : n2;
            rectangle.x += n4;
            rectangle.width -= n4 + n5;
        }
        if ((insets = this.getPadding()) != null) {
            rectangle = FlatUIUtils.subtractInsets(rectangle, insets);
        }
        rectangle.width = Math.max(rectangle.width, 0);
        rectangle.height = Math.max(rectangle.height, 0);
        return rectangle;
    }

    protected Rectangle getIconsRect() {
        int n2;
        Rectangle rectangle = super.getVisibleEditorRect();
        if (rectangle == null) {
            return null;
        }
        boolean bl2 = this.isLeftToRight();
        JComponent[] jComponentArray = bl2 ? this.getLeadingComponents() : this.getTrailingComponents();
        JComponent[] jComponentArray2 = bl2 ? this.getTrailingComponents() : this.getLeadingComponents();
        boolean bl3 = false;
        boolean bl4 = false;
        for (JComponent jComponent : jComponentArray) {
            if (jComponent == null || !jComponent.isVisible()) continue;
            int n3 = jComponent.getPreferredSize().width;
            rectangle.x += n3;
            rectangle.width -= n3;
            bl3 = true;
        }
        for (JComponent jComponent : jComponentArray2) {
            if (jComponent == null || !jComponent.isVisible()) continue;
            rectangle.width -= jComponent.getPreferredSize().width;
            bl4 = true;
        }
        if (bl3 || (bl2 ? this.hasLeadingIcon() : this.hasTrailingIcon())) {
            Insets insets = this.getComponent().getMargin();
            n2 = Math.min(insets.left, insets.top);
            if (n2 < insets.left) {
                int n4 = UIScale.scale(insets.left - n2);
                rectangle.x -= n4;
                rectangle.width += n4;
            }
        }
        if (bl4 || (bl2 ? this.hasTrailingIcon() : this.hasLeadingIcon())) {
            Insets insets = this.getComponent().getMargin();
            n2 = Math.min(insets.right, insets.top);
            if (n2 < insets.left) {
                rectangle.width += UIScale.scale(insets.right - n2);
            }
        }
        rectangle.width = Math.max(rectangle.width, 0);
        rectangle.height = Math.max(rectangle.height, 0);
        return rectangle;
    }

    protected boolean hasLeadingIcon() {
        return this.leadingIcon != null;
    }

    protected boolean hasTrailingIcon() {
        return this.trailingIcon != null;
    }

    protected int getLeadingIconWidth() {
        return this.leadingIcon != null ? this.leadingIcon.getIconWidth() + UIScale.scale(this.iconTextGap) : 0;
    }

    protected int getTrailingIconWidth() {
        return this.trailingIcon != null ? this.trailingIcon.getIconWidth() + UIScale.scale(this.iconTextGap) : 0;
    }

    boolean isLeftToRight() {
        return this.getComponent().getComponentOrientation().isLeftToRight();
    }

    protected Insets getPadding() {
        return UIScale.scale(FlatClientProperties.clientProperty(this.getComponent(), "JTextField.padding", null, Insets.class));
    }

    protected void scrollCaretToVisible() {
        Caret caret = this.getComponent().getCaret();
        if (caret instanceof FlatCaret) {
            ((FlatCaret)caret).scrollCaretToVisible();
        }
    }

    protected void installLeadingComponent() {
        JTextComponent jTextComponent = this.getComponent();
        this.leadingComponent = FlatClientProperties.clientProperty(jTextComponent, "JTextField.leadingComponent", null, JComponent.class);
        if (this.leadingComponent != null) {
            this.prepareLeadingOrTrailingComponent(this.leadingComponent);
            this.installLayout();
            jTextComponent.add(this.leadingComponent);
        }
    }

    protected void installTrailingComponent() {
        JTextComponent jTextComponent = this.getComponent();
        this.trailingComponent = FlatClientProperties.clientProperty(jTextComponent, "JTextField.trailingComponent", null, JComponent.class);
        if (this.trailingComponent != null) {
            this.prepareLeadingOrTrailingComponent(this.trailingComponent);
            this.installLayout();
            jTextComponent.add(this.trailingComponent);
        }
    }

    protected void uninstallLeadingComponent() {
        if (this.leadingComponent != null) {
            this.getComponent().remove(this.leadingComponent);
            this.leadingComponent = null;
        }
    }

    protected void uninstallTrailingComponent() {
        if (this.trailingComponent != null) {
            this.getComponent().remove(this.trailingComponent);
            this.trailingComponent = null;
        }
    }

    protected void installClearButton() {
        JTextComponent jTextComponent = this.getComponent();
        if (FlatClientProperties.clientPropertyBoolean(jTextComponent, "JTextField.showClearButton", this.showClearButton)) {
            this.clearButton = this.createClearButton();
            this.updateClearButton();
            this.installDocumentListener();
            this.installLayout();
            jTextComponent.add(this.clearButton);
        }
    }

    protected void uninstallClearButton() {
        if (this.clearButton != null) {
            this.getComponent().remove(this.clearButton);
            this.clearButton = null;
        }
    }

    protected JComponent createClearButton() {
        JButton jButton = new JButton();
        jButton.setName("TextField.clearButton");
        jButton.putClientProperty("FlatLaf.styleClass", "clearButton");
        jButton.putClientProperty("JButton.buttonType", "toolBarButton");
        jButton.setCursor(Cursor.getDefaultCursor());
        jButton.addActionListener(actionEvent -> this.clearButtonClicked());
        return jButton;
    }

    protected void clearButtonClicked() {
        JTextComponent jTextComponent = this.getComponent();
        Object object = jTextComponent.getClientProperty("JTextField.clearCallback");
        if (object instanceof Runnable) {
            ((Runnable)object).run();
        } else if (object instanceof Consumer) {
            ((Consumer)object).accept(jTextComponent);
        } else {
            jTextComponent.setText("");
        }
    }

    protected void updateClearButton() {
        boolean bl2;
        if (this.clearButton == null) {
            return;
        }
        JTextComponent jTextComponent = this.getComponent();
        boolean bl3 = bl2 = jTextComponent.isEnabled() && jTextComponent.isEditable() && jTextComponent.getDocument().getLength() > 0;
        if (bl2 != this.clearButton.isVisible()) {
            this.clearButton.setVisible(bl2);
            jTextComponent.revalidate();
            HiDPIUtils.repaint(jTextComponent);
        }
    }

    protected JComponent[] getLeadingComponents() {
        return new JComponent[]{this.leadingComponent};
    }

    protected JComponent[] getTrailingComponents() {
        return new JComponent[]{this.trailingComponent, this.clearButton};
    }

    protected void prepareLeadingOrTrailingComponent(JComponent jComponent) {
        jComponent.putClientProperty("FlatLaf.styleClass", "inTextField");
        if (jComponent instanceof JButton || jComponent instanceof JToggleButton) {
            jComponent.putClientProperty("JButton.buttonType", "toolBarButton");
            if (!jComponent.isCursorSet()) {
                jComponent.setCursor(Cursor.getDefaultCursor());
            }
        } else if (jComponent instanceof JToolBar) {
            for (Component component : jComponent.getComponents()) {
                if (!(component instanceof JComponent)) continue;
                ((JComponent)component).putClientProperty("FlatLaf.styleClass", "inTextField");
            }
            if (!jComponent.isCursorSet()) {
                jComponent.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected void installLayout() {
        JTextComponent jTextComponent = this.getComponent();
        LayoutManager layoutManager = jTextComponent.getLayout();
        if (!(layoutManager instanceof FlatTextFieldLayout)) {
            jTextComponent.setLayout(new FlatTextFieldLayout(layoutManager));
        }
    }

    private class FlatDocumentListener
    implements DocumentListener {
        private FlatDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            FlatTextFieldUI.this.documentChanged(documentEvent);
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            FlatTextFieldUI.this.documentChanged(documentEvent);
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
            FlatTextFieldUI.this.documentChanged(documentEvent);
        }
    }

    private class FlatTextFieldLayout
    implements LayoutManager2,
    UIResource {
        private final LayoutManager delegate;

        FlatTextFieldLayout(LayoutManager layoutManager) {
            this.delegate = layoutManager;
        }

        @Override
        public void addLayoutComponent(String string, Component component) {
            if (this.delegate != null) {
                this.delegate.addLayoutComponent(string, component);
            }
        }

        @Override
        public void removeLayoutComponent(Component component) {
            if (this.delegate != null) {
                this.delegate.removeLayoutComponent(component);
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container container) {
            return this.delegate != null ? this.delegate.preferredLayoutSize(container) : null;
        }

        @Override
        public Dimension minimumLayoutSize(Container container) {
            return this.delegate != null ? this.delegate.minimumLayoutSize(container) : null;
        }

        @Override
        public void layoutContainer(Container container) {
            int n2;
            if (this.delegate != null) {
                this.delegate.layoutContainer(container);
            }
            int n3 = FlatUIUtils.getBorderFocusAndLineWidth(FlatTextFieldUI.this.getComponent());
            int n4 = container.getHeight() - n3 - n3;
            boolean bl2 = FlatTextFieldUI.this.isLeftToRight();
            JComponent[] jComponentArray = bl2 ? FlatTextFieldUI.this.getLeadingComponents() : FlatTextFieldUI.this.getTrailingComponents();
            JComponent[] jComponentArray2 = bl2 ? FlatTextFieldUI.this.getTrailingComponents() : FlatTextFieldUI.this.getLeadingComponents();
            int n5 = n3;
            for (JComponent jComponent : jComponentArray) {
                if (jComponent == null || !jComponent.isVisible()) continue;
                n2 = jComponent.getPreferredSize().width;
                jComponent.setBounds(n5, n3, n2, n4);
                n5 += n2;
            }
            n5 = container.getWidth() - n3;
            for (JComponent jComponent : jComponentArray2) {
                if (jComponent == null || !jComponent.isVisible()) continue;
                n2 = jComponent.getPreferredSize().width;
                jComponent.setBounds(n5 -= n2, n3, n2, n4);
            }
        }

        @Override
        public void addLayoutComponent(Component component, Object object) {
            if (this.delegate instanceof LayoutManager2) {
                ((LayoutManager2)this.delegate).addLayoutComponent(component, object);
            }
        }

        @Override
        public Dimension maximumLayoutSize(Container container) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).maximumLayoutSize(container) : null;
        }

        @Override
        public float getLayoutAlignmentX(Container container) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).getLayoutAlignmentX(container) : 0.5f;
        }

        @Override
        public float getLayoutAlignmentY(Container container) {
            return this.delegate instanceof LayoutManager2 ? ((LayoutManager2)this.delegate).getLayoutAlignmentY(container) : 0.5f;
        }

        @Override
        public void invalidateLayout(Container container) {
            if (this.delegate instanceof LayoutManager2) {
                ((LayoutManager2)this.delegate).invalidateLayout(container);
            }
        }
    }
}

