/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatButtonUI;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.MigLayoutVisualPadding;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class FlatToggleButtonUI
extends FlatButtonUI {
    @FlatStylingSupport.Styleable(dot=true)
    protected int tabUnderlineHeight;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabUnderlineColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabDisabledUnderlineColor;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabSelectedBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabSelectedForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabHoverBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabHoverForeground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabFocusBackground;
    @FlatStylingSupport.Styleable(dot=true)
    protected Color tabFocusForeground;
    private boolean defaults_initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.canUseSharedUI(jComponent) ? FlatUIUtils.createSharedUI(FlatToggleButtonUI.class, () -> new FlatToggleButtonUI(true)) : new FlatToggleButtonUI(false);
    }

    protected FlatToggleButtonUI(boolean bl2) {
        super(bl2);
    }

    @Override
    String getStyleType() {
        return "ToggleButton";
    }

    @Override
    protected String getPropertyPrefix() {
        return "ToggleButton.";
    }

    @Override
    protected void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.defaults_initialized) {
            this.tabUnderlineHeight = UIManager.getInt("ToggleButton.tab.underlineHeight");
            this.tabUnderlineColor = UIManager.getColor("ToggleButton.tab.underlineColor");
            this.tabDisabledUnderlineColor = UIManager.getColor("ToggleButton.tab.disabledUnderlineColor");
            this.tabSelectedBackground = UIManager.getColor("ToggleButton.tab.selectedBackground");
            this.tabSelectedForeground = UIManager.getColor("ToggleButton.tab.selectedForeground");
            this.tabHoverBackground = UIManager.getColor("ToggleButton.tab.hoverBackground");
            this.tabHoverForeground = UIManager.getColor("ToggleButton.tab.hoverForeground");
            this.tabFocusBackground = UIManager.getColor("ToggleButton.tab.focusBackground");
            this.tabFocusForeground = UIManager.getColor("ToggleButton.tab.focusForeground");
            this.defaults_initialized = true;
        }
    }

    @Override
    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.defaults_initialized = false;
    }

    @Override
    protected void propertyChange(AbstractButton abstractButton, PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(abstractButton, propertyChangeEvent);
        switch (propertyChangeEvent.getPropertyName()) {
            case "JButton.buttonType": {
                if ("tab".equals(propertyChangeEvent.getOldValue()) || "tab".equals(propertyChangeEvent.getNewValue())) {
                    MigLayoutVisualPadding.uninstall(abstractButton);
                    MigLayoutVisualPadding.install(abstractButton);
                    abstractButton.revalidate();
                }
                HiDPIUtils.repaint(abstractButton);
                break;
            }
            case "JToggleButton.tab.underlinePlacement": 
            case "JToggleButton.tab.underlineHeight": 
            case "JToggleButton.tab.underlineColor": 
            case "JToggleButton.tab.selectedBackground": {
                HiDPIUtils.repaint(abstractButton);
            }
        }
    }

    @Override
    protected Object applyStyleProperty(AbstractButton abstractButton, String string, Object object) {
        if (string.startsWith("help.")) {
            throw new FlatStylingSupport.UnknownStyleException(string);
        }
        return super.applyStyleProperty(abstractButton, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        Map<String, Class<?>> map = super.getStyleableInfos(jComponent);
        map.keySet().removeIf(string -> string.startsWith("help."));
        return map;
    }

    static boolean isTabButton(Component component) {
        return component instanceof JToggleButton && "tab".equals(FlatToggleButtonUI.getButtonTypeStr((JToggleButton)component));
    }

    @Override
    protected void paintBackground(Graphics graphics, JComponent jComponent) {
        if (FlatToggleButtonUI.isTabButton(jComponent)) {
            Color color;
            Color color2;
            int n2 = jComponent.getHeight();
            int n3 = jComponent.getWidth();
            boolean bl2 = ((AbstractButton)jComponent).isSelected();
            Color color3 = color2 = bl2 ? FlatClientProperties.clientPropertyColor(jComponent, "JToggleButton.tab.selectedBackground", this.tabSelectedBackground) : null;
            if (color2 == null && this.isCustomBackground(color = jComponent.getBackground())) {
                color2 = color;
            }
            if ((color = FlatToggleButtonUI.buttonStateColor(jComponent, color2, null, this.tabFocusBackground, this.tabHoverBackground, null)) != null) {
                graphics.setColor(color);
                graphics.fillRect(0, 0, n3, n2);
            }
            if (bl2) {
                int n4 = UIScale.scale(FlatClientProperties.clientPropertyInt(jComponent, "JToggleButton.tab.underlineHeight", this.tabUnderlineHeight));
                graphics.setColor(jComponent.isEnabled() ? FlatClientProperties.clientPropertyColor(jComponent, "JToggleButton.tab.underlineColor", this.tabUnderlineColor) : this.tabDisabledUnderlineColor);
                int n5 = FlatClientProperties.clientPropertyInt(jComponent, "JToggleButton.tab.underlinePlacement", 3);
                switch (n5) {
                    case 1: {
                        graphics.fillRect(0, 0, n3, n4);
                        break;
                    }
                    case 2: {
                        graphics.fillRect(0, 0, n4, n2);
                        break;
                    }
                    case 4: {
                        graphics.fillRect(n3 - n4, 0, n4, n2);
                        break;
                    }
                    default: {
                        graphics.fillRect(0, n2 - n4, n3, n4);
                    }
                }
            }
        } else {
            super.paintBackground(graphics, jComponent);
        }
    }

    @Override
    protected Color getForeground(JComponent jComponent) {
        if (FlatToggleButtonUI.isTabButton(jComponent)) {
            if (!jComponent.isEnabled()) {
                return this.disabledText;
            }
            if (this.tabSelectedForeground != null && ((AbstractButton)jComponent).isSelected()) {
                return this.tabSelectedForeground;
            }
            return FlatToggleButtonUI.buttonStateColor(jComponent, jComponent.getForeground(), this.disabledText, this.tabFocusForeground, this.tabHoverForeground, null);
        }
        return super.getForeground(jComponent);
    }
}

