/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatMarginBorder;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.function.Function;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ToolBarUI;

public class FlatToolBarBorder
extends FlatMarginBorder {
    private static final int DOT_COUNT = 4;
    private static final int DOT_SIZE = 2;
    private static final int GRIP_SIZE = 6;
    protected Color gripColor = UIManager.getColor("ToolBar.gripColor");

    public FlatToolBarBorder() {
        super(UIManager.getInsets("ToolBar.borderMargins"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        if (component instanceof JToolBar && ((JToolBar)component).isFloatable()) {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            try {
                FlatUIUtils.setRenderingHints(graphics2D);
                Color color = FlatToolBarBorder.getStyleFromToolBarUI(component, flatToolBarUI -> flatToolBarUI.gripColor);
                graphics2D.setColor(color != null ? color : this.gripColor);
                this.paintGrip(component, graphics2D, n2, n3, n4, n5);
            }
            finally {
                graphics2D.dispose();
            }
        }
    }

    protected void paintGrip(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.calculateGripBounds(component, n2, n3, n4, n5);
        FlatUIUtils.paintGrip(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height, ((JToolBar)component).getOrientation() == 1, 4, 2, 2, false);
    }

    protected Rectangle calculateGripBounds(Component component, int n2, int n3, int n4, int n5) {
        Insets insets = super.getBorderInsets(component, new Insets(0, 0, 0, 0));
        Rectangle rectangle = FlatUIUtils.subtractInsets(new Rectangle(n2, n3, n4, n5), insets);
        int n6 = UIScale.scale(6);
        if (((JToolBar)component).getOrientation() == 0) {
            if (!component.getComponentOrientation().isLeftToRight()) {
                rectangle.x = rectangle.x + rectangle.width - n6;
            }
            rectangle.width = n6;
        } else {
            rectangle.height = n6;
        }
        return rectangle;
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        int n2;
        Insets insets2 = FlatToolBarBorder.getStyleFromToolBarUI(component, flatToolBarUI -> flatToolBarUI.borderMargins);
        if (insets2 != null) {
            n2 = this.top;
            int n3 = this.left;
            int n4 = this.bottom;
            int n5 = this.right;
            this.top = insets2.top;
            this.left = insets2.left;
            this.bottom = insets2.bottom;
            this.right = insets2.right;
            insets = super.getBorderInsets(component, insets);
            this.top = n2;
            this.left = n3;
            this.bottom = n4;
            this.right = n5;
        } else {
            insets = super.getBorderInsets(component, insets);
        }
        if (component instanceof JToolBar && ((JToolBar)component).isFloatable()) {
            n2 = UIScale.scale(6);
            if (((JToolBar)component).getOrientation() == 0) {
                if (component.getComponentOrientation().isLeftToRight()) {
                    insets.left += n2;
                } else {
                    insets.right += n2;
                }
            } else {
                insets.top += n2;
            }
        }
        return insets;
    }

    static <T> T getStyleFromToolBarUI(Component component, Function<FlatToolBarUI, T> function) {
        ToolBarUI toolBarUI;
        if (component instanceof JToolBar && (toolBarUI = ((JToolBar)component).getUI()) instanceof FlatToolBarUI) {
            return function.apply((FlatToolBarUI)toolBarUI);
        }
        return null;
    }
}

