/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatToolBarUI;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarSeparatorUI;

public class FlatToolBarSeparatorUI
extends BasicToolBarSeparatorUI
implements FlatStylingSupport.StyleableUI,
PropertyChangeListener {
    private static final int LINE_WIDTH = 1;
    @FlatStylingSupport.Styleable
    protected int separatorWidth;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    private final boolean shared;
    private boolean defaults_initialized = false;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.canUseSharedUI(jComponent) ? FlatUIUtils.createSharedUI(FlatToolBarSeparatorUI.class, () -> new FlatToolBarSeparatorUI(true)) : new FlatToolBarSeparatorUI(false);
    }

    protected FlatToolBarSeparatorUI(boolean bl2) {
        this.shared = bl2;
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle((JSeparator)jComponent);
    }

    @Override
    protected void installDefaults(JSeparator jSeparator) {
        super.installDefaults(jSeparator);
        if (!this.defaults_initialized) {
            this.separatorWidth = UIManager.getInt("ToolBar.separatorWidth");
            this.separatorColor = UIManager.getColor("ToolBar.separatorColor");
            this.defaults_initialized = true;
        }
        jSeparator.setAlignmentX(0.0f);
    }

    @Override
    protected void uninstallDefaults(JSeparator jSeparator) {
        super.uninstallDefaults(jSeparator);
        this.defaults_initialized = false;
        this.oldStyleValues = null;
    }

    @Override
    protected void installListeners(JSeparator jSeparator) {
        super.installListeners(jSeparator);
        jSeparator.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JSeparator jSeparator) {
        super.uninstallListeners(jSeparator);
        jSeparator.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        switch (propertyChangeEvent.getPropertyName()) {
            case "FlatLaf.style": 
            case "FlatLaf.styleClass": {
                JSeparator jSeparator = (JSeparator)propertyChangeEvent.getSource();
                if (this.shared && FlatStylingSupport.hasStyleProperty(jSeparator)) {
                    jSeparator.updateUI();
                } else {
                    this.installStyle(jSeparator);
                }
                jSeparator.revalidate();
                HiDPIUtils.repaint(jSeparator);
            }
        }
    }

    protected void installStyle(JSeparator jSeparator) {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(jSeparator, "ToolBarSeparator"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObject(this, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = ((JToolBar.Separator)jComponent).getSeparatorSize();
        if (dimension != null) {
            return UIScale.scale(dimension);
        }
        int n2 = this.separatorWidth;
        FlatToolBarUI flatToolBarUI = this.getToolBarUI(jComponent);
        if (flatToolBarUI != null && flatToolBarUI.separatorWidth != null) {
            n2 = flatToolBarUI.separatorWidth;
        }
        int n3 = UIScale.scale((n2 - 1) / 2) * 2 + UIScale.scale(1);
        boolean bl2 = this.isVertical(jComponent);
        return new Dimension(bl2 ? n3 : 0, bl2 ? 0 : n3);
    }

    @Override
    public Dimension getMaximumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredSize(jComponent);
        if (this.isVertical(jComponent)) {
            return new Dimension(dimension.width, Short.MAX_VALUE);
        }
        return new Dimension(Short.MAX_VALUE, dimension.height);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        float f2 = UIScale.scale(1.0f);
        float f3 = UIScale.scale(2.0f);
        Color color = this.separatorColor;
        FlatToolBarUI flatToolBarUI = this.getToolBarUI(jComponent);
        if (flatToolBarUI != null && flatToolBarUI.separatorColor != null) {
            color = flatToolBarUI.separatorColor;
        }
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        graphics.setColor(color);
        if (this.isVertical(jComponent)) {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(Math.round(((float)n2 - f2) / 2.0f), f3, f2, (float)n3 - f3 * 2.0f));
        } else {
            ((Graphics2D)graphics).fill(new Rectangle2D.Float(f3, Math.round(((float)n3 - f2) / 2.0f), (float)n2 - f3 * 2.0f, f2));
        }
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    private boolean isVertical(JComponent jComponent) {
        return ((JToolBar.Separator)jComponent).getOrientation() == 1;
    }

    private FlatToolBarUI getToolBarUI(JComponent jComponent) {
        Container container = jComponent.getParent();
        return container instanceof JToolBar && ((JToolBar)container).getUI() instanceof FlatToolBarUI ? (FlatToolBarUI)((JToolBar)container).getUI() : null;
    }
}

