/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatTitlePane;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolBarUI;

public class FlatToolBarUI
extends BasicToolBarUI
implements FlatStylingSupport.StyleableUI,
FlatTitlePane.TitleBarCaptionHitTest {
    @FlatStylingSupport.Styleable
    protected boolean focusableButtons;
    @FlatStylingSupport.Styleable
    protected boolean arrowKeysOnlyNavigation;
    @FlatStylingSupport.Styleable
    protected int hoverButtonGroupArc;
    @FlatStylingSupport.Styleable
    protected Color hoverButtonGroupBackground;
    @FlatStylingSupport.Styleable
    protected Insets borderMargins;
    @FlatStylingSupport.Styleable
    protected Color gripColor;
    @FlatStylingSupport.Styleable
    protected Integer separatorWidth;
    @FlatStylingSupport.Styleable
    protected Color separatorColor;
    private FocusTraversalPolicy focusTraversalPolicy;
    private Boolean oldFloatable;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatToolBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installFocusTraversalPolicy();
        this.installStyle();
        if (!this.focusableButtons) {
            this.setButtonsFocusable(false);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        if (!this.focusableButtons) {
            this.setButtonsFocusable(true);
        }
        this.uninstallFocusTraversalPolicy();
        this.oldStyleValues = null;
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.focusableButtons = UIManager.getBoolean("ToolBar.focusableButtons");
        this.arrowKeysOnlyNavigation = UIManager.getBoolean("ToolBar.arrowKeysOnlyNavigation");
        this.hoverButtonGroupArc = UIManager.getInt("ToolBar.hoverButtonGroupArc");
        this.hoverButtonGroupBackground = UIManager.getColor("ToolBar.hoverButtonGroupBackground");
        if (!UIManager.getBoolean("ToolBar.floatable")) {
            this.oldFloatable = this.toolBar.isFloatable();
            this.toolBar.setFloatable(false);
        } else {
            this.oldFloatable = null;
        }
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        this.hoverButtonGroupBackground = null;
        if (this.oldFloatable != null) {
            this.toolBar.setFloatable(this.oldFloatable);
            this.oldFloatable = null;
        }
    }

    @Override
    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        RootPaneContainer rootPaneContainer = super.createFloatingWindow(jToolBar);
        rootPaneContainer.getRootPane().putClientProperty("Window.style", "small");
        return rootPaneContainer;
    }

    @Override
    protected ContainerListener createToolBarContListener() {
        return new BasicToolBarUI.ToolBarContListener(){

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                super.componentAdded(containerEvent);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(containerEvent.getChild(), false);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                super.componentRemoved(containerEvent);
                if (!FlatToolBarUI.this.focusableButtons) {
                    FlatToolBarUI.this.setButtonFocusable(containerEvent.getChild(), true);
                }
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyListener() {
        return FlatStylingSupport.createPropertyChangeListener(this.toolBar, this::installStyle, super.createPropertyListener());
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.toolBar, "ToolBar"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        boolean bl2 = this.focusableButtons;
        boolean bl3 = this.arrowKeysOnlyNavigation;
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
        if (this.focusableButtons != bl2) {
            this.setButtonsFocusable(this.focusableButtons);
        }
        if (this.arrowKeysOnlyNavigation != bl3 || this.focusableButtons != bl2) {
            if (this.arrowKeysOnlyNavigation) {
                this.installFocusTraversalPolicy();
            } else {
                this.uninstallFocusTraversalPolicy();
            }
        }
    }

    protected Object applyStyleProperty(String string, Object object) {
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.toolBar, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    protected void setButtonsFocusable(boolean bl2) {
        for (Component component : this.toolBar.getComponents()) {
            this.setButtonFocusable(component, bl2);
        }
    }

    private void setButtonFocusable(Component component, boolean bl2) {
        if (component instanceof AbstractButton && bl2 != component.isFocusable()) {
            component.setFocusable(bl2);
        }
    }

    protected void installFocusTraversalPolicy() {
        if (!this.arrowKeysOnlyNavigation || !this.focusableButtons || this.toolBar.getFocusTraversalPolicy() != null) {
            return;
        }
        this.focusTraversalPolicy = this.createFocusTraversalPolicy();
        if (this.focusTraversalPolicy != null) {
            this.toolBar.setFocusTraversalPolicy(this.focusTraversalPolicy);
            this.toolBar.setFocusTraversalPolicyProvider(true);
        }
    }

    protected void uninstallFocusTraversalPolicy() {
        if (this.focusTraversalPolicy != null && this.toolBar.getFocusTraversalPolicy() == this.focusTraversalPolicy) {
            this.toolBar.setFocusTraversalPolicy(null);
            this.toolBar.setFocusTraversalPolicyProvider(false);
        }
        this.focusTraversalPolicy = null;
    }

    protected FocusTraversalPolicy createFocusTraversalPolicy() {
        return new FlatToolBarFocusTraversalPolicy();
    }

    @Override
    protected void navigateFocusedComp(int n2) {
        block9: {
            Component component;
            int n3;
            int n4 = this.toolBar.getComponentCount();
            if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n4) {
                return;
            }
            switch (n2) {
                case 3: 
                case 5: {
                    n3 = 1;
                    break;
                }
                case 1: 
                case 7: {
                    n3 = -1;
                    break;
                }
                default: {
                    return;
                }
            }
            int n5 = this.focusedCompIndex;
            do {
                if ((n5 += n3) < 0) {
                    n5 = n4 - 1;
                } else if (n5 >= n4) {
                    n5 = 0;
                }
                if (n5 == this.focusedCompIndex) break block9;
            } while (!FlatToolBarUI.canBeFocusOwner(component = this.toolBar.getComponentAtIndex(n5)));
            component.requestFocus();
            return;
        }
    }

    private static boolean canBeFocusOwner(Component component) {
        if (!(component != null && component.isEnabled() && component.isVisible() && component.isDisplayable() && component.isFocusable())) {
            return false;
        }
        if (component instanceof JComboBox) {
            JComboBox jComboBox = (JComboBox)component;
            return jComboBox.getUI().isFocusTraversable(jComboBox);
        }
        if (component instanceof JComponent) {
            InputMap inputMap;
            for (inputMap = ((JComponent)component).getInputMap(0); inputMap != null && inputMap.size() == 0; inputMap = inputMap.getParent()) {
            }
            if (inputMap == null) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected void setBorderToRollover(Component component) {
    }

    @Override
    protected void setBorderToNonRollover(Component component) {
    }

    @Override
    protected void setBorderToNormal(Component component) {
    }

    @Override
    protected void installRolloverBorders(JComponent jComponent) {
    }

    @Override
    protected void installNonRolloverBorders(JComponent jComponent) {
    }

    @Override
    protected void installNormalBorders(JComponent jComponent) {
    }

    @Override
    protected Border createRolloverBorder() {
        return null;
    }

    @Override
    protected Border createNonRolloverBorder() {
        return null;
    }

    @Override
    public void setOrientation(int n2) {
        Insets insets;
        Insets insets2;
        if (n2 != this.toolBar.getOrientation() && !(insets2 = new Insets(insets.left, insets.top, insets.right, insets.bottom)).equals(insets = this.toolBar.getMargin())) {
            this.toolBar.setMargin(insets2);
        }
        super.setOrientation(n2);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        super.paint(graphics, jComponent);
        this.paintButtonGroup(graphics);
    }

    protected void paintButtonGroup(Graphics graphics) {
        Object[] objectArray;
        boolean bl2;
        if (this.hoverButtonGroupBackground == null) {
            return;
        }
        ButtonGroup buttonGroup = null;
        Object object = this.toolBar.getComponents();
        boolean bl3 = ((Component[])object).length;
        for (bl2 = false; !(bl2 >= bl3 || (objectArray = object[bl2]) instanceof AbstractButton && ((AbstractButton)objectArray).getModel().isRollover() && (buttonGroup = this.getButtonGroup((AbstractButton)objectArray)) != null); bl2 += 1) {
        }
        if (buttonGroup == null) {
            return;
        }
        object = new ArrayList();
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton = enumeration.nextElement();
            if (abstractButton.getParent() != this.toolBar) continue;
            ((ArrayList)object).add(abstractButton.getBounds());
        }
        bl2 = this.toolBar.getOrientation() == 0;
        ((ArrayList)object).sort((rectangle, rectangle2) -> bl2 ? rectangle.x - rectangle2.x : rectangle.y - rectangle2.y);
        objectArray = FlatUIUtils.setRenderingHints(graphics);
        graphics.setColor(FlatUIUtils.deriveColor(this.hoverButtonGroupBackground, this.toolBar.getBackground()));
        int n2 = UIScale.scale(10);
        Rectangle rectangle3 = null;
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            Rectangle rectangle4 = (Rectangle)iterator.next();
            if (rectangle3 == null) {
                rectangle3 = rectangle4;
                continue;
            }
            if (bl2 ? rectangle3.x + rectangle3.width + n2 >= rectangle4.x : rectangle3.y + rectangle3.height + n2 >= rectangle4.y) {
                rectangle3 = rectangle3.union(rectangle4);
                continue;
            }
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, 0.0f, UIScale.scale(this.hoverButtonGroupArc));
            rectangle3 = rectangle4;
        }
        if (rectangle3 != null) {
            FlatUIUtils.paintComponentBackground((Graphics2D)graphics, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height, 0.0f, UIScale.scale(this.hoverButtonGroupArc));
        }
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }

    protected void repaintButtonGroup(AbstractButton abstractButton) {
        if (this.hoverButtonGroupBackground == null) {
            return;
        }
        ButtonGroup buttonGroup = this.getButtonGroup(abstractButton);
        if (buttonGroup == null) {
            return;
        }
        Rectangle rectangle = null;
        Enumeration<AbstractButton> enumeration = buttonGroup.getElements();
        while (enumeration.hasMoreElements()) {
            AbstractButton abstractButton2 = enumeration.nextElement();
            Container container = abstractButton2.getParent();
            if (container != this.toolBar) continue;
            rectangle = rectangle != null ? rectangle.union(abstractButton2.getBounds()) : abstractButton2.getBounds();
        }
        if (rectangle != null) {
            HiDPIUtils.repaint(this.toolBar, rectangle);
        }
    }

    private ButtonGroup getButtonGroup(AbstractButton abstractButton) {
        ButtonModel buttonModel = abstractButton.getModel();
        return buttonModel instanceof DefaultButtonModel ? ((DefaultButtonModel)buttonModel).getGroup() : null;
    }

    @Override
    public Boolean isTitleBarCaptionAt(int n2, int n3) {
        return null;
    }

    protected class FlatToolBarFocusTraversalPolicy
    extends LayoutFocusTraversalPolicy {
        protected FlatToolBarFocusTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (!(component instanceof AbstractButton)) {
                return super.getComponentAfter(container, component);
            }
            Component component2 = component;
            while ((component2 = super.getComponentAfter(container, component2)) != null) {
                if (component2 instanceof AbstractButton) continue;
                return component2;
            }
            return null;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (!(component instanceof AbstractButton)) {
                return super.getComponentBefore(container, component);
            }
            Component component2 = component;
            while ((component2 = super.getComponentBefore(container, component2)) != null) {
                if (component2 instanceof AbstractButton) continue;
                return component2;
            }
            return null;
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.getRecentComponent(container, true);
        }

        @Override
        public Component getLastComponent(Container container) {
            return this.getRecentComponent(container, false);
        }

        private Component getRecentComponent(Container container, boolean bl2) {
            if (FlatToolBarUI.this.focusedCompIndex >= 0 && FlatToolBarUI.this.focusedCompIndex < FlatToolBarUI.this.toolBar.getComponentCount()) {
                return FlatToolBarUI.this.toolBar.getComponent(FlatToolBarUI.this.focusedCompIndex);
            }
            return bl2 ? super.getFirstComponent(container) : super.getLastComponent(container);
        }
    }
}

