/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.ui.FlatHTML;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.StringUtils;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToolTipUI;

public class FlatToolTipUI
extends BasicToolTipUI
implements PropertyChangeListener {
    public static ComponentUI createUI(JComponent jComponent) {
        return FlatUIUtils.createSharedUI(FlatToolTipUI.class, FlatToolTipUI::new);
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        FlatHTML.updateRendererCSSFontBaseSize(jComponent);
    }

    @Override
    protected void installListeners(JComponent jComponent) {
        super.installListeners(jComponent);
        jComponent.addPropertyChangeListener(this);
    }

    @Override
    protected void uninstallListeners(JComponent jComponent) {
        super.uninstallListeners(jComponent);
        jComponent.removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        FlatHTML.propertyChange(propertyChangeEvent);
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        String string = ((JToolTip)jComponent).getTipText();
        if (string == null || string.isEmpty()) {
            return new Dimension();
        }
        if (this.isMultiLine(jComponent)) {
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            Insets insets = jComponent.getInsets();
            List<String> list = StringUtils.split(((JToolTip)jComponent).getTipText(), '\n');
            int n2 = 0;
            int n3 = fontMetrics.getHeight() * Math.max(list.size(), 1);
            for (String string2 : list) {
                n2 = Math.max(n2, SwingUtilities.computeStringWidth(fontMetrics, string2));
            }
            return new Dimension(insets.left + n2 + insets.right + 6, insets.top + n3 + insets.bottom);
        }
        return super.getPreferredSize(jComponent);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.isMultiLine(jComponent)) {
            FontMetrics fontMetrics = jComponent.getFontMetrics(jComponent.getFont());
            Insets insets = jComponent.getInsets();
            graphics.setColor(jComponent.getForeground());
            List<String> list = StringUtils.split(((JToolTip)jComponent).getTipText(), '\n');
            int n2 = insets.left + 3;
            int n3 = jComponent.getWidth() - insets.right - 3;
            int n4 = insets.top - fontMetrics.getDescent();
            int n5 = fontMetrics.getHeight();
            JComponent jComponent2 = ((JToolTip)jComponent).getComponent();
            boolean bl2 = (jComponent2 != null ? jComponent2 : jComponent).getComponentOrientation().isLeftToRight();
            for (String string : list) {
                FlatUIUtils.drawString(jComponent, graphics, string, bl2 ? n2 : n3 - SwingUtilities.computeStringWidth(fontMetrics, string), n4 += n5);
            }
        } else {
            super.paint(HiDPIUtils.createGraphicsTextYCorrection((Graphics2D)graphics), jComponent);
        }
    }

    private boolean isMultiLine(JComponent jComponent) {
        String string = ((JToolTip)jComponent).getTipText();
        return jComponent.getClientProperty("html") == null && string != null && string.indexOf(10) >= 0;
    }
}

