/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.ui.StackUtils;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.LoggingFacade;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;

public class FlatTreeUI
extends BasicTreeUI
implements FlatStylingSupport.StyleableUI {
    @FlatStylingSupport.Styleable
    protected Color selectionBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveBackground;
    @FlatStylingSupport.Styleable
    protected Color selectionInactiveForeground;
    @FlatStylingSupport.Styleable
    protected Color selectionBorderColor;
    @FlatStylingSupport.Styleable
    protected Insets selectionInsets;
    @FlatStylingSupport.Styleable
    protected int selectionArc;
    @FlatStylingSupport.Styleable
    protected boolean wideSelection;
    @FlatStylingSupport.Styleable
    protected boolean showCellFocusIndicator;
    protected boolean showDefaultIcons;
    @FlatStylingSupport.Styleable(dot=true)
    public String iconArrowType;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconExpandedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconCollapsedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconLeafColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconClosedColor;
    @FlatStylingSupport.Styleable(dot=true)
    public Color iconOpenColor;
    @FlatStylingSupport.Styleable
    protected boolean paintSelection = true;
    private Icon defaultLeafIcon;
    private Icon defaultClosedIcon;
    private Icon defaultOpenIcon;
    private boolean paintLines;
    private Color defaultCellNonSelectionBackground;
    private Color defaultSelectionBackground;
    private Color defaultSelectionForeground;
    private Color defaultSelectionBorderColor;
    private Map<String, Object> oldStyleValues;

    public static ComponentUI createUI(JComponent jComponent) {
        return new FlatTreeUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        this.installStyle();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        LookAndFeel.installBorder(this.tree, "Tree.border");
        this.selectionBackground = UIManager.getColor("Tree.selectionBackground");
        this.selectionForeground = UIManager.getColor("Tree.selectionForeground");
        this.selectionInactiveBackground = UIManager.getColor("Tree.selectionInactiveBackground");
        this.selectionInactiveForeground = UIManager.getColor("Tree.selectionInactiveForeground");
        this.selectionBorderColor = UIManager.getColor("Tree.selectionBorderColor");
        this.selectionInsets = UIManager.getInsets("Tree.selectionInsets");
        this.selectionArc = UIManager.getInt("Tree.selectionArc");
        this.wideSelection = UIManager.getBoolean("Tree.wideSelection");
        this.showCellFocusIndicator = UIManager.getBoolean("Tree.showCellFocusIndicator");
        this.showDefaultIcons = UIManager.getBoolean("Tree.showDefaultIcons");
        this.defaultLeafIcon = UIManager.getIcon("Tree.leafIcon");
        this.defaultClosedIcon = UIManager.getIcon("Tree.closedIcon");
        this.defaultOpenIcon = UIManager.getIcon("Tree.openIcon");
        this.paintLines = UIManager.getBoolean("Tree.paintLines");
        this.defaultCellNonSelectionBackground = UIManager.getColor("Tree.textBackground");
        this.defaultSelectionBackground = this.selectionBackground;
        this.defaultSelectionForeground = this.selectionForeground;
        this.defaultSelectionBorderColor = this.selectionBorderColor;
        int n2 = FlatUIUtils.getUIInt("Tree.rowHeight", 16);
        if (n2 > 0) {
            LookAndFeel.installProperty(this.tree, "rowHeight", UIScale.scale(n2));
        }
        this.setLeftChildIndent(UIScale.scale(this.getLeftChildIndent()));
        this.setRightChildIndent(UIScale.scale(this.getRightChildIndent()));
    }

    @Override
    protected void uninstallDefaults() {
        super.uninstallDefaults();
        LookAndFeel.uninstallBorder(this.tree);
        this.selectionBackground = null;
        this.selectionForeground = null;
        this.selectionInactiveBackground = null;
        this.selectionInactiveForeground = null;
        this.selectionBorderColor = null;
        this.defaultLeafIcon = null;
        this.defaultClosedIcon = null;
        this.defaultOpenIcon = null;
        this.defaultCellNonSelectionBackground = null;
        this.defaultSelectionBackground = null;
        this.defaultSelectionForeground = null;
        this.defaultSelectionBorderColor = null;
        this.oldStyleValues = null;
    }

    @Override
    protected void updateRenderer() {
        DefaultTreeCellRenderer defaultTreeCellRenderer;
        super.updateRenderer();
        if (!this.showDefaultIcons && this.currentCellRenderer instanceof DefaultTreeCellRenderer && (defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.currentCellRenderer).getLeafIcon() == this.defaultLeafIcon && defaultTreeCellRenderer.getClosedIcon() == this.defaultClosedIcon && defaultTreeCellRenderer.getOpenIcon() == this.defaultOpenIcon) {
            defaultTreeCellRenderer.setLeafIcon(null);
            defaultTreeCellRenderer.setClosedIcon(null);
            defaultTreeCellRenderer.setOpenIcon(null);
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return new BasicTreeUI.MouseHandler(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(this.handleWideMouseEvent(mouseEvent));
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                super.mouseReleased(this.handleWideMouseEvent(mouseEvent));
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                super.mouseDragged(this.handleWideMouseEvent(mouseEvent));
            }

            private MouseEvent handleWideMouseEvent(MouseEvent mouseEvent) {
                if (!FlatTreeUI.this.isWideSelection() || !FlatTreeUI.this.tree.isEnabled() || !SwingUtilities.isLeftMouseButton(mouseEvent) || mouseEvent.isConsumed()) {
                    return mouseEvent;
                }
                int n2 = mouseEvent.getX();
                int n3 = mouseEvent.getY();
                TreePath treePath = FlatTreeUI.this.getClosestPathForLocation(FlatTreeUI.this.tree, n2, n3);
                if (treePath == null || FlatTreeUI.this.isLocationInExpandControl(treePath, n2, n3)) {
                    return mouseEvent;
                }
                Rectangle rectangle = FlatTreeUI.this.getPathBounds(FlatTreeUI.this.tree, treePath);
                if (rectangle == null || n3 < rectangle.y || n3 >= rectangle.y + rectangle.height) {
                    return mouseEvent;
                }
                int n4 = Math.max(rectangle.x, Math.min(n2, rectangle.x + rectangle.width - 1));
                if (n4 == n2) {
                    return mouseEvent;
                }
                return new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers() | mouseEvent.getModifiersEx(), n4, mouseEvent.getY(), mouseEvent.getClickCount(), mouseEvent.isPopupTrigger(), mouseEvent.getButton());
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        PropertyChangeListener propertyChangeListener = super.createPropertyChangeListener();
        return propertyChangeEvent -> {
            propertyChangeListener.propertyChange(propertyChangeEvent);
            if (propertyChangeEvent.getSource() == this.tree) {
                switch (propertyChangeEvent.getPropertyName()) {
                    case "JTree.wideSelection": 
                    case "JTree.paintSelection": {
                        HiDPIUtils.repaint(this.tree);
                        break;
                    }
                    case "dropLocation": {
                        if (!this.isWideSelection()) break;
                        JTree.DropLocation dropLocation = (JTree.DropLocation)propertyChangeEvent.getOldValue();
                        this.repaintWideDropLocation(dropLocation);
                        this.repaintWideDropLocation(this.tree.getDropLocation());
                        break;
                    }
                    case "FlatLaf.style": 
                    case "FlatLaf.styleClass": {
                        this.installStyle();
                        this.tree.revalidate();
                        HiDPIUtils.repaint(this.tree);
                        break;
                    }
                    case "enabled": {
                        if (this.showDefaultIcons || !(this.currentCellRenderer instanceof DefaultTreeCellRenderer) || this.currentCellRenderer.getClass() == DefaultTreeCellRenderer.class || this.treeState == null) break;
                        this.treeState.invalidateSizes();
                        this.updateSize();
                    }
                }
            }
        };
    }

    private void repaintWideDropLocation(JTree.DropLocation dropLocation) {
        if (dropLocation == null || this.isDropLine(dropLocation)) {
            return;
        }
        Rectangle rectangle = this.tree.getPathBounds(dropLocation.getPath());
        if (rectangle != null) {
            HiDPIUtils.repaint(this.tree, 0, rectangle.y, this.tree.getWidth(), rectangle.height);
        }
    }

    @Override
    protected TreeSelectionListener createTreeSelectionListener() {
        TreeSelectionListener treeSelectionListener = super.createTreeSelectionListener();
        return treeSelectionEvent -> {
            TreePath[] treePathArray;
            treeSelectionListener.valueChanged(treeSelectionEvent);
            if (this.useUnitedRoundedSelection() && this.tree.getSelectionCount() > 1 && (treePathArray = treeSelectionEvent.getPaths()) != null) {
                if (treePathArray.length > 4) {
                    HiDPIUtils.repaint(this.tree);
                } else {
                    int n2 = (int)Math.ceil(UIScale.scale((float)this.selectionArc / 2.0f));
                    for (TreePath treePath : treePathArray) {
                        Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                        if (rectangle == null) continue;
                        HiDPIUtils.repaint(this.tree, rectangle.x, rectangle.y - n2, rectangle.width, rectangle.height + n2 * 2);
                    }
                }
            }
        };
    }

    @Override
    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        Rectangle rectangle = super.getPathBounds(jTree, treePath);
        if (rectangle != null && this.isWideSelection() && UIManager.getBoolean("FlatLaf.experimental.tree.widePathForLocation") && StackUtils.wasInvokedFrom(JTree.class.getName(), "getPathForLocation", 5)) {
            rectangle.x = 0;
            rectangle.width = jTree.getWidth();
        }
        return rectangle;
    }

    protected void installStyle() {
        try {
            this.applyStyle(FlatStylingSupport.getResolvedStyle(this.tree, "Tree"));
        }
        catch (RuntimeException runtimeException) {
            LoggingFacade.INSTANCE.logSevere(null, runtimeException);
        }
    }

    protected void applyStyle(Object object) {
        this.oldStyleValues = FlatStylingSupport.parseAndApply(this.oldStyleValues, object, this::applyStyleProperty);
    }

    protected Object applyStyleProperty(String string, Object object) {
        if ("rowHeight".equals(string) && object instanceof Integer) {
            object = UIScale.scale((Integer)object);
        }
        return FlatStylingSupport.applyToAnnotatedObjectOrComponent(this, this.tree, string, object);
    }

    @Override
    public Map<String, Class<?>> getStyleableInfos(JComponent jComponent) {
        return FlatStylingSupport.getAnnotatedStyleableInfos(this);
    }

    @Override
    public Object getStyleableValue(JComponent jComponent, String string) {
        return FlatStylingSupport.getAnnotatedStyleableValue(this, string);
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.treeState == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration<TreePath> enumeration = this.treeState.getVisiblePathsFrom(treePath);
        if (enumeration != null) {
            Iterator iterator;
            Object[] objectArray;
            Serializable serializable;
            ArrayList<Runnable> arrayList;
            Insets insets = this.tree.getInsets();
            HashSet<Serializable> hashSet = this.paintLines ? new HashSet<Serializable>() : null;
            ArrayList<Runnable> arrayList2 = this.paintLines ? new ArrayList<Runnable>() : null;
            ArrayList<Runnable> arrayList3 = arrayList = this.paintLines ? new ArrayList<Runnable>() : null;
            if (this.paintLines) {
                for (serializable = treePath.getParentPath(); serializable != null; serializable = ((TreePath)serializable).getParentPath()) {
                    hashSet.add(serializable);
                }
            }
            serializable = new Rectangle();
            boolean bl2 = this.isRootVisible();
            int n2 = this.treeState.getRowForPath(treePath);
            boolean bl3 = this.tree.getComponentOrientation().isLeftToRight();
            int n3 = this.tree.getWidth();
            while (enumeration.hasMoreElements() && (objectArray = enumeration.nextElement()) != null && (iterator = this.treeState.getBounds((TreePath)objectArray, (Rectangle)serializable)) != null) {
                Serializable serializable2;
                ((Rectangle)((Object)iterator)).x = bl3 ? (((Rectangle)((Object)iterator)).x += insets.left) : n3 - insets.right - (((Rectangle)((Object)iterator)).x + ((Rectangle)((Object)iterator)).width);
                ((Rectangle)((Object)iterator)).y += insets.top;
                boolean bl4 = this.treeModel.isLeaf(objectArray.getLastPathComponent());
                boolean bl5 = bl4 ? false : this.treeState.getExpandedState((TreePath)objectArray);
                boolean bl6 = bl4 ? false : this.tree.hasBeenExpanded((TreePath)objectArray);
                this.paintRow(graphics, rectangle, insets, (Rectangle)((Object)iterator), (TreePath)objectArray, n2, bl5, bl6, bl4);
                if (this.paintLines) {
                    serializable2 = objectArray.getParentPath();
                    if (serializable2 != null) {
                        hashSet.add(serializable2);
                    }
                    if (serializable2 != null || bl2 && n2 == 0) {
                        Rectangle rectangle2 = new Rectangle((Rectangle)((Object)iterator));
                        int n4 = n2;
                        arrayList2.add(() -> this.lambda$paint$2(graphics, rectangle, insets, rectangle2, (TreePath)objectArray, n4, bl5, bl6, bl4));
                    }
                }
                if (this.shouldPaintExpandControl((TreePath)objectArray, n2, bl5, bl6, bl4)) {
                    if (this.paintLines) {
                        serializable2 = new Rectangle((Rectangle)((Object)iterator));
                        int n5 = n2;
                        arrayList.add(() -> this.lambda$paint$3(graphics, rectangle, insets, (Rectangle)serializable2, (TreePath)objectArray, n5, bl5, bl6, bl4));
                    } else {
                        this.paintExpandControl(graphics, rectangle, insets, (Rectangle)((Object)iterator), (TreePath)objectArray, n2, bl5, bl6, bl4);
                    }
                }
                if (((Rectangle)((Object)iterator)).y + ((Rectangle)((Object)iterator)).height >= rectangle.y + rectangle.height) break;
                ++n2;
            }
            if (this.paintLines) {
                objectArray = FlatUIUtils.setRenderingHints(graphics);
                for (Runnable runnable : arrayList2) {
                    runnable.run();
                }
                graphics.setColor(Color.green);
                for (TreePath treePath2 : hashSet) {
                    this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                }
                if (objectArray != null) {
                    FlatUIUtils.resetRenderingHints(graphics, objectArray);
                }
                for (Runnable runnable : arrayList) {
                    runnable.run();
                }
            }
        }
        this.paintDropLine(graphics);
        this.rendererPane.removeAll();
    }

    @Override
    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        DefaultTreeCellRenderer defaultTreeCellRenderer;
        Color color;
        boolean bl5;
        boolean bl6;
        boolean bl7 = this.editingComponent != null && this.editingRow == n2;
        boolean bl8 = this.tree.isRowSelected(n2);
        boolean bl9 = this.isDropRow(n2);
        boolean bl10 = bl6 = (bl8 || bl9) && this.isPaintSelection();
        if (bl7) {
            if (bl8 && this.isWideSelection()) {
                Color color2 = graphics.getColor();
                graphics.setColor(this.selectionInactiveBackground);
                this.paintWideSelection(graphics, rectangle2, n2);
                graphics.setColor(color2);
            }
            return;
        }
        boolean bl11 = FlatUIUtils.isPermanentFocusOwner(this.tree);
        boolean bl12 = bl5 = bl11 && n2 == this.getLeadSelectionRow();
        if (!bl11 && bl8 && this.tree.getParent() instanceof CellRendererPane) {
            bl11 = FlatUIUtils.isPermanentFocusOwner(this.tree.getParent().getParent());
        }
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), bl8, bl2, bl4, n2, bl5);
        Color color3 = null;
        if (bl8 && !bl11 && !bl9) {
            color3 = this.setRendererBackgroundSelectionColor(component, this.selectionInactiveBackground);
            this.setRendererForeground(component, this.selectionInactiveForeground);
        } else if (bl8) {
            if (this.selectionBackground != this.defaultSelectionBackground) {
                color3 = this.setRendererBackgroundSelectionColor(component, this.selectionBackground);
            }
            if (this.selectionForeground != this.defaultSelectionForeground) {
                this.setRendererForeground(component, this.selectionForeground);
            }
        }
        Color color4 = null;
        if (bl8 && bl11 && (!this.showCellFocusIndicator || this.tree.getMinSelectionRow() == this.tree.getMaxSelectionRow())) {
            color4 = this.setRendererBorderSelectionColor(component, null);
        } else if (bl11 && this.selectionBorderColor != this.defaultSelectionBorderColor) {
            color4 = this.setRendererBorderSelectionColor(component, this.selectionBorderColor);
        }
        if (bl6) {
            Color color5 = graphics.getColor();
            graphics.setColor(bl9 ? UIManager.getColor("Tree.dropCellBackground") : (component instanceof DefaultTreeCellRenderer ? ((DefaultTreeCellRenderer)component).getBackgroundSelectionColor() : (bl11 ? this.selectionBackground : this.selectionInactiveBackground)));
            if (this.isWideSelection()) {
                this.paintWideSelection(graphics, rectangle2, n2);
            } else {
                this.paintCellBackground(graphics, component, rectangle2, n2, true);
            }
            graphics.setColor(color5);
        } else if (component instanceof DefaultTreeCellRenderer && (color = (defaultTreeCellRenderer = (DefaultTreeCellRenderer)component).getBackgroundNonSelectionColor()) != null && !color.equals(this.defaultCellNonSelectionBackground)) {
            Color color6 = graphics.getColor();
            graphics.setColor(color);
            this.paintCellBackground(graphics, component, rectangle2, n2, false);
            graphics.setColor(color6);
        }
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
        if (color3 != null) {
            ((DefaultTreeCellRenderer)component).setBackgroundSelectionColor(color3);
        }
        if (color4 != null) {
            ((DefaultTreeCellRenderer)component).setBorderSelectionColor(color4);
        }
    }

    private Color setRendererBackgroundSelectionColor(Component component, Color color) {
        Color color2 = null;
        if (component instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)component;
            if (defaultTreeCellRenderer.getBackgroundSelectionColor() == this.defaultSelectionBackground) {
                color2 = defaultTreeCellRenderer.getBackgroundSelectionColor();
                defaultTreeCellRenderer.setBackgroundSelectionColor(color);
            }
        } else if (component.getBackground() == this.defaultSelectionBackground) {
            component.setBackground(color);
        }
        return color2;
    }

    private void setRendererForeground(Component component, Color color) {
        if (component.getForeground() == this.defaultSelectionForeground) {
            component.setForeground(color);
        }
    }

    private Color setRendererBorderSelectionColor(Component component, Color color) {
        DefaultTreeCellRenderer defaultTreeCellRenderer;
        Color color2 = null;
        if (component instanceof DefaultTreeCellRenderer && (defaultTreeCellRenderer = (DefaultTreeCellRenderer)component).getBorderSelectionColor() == this.defaultSelectionBorderColor) {
            color2 = defaultTreeCellRenderer.getBorderSelectionColor();
            defaultTreeCellRenderer.setBorderSelectionColor(color);
        }
        return color2;
    }

    private void paintWideSelection(Graphics graphics, Rectangle rectangle, int n2) {
        float f2;
        float f3 = f2 = UIScale.scale((float)this.selectionArc / 2.0f);
        if (this.useUnitedRoundedSelection()) {
            if (n2 > 0 && this.tree.isRowSelected(n2 - 1)) {
                f3 = 0.0f;
            }
            if (n2 < this.tree.getRowCount() - 1 && this.tree.isRowSelected(n2 + 1)) {
                f2 = 0.0f;
            }
        }
        FlatUIUtils.paintSelection((Graphics2D)graphics, 0, rectangle.y, this.tree.getWidth(), rectangle.height, UIScale.scale(this.selectionInsets), f3, f3, f2, f2, 0);
    }

    private void paintCellBackground(Graphics graphics, Component component, Rectangle rectangle, int n2, boolean bl2) {
        int n3 = 0;
        int n4 = 0;
        if (component instanceof JLabel) {
            JLabel jLabel = (JLabel)component;
            Icon icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
            n4 = icon != null && jLabel.getText() != null ? icon.getIconWidth() + Math.max(jLabel.getIconTextGap() - 1, 0) : 0;
            int n5 = n3 = jLabel.getComponentOrientation().isLeftToRight() ? n4 : 0;
        }
        if (bl2) {
            float f2;
            float f3 = f2 = UIScale.scale((float)this.selectionArc / 2.0f);
            float f4 = f2;
            float f5 = f2;
            if (this.useUnitedRoundedSelection()) {
                Rectangle rectangle2;
                if (n2 > 0 && this.tree.isRowSelected(n2 - 1)) {
                    rectangle2 = this.getPathBounds(this.tree, this.tree.getPathForRow(n2 - 1));
                    f5 = Math.min(f5, (float)(rectangle2.x - rectangle.x));
                    f4 = Math.min(f4, (float)(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width)));
                }
                if (n2 < this.tree.getRowCount() - 1 && this.tree.isRowSelected(n2 + 1)) {
                    rectangle2 = this.getPathBounds(this.tree, this.tree.getPathForRow(n2 + 1));
                    f3 = Math.min(f3, (float)(rectangle2.x - rectangle.x));
                    f2 = Math.min(f2, (float)(rectangle.x + rectangle.width - (rectangle2.x + rectangle2.width)));
                }
            }
            FlatUIUtils.paintSelection((Graphics2D)graphics, rectangle.x + n3, rectangle.y, rectangle.width - n4, rectangle.height, UIScale.scale(this.selectionInsets), f5, f4, f3, f2, 0);
        } else {
            graphics.fillRect(rectangle.x + n3, rectangle.y, rectangle.width - n4, rectangle.height);
        }
    }

    private boolean useUnitedRoundedSelection() {
        return this.selectionArc > 0 && (this.selectionInsets == null || this.selectionInsets.top == 0 && this.selectionInsets.bottom == 0);
    }

    @Override
    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        ((Graphics2D)graphics).fill(new Rectangle2D.Float(n2, n3, UIScale.scale(1.0f), n4 - n3));
    }

    @Override
    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n2, int n3, int n4) {
        ((Graphics2D)graphics).fill(new Rectangle2D.Float(n3, n2, n4 - n3, UIScale.scale(1.0f)));
    }

    private boolean isDropRow(int n2) {
        JTree.DropLocation dropLocation = this.tree.getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && this.tree.getRowForPath(dropLocation.getPath()) == n2;
    }

    @Override
    protected Rectangle getDropLineRect(JTree.DropLocation dropLocation) {
        Rectangle rectangle = super.getDropLineRect(dropLocation);
        return this.isWideSelection() ? new Rectangle(0, rectangle.y, this.tree.getWidth(), rectangle.height) : rectangle;
    }

    protected boolean isWideSelection() {
        return FlatClientProperties.clientPropertyBoolean(this.tree, "JTree.wideSelection", this.wideSelection);
    }

    protected boolean isPaintSelection() {
        return FlatClientProperties.clientPropertyBoolean(this.tree, "JTree.paintSelection", this.paintSelection);
    }

    private /* synthetic */ void lambda$paint$3(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n2, bl2, bl3, bl4);
    }

    private /* synthetic */ void lambda$paint$2(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n2, bl2, bl3, bl4);
    }
}

