/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.FlatIntelliJLaf;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.FlatLightLaf;
import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.ui.FlatBorder;
import com.formdev.flatlaf.ui.FlatStylingSupport;
import com.formdev.flatlaf.util.DerivedColor;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.HiDPIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.IdentityHashMap;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.DefaultTreeCellEditor;

public class FlatUIUtils {
    private static boolean useSharedUIs = true;
    private static final WeakHashMap<LookAndFeel, IdentityHashMap<Object, ComponentUI>> sharedUIinstances = new WeakHashMap();
    private static UIDefaults lightAWTPeerDefaults;
    public static final double MOVE_TO = -1.000000000001E12;
    public static final double QUAD_TO = -1.000000000002E12;
    public static final double CURVE_TO = -1.000000000003E12;
    public static final double ROUNDED = -1.000000000004E12;
    public static final double CLOSE_PATH = -1.000000000005E12;

    public static Rectangle addInsets(Rectangle rectangle, Insets insets) {
        return new Rectangle(rectangle.x - insets.left, rectangle.y - insets.top, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
    }

    public static Rectangle subtractInsets(Rectangle rectangle, Insets insets) {
        return new Rectangle(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - insets.left - insets.right, rectangle.height - insets.top - insets.bottom);
    }

    public static Dimension addInsets(Dimension dimension, Insets insets) {
        return new Dimension(dimension.width + insets.left + insets.right, dimension.height + insets.top + insets.bottom);
    }

    public static Insets addInsets(Insets insets, Insets insets2) {
        if (insets == null) {
            return insets2;
        }
        if (insets2 == null) {
            return insets;
        }
        return new Insets(insets.top + insets2.top, insets.left + insets2.left, insets.bottom + insets2.bottom, insets.right + insets2.right);
    }

    public static void setInsets(Insets insets, Insets insets2) {
        insets.top = insets2.top;
        insets.left = insets2.left;
        insets.bottom = insets2.bottom;
        insets.right = insets2.right;
    }

    public static boolean isInsetsEmpty(Insets insets) {
        return insets.top == 0 && insets.left == 0 && insets.bottom == 0 && insets.right == 0;
    }

    public static Color getUIColor(String string, int n2) {
        Color color = UIManager.getColor(string);
        return color != null ? color : new Color(n2);
    }

    public static Color getUIColor(String string, Color color) {
        Color color2 = UIManager.getColor(string);
        return color2 != null ? color2 : color;
    }

    public static Color getUIColor(String string, String string2) {
        Color color = UIManager.getColor(string);
        return color != null ? color : UIManager.getColor(string2);
    }

    public static boolean getUIBoolean(String string, boolean bl2) {
        Object object = UIManager.get(string);
        return object instanceof Boolean ? (Boolean)object : bl2;
    }

    public static int getUIInt(String string, int n2) {
        Object object = UIManager.get(string);
        return object instanceof Integer ? (Integer)object : n2;
    }

    public static float getUIFloat(String string, float f2) {
        Object object = UIManager.get(string);
        return object instanceof Number ? ((Number)object).floatValue() : f2;
    }

    public static <T extends Enum<T>> T getUIEnum(String string, Class<T> clazz, T t2) {
        Object object = UIManager.get(string);
        if (object instanceof String) {
            try {
                return Enum.valueOf(clazz, (String)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return t2;
    }

    public static Color getSubUIColor(String string, String string2) {
        Color color;
        if (string2 != null && (color = UIManager.getColor(FlatUIUtils.buildSubKey(string, string2))) != null) {
            return color;
        }
        return UIManager.getColor(string);
    }

    public static boolean getSubUIBoolean(String string, String string2, boolean bl2) {
        Object object;
        if (string2 != null && (object = UIManager.get(FlatUIUtils.buildSubKey(string, string2))) instanceof Boolean) {
            return (Boolean)object;
        }
        return FlatUIUtils.getUIBoolean(string, bl2);
    }

    public static int getSubUIInt(String string, String string2, int n2) {
        Object object;
        if (string2 != null && (object = UIManager.get(FlatUIUtils.buildSubKey(string, string2))) instanceof Integer) {
            return (Integer)object;
        }
        return FlatUIUtils.getUIInt(string, n2);
    }

    public static Insets getSubUIInsets(String string, String string2) {
        Insets insets;
        if (string2 != null && (insets = UIManager.getInsets(FlatUIUtils.buildSubKey(string, string2))) != null) {
            return insets;
        }
        return UIManager.getInsets(string);
    }

    public static Dimension getSubUIDimension(String string, String string2) {
        Dimension dimension;
        if (string2 != null && (dimension = UIManager.getDimension(FlatUIUtils.buildSubKey(string, string2))) != null) {
            return dimension;
        }
        return UIManager.getDimension(string);
    }

    public static Icon getSubUIIcon(String string, String string2) {
        Icon icon;
        if (string2 != null && (icon = UIManager.getIcon(FlatUIUtils.buildSubKey(string, string2))) != null) {
            return icon;
        }
        return UIManager.getIcon(string);
    }

    public static Font getSubUIFont(String string, String string2) {
        Font font;
        if (string2 != null && (font = UIManager.getFont(FlatUIUtils.buildSubKey(string, string2))) != null) {
            return font;
        }
        return UIManager.getFont(string);
    }

    private static String buildSubKey(String string, String string2) {
        int n2 = string.lastIndexOf(46);
        return n2 >= 0 ? string.substring(0, n2) + '.' + string2 + '.' + string.substring(n2 + 1) : string;
    }

    public static boolean getBoolean(JComponent jComponent, String string, String string2, String string3, boolean bl2) {
        Boolean bl3 = FlatSystemProperties.getBooleanStrict(string, null);
        if (bl3 != null) {
            return bl3;
        }
        bl3 = FlatClientProperties.clientPropertyBooleanStrict(jComponent, string2, null);
        if (bl3 != null) {
            return bl3;
        }
        return FlatUIUtils.getUIBoolean(string3, bl2);
    }

    public static boolean isChevron(String string) {
        return !"triangle".equals(string);
    }

    public static Color nonUIResource(Color color) {
        return color instanceof UIResource ? new Color(color.getRGB(), true) : color;
    }

    public static Font nonUIResource(Font font) {
        return font instanceof UIResource ? font.deriveFont(font.getStyle()) : font;
    }

    public static Border nonUIResource(Border border) {
        return border instanceof UIResource ? new NonUIResourceBorder(border) : border;
    }

    static Border unwrapNonUIResourceBorder(Border border) {
        return border instanceof NonUIResourceBorder ? ((NonUIResourceBorder)border).delegate : border;
    }

    public static int minimumWidth(JComponent jComponent, int n2) {
        return FlatClientProperties.clientPropertyInt(jComponent, "JComponent.minimumWidth", n2);
    }

    public static int minimumHeight(JComponent jComponent, int n2) {
        return FlatClientProperties.clientPropertyInt(jComponent, "JComponent.minimumHeight", n2);
    }

    public static boolean isCellEditor(Component component) {
        if (component == null) {
            return false;
        }
        Container container = component.getParent();
        if (container instanceof JTable && ((JTable)container).getEditorComponent() == component) {
            return true;
        }
        if (container instanceof DefaultTreeCellEditor.EditorContainer) {
            return true;
        }
        String string = component.getName();
        if ("Table.editor".equals(string) || "Tree.cellEditor".equals(string)) {
            return true;
        }
        return component instanceof JComponent && Boolean.TRUE.equals(((JComponent)component).getClientProperty("JComboBox.isTableCellEditor"));
    }

    public static boolean isPermanentFocusOwner(Component component) {
        Object object;
        KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (component instanceof JComponent && (object = ((JComponent)component).getClientProperty("JComponent.focusOwner")) instanceof Predicate) {
            return ((Predicate)object).test((JComponent)component) && FlatUIUtils.isInActiveWindow(component, keyboardFocusManager.getActiveWindow());
        }
        if (component.hasFocus()) {
            return true;
        }
        return keyboardFocusManager.getPermanentFocusOwner() == component && FlatUIUtils.isInActiveWindow(component, keyboardFocusManager.getActiveWindow());
    }

    static boolean isInActiveWindow(Component component, Window window) {
        Window window2 = SwingUtilities.windowForComponent(component);
        return window2 == window || window2 != null && window2.getType() == Window.Type.POPUP && window2.getOwner() == window;
    }

    static boolean isAWTPeer(Component component) {
        if (SystemInfo.isMacOS) {
            return component.getClass().getName().startsWith("sun.lwawt.LW");
        }
        return false;
    }

    static boolean needsLightAWTPeer(JComponent jComponent) {
        return FlatUIUtils.isAWTPeer(jComponent) && FlatLaf.isLafDark();
    }

    static void runWithLightAWTPeerUIDefaults(Runnable runnable) {
        if (lightAWTPeerDefaults == null) {
            FlatLightLaf flatLightLaf = UIManager.getInt("Component.focusWidth") >= 2 ? new FlatIntelliJLaf() : new FlatLightLaf();
            lightAWTPeerDefaults = flatLightLaf.getDefaults();
        }
        FlatLaf.runWithUIDefaultsGetter(object -> {
            Object object2 = lightAWTPeerDefaults.get(object);
            return object2 != null ? object2 : FlatLaf.NULL_VALUE;
        }, runnable);
    }

    public static boolean isFullScreen(Component component) {
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        GraphicsDevice graphicsDevice = graphicsConfiguration != null ? graphicsConfiguration.getDevice() : null;
        Window window = graphicsDevice != null ? graphicsDevice.getFullScreenWindow() : null;
        return window != null && window == SwingUtilities.windowForComponent(component);
    }

    public static Boolean isRoundRect(Component component) {
        return component instanceof JComponent ? FlatClientProperties.clientPropertyBooleanStrict((JComponent)component, "JComponent.roundRect", null) : null;
    }

    public static float getBorderFocusWidth(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        return flatBorder != null ? UIScale.scale((float)flatBorder.getFocusWidth(jComponent)) : 0.0f;
    }

    public static float getBorderLineWidth(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        return flatBorder != null ? UIScale.scale((float)flatBorder.getLineWidth(jComponent)) : 0.0f;
    }

    public static int getBorderFocusAndLineWidth(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        return flatBorder != null ? Math.round(UIScale.scale((float)flatBorder.getFocusWidth(jComponent)) + UIScale.scale((float)flatBorder.getLineWidth(jComponent))) : 0;
    }

    public static float getBorderArc(JComponent jComponent) {
        FlatBorder flatBorder = FlatUIUtils.getOutsideFlatBorder(jComponent);
        return flatBorder != null ? UIScale.scale((float)flatBorder.getArc(jComponent)) : 0.0f;
    }

    public static boolean hasRoundBorder(JComponent jComponent) {
        return FlatUIUtils.getBorderArc(jComponent) >= (float)jComponent.getHeight();
    }

    public static FlatBorder getOutsideFlatBorder(JComponent jComponent) {
        Border border = jComponent.getBorder();
        while (true) {
            if (border instanceof FlatBorder) {
                return (FlatBorder)border;
            }
            if (!(border instanceof CompoundBorder)) break;
            border = ((CompoundBorder)border).getOutsideBorder();
        }
        return null;
    }

    public static Object[] setRenderingHints(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray = new Object[]{graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING), graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        return objectArray;
    }

    public static void resetRenderingHints(Graphics graphics, Object[] objectArray) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (objectArray[0] != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, objectArray[0]);
        }
        if (objectArray[1] != null) {
            graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, objectArray[1]);
        }
    }

    public static void runWithoutRenderingHints(Graphics graphics, Object[] objectArray, Runnable runnable) {
        if (objectArray == null) {
            runnable.run();
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Object[] objectArray2 = new Object[]{graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING), graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL)};
        FlatUIUtils.resetRenderingHints(graphics2D, objectArray);
        runnable.run();
        FlatUIUtils.resetRenderingHints(graphics2D, objectArray2);
    }

    public static Color deriveColor(Color color, Color color2) {
        return color instanceof DerivedColor ? ((DerivedColor)color).derive(color2) : color;
    }

    public static void paintComponentBackground(Graphics2D graphics2D, int n2, int n3, int n4, int n5, float f2, float f3) {
        FlatUIUtils.paintOutlinedComponent(graphics2D, n2, n3, n4, n5, f2, 0.0f, 0.0f, 0.0f, f3, null, null, graphics2D.getPaint());
    }

    public static void paintOutlinedComponent(Graphics2D graphics2D, int n2, int n3, int n4, int n5, float f2, float f3, float f4, float f5, float f6, Paint paint, Paint paint2, Paint paint3) {
        FlatUIUtils.paintOutlinedComponent(graphics2D, n2, n3, n4, n5, f2, f3, f4, f5, f6, paint, paint2, paint3, false);
    }

    static void paintOutlinedComponent(Graphics2D graphics2D2, int n6, int n7, int n8, int n9, float f2, float f3, float f4, float f5, float f6, Paint paint, Paint paint2, Paint paint3, boolean bl2) {
        double d3 = UIScale.getSystemScaleFactor(graphics2D2);
        if ((double)((int)d3) != d3) {
            HiDPIUtils.paintAtScale1x(graphics2D2, n6, n7, n8, n9, (graphics2D, n2, n3, n4, n5, d2) -> FlatUIUtils.paintOutlinedComponentImpl(graphics2D, n2, n3, n4, n5, (float)((double)f2 * d2), f3, (float)((double)f4 * d2), (float)((double)f5 * d2), (float)((double)f6 * d2), paint, paint2, paint3, bl2, d2));
            return;
        }
        FlatUIUtils.paintOutlinedComponentImpl(graphics2D2, n6, n7, n8, n9, f2, f3, f4, f5, f6, paint, paint2, paint3, bl2, d3);
    }

    private static void paintOutlinedComponentImpl(Graphics2D graphics2D, int n2, int n3, int n4, int n5, float f2, float f3, float f4, float f5, float f6, Paint paint, Paint paint2, Paint paint3, boolean bl2, double d2) {
        if (bl2 && d2 != (double)((int)d2)) {
            if (f2 > 0.0f) {
                int n6 = (int)(f2 + f5);
                f2 = (float)n6 - f5;
            } else {
                f5 = (int)f5;
            }
        }
        float f7 = (float)n2 + f2;
        float f8 = (float)n3 + f2;
        float f9 = (float)n4 - f2 * 2.0f;
        float f10 = (float)n5 - f2 * 2.0f;
        if (paint3 != null) {
            graphics2D.setPaint(paint3);
            graphics2D.fill(FlatUIUtils.createComponentRectangle(f7, f8, f9, f10, f6));
        }
        if (paint2 != null && paint2.equals(paint)) {
            paint2 = null;
            f4 = Math.max(f4, f5);
        }
        float f11 = f2 * f3 + f4;
        if (paint != null && f11 != 0.0f) {
            float f12 = f2 - f2 * f3;
            float f13 = (float)n2 + f12;
            float f14 = (float)n3 + f12;
            float f15 = (float)n4 - f12 * 2.0f;
            float f16 = (float)n5 - f12 * 2.0f;
            float f17 = f6 + f2 * 2.0f;
            float f18 = f6 - f4 * 2.0f;
            if (f2 > 0.0f && f6 > 0.0f && f6 < (float)UIScale.scale(10)) {
                f17 -= UIScale.scale(2.0f);
            }
            if (f3 != 1.0f) {
                f17 = f6 + (f17 - f6) * f3;
            }
            graphics2D.setPaint(paint);
            FlatUIUtils.paintOutline(graphics2D, f13, f14, f15, f16, f11, f17, f18);
        }
        if (paint2 != null && f5 != 0.0f) {
            graphics2D.setPaint(paint2);
            FlatUIUtils.paintOutline(graphics2D, f7, f8, f9, f10, f5, f6);
        }
    }

    public static void paintOutline(Graphics2D graphics2D, float f2, float f3, float f4, float f5, float f6, float f7) {
        FlatUIUtils.paintOutline(graphics2D, f2, f3, f4, f5, f6, f7, f7 - f6 * 2.0f);
    }

    public static void paintOutline(Graphics2D graphics2D, float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        if (f6 == 0.0f || f4 <= 0.0f || f5 <= 0.0f) {
            return;
        }
        float f9 = f6;
        float f10 = f9 * 2.0f;
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(FlatUIUtils.createComponentRectangle(f2, f3, f4, f5, f7), false);
        float_.append(FlatUIUtils.createComponentRectangle(f2 + f9, f3 + f9, f4 - f10, f5 - f10, f8), false);
        graphics2D.fill(float_);
    }

    public static Shape createComponentRectangle(float f2, float f3, float f4, float f5, float f6) {
        if (f6 <= 0.0f) {
            return new Rectangle2D.Float(f2, f3, f4, f5);
        }
        if (f4 == f5 && f6 >= f4) {
            return new Ellipse2D.Float(f2, f3, f4, f5);
        }
        f6 = Math.min(f6, Math.min(f4, f5));
        return new RoundRectangle2D.Float(f2, f3, f4, f5, f6, f6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void paintFilledRectangle(Graphics graphics, Color color, float f2, float f3, float f4, float f5) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        try {
            FlatUIUtils.setRenderingHints(graphics2D);
            graphics2D.setColor(color);
            graphics2D.fill(new Rectangle2D.Float(f2, f3, f4, f5));
        }
        finally {
            graphics2D.dispose();
        }
    }

    public static void paintSelection(Graphics2D graphics2D2, int n6, int n7, int n8, int n9, Insets insets, float f2, float f3, float f4, float f5, int n10) {
        if (insets != null) {
            n6 += insets.left;
            n7 += insets.top;
            n8 -= insets.left + insets.right;
            n9 -= insets.top + insets.bottom;
        }
        if (f2 > 0.0f || f3 > 0.0f || f4 > 0.0f || f5 > 0.0f) {
            double d3 = UIScale.getSystemScaleFactor(graphics2D2);
            if (d3 != (double)((int)d3)) {
                HiDPIUtils.paintAtScale1x(graphics2D2, n6, n7, n8, n9, (graphics2D, n2, n3, n4, n5, d2) -> FlatUIUtils.paintRoundedSelectionImpl(graphics2D, n2, n3, n4, n5, (float)((double)f2 * d2), (float)((double)f3 * d2), (float)((double)f4 * d2), (float)((double)f5 * d2)));
            } else {
                FlatUIUtils.paintRoundedSelectionImpl(graphics2D2, n6, n7, n8, n9, f2, f3, f4, f5);
            }
        } else {
            graphics2D2.fillRect(n6, n7, n8, n9);
        }
    }

    private static void paintRoundedSelectionImpl(Graphics2D graphics2D, int n2, int n3, int n4, int n5, float f2, float f3, float f4, float f5) {
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics2D);
        graphics2D.fill(FlatUIUtils.createRoundRectanglePath(n2, n3, n4, n5, f2, f3, f4, f5));
        FlatUIUtils.resetRenderingHints(graphics2D, objectArray);
    }

    public static void paintGrip(Graphics graphics, int n2, int n3, int n4, int n5, boolean bl2, int n6, int n7, int n8, boolean bl3) {
        float f2;
        float f3;
        n7 = UIScale.scale(n7);
        n8 = UIScale.scale(n8);
        int n9 = n7 * n6 + n8 * (n6 - 1);
        if (bl2) {
            f3 = n2 + Math.round((float)(n4 - n9) / 2.0f);
            f2 = (float)n3 + (float)(n5 - n7) / 2.0f;
            if (!bl3) {
                f2 = Math.round(f2);
            }
        } else {
            f3 = (float)n2 + (float)(n4 - n7) / 2.0f;
            f2 = n3 + Math.round((float)(n5 - n9) / 2.0f);
            if (!bl3) {
                f3 = Math.round(f3);
            }
        }
        for (int i2 = 0; i2 < n6; ++i2) {
            ((Graphics2D)graphics).fill(new Ellipse2D.Float(f3, f2, n7, n7));
            if (bl2) {
                f3 += (float)(n7 + n8);
                continue;
            }
            f2 += (float)(n7 + n8);
        }
    }

    public static void paintParentBackground(Graphics graphics, JComponent jComponent) {
        Color color = FlatUIUtils.getParentBackground(jComponent);
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, jComponent.getWidth(), jComponent.getHeight());
        }
    }

    public static Color getParentBackground(JComponent jComponent) {
        Color color;
        Container container = FlatUIUtils.findOpaqueParent(jComponent);
        Color color2 = color = container != null ? container.getBackground() : null;
        if (color != null) {
            return color;
        }
        if (FlatUIUtils.isAWTPeer(jComponent)) {
            return jComponent instanceof JTextField || jComponent instanceof JScrollPane || jComponent.getBackground() == null ? SystemColor.window : jComponent.getBackground();
        }
        return UIManager.getColor("Panel.background");
    }

    private static Container findOpaqueParent(Container container) {
        while ((container = container.getParent()) != null) {
            if (!container.isOpaque()) continue;
            return container;
        }
        return null;
    }

    public static Path2D createRectangle(float f2, float f3, float f4, float f5, float f6) {
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(new Rectangle2D.Float(f2, f3, f4, f5), false);
        float_.append(new Rectangle2D.Float(f2 + f6, f3 + f6, f4 - f6 * 2.0f, f5 - f6 * 2.0f), false);
        return float_;
    }

    public static Path2D createRoundRectangle(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        Path2D.Float float_ = new Path2D.Float(0);
        float_.append(FlatUIUtils.createRoundRectanglePath(f2, f3, f4, f5, f7, f8, f9, f10), false);
        float_.append(FlatUIUtils.createRoundRectanglePath(f2 + f6, f3 + f6, f4 - f6 * 2.0f, f5 - f6 * 2.0f, f7 - f6, f8 - f6, f9 - f6, f10 - f6), false);
        return float_;
    }

    public static Shape createRoundRectanglePath(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        if (f6 <= 0.0f && f7 <= 0.0f && f8 <= 0.0f && f9 <= 0.0f) {
            return new Rectangle2D.Float(f2, f3, f4, f5);
        }
        float f10 = Math.min(f4, f5) / 2.0f;
        f6 = f6 > 0.0f ? Math.min(f6, f10) : 0.0f;
        f7 = f7 > 0.0f ? Math.min(f7, f10) : 0.0f;
        f8 = f8 > 0.0f ? Math.min(f8, f10) : 0.0f;
        f9 = f9 > 0.0f ? Math.min(f9, f10) : 0.0f;
        float f11 = f2 + f4;
        float f12 = f3 + f5;
        double d2 = 0.5522847498307933;
        double d3 = 1.0 - d2;
        double d4 = (double)f6 * d3;
        double d5 = (double)f7 * d3;
        double d6 = (double)f8 * d3;
        double d7 = (double)f9 * d3;
        Path2D.Float float_ = new Path2D.Float(1, 16);
        ((Path2D)float_).moveTo(f11 - f7, f3);
        ((Path2D)float_).curveTo((double)f11 - d5, f3, f11, (double)f3 + d5, f11, f3 + f7);
        ((Path2D)float_).lineTo(f11, f12 - f9);
        ((Path2D)float_).curveTo(f11, (double)f12 - d7, (double)f11 - d7, f12, f11 - f9, f12);
        ((Path2D)float_).lineTo(f2 + f8, f12);
        ((Path2D)float_).curveTo((double)f2 + d6, f12, f2, (double)f12 - d6, f2, f12 - f8);
        ((Path2D)float_).lineTo(f2, f3 + f6);
        ((Path2D)float_).curveTo(f2, (double)f3 + d4, (double)f2 + d4, f3, f2 + f6, f3);
        float_.closePath();
        return float_;
    }

    public static Shape createRoundTrianglePath(float f2, float f3, float f4, float f5, float f6, float f7, float f8) {
        double d2 = (FlatUIUtils.distance(f2, f3, f4, f5) + FlatUIUtils.distance(f4, f5, f6, f7) + FlatUIUtils.distance(f6, f7, f2, f3)) / 3.0;
        double d3 = 1.0 / d2 * (double)f8;
        double d4 = 1.0 - d3;
        return FlatUIUtils.createPath(FlatUIUtils.lerp(f6, f2, d4), FlatUIUtils.lerp(f7, f3, d4), -1.000000000002E12, f2, f3, FlatUIUtils.lerp(f2, f4, d3), FlatUIUtils.lerp(f3, f5, d3), FlatUIUtils.lerp(f2, f4, d4), FlatUIUtils.lerp(f3, f5, d4), -1.000000000002E12, f4, f5, FlatUIUtils.lerp(f4, f6, d3), FlatUIUtils.lerp(f5, f7, d3), FlatUIUtils.lerp(f4, f6, d4), FlatUIUtils.lerp(f5, f7, d4), -1.000000000002E12, f6, f7, FlatUIUtils.lerp(f6, f2, d3), FlatUIUtils.lerp(f7, f3, d3));
    }

    public static void paintArrow(Graphics2D graphics2D, int n2, int n3, int n4, int n5, int n6, boolean bl2, int n7, float f2, float f3, float f4) {
        boolean bl3;
        float f5 = UIScale.scale(n7 + (bl2 ? -1 : 0));
        float f6 = bl2 ? f5 / 2.0f : (float)UIScale.scale(n7 / 2 + 1);
        boolean bl4 = bl3 = n6 == 1 || n6 == 5;
        if (!bl3) {
            float f7 = f5;
            f5 = f6;
            f6 = f7;
        }
        boolean bl5 = bl2;
        float f8 = ((float)n4 - (f5 + (float)bl5)) / 2.0f + UIScale.scale(f3);
        float f9 = ((float)n5 - (f6 + (float)bl5)) / 2.0f + UIScale.scale(f4);
        float f10 = (float)n2 + (n6 == 7 ? (float)(-Math.round(-(f8 + f5))) - f5 : (float)Math.round(f8));
        float f11 = (float)n3 + (n6 == 1 ? (float)(-Math.round(-(f9 + f6))) - f6 : (float)Math.round(f9));
        graphics2D.translate(f10, f11);
        Shape shape = FlatUIUtils.createArrowShape(n6, bl2, f5, f6);
        if (bl2) {
            Stroke stroke = graphics2D.getStroke();
            graphics2D.setStroke(new BasicStroke(UIScale.scale(f2)));
            FlatUIUtils.drawShapePure(graphics2D, shape);
            graphics2D.setStroke(stroke);
        } else {
            graphics2D.fill(shape);
        }
        graphics2D.translate(-f10, -f11);
    }

    public static Shape createArrowShape(int n2, boolean bl2, float f2, float f3) {
        switch (n2) {
            case 1: {
                return FlatUIUtils.createPath(!bl2, 0.0, f3, f2 / 2.0f, 0.0, f2, f3);
            }
            case 5: {
                return FlatUIUtils.createPath(!bl2, 0.0, 0.0, f2 / 2.0f, f3, f2, 0.0);
            }
            case 7: {
                return FlatUIUtils.createPath(!bl2, f2, 0.0, 0.0, f3 / 2.0f, f2, f3);
            }
            case 3: {
                return FlatUIUtils.createPath(!bl2, 0.0, 0.0, f2, f3 / 2.0f, 0.0, f3);
            }
        }
        return new Path2D.Float();
    }

    public static Path2D createPath(double ... dArray) {
        return FlatUIUtils.createPath(true, dArray);
    }

    public static Path2D createPath(boolean bl2, double ... dArray) {
        Path2D.Float float_ = new Path2D.Float(1, dArray.length / 2 + (bl2 ? 1 : 0));
        ((Path2D)float_).moveTo(dArray[0], dArray[1]);
        int n2 = 2;
        while (n2 < dArray.length) {
            double d2 = dArray[n2];
            if (d2 == -1.000000000001E12) {
                ((Path2D)float_).moveTo(dArray[n2 + 1], dArray[n2 + 2]);
                n2 += 3;
                continue;
            }
            if (d2 == -1.000000000002E12) {
                ((Path2D)float_).quadTo(dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4]);
                n2 += 5;
                continue;
            }
            if (d2 == -1.000000000003E12) {
                ((Path2D)float_).curveTo(dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5], dArray[n2 + 6]);
                n2 += 7;
                continue;
            }
            if (d2 == -1.000000000004E12) {
                double d3 = dArray[n2 + 1];
                double d4 = dArray[n2 + 2];
                double d5 = dArray[n2 + 3];
                int n3 = n2 + 4;
                if (dArray[n3] == -1.000000000002E12 || dArray[n3] == -1.000000000004E12) {
                    ++n3;
                }
                Point2D point2D = float_.getCurrentPoint();
                double d6 = point2D.getX();
                double d7 = point2D.getY();
                double d8 = dArray[n3];
                double d9 = dArray[n3 + 1];
                double d10 = FlatUIUtils.distance(d3, d4, d6, d7);
                double d11 = FlatUIUtils.distance(d3, d4, d8, d9);
                double d12 = 1.0 - 1.0 / d10 * d5;
                double d13 = 1.0 / d11 * d5;
                ((Path2D)float_).lineTo(FlatUIUtils.lerp(d6, d3, d12), FlatUIUtils.lerp(d7, d4, d12));
                ((Path2D)float_).quadTo(d3, d4, FlatUIUtils.lerp(d3, d8, d13), FlatUIUtils.lerp(d4, d9, d13));
                n2 += 4;
                continue;
            }
            if (d2 == -1.000000000005E12) {
                float_.closePath();
                ++n2;
                continue;
            }
            ((Path2D)float_).lineTo(d2, dArray[n2 + 1]);
            n2 += 2;
        }
        if (bl2) {
            float_.closePath();
        }
        return float_;
    }

    private static double lerp(double d2, double d3, double d4) {
        return d2 * (1.0 - d4) + d3 * d4;
    }

    private static double distance(double d2, double d3, double d4, double d5) {
        double d6 = d4 - d2;
        double d7 = d5 - d3;
        return Math.sqrt(d6 * d6 + d7 * d7);
    }

    public static void drawShapePure(Graphics2D graphics2D, Shape shape) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_STROKE_CONTROL);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.translate(0.5, 0.5);
        graphics2D.draw(shape);
        graphics2D.translate(-0.5, -0.5);
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, object);
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n2, int n3) {
        HiDPIUtils.drawStringWithYCorrection(jComponent, (Graphics2D)graphics, string, n2, n3);
    }

    public static void drawStringUnderlineCharAt(JComponent jComponent, Graphics graphics, String string, int n2, int n3, int n4) {
        if (n2 >= 0 && UIScale.getUserScaleFactor() > 1.0f) {
            graphics = new Graphics2DProxy((Graphics2D)graphics){

                @Override
                public void fillRect(int n2, int n3, int n4, int n5) {
                    if (n5 == 1) {
                        n5 = Math.round(UIScale.scale(0.9f));
                        n3 += n5 - 1;
                    }
                    super.fillRect(n2, n3, n4, n5);
                }
            };
        }
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(jComponent, (Graphics2D)graphics, string, n2, n3, n4);
    }

    public static boolean hasOpaqueBeenExplicitlySet(JComponent jComponent) {
        boolean bl2 = jComponent.isOpaque();
        LookAndFeel.installProperty(jComponent, "opaque", !bl2);
        boolean bl3 = jComponent.isOpaque() == bl2;
        LookAndFeel.installProperty(jComponent, "opaque", bl2);
        return bl3;
    }

    public static boolean isUseSharedUIs() {
        return useSharedUIs;
    }

    public static boolean setUseSharedUIs(boolean bl2) {
        boolean bl3 = useSharedUIs;
        useSharedUIs = bl2;
        return bl3;
    }

    public static ComponentUI createSharedUI(Object object2, Supplier<ComponentUI> supplier) {
        if (!useSharedUIs) {
            return supplier.get();
        }
        return sharedUIinstances.computeIfAbsent(UIManager.getLookAndFeel(), lookAndFeel -> new IdentityHashMap()).computeIfAbsent(object2, object -> (ComponentUI)supplier.get());
    }

    public static boolean canUseSharedUI(JComponent jComponent) {
        return !FlatStylingSupport.hasStyleProperty(jComponent);
    }

    private static class NonUIResourceBorder
    implements Border {
        private final Border delegate;

        NonUIResourceBorder(Border border) {
            this.delegate = border;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n2, int n3, int n4, int n5) {
            this.delegate.paintBorder(component, graphics, n2, n3, n4, n5);
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return this.delegate.getBorderInsets(component);
        }

        @Override
        public boolean isBorderOpaque() {
            return this.delegate.isBorderOpaque();
        }
    }

    public static class RepaintFocusListener
    implements FocusListener {
        private final Component repaintComponent;
        private final Predicate<Component> repaintCondition;

        public RepaintFocusListener(Component component, Predicate<Component> predicate) {
            this.repaintComponent = component;
            this.repaintCondition = predicate;
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                HiDPIUtils.repaint(this.repaintComponent);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (this.repaintCondition == null || this.repaintCondition.test(this.repaintComponent)) {
                HiDPIUtils.repaint(this.repaintComponent);
            }
        }
    }
}

