/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.ui;

import com.formdev.flatlaf.FlatClientProperties;
import com.formdev.flatlaf.ui.FlatNativeMacLibrary;
import com.formdev.flatlaf.ui.FlatUIUtils;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class FullWindowContentSupport {
    private static final String KEY_DEBUG_SHOW_PLACEHOLDERS = "FlatLaf.debug.panel.showPlaceholders";
    private static ArrayList<WeakReference<JComponent>> placeholders = new ArrayList();

    FullWindowContentSupport() {
    }

    static Dimension getPlaceholderPreferredSize(JComponent jComponent, String string) {
        Rectangle rectangle;
        Rectangle rectangle2;
        JRootPane jRootPane;
        if (!string.startsWith(SystemInfo.isMacOS ? "mac" : "win") || !jComponent.isDisplayable() || (jRootPane = SwingUtilities.getRootPane(jComponent)) == null || (rectangle2 = (Rectangle)jRootPane.getClientProperty("FlatLaf.fullWindowContent.buttonsBounds")) == null) {
            return new Dimension(0, 0);
        }
        if (string.length() > 3 && (string.contains("leftToRight") && !jComponent.getComponentOrientation().isLeftToRight() || string.contains("rightToLeft") && jComponent.getComponentOrientation().isLeftToRight())) {
            return new Dimension(0, 0);
        }
        if (SystemInfo.isMacFullWindowContentSupported && FlatNativeMacLibrary.isLoaded() && (rectangle = FlatNativeMacLibrary.getWindowButtonsBounds(SwingUtilities.windowForComponent(jComponent))) != null) {
            rectangle2 = rectangle;
        }
        int n2 = rectangle2.width;
        int n3 = rectangle2.height;
        if (string.length() > 3) {
            if (n2 == 0 && string.contains("zeroInFullScreen")) {
                n3 = 0;
            }
            if (string.contains("horizontal")) {
                n3 = 0;
            }
            if (string.contains("vertical")) {
                n2 = 0;
            }
        }
        return new Dimension(n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void registerPlaceholder(JComponent jComponent) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            if (FullWindowContentSupport.indexOfPlaceholder(jComponent) < 0) {
                placeholders.add(new WeakReference<JComponent>(jComponent));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unregisterPlaceholder(JComponent jComponent) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            int n2 = FullWindowContentSupport.indexOfPlaceholder(jComponent);
            if (n2 >= 0) {
                placeholders.remove(n2);
            }
        }
    }

    private static int indexOfPlaceholder(JComponent jComponent) {
        int n2 = placeholders.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (placeholders.get(i2).get() != jComponent) continue;
            return i2;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void revalidatePlaceholders(Component component) {
        ArrayList<WeakReference<JComponent>> arrayList = placeholders;
        synchronized (arrayList) {
            if (placeholders.isEmpty()) {
                return;
            }
            Iterator<WeakReference<JComponent>> iterator = placeholders.iterator();
            while (iterator.hasNext()) {
                WeakReference<JComponent> weakReference = iterator.next();
                JComponent jComponent = (JComponent)weakReference.get();
                if (jComponent == null) {
                    iterator.remove();
                    continue;
                }
                if (!SwingUtilities.isDescendingFrom(jComponent, component)) continue;
                jComponent.revalidate();
            }
        }
    }

    static ComponentListener macInstallListeners(final JRootPane jRootPane) {
        ComponentAdapter componentAdapter = new ComponentAdapter(){
            boolean lastFullScreen;

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                boolean bl2;
                Window window = SwingUtilities.windowForComponent(jRootPane);
                if (window == null) {
                    return;
                }
                boolean bl3 = bl2 = FlatNativeMacLibrary.isLoaded() && FlatNativeMacLibrary.isWindowFullScreen(window);
                if (bl2 == this.lastFullScreen) {
                    return;
                }
                this.lastFullScreen = bl2;
                FullWindowContentSupport.macUpdateFullWindowContentButtonsBoundsProperty(jRootPane);
            }
        };
        jRootPane.addComponentListener(componentAdapter);
        return componentAdapter;
    }

    static void macUninstallListeners(JRootPane jRootPane, ComponentListener componentListener) {
        if (componentListener != null) {
            jRootPane.removeComponentListener(componentListener);
        }
    }

    static void macUpdateFullWindowContentButtonsBoundsProperty(JRootPane jRootPane) {
        if (!SystemInfo.isMacFullWindowContentSupported || !jRootPane.isDisplayable()) {
            return;
        }
        Rectangle rectangle = null;
        if (FlatClientProperties.clientPropertyBoolean(jRootPane, "apple.awt.fullWindowContent", false)) {
            rectangle = FlatNativeMacLibrary.isLoaded() ? FlatNativeMacLibrary.getWindowButtonsBounds(SwingUtilities.windowForComponent(jRootPane)) : new Rectangle(68, 28);
        }
        jRootPane.putClientProperty("FlatLaf.fullWindowContent.buttonsBounds", rectangle);
    }

    static void macUninstallFullWindowContentButtonsBoundsProperty(JRootPane jRootPane) {
        if (!SystemInfo.isMacFullWindowContentSupported) {
            return;
        }
        jRootPane.putClientProperty("FlatLaf.fullWindowContent.buttonsBounds", null);
    }

    static void debugPaint(Graphics graphics, JComponent jComponent) {
        Rectangle rectangle;
        if (!UIManager.getBoolean(KEY_DEBUG_SHOW_PLACEHOLDERS)) {
            return;
        }
        int n2 = jComponent.getWidth();
        int n3 = jComponent.getHeight();
        if (n2 <= 0 || n3 <= 0) {
            return;
        }
        graphics.setColor(Color.red);
        FullWindowContentSupport.debugPaintRect(graphics, new Rectangle(n2, n3));
        JRootPane jRootPane = SwingUtilities.getRootPane(jComponent);
        if (jRootPane != null && (rectangle = (Rectangle)jRootPane.getClientProperty("FlatLaf.fullWindowContent.buttonsBounds")) != null && (rectangle.width != n2 || rectangle.height != n3)) {
            graphics.setColor(Color.magenta);
            FullWindowContentSupport.debugPaintRect(graphics, SwingUtilities.convertRectangle(jRootPane, rectangle, jComponent));
        }
    }

    private static void debugPaintRect(Graphics graphics, Rectangle rectangle) {
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width - 1, rectangle.height - 1);
        int n2 = rectangle.x + rectangle.width - 1;
        int n3 = rectangle.y + rectangle.height - 1;
        Object[] objectArray = FlatUIUtils.setRenderingHints(graphics);
        graphics.drawLine(rectangle.x, rectangle.y, n2, n3);
        graphics.drawLine(rectangle.x, n3, n2, rectangle.y);
        FlatUIUtils.resetRenderingHints(graphics, objectArray);
    }
}

