/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.Animator;

public class CubicBezierEasing
implements Animator.Interpolator {
    public static final CubicBezierEasing STANDARD_EASING = new CubicBezierEasing(0.4f, 0.0f, 0.2f, 1.0f);
    public static final CubicBezierEasing EASE = new CubicBezierEasing(0.25f, 0.1f, 0.25f, 1.0f);
    public static final CubicBezierEasing EASE_IN = new CubicBezierEasing(0.42f, 0.0f, 1.0f, 1.0f);
    public static final CubicBezierEasing EASE_IN_OUT = new CubicBezierEasing(0.42f, 0.0f, 0.58f, 1.0f);
    public static final CubicBezierEasing EASE_OUT = new CubicBezierEasing(0.0f, 0.0f, 0.58f, 1.0f);
    private final float x1;
    private final float y1;
    private final float x2;
    private final float y2;

    public CubicBezierEasing(float f2, float f3, float f4, float f5) {
        if (f2 < 0.0f || f2 > 1.0f || f3 < 0.0f || f3 > 1.0f || f4 < 0.0f || f4 > 1.0f || f5 < 0.0f || f5 > 1.0f) {
            throw new IllegalArgumentException("control points must be in range [0, 1]");
        }
        this.x1 = f2;
        this.y1 = f3;
        this.x2 = f4;
        this.y2 = f5;
    }

    @Override
    public float interpolate(float f2) {
        if (f2 <= 0.0f || f2 >= 1.0f) {
            return f2;
        }
        float f3 = 0.0f;
        float f4 = 1.0f;
        float f5;
        float f6;
        while (!(Math.abs(f2 - (f6 = CubicBezierEasing.cubicBezier(f5 = (f3 + f4) / 2.0f, this.x1, this.x2))) < 5.0E-4f)) {
            if (f6 < f2) {
                f3 = f5;
                continue;
            }
            f4 = f5;
        }
        return CubicBezierEasing.cubicBezier(f5, this.y1, this.y2);
    }

    private static float cubicBezier(float f2, float f3, float f4) {
        float f5 = 1.0f - f2;
        float f6 = 3.0f * f2 * (f5 * f5);
        float f7 = 3.0f * (f2 * f2) * f5;
        float f8 = f2 * f2 * f2;
        return f6 * f3 + f7 * f4 + f8;
    }
}

