/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.util.LoggingFacade;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.plaf.UIResource;
import javax.swing.text.StyleContext;

public class FontUtils {
    private static Map<String, Runnable> loadersMap;

    public static Font getCompositeFont(String string, int n2, int n3) {
        FontUtils.loadFontFamily(string);
        Font font = StyleContext.getDefaultStyleContext().getFont(string, n2, n3);
        if (font instanceof UIResource) {
            font = font.deriveFont(font.getStyle());
        }
        return font;
    }

    public static void registerFontFamilyLoader(String string, Runnable runnable) {
        if (loadersMap == null) {
            loadersMap = new HashMap<String, Runnable>();
        }
        loadersMap.put(string, runnable);
    }

    public static void loadFontFamily(String string) {
        if (!FontUtils.hasLoaders()) {
            return;
        }
        Runnable runnable = loadersMap.remove(string);
        if (runnable != null) {
            runnable.run();
        }
        if (loadersMap.isEmpty()) {
            loadersMap = null;
        }
    }

    public static boolean installFont(URL uRL) {
        boolean bl2;
        block8: {
            InputStream inputStream = uRL.openStream();
            try {
                Font font = Font.createFont(0, inputStream);
                bl2 = GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FontFormatException | IOException exception) {
                    LoggingFacade.INSTANCE.logSevere("FlatLaf: Failed to install font " + uRL, exception);
                    return false;
                }
            }
            inputStream.close();
        }
        return bl2;
    }

    public static String[] getAvailableFontFamilyNames() {
        String[] stringArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        if (!FontUtils.hasLoaders()) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length + loadersMap.size());
        for (String string : stringArray) {
            arrayList.add(string);
        }
        for (String string : loadersMap.keySet()) {
            if (arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static Font[] getAllFonts() {
        if (FontUtils.hasLoaders()) {
            String[] stringArray;
            for (String string : stringArray = loadersMap.keySet().toArray(new String[loadersMap.size()])) {
                FontUtils.loadFontFamily(string);
            }
        }
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
    }

    private static boolean hasLoaders() {
        return loadersMap != null && !loadersMap.isEmpty();
    }
}

