/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private final float brightness;
    private final float contrast;
    private final int alpha;
    private final int origContrast;
    private final int origBrightness;

    public static GrayFilter createDisabledIconFilter(boolean bl2) {
        return bl2 ? new GrayFilter(-20, -70, 100) : new GrayFilter(25, -25, 100);
    }

    public GrayFilter(int n2, int n3, int n4) {
        this.origBrightness = Math.max(-100, Math.min(100, n2));
        this.origContrast = Math.max(-100, Math.min(100, n3));
        this.alpha = Math.max(0, Math.min(100, n4));
        this.brightness = (float)(Math.pow(this.origBrightness, 3.0) / 10000.0);
        this.contrast = (float)this.origContrast / 100.0f;
        this.canFilterIndexColorModel = true;
    }

    public GrayFilter() {
        this(0, 0, 100);
    }

    public int getBrightness() {
        return this.origBrightness;
    }

    public int getContrast() {
        return this.origContrast;
    }

    public int getAlpha() {
        return this.alpha;
    }

    @Override
    public int filterRGB(int n2, int n3, int n4) {
        int n5 = (int)(0.3 * (double)(n4 >> 16 & 0xFF) + 0.59 * (double)(n4 >> 8 & 0xFF) + 0.11 * (double)(n4 & 0xFF));
        n5 = this.brightness >= 0.0f ? (int)(((float)n5 + this.brightness * 255.0f) / (1.0f + this.brightness)) : (int)((float)n5 / (1.0f - this.brightness));
        n5 = this.contrast >= 0.0f ? (n5 >= 127 ? (int)((float)n5 + (float)(255 - n5) * this.contrast) : (int)((float)n5 - (float)n5 * this.contrast)) : (int)(127.0f + (float)(n5 - 127) * (this.contrast + 1.0f));
        int n6 = this.alpha != 100 ? (n4 >> 24 & 0xFF) * this.alpha / 100 << 24 : n4 & 0xFF000000;
        return n6 | n5 << 16 | n5 << 8 | n5;
    }
}

