/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import java.awt.Color;

public class HSLColor {
    private final Color rgb;
    private final float[] hsl;
    private final float alpha;

    public HSLColor(Color color) {
        this.rgb = color;
        this.hsl = HSLColor.fromRGB(color);
        this.alpha = (float)color.getAlpha() / 255.0f;
    }

    public HSLColor(float f2, float f3, float f4) {
        this(f2, f3, f4, 1.0f);
    }

    public HSLColor(float f2, float f3, float f4, float f5) {
        this.hsl = new float[]{f2, f3, f4};
        this.alpha = f5;
        this.rgb = HSLColor.toRGB(this.hsl, f5);
    }

    public HSLColor(float[] fArray) {
        this(fArray, 1.0f);
    }

    public HSLColor(float[] fArray, float f2) {
        this.hsl = fArray;
        this.alpha = f2;
        this.rgb = HSLColor.toRGB(fArray, f2);
    }

    public Color adjustHue(float f2) {
        return HSLColor.toRGB(f2, this.hsl[1], this.hsl[2], this.alpha);
    }

    public Color adjustLuminance(float f2) {
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f2, this.alpha);
    }

    public Color adjustSaturation(float f2) {
        return HSLColor.toRGB(this.hsl[0], f2, this.hsl[2], this.alpha);
    }

    public Color adjustShade(float f2) {
        float f3 = (100.0f - f2) / 100.0f;
        float f4 = Math.max(0.0f, this.hsl[2] * f3);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f4, this.alpha);
    }

    public Color adjustTone(float f2) {
        float f3 = (100.0f + f2) / 100.0f;
        float f4 = Math.min(100.0f, this.hsl[2] * f3);
        return HSLColor.toRGB(this.hsl[0], this.hsl[1], f4, this.alpha);
    }

    public float getAlpha() {
        return this.alpha;
    }

    public Color getComplementary() {
        float f2 = (this.hsl[0] + 180.0f) % 360.0f;
        return HSLColor.toRGB(f2, this.hsl[1], this.hsl[2]);
    }

    public float getHue() {
        return this.hsl[0];
    }

    public float[] getHSL() {
        return this.hsl;
    }

    public float getLuminance() {
        return this.hsl[2];
    }

    public Color getRGB() {
        return this.rgb;
    }

    public float getSaturation() {
        return this.hsl[1];
    }

    public String toString() {
        String string = "HSLColor[h=" + this.hsl[0] + ",s=" + this.hsl[1] + ",l=" + this.hsl[2] + ",alpha=" + this.alpha + "]";
        return string;
    }

    public static float[] fromRGB(Color color) {
        float[] fArray = color.getRGBColorComponents(null);
        float f2 = fArray[0];
        float f3 = fArray[1];
        float f4 = fArray[2];
        float f5 = Math.min(f2, Math.min(f3, f4));
        float f6 = Math.max(f2, Math.max(f3, f4));
        float f7 = 0.0f;
        if (f6 == f5) {
            f7 = 0.0f;
        } else if (f6 == f2) {
            f7 = (60.0f * (f3 - f4) / (f6 - f5) + 360.0f) % 360.0f;
        } else if (f6 == f3) {
            f7 = 60.0f * (f4 - f2) / (f6 - f5) + 120.0f;
        } else if (f6 == f4) {
            f7 = 60.0f * (f2 - f3) / (f6 - f5) + 240.0f;
        }
        float f8 = (f6 + f5) / 2.0f;
        float f9 = f6 == f5 ? 0.0f : (f8 <= 0.5f ? (f6 - f5) / (f6 + f5) : (f6 - f5) / (2.0f - f6 - f5));
        return new float[]{f7, f9 * 100.0f, f8 * 100.0f};
    }

    public static Color toRGB(float[] fArray) {
        return HSLColor.toRGB(fArray, 1.0f);
    }

    public static Color toRGB(float[] fArray, float f2) {
        return HSLColor.toRGB(fArray[0], fArray[1], fArray[2], f2);
    }

    public static Color toRGB(float f2, float f3, float f4) {
        return HSLColor.toRGB(f2, f3, f4, 1.0f);
    }

    public static Color toRGB(float f2, float f3, float f4, float f5) {
        if (f3 < 0.0f || f3 > 100.0f) {
            String string = "Color parameter outside of expected range - Saturation";
            throw new IllegalArgumentException(string);
        }
        if (f4 < 0.0f || f4 > 100.0f) {
            String string = "Color parameter outside of expected range - Luminance";
            throw new IllegalArgumentException(string);
        }
        if (f5 < 0.0f || f5 > 1.0f) {
            String string = "Color parameter outside of expected range - Alpha";
            throw new IllegalArgumentException(string);
        }
        f2 %= 360.0f;
        float f6 = (double)(f4 /= 100.0f) < 0.5 ? f4 * (1.0f + f3) : f4 + (f3 /= 100.0f) - f3 * f4;
        float f7 = 2.0f * f4 - f6;
        float f8 = Math.max(0.0f, HSLColor.HueToRGB(f7, f6, (f2 /= 360.0f) + 0.33333334f));
        float f9 = Math.max(0.0f, HSLColor.HueToRGB(f7, f6, f2));
        float f10 = Math.max(0.0f, HSLColor.HueToRGB(f7, f6, f2 - 0.33333334f));
        f8 = Math.min(f8, 1.0f);
        f9 = Math.min(f9, 1.0f);
        f10 = Math.min(f10, 1.0f);
        return new Color(f8, f9, f10, f5);
    }

    private static float HueToRGB(float f2, float f3, float f4) {
        if (f4 < 0.0f) {
            f4 += 1.0f;
        }
        if (f4 > 1.0f) {
            f4 -= 1.0f;
        }
        if (6.0f * f4 < 1.0f) {
            return f2 + (f3 - f2) * 6.0f * f4;
        }
        if (2.0f * f4 < 1.0f) {
            return f3;
        }
        if (3.0f * f4 < 2.0f) {
            return f2 + (f3 - f2) * 6.0f * (0.6666667f - f4);
        }
        return f2;
    }
}

