/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.Graphics2DProxy;
import com.formdev.flatlaf.util.JavaCompatibility;
import com.formdev.flatlaf.util.SystemInfo;
import com.formdev.flatlaf.util.UIScale;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import javax.swing.JComponent;
import javax.swing.RepaintManager;

public class HiDPIUtils {
    private static Boolean useTextYCorrection;
    private static final float[] SCALE_FACTORS;
    private static final float[] CORRECTION_SEGOE_UI;
    private static final float[] CORRECTION_TAHOMA;
    private static final float[] CORRECTION_INTER;
    private static final float[] CORRECTION_OPEN_SANS;
    private static Boolean useDebugScaleFactor;

    public static void paintAtScale1x(Graphics2D graphics2D, JComponent jComponent, Painter painter) {
        HiDPIUtils.paintAtScale1x(graphics2D, 0, 0, jComponent.getWidth(), jComponent.getHeight(), painter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintAtScale1x(Graphics2D graphics2D, int n2, int n3, int n4, int n5, Painter painter) {
        double d2;
        double d3;
        boolean bl2;
        AffineTransform affineTransform = graphics2D.getTransform();
        double d4 = affineTransform.getScaleX();
        double d5 = affineTransform.getScaleY();
        double d6 = affineTransform.getShearX();
        double d7 = affineTransform.getShearY();
        boolean bl3 = bl2 = d6 != 0.0 || d7 != 0.0 || d4 <= 0.0 || d5 <= 0.0;
        if (bl2) {
            d3 = Math.hypot(d4, d6);
            d2 = Math.hypot(d5, d7);
        } else {
            d3 = Math.abs(d4);
            d2 = Math.abs(d5);
        }
        if (d3 == 1.0 && d2 == 1.0) {
            painter.paint(graphics2D, n2, n3, n4, n5, 1.0);
            return;
        }
        double d8 = (double)n2 * d4 + (double)n3 * d6 + affineTransform.getTranslateX();
        double d9 = (double)n3 * d5 + (double)n2 * d7 + affineTransform.getTranslateY();
        Rectangle2D.Double double_ = HiDPIUtils.scale(d3, d2, d8, d9, n4, n5);
        try {
            AffineTransform affineTransform2;
            if (bl2) {
                affineTransform2 = new AffineTransform(d4, d7, d6, d5, Math.floor(double_.x), Math.floor(double_.y));
                affineTransform2.scale(1.0 / d3, 1.0 / d2);
            } else {
                affineTransform2 = new AffineTransform(1.0, 0.0, 0.0, 1.0, Math.floor(double_.x), Math.floor(double_.y));
            }
            graphics2D.setTransform(affineTransform2);
            int n6 = (int)double_.width;
            int n7 = (int)double_.height;
            painter.paint(graphics2D, 0, 0, n6, n7, d3);
        }
        finally {
            graphics2D.setTransform(affineTransform);
        }
    }

    private static Rectangle2D.Double scale(double d2, double d3, double d4, double d5, int n2, int n3) {
        double d6 = HiDPIUtils.normalize(d4);
        double d7 = HiDPIUtils.normalize(d5);
        double d8 = HiDPIUtils.normalize(d4 + (double)n2 * d2) - d6;
        double d9 = HiDPIUtils.normalize(d5 + (double)n3 * d3) - d7;
        return new Rectangle2D.Double(d6, d7, d8, d9);
    }

    private static double normalize(double d2) {
        return Math.floor(d2 + 0.25) + 0.25;
    }

    private static boolean useTextYCorrection() {
        if (useTextYCorrection == null) {
            useTextYCorrection = FlatSystemProperties.getBoolean("flatlaf.useTextYCorrection", true);
        }
        return useTextYCorrection;
    }

    public static float computeTextYCorrection(Graphics2D graphics2D) {
        if (!HiDPIUtils.useTextYCorrection() || !SystemInfo.isWindows) {
            return 0.0f;
        }
        if (!SystemInfo.isJava_9_orLater) {
            float f2 = HiDPIUtils.getUserScaleFactor();
            if (f2 > 1.0f) {
                switch (graphics2D.getFont().getFamily()) {
                    case "Segoe UI": 
                    case "Segoe UI Light": 
                    case "Segoe UI Semibold": {
                        return -((f2 == 2.25f || f2 == 4.0f ? 0.875f : 0.625f) * f2);
                    }
                    case "Noto Sans": 
                    case "Open Sans": {
                        return -(0.3f * f2);
                    }
                    case "Verdana": {
                        return -((f2 < 2.0f ? 0.4f : 0.3f) * f2);
                    }
                }
            }
        } else {
            switch (graphics2D.getFont().getFamily()) {
                case "Segoe UI": 
                case "Segoe UI Light": 
                case "Segoe UI Semibold": 
                case "Verdana": 
                case "Dialog": 
                case "SansSerif": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_SEGOE_UI);
                }
                case "Tahoma": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_TAHOMA);
                }
                case "Inter": 
                case "Inter Light": 
                case "Inter Semi Bold": 
                case "Inter SemiBold": 
                case "Roboto": 
                case "Roboto Light": 
                case "Roboto Medium": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_INTER);
                }
                case "Noto Sans": 
                case "Open Sans": {
                    return HiDPIUtils.correctionForScaleY(graphics2D, CORRECTION_OPEN_SANS);
                }
            }
        }
        return 0.0f;
    }

    private static float correctionForScaleY(Graphics2D graphics2D, float[] fArray) {
        if (fArray.length != 9) {
            throw new IllegalArgumentException();
        }
        double d2 = graphics2D.getTransform().getScaleY();
        return d2 < 1.25 ? 0.0f : fArray[HiDPIUtils.scaleFactor2index((float)d2)];
    }

    private static int scaleFactor2index(float f2) {
        for (int i2 = 0; i2 < SCALE_FACTORS.length; ++i2) {
            if (!(f2 <= SCALE_FACTORS[i2])) continue;
            return i2;
        }
        return SCALE_FACTORS.length - 1;
    }

    private static boolean useDebugScaleFactor() {
        if (useDebugScaleFactor == null) {
            useDebugScaleFactor = FlatSystemProperties.getBoolean("FlatLaf.debug.HiDPIUtils.useDebugScaleFactor", false);
        }
        return useDebugScaleFactor;
    }

    private static float getUserScaleFactor() {
        return !HiDPIUtils.useDebugScaleFactor() ? UIScale.getUserScaleFactor() : Float.parseFloat(System.getProperty("FlatLaf.debug.HiDPIUtils.debugScaleFactor", "1"));
    }

    public static void drawStringWithYCorrection(JComponent jComponent, Graphics2D graphics2D, String string, int n2, int n3) {
        HiDPIUtils.drawStringUnderlineCharAtWithYCorrection(jComponent, graphics2D, string, -1, n2, n3);
    }

    public static void drawStringUnderlineCharAtWithYCorrection(JComponent jComponent, Graphics2D graphics2D, String string, int n2, int n3, int n4) {
        float f2 = HiDPIUtils.computeTextYCorrection(graphics2D);
        if (f2 != 0.0f) {
            graphics2D.translate(0.0, f2);
            JavaCompatibility.drawStringUnderlineCharAt(jComponent, graphics2D, string, n2, n3, n4);
            graphics2D.translate(0.0, -f2);
        } else {
            JavaCompatibility.drawStringUnderlineCharAt(jComponent, graphics2D, string, n2, n3, n4);
        }
    }

    public static Graphics2D createGraphicsTextYCorrection(Graphics2D graphics2D) {
        final float f2 = HiDPIUtils.computeTextYCorrection(graphics2D);
        if (f2 == 0.0f) {
            return graphics2D;
        }
        return new Graphics2DProxy(graphics2D){

            @Override
            public void drawString(String string, int n2, int n3) {
                super.drawString(string, (float)n2, (float)n3 + f2);
            }

            @Override
            public void drawString(String string, float f22, float f3) {
                super.drawString(string, f22, f3 + f2);
            }

            @Override
            public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n2, int n3) {
                super.drawString(attributedCharacterIterator, (float)n2, (float)n3 + f2);
            }

            @Override
            public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f22, float f3) {
                super.drawString(attributedCharacterIterator, f22, f3 + f2);
            }

            @Override
            public void drawChars(char[] cArray, int n2, int n3, int n4, int n5) {
                super.drawChars(cArray, n2, n3, n4, Math.round((float)n5 + f2));
            }

            @Override
            public void drawBytes(byte[] byArray, int n2, int n3, int n4, int n5) {
                super.drawBytes(byArray, n2, n3, n4, Math.round((float)n5 + f2));
            }

            @Override
            public void drawGlyphVector(GlyphVector glyphVector, float f22, float f3) {
                super.drawGlyphVector(glyphVector, f22, f3 + f2);
            }
        };
    }

    public static void repaint(Component component) {
        HiDPIUtils.repaint(component, 0, 0, component.getWidth(), component.getHeight());
    }

    public static void repaint(Component component, Rectangle rectangle) {
        HiDPIUtils.repaint(component, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void repaint(Component component, int n2, int n3, int n4, int n5) {
        component.repaint(n2, n3, n4, n5);
        if (RepaintManager.currentManager(component) instanceof HiDPIRepaintManager) {
            return;
        }
        if (HiDPIUtils.needsSpecialRepaint(component, n2, n3, n4, n5)) {
            int n6 = n2 + component.getX();
            int n7 = n3 + component.getY();
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                if ((n6 += container.getX()) + n4 >= container.getWidth() || (n7 += container.getY()) + n5 >= container.getHeight()) continue;
                container.repaint(n6, n7, n4, n5);
                break;
            }
        }
    }

    private static boolean needsSpecialRepaint(Component component, int n2, int n3, int n4, int n5) {
        double d2;
        double d3;
        if (!SystemInfo.isJava_9_orLater || !SystemInfo.isWindows) {
            return false;
        }
        if (n4 <= 0 || n5 <= 0 || component == null) {
            return false;
        }
        int n6 = component.getWidth();
        int n7 = component.getHeight();
        if (n6 <= 0 || n7 <= 0) {
            return false;
        }
        if (n2 + n4 < n6 && n3 + n5 < n7) {
            return false;
        }
        if (!component.isOpaque()) {
            int n8 = n2;
            int n9 = n3;
            for (Container container = component.getParent(); container != null; container = container.getParent()) {
                n8 += container.getX();
                n9 += container.getY();
                if (!container.isOpaque()) continue;
                if (n8 + n4 >= container.getWidth() || n9 + n5 >= container.getHeight()) break;
                return false;
            }
        }
        return (d3 = (d2 = UIScale.getSystemScaleFactor(component.getGraphicsConfiguration())) - (double)((int)d2)) != 0.0 && d3 != 0.5;
    }

    public static void installHiDPIRepaintManager() {
        if (!SystemInfo.isJava_9_orLater || !SystemInfo.isWindows) {
            return;
        }
        RepaintManager repaintManager = RepaintManager.currentManager((Component)null);
        if (repaintManager.getClass() == RepaintManager.class) {
            RepaintManager.setCurrentManager(new HiDPIRepaintManager());
        }
    }

    public static void addDirtyRegion(JComponent jComponent, int n2, int n3, int n4, int n5, DirtyRegionCallback dirtyRegionCallback) {
        if (HiDPIUtils.needsSpecialRepaint(jComponent, n2, n3, n4, n5)) {
            int n6 = n2 + jComponent.getX();
            int n7 = n3 + jComponent.getY();
            for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
                if (n6 + n4 < container.getWidth() && n7 + n5 < container.getHeight() && container instanceof JComponent) {
                    dirtyRegionCallback.addDirtyRegion((JComponent)container, n6, n7, n4, n5);
                    return;
                }
                n6 += container.getX();
                n7 += container.getY();
            }
        }
        dirtyRegionCallback.addDirtyRegion(jComponent, n2, n3, n4, n5);
    }

    static {
        SCALE_FACTORS = new float[]{1.25f, 1.5f, 1.75f, 2.0f, 2.25f, 2.5f, 3.0f, 3.5f, 4.0f};
        CORRECTION_SEGOE_UI = new float[]{-0.5f, -0.5f, -0.625f, -0.75f, -0.75f, -0.75f, -0.75f, -0.75f, -0.875f};
        CORRECTION_TAHOMA = new float[]{-0.25f, -0.25f, -0.25f, 0.0f, -0.125f, -0.125f, -0.125f, -0.125f, 0.0f};
        CORRECTION_INTER = new float[]{-0.25f, -0.25f, -0.25f, 0.0f, -0.125f, -0.125f, 0.0f, -0.25f, 0.0f};
        CORRECTION_OPEN_SANS = new float[]{-0.5f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f, 0.0f, -0.25f, -0.25f};
    }

    public static class HiDPIRepaintManager
    extends RepaintManager {
        @Override
        public void addDirtyRegion(JComponent jComponent2, int n6, int n7, int n8, int n9) {
            HiDPIUtils.addDirtyRegion(jComponent2, n6, n7, n8, n9, (jComponent, n2, n3, n4, n5) -> super.addDirtyRegion(jComponent, n2, n3, n4, n5));
        }
    }

    public static interface DirtyRegionCallback {
        public void addDirtyRegion(JComponent var1, int var2, int var3, int var4, int var5);
    }

    public static interface Painter {
        public void paint(Graphics2D var1, int var2, int var3, int var4, int var5, double var6);
    }
}

