/*
 * Decompiled with CFR 0.152.
 */
package com.formdev.flatlaf.util;

import com.formdev.flatlaf.FlatSystemProperties;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.DimensionUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;

public class UIScale {
    private static final boolean DEBUG = false;
    private static PropertyChangeSupport changeSupport;
    private static Boolean jreHiDPI;
    private static float scaleFactor;
    private static boolean initialized;

    public static void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (changeSupport == null) {
            changeSupport = new PropertyChangeSupport(UIScale.class);
        }
        changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (changeSupport == null) {
            return;
        }
        changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public static boolean isSystemScalingEnabled() {
        if (jreHiDPI != null) {
            return jreHiDPI;
        }
        jreHiDPI = false;
        if (SystemInfo.isJava_9_orLater) {
            jreHiDPI = true;
        } else if (SystemInfo.isJetBrainsJVM) {
            try {
                GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                Class<?> clazz = Class.forName("sun.java2d.SunGraphicsEnvironment");
                if (clazz.isInstance(graphicsEnvironment)) {
                    Method method = clazz.getDeclaredMethod("isUIScaleOn", new Class[0]);
                    jreHiDPI = (Boolean)method.invoke((Object)graphicsEnvironment, new Object[0]);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return jreHiDPI;
    }

    public static double getSystemScaleFactor(Graphics2D graphics2D) {
        return UIScale.isSystemScalingEnabled() ? UIScale.getSystemScaleFactor(graphics2D.getDeviceConfiguration()) : 1.0;
    }

    public static double getSystemScaleFactor(GraphicsConfiguration graphicsConfiguration) {
        return UIScale.isSystemScalingEnabled() && graphicsConfiguration != null ? graphicsConfiguration.getDefaultTransform().getScaleX() : 1.0;
    }

    private static void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        if (!UIScale.isUserScalingEnabled()) {
            return;
        }
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                switch (propertyChangeEvent.getPropertyName()) {
                    case "lookAndFeel": {
                        if (propertyChangeEvent.getNewValue() instanceof LookAndFeel) {
                            UIManager.getLookAndFeelDefaults().addPropertyChangeListener(this);
                        }
                        UIScale.updateScaleFactor();
                        break;
                    }
                    case "defaultFont": 
                    case "Label.font": {
                        UIScale.updateScaleFactor();
                    }
                }
            }
        };
        UIManager.addPropertyChangeListener(propertyChangeListener);
        UIManager.getDefaults().addPropertyChangeListener(propertyChangeListener);
        UIManager.getLookAndFeelDefaults().addPropertyChangeListener(propertyChangeListener);
        UIScale.updateScaleFactor();
    }

    private static void updateScaleFactor() {
        if (!UIScale.isUserScalingEnabled()) {
            return;
        }
        float f2 = UIScale.getCustomScaleFactor();
        if (f2 > 0.0f) {
            UIScale.setUserScaleFactor(f2, false);
            return;
        }
        Font font = UIManager.getFont("defaultFont");
        if (font == null) {
            font = UIManager.getFont("Label.font");
        }
        UIScale.setUserScaleFactor(UIScale.computeFontScaleFactor(font), true);
    }

    public static float computeFontScaleFactor(Font font) {
        Font font2;
        if (SystemInfo.isWindows && font instanceof UIResource && ((font2 = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font")) == null || font2.getSize() == font.getSize())) {
            if (UIScale.isSystemScalingEnabled()) {
                return 1.0f;
            }
            Font font3 = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.defaultGUI.font");
            return UIScale.computeScaleFactor(font3 != null ? font3 : font);
        }
        return UIScale.computeScaleFactor(font);
    }

    private static float computeScaleFactor(Font font) {
        float f2 = 12.0f;
        if (SystemInfo.isWindows) {
            if ("Tahoma".equals(font.getFamily())) {
                f2 = 11.0f;
            }
        } else if (SystemInfo.isMacOS) {
            f2 = 13.0f;
        } else if (SystemInfo.isLinux) {
            f2 = SystemInfo.isKDE ? 13.0f : 15.0f;
        }
        return (float)font.getSize() / f2;
    }

    private static boolean isUserScalingEnabled() {
        return FlatSystemProperties.getBoolean("flatlaf.uiScale.enabled", true);
    }

    public static FontUIResource applyCustomScaleFactor(FontUIResource fontUIResource) {
        if (!UIScale.isUserScalingEnabled()) {
            return fontUIResource;
        }
        float f2 = UIScale.getCustomScaleFactor();
        if (f2 <= 0.0f) {
            return fontUIResource;
        }
        float f3 = UIScale.computeScaleFactor(fontUIResource);
        if (f2 == f3) {
            return fontUIResource;
        }
        int n2 = Math.max(Math.round((float)fontUIResource.getSize() / f3 * f2), 1);
        return new FontUIResource(fontUIResource.deriveFont((float)n2));
    }

    private static float getCustomScaleFactor() {
        return UIScale.parseScaleFactor(System.getProperty("flatlaf.uiScale"));
    }

    private static float parseScaleFactor(String string) {
        if (string == null) {
            return -1.0f;
        }
        float f2 = 1.0f;
        if (string.endsWith("x")) {
            string = string.substring(0, string.length() - 1);
        } else if (string.endsWith("dpi")) {
            f2 = 96.0f;
            string = string.substring(0, string.length() - 3);
        } else if (string.endsWith("%")) {
            f2 = 100.0f;
            string = string.substring(0, string.length() - 1);
        }
        try {
            float f3 = Float.parseFloat(string);
            return f3 > 0.0f ? f3 / f2 : -1.0f;
        }
        catch (NumberFormatException numberFormatException) {
            return -1.0f;
        }
    }

    public static float getUserScaleFactor() {
        UIScale.initialize();
        return scaleFactor;
    }

    private static void setUserScaleFactor(float f2, boolean bl2) {
        if (bl2) {
            if (f2 < 1.0f) {
                f2 = FlatSystemProperties.getBoolean("flatlaf.uiScale.allowScaleDown", false) ? (float)Math.round(f2 * 10.0f) / 10.0f : 1.0f;
            } else if (f2 > 1.0f) {
                f2 = (float)Math.round(f2 * 4.0f) / 4.0f;
            }
        }
        f2 = Math.max(f2, 0.1f);
        float f3 = scaleFactor;
        scaleFactor = f2;
        if (changeSupport != null) {
            changeSupport.firePropertyChange("userScaleFactor", Float.valueOf(f3), Float.valueOf(f2));
        }
    }

    public static float scale(float f2) {
        UIScale.initialize();
        return scaleFactor == 1.0f ? f2 : f2 * scaleFactor;
    }

    public static int scale(int n2) {
        UIScale.initialize();
        return scaleFactor == 1.0f ? n2 : Math.round((float)n2 * scaleFactor);
    }

    public static int scale2(int n2) {
        UIScale.initialize();
        return scaleFactor == 1.0f ? n2 : (int)((float)n2 * scaleFactor);
    }

    public static float unscale(float f2) {
        UIScale.initialize();
        return scaleFactor == 1.0f ? f2 : f2 / scaleFactor;
    }

    public static int unscale(int n2) {
        UIScale.initialize();
        return scaleFactor == 1.0f ? n2 : Math.round((float)n2 / scaleFactor);
    }

    public static void scaleGraphics(Graphics2D graphics2D) {
        UIScale.initialize();
        if (scaleFactor != 1.0f) {
            graphics2D.scale(scaleFactor, scaleFactor);
        }
    }

    public static Dimension scale(Dimension dimension) {
        UIScale.initialize();
        return dimension == null || scaleFactor == 1.0f ? dimension : (dimension instanceof UIResource ? new DimensionUIResource(UIScale.scale(dimension.width), UIScale.scale(dimension.height)) : new Dimension(UIScale.scale(dimension.width), UIScale.scale(dimension.height)));
    }

    public static Insets scale(Insets insets) {
        UIScale.initialize();
        return insets == null || scaleFactor == 1.0f ? insets : (insets instanceof UIResource ? new InsetsUIResource(UIScale.scale(insets.top), UIScale.scale(insets.left), UIScale.scale(insets.bottom), UIScale.scale(insets.right)) : new Insets(UIScale.scale(insets.top), UIScale.scale(insets.left), UIScale.scale(insets.bottom), UIScale.scale(insets.right)));
    }

    static {
        scaleFactor = 1.0f;
    }
}

