/*
 * Decompiled with CFR 0.152.
 */
package oracle.as.management.opmn.integrator;

import java.util.HashMap;
import oracle.as.management.opmn.integrator.ComponentCallBack;
import oracle.as.management.opmn.integrator.OpmnIntegratorException;
import oracle.as.management.opmn.integrator.PingCallback;
import oracle.as.management.opmn.integrator.ReloadCallback;
import oracle.as.management.opmn.integrator.StopCallback;
import oracle.ons.BodyBlock;
import oracle.ons.CallBackMode;
import oracle.ons.HeaderBlock;
import oracle.ons.Notification;
import oracle.ons.ONS;
import oracle.ons.Publisher;
import oracle.ons.rpc.RpcRequest;
import oracle.ons.rpc.RpcRequestListener;
import oracle.ons.rpc.RpcServer;
import oracle.ons.rpc.RpcServerException;

public class OpmnIntegrator
implements Runnable {
    public static final String RPC_SERVER_NAME = "OpmnIntegrator";
    public static final String RELOAD_CALLBACK_NAME = "reload";
    public static final String PING_CALLBACK_NAME = "ping";
    public static final String STOP_CALLBACK_NAME = "stop";
    private final String PROC_READY_EVENT = "IAS/PM/PROC_READY";
    private final String OPMN_FIRST = "OPMFirst";
    private final String OPMN_ID = "PROCESS_UID";
    private final String UMP_UID = "-1";
    private ONS myONS;
    private RpcServer rpcServer;
    private ReloadCallback reloadCallback;
    private StopCallback stopCallback;
    private PingCallback pingCallback;
    private String componentName;
    private String opmnId;
    private long procReadyInterval = 10000L;
    private boolean localOnly = false;
    private ComponentCallBack compCb = null;
    private Object callbackData = null;
    private volatile boolean shutdown = false;

    public OpmnIntegrator(int n2, String string, String string2, String string3) throws OpmnIntegratorException {
        this(n2, string, string2, string3, 10, false, null, null);
    }

    public OpmnIntegrator(int n2, String string, String string2, String string3, int n3, boolean bl2, ComponentCallBack componentCallBack, Object object) throws OpmnIntegratorException {
        this.myONS = new ONS(n2, string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("PROCESS_UID", string3);
        hashMap.put("INSTANCE_UID", System.getenv("INSTANCE_UID"));
        this.rpcServer = this.myONS.createRpcServer(RPC_SERVER_NAME, "/Component/OpmnIntegrator", hashMap, CallBackMode.SERIAL);
        this.rpcServer.addRequestListener(RELOAD_CALLBACK_NAME, new ReloadRequestListener());
        this.rpcServer.addRequestListener(PING_CALLBACK_NAME, new PingRequestListener());
        this.rpcServer.addRequestListener(STOP_CALLBACK_NAME, new StopRequestListener());
        this.componentName = string2;
        this.opmnId = string3;
        this.compCb = componentCallBack;
        this.callbackData = object;
        this.localOnly = bl2;
        if (n3 > 0) {
            this.procReadyInterval = n3 * 1000;
        }
    }

    public void start() throws OpmnIntegratorException {
        try {
            this.rpcServer.launch();
        }
        catch (RpcServerException rpcServerException) {
            throw new OpmnIntegratorException(rpcServerException.getMessage());
        }
        if (this.componentName == null || this.opmnId == null) {
            ONS.debug("ComponentName or OPMNID is NULL. Do not start the thread to send periodic PROC_READY");
        } else {
            ONS.debug("Start the thread for component " + this.componentName + " to send periodic PROC_READY");
            Thread thread = new Thread(this);
            thread.setName("OpmnIntegrator-" + this.componentName);
            thread.setDaemon(true);
            thread.start();
        }
    }

    public void registerReloadCallback(ReloadCallback reloadCallback) {
        ONS.debug("OpmnIntegrator: Register Reload callback.");
        this.reloadCallback = reloadCallback;
    }

    public void registerStopCallback(StopCallback stopCallback) {
        ONS.debug("OpmnIntegrator: Register Stop callback.");
        this.stopCallback = stopCallback;
    }

    public void registerPingCallback(PingCallback pingCallback) {
        ONS.debug("OpmnIntegrator: Register Ping callback.");
        this.pingCallback = pingCallback;
    }

    @Override
    public void run() {
        boolean bl2 = true;
        Publisher publisher = new Publisher(this.myONS, this.componentName);
        while (!this.shutdown) {
            BodyBlock bodyBlock = new BodyBlock();
            HeaderBlock headerBlock = new HeaderBlock();
            if (this.compCb != null) {
                this.compCb.OpmnCallback(bodyBlock, headerBlock, this.callbackData);
            }
            byte[] byArray = bodyBlock.generateBody();
            Notification notification = new Notification("IAS/PM/PROC_READY", "", "", byArray);
            headerBlock.setHeader(notification);
            String string = this.myONS.config.getInstanceId();
            if (string != null) {
                notification.put("instanceId", string);
            }
            if (!this.opmnId.equals("-1")) {
                notification.put("PROCESS_UID", this.opmnId);
            }
            if (bl2) {
                notification.put("OPMFirst", "true");
                bl2 = false;
            } else {
                notification.put("OPMFirst", "false");
            }
            if (this.localOnly) {
                notification.setLocalOnly();
            }
            publisher.publish(notification);
            if (this.shutdown) continue;
            try {
                Thread.sleep(this.procReadyInterval);
            }
            catch (Exception exception) {}
        }
        publisher.close();
    }

    public void shutdown() {
        ONS.debug("OpmnIntegrator: Shutdown ...");
        this.shutdown = true;
        this.rpcServer.shutdown();
        this.myONS.shutdown();
    }

    private void invokeStopCallback() throws OpmnIntegratorException {
        if (this.stopCallback == null) {
            throw new OpmnIntegratorException("stop callback is not registered");
        }
        this.stopCallback.onStop();
    }

    private void invokeReloadCallback() throws OpmnIntegratorException {
        if (this.reloadCallback == null) {
            throw new OpmnIntegratorException("reload callback is not registered");
        }
        this.reloadCallback.onConfigurationReload();
    }

    private void invokePingCallback() throws OpmnIntegratorException {
        if (this.pingCallback == null) {
            throw new OpmnIntegratorException("ping callback is not registered");
        }
        this.pingCallback.onPing();
    }

    class StopRequestListener
    implements RpcRequestListener {
        StopRequestListener() {
        }

        @Override
        public void onRequest(RpcRequest rpcRequest) {
            ONS.debug("OpmnIntegrator received stop request");
            String string = null;
            try {
                OpmnIntegrator.this.invokeStopCallback();
            }
            catch (Throwable throwable) {
                string = "failed: " + throwable.getMessage();
            }
            if (string != null) {
                rpcRequest.sendResult(string.getBytes(), false);
            } else {
                rpcRequest.sendResult("success".getBytes(), true);
            }
        }
    }

    class PingRequestListener
    implements RpcRequestListener {
        PingRequestListener() {
        }

        @Override
        public void onRequest(RpcRequest rpcRequest) {
            ONS.debug("OpmnIntegrator received ping request");
            String string = null;
            try {
                OpmnIntegrator.this.invokePingCallback();
            }
            catch (Throwable throwable) {
                string = "failed: " + throwable.getMessage();
            }
            if (string != null) {
                rpcRequest.sendResult(string.getBytes(), false);
            } else {
                rpcRequest.sendResult("success".getBytes(), true);
            }
        }
    }

    class ReloadRequestListener
    implements RpcRequestListener {
        ReloadRequestListener() {
        }

        @Override
        public void onRequest(RpcRequest rpcRequest) {
            ONS.debug("OpmnIntegrator received reload request");
            String string = null;
            try {
                OpmnIntegrator.this.invokeReloadCallback();
            }
            catch (Throwable throwable) {
                string = "failed: " + throwable.getMessage();
            }
            if (string != null) {
                rpcRequest.sendResult(string.getBytes(), false);
            } else {
                rpcRequest.sendResult("success".getBytes(), true);
            }
        }
    }
}

