/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.JavaToJavaConverter;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleResultSet;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.internal.OracleArray;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.METADATA})
class ArrayDataResultSet
extends OracleResultSet {
    Datum[] data;
    Map map;
    private int currentIndex;
    private int lastIndex;
    private Boolean wasNull;
    private int fetchSize;
    OracleArray array;

    ArrayDataResultSet(PhysicalConnection physicalConnection, Datum[] datumArray, Map map) throws SQLException {
        super(physicalConnection);
        this.connection = physicalConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = 0;
        this.lastIndex = this.data == null ? 0 : this.data.length;
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    ArrayDataResultSet(PhysicalConnection physicalConnection, Datum[] datumArray, long l2, int n2, Map map) throws SQLException {
        super(physicalConnection);
        this.connection = physicalConnection;
        this.data = datumArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.data == null ? 0 : this.data.length;
        this.lastIndex = this.currentIndex + Math.min(n3 - this.currentIndex, n2);
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    ArrayDataResultSet(PhysicalConnection physicalConnection, OracleArray oracleArray, long l2, int n2, Map map) throws SQLException {
        super(physicalConnection);
        this.connection = physicalConnection;
        this.array = oracleArray;
        this.map = map;
        this.currentIndex = (int)l2 - 1;
        int n3 = this.array == null ? 0 : oracleArray.length();
        this.lastIndex = this.currentIndex + (n2 == -1 ? n3 - this.currentIndex : Math.min(n3 - this.currentIndex, n2));
        this.fetchSize = OracleConnection.DEFAULT_ROW_PREFETCH;
    }

    void ensureOpen() throws SQLException {
        this.ensureOpen(null);
    }

    void ensureOpen(String string) throws SQLException {
        if (this.closed) {
            if (this.connection.isClosed()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8, string).fillInStackTrace();
            }
            throw (SQLException)DatabaseError.createSqlException(10, string).fillInStackTrace();
        }
    }

    @Override
    OracleStatement getOracleStatement() throws SQLException {
        this.ensureOpen("getOracleStatement");
        return null;
    }

    @Override
    int refreshRows(long l2, int n2) throws SQLException {
        this.ensureOpen("refreshRows");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
    }

    @Override
    void removeCurrentRowFromCache() throws SQLException {
    }

    @Override
    public boolean isFromResultSetCache() throws SQLException {
        return false;
    }

    @Override
    public byte[] getCompileKey() throws SQLException {
        return null;
    }

    @Override
    public byte[] getRuntimeKey() throws SQLException {
        return null;
    }

    @Override
    int getColumnCount() throws SQLException {
        this.ensureOpen("getColumnCount");
        return 2;
    }

    @Override
    protected void doneFetchingRows(boolean bl2) throws SQLException {
    }

    @Override
    public boolean next() throws SQLException {
        this.ensureOpen("next");
        ++this.currentIndex;
        return this.currentIndex <= this.lastIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            super.close();
        }
    }

    @Override
    public int getCursorId() throws SQLException {
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 76, "getCursorId()").fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("wasNull");
            if (this.wasNull == null) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24, null).fillInStackTrace();
            }
            return this.wasNull;
        }
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.ensureOpen("beforeFirst");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "beforeFirst").fillInStackTrace();
    }

    @Override
    public void afterLast() throws SQLException {
        this.ensureOpen("afterLast");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "afterLast").fillInStackTrace();
    }

    @Override
    public boolean first() throws SQLException {
        this.ensureOpen("first");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "first").fillInStackTrace();
    }

    @Override
    public boolean last() throws SQLException {
        this.ensureOpen("last");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "last").fillInStackTrace();
    }

    @Override
    public boolean absolute(int n2) throws SQLException {
        this.ensureOpen("absolute");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "absolute").fillInStackTrace();
    }

    @Override
    public boolean relative(int n2) throws SQLException {
        this.ensureOpen("relative");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "relative").fillInStackTrace();
    }

    @Override
    public boolean previous() throws SQLException {
        this.ensureOpen("previous");
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 75, "previous").fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getString");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ || datum instanceof TIMESTAMPLTZ) {
                    return datum.stringValue(this.connection);
                }
                return JavaToJavaConverter.convert(datum, String.class, this.connection, null, null);
            }
            return null;
        }
    }

    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCursor");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCursor").fillInStackTrace();
        }
    }

    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        this.ensureOpen("getOracleObject");
        if (this.currentIndex <= 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 14, null).fillInStackTrace();
        }
        if (this.currentIndex > this.lastIndex) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 289, null).fillInStackTrace();
        }
        if (n2 == 1) {
            this.wasNull = Boolean.FALSE;
            return new NUMBER(this.currentIndex);
        }
        if (n2 == 2) {
            Datum[] datumArray;
            if (this.data != null) {
                this.wasNull = this.data[this.currentIndex - 1] == null ? Boolean.TRUE : Boolean.FALSE;
                return this.data[this.currentIndex - 1];
            }
            if (this.array != null && (datumArray = this.array.getOracleArray(this.currentIndex, 1)) != null && datumArray.length >= 1) {
                this.wasNull = datumArray[0] == null ? Boolean.TRUE : Boolean.FALSE;
                return datumArray[0];
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Out of sync").fillInStackTrace();
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3, null).fillInStackTrace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getROWID");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ROWID) {
                    return (ROWID)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getROWID").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getNUMBER");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof NUMBER) {
                    return (NUMBER)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNUMBER").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDATE");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof DATE) {
                    return (DATE)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getDATE").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getARRAY");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof ARRAY) {
                    return (ARRAY)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getARRAY").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getSTRUCT");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return (STRUCT)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSTRUCT").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getOPAQUE");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof OPAQUE) {
                    return (OPAQUE)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getOPAQUE").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getREF");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof REF) {
                    return (REF)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getREF").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCHAR");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CHAR) {
                    return (CHAR)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCHAR").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getRAW");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return (RAW)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getRAW").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBLOB");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BLOB) {
                    return (BLOB)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBLOB").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCLOB");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof CLOB) {
                    return (CLOB)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getCLOB").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBFILE");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof BFILE) {
                    return (BFILE)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBFILE").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getINTERVALDS");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALDS) {
                    return (INTERVALDS)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALDS").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getINTERVALYM");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof INTERVALYM) {
                    return (INTERVALYM)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getINTERVALYM").fillInStackTrace();
            }
            return null;
        }
    }

    @Override
    public BFILE getBfile(int n2) throws SQLException {
        return this.getBFILE(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTIMESTAMP");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMP) {
                    return (TIMESTAMP)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMP").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTIMESTAMPTZ");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPTZ) {
                    return (TIMESTAMPTZ)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPTZ").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTIMESTAMPLTZ");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof TIMESTAMPLTZ) {
                    return (TIMESTAMPLTZ)datum;
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getTIMESTAMPLTZ").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBoolean");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Boolean.class, this.connection, null, null);
            }
            return false;
        }
    }

    @Override
    public OracleResultSet.AuthorizationIndicator getAuthorizationIndicator(int n2) throws SQLException {
        this.ensureOpen("getAuthorizationIndicator");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getByte");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Byte.class, this.connection, null, null);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getShort");
            long l2 = this.getLong(n2);
            if (l2 > 32767L || l2 < -32768L) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "getShort").fillInStackTrace();
            }
            return (short)l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getInt");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Integer.class, this.connection, null, null);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getLong");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Long.class, this.connection, null, null);
            }
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getFloat");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Float.class, this.connection, null, null).floatValue();
            }
            return 0.0f;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDouble");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return JavaToJavaConverter.convert(datum, Double.class, this.connection, null, null);
            }
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBigDecimal");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, BigDecimal.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBytes");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof RAW) {
                    return ((RAW)datum).shareBytes();
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getBytes").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDate");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, Date.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTime");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, Time.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTimestamp");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, Timestamp.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getAsciiStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.asciiStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getUnicodeStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DBConversion dBConversion = this.connection.conversion;
                byte[] byArray = datum.shareBytes();
                if (datum instanceof RAW) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 3);
                }
                if (datum instanceof CHAR) {
                    return dBConversion.ConvertStream(new ByteArrayInputStream(byArray), 1);
                }
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getUnicodeStream").fillInStackTrace();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBinaryStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.binaryStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            Object object = this.getObject(n2);
            return oracleDataFactory.create(object, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            return this.getObject(n2, this.map);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CustomDatum getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCustomDatum");
            Datum datum = this.getOracleObject(n2);
            return customDatumFactory.create(datum, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORAData getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getORAData");
            Datum datum = this.getOracleObject(n2);
            return oRADataFactory.create(datum, 0);
        }
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getMetaData");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getMetaData").fillInStackTrace();
        }
    }

    @Override
    public int findColumn(String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("findColumn");
            if (string.equalsIgnoreCase("index")) {
                return 1;
            }
            if (string.equalsIgnoreCase("value")) {
                return 2;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6, "findColumn").fillInStackTrace();
        }
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.ensureOpen("getStatement");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, Map map) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                if (datum instanceof STRUCT) {
                    return ((STRUCT)datum).toJdbc(map);
                }
                return datum.toJdbc();
            }
            return null;
        }
    }

    @Override
    public Ref getRef(int n2) throws SQLException {
        return this.getREF(n2);
    }

    @Override
    public Blob getBlob(int n2) throws SQLException {
        return this.getBLOB(n2);
    }

    @Override
    public Clob getClob(int n2) throws SQLException {
        return this.getCLOB(n2);
    }

    @Override
    public Array getArray(int n2) throws SQLException {
        return this.getARRAY(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCharacterStream");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                return datum.characterStreamValue();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getBigDecimal");
            Datum datum = this.getOracleObject(n2);
            return JavaToJavaConverter.convert(datum, BigDecimal.class, this.connection, null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getDate");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dATE != null) {
                    return JavaToJavaConverter.convert(datum, Date.class, this.connection, calendar, null);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTime");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dATE != null) {
                    return JavaToJavaConverter.convert(datum, Time.class, this.connection, calendar, null);
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getTimestamp");
            Datum datum = this.getOracleObject(n2);
            if (datum != null) {
                DATE dATE = null;
                dATE = datum instanceof DATE ? (DATE)datum : new DATE(JavaToJavaConverter.convert(datum, String.class, this.connection, null, null));
                if (dATE != null) {
                    return JavaToJavaConverter.convert(datum, Timestamp.class, this.connection, calendar, null);
                }
            }
            return null;
        }
    }

    @Override
    public URL getURL(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getURL");
            throw (SQLException)DatabaseError.createSQLFeatureNotSupportedException("getURL").fillInStackTrace();
        }
    }

    @Override
    public String getCursorName() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getCursorName");
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23, "getCursorName").fillInStackTrace();
        }
    }

    @Override
    public NClob getNClob(int n2) throws SQLException {
        this.ensureOpen("getNClob");
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof NCLOB) {
                return (NCLOB)datum;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getNClob").fillInStackTrace();
        }
        return null;
    }

    @Override
    public String getNString(int n2) throws SQLException {
        this.ensureOpen("getNString");
        Datum datum = this.getOracleObject(n2);
        return JavaToJavaConverter.convert(datum, String.class, this.connection, null, null);
    }

    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        this.ensureOpen("getNCharacterStream");
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            return datum.characterStreamValue();
        }
        return null;
    }

    @Override
    public RowId getRowId(int n2) throws SQLException {
        return this.getROWID(n2);
    }

    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        this.ensureOpen("getSQLXML");
        Datum datum = this.getOracleObject(n2);
        if (datum != null) {
            if (datum instanceof SQLXML) {
                return (SQLXML)((Object)datum);
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getSQLXML").fillInStackTrace();
        }
        return null;
    }

    @Override
    public <T> T getObject(int n2, Class<T> clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            this.ensureOpen("getObject");
            Object object = this.getObject(n2);
            if (clazz.isInstance(object)) {
                return (T)object;
            }
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, "getObject").fillInStackTrace();
        }
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        this.ensureOpen("isBeforeFirst");
        return this.currentIndex < 1;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        this.ensureOpen("isAfterLast");
        return this.currentIndex > this.lastIndex;
    }

    @Override
    public boolean isFirst() throws SQLException {
        this.ensureOpen("isFirst");
        return this.currentIndex == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        this.ensureOpen("isLast");
        return this.currentIndex == this.lastIndex;
    }

    @Override
    public int getRow() throws SQLException {
        this.ensureOpen("getRow");
        return this.currentIndex;
    }

    @Override
    public void setFetchSize(int n2) throws SQLException {
        this.ensureOpen("setFetchSize");
        if (n2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "setFetchSize").fillInStackTrace();
        }
        this.fetchSize = n2 == 0 ? OracleConnection.DEFAULT_ROW_PREFETCH : n2;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.ensureOpen("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        this.ensureOpen("getType");
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        this.ensureOpen("getConcurrency");
        return 1007;
    }
}

