/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.time.Duration;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class IntervaldsAccessor
extends Accessor {
    static final int MAXLENGTH = 11;
    private static int INTERVALDSOFFSET = 60;
    private static int INTERVALDAYOFFSET = Integer.MIN_VALUE;

    IntervaldsAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        super(Representation.INTERVALDS, oracleStatement, 11, bl2);
        this.init(oracleStatement, 183, 183, s2, bl2);
        this.initForDataAccess(n3, n2, null);
    }

    IntervaldsAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(Representation.INTERVALDS, oracleStatement, 11, false);
        this.init(oracleStatement, 183, 183, s2, false);
        this.initForDescribe(183, n2, bl2, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    Duration getDuration(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        byte[] byArray = this.getBytesInternal(n2);
        long l2 = (byArray[0] & 0xFF) << 24;
        l2 |= (long)((byArray[1] & 0xFF) << 16);
        l2 |= (long)((byArray[2] & 0xFF) << 8);
        l2 |= (long)(byArray[3] & 0xFF);
        l2 -= (long)INTERVALDAYOFFSET;
        long l3 = byArray[4] - INTERVALDSOFFSET;
        long l4 = byArray[5] - INTERVALDSOFFSET;
        long l5 = byArray[6] - INTERVALDSOFFSET;
        int n3 = (byArray[7] & 0xFF) << 24;
        n3 |= (byArray[8] & 0xFF) << 16;
        n3 |= (byArray[9] & 0xFF) << 8;
        n3 |= byArray[10] & 0xFF;
        return Duration.ofSeconds(l2 * 86400L + l3 * 3600L + l4 * 60L + l5, n3 -= INTERVALDAYOFFSET);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        return this.getINTERVALDS(n2).toString();
    }

    @Override
    Object getObject(int n2) throws SQLException {
        return this.getINTERVALDS(n2);
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getINTERVALDS(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getINTERVALDS(n2);
    }

    @Override
    INTERVALDS getINTERVALDS(int n2) throws SQLException {
        if (this.isNull(n2)) {
            return null;
        }
        return new INTERVALDS(this.getBytesInternal(n2));
    }
}

