/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.StandardMBean;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DiagnosabilityMXBean;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.runtime.TraceController;
import oracle.jdbc.logging.runtime.TraceControllerImpl;

@DisableTrace
public class OracleDiagnosabilityMBean
extends StandardMBean
implements DiagnosabilityMXBean {
    private final TraceController tc = new TraceControllerImpl();

    public OracleDiagnosabilityMBean() {
        super(DiagnosabilityMXBean.class, true);
    }

    @Override
    public boolean getLoggingEnabled() {
        return OracleLog.isEnabled();
    }

    @Override
    public void setLoggingEnabled(boolean bl2) {
        OracleLog.setTrace(bl2);
    }

    @Override
    public boolean stateManageable() {
        return false;
    }

    @Override
    public boolean statisticsProvider() {
        return false;
    }

    @Override
    protected String getDescription(MBeanInfo mBeanInfo) {
        return DatabaseError.findMessage("DiagnosabilityMBeanDescription", (Object)this);
    }

    @Override
    protected String getDescription(MBeanConstructorInfo mBeanConstructorInfo) {
        return DatabaseError.findMessage("DiagnosabilityMBeanConstructor()", (Object)this);
    }

    @Override
    protected String getDescription(MBeanAttributeInfo mBeanAttributeInfo) {
        String string = mBeanAttributeInfo.getName();
        if (string.equals("LoggingEnabled")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanLoggingEnabledDescription", (Object)this);
        }
        if (string.equals("stateManageable")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStateManageableDescription", (Object)this);
        }
        if (string.equals("statisticsProvider")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanStatisticsProviderDescription", (Object)this);
        }
        if (string.equals("TraceController")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanTraceControllerDescription", (Object)this);
        }
        if (string.equals("suspend")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanSuspendDescription", (Object)this);
        }
        if (string.equals("resume")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanResumeDescription", (Object)this);
        }
        if (string.equals("trace")) {
            return DatabaseError.findMessage("DiagnosabilityMBeanTraceDescription", (Object)this);
        }
        Logger.getLogger("oracle.jdbc.driver").log(Level.SEVERE, "Got a request to describe an unexpected  Attribute: " + string);
        return super.getDescription(mBeanAttributeInfo);
    }

    @Override
    public TraceController getTraceController() {
        return this.tc;
    }

    public void trace(boolean bl2, Feature ... featureArray) {
        this.tc.trace(bl2, featureArray);
    }

    @Override
    public void suspend() {
        this.tc.suspend();
    }

    @Override
    public void resume() {
        this.tc.resume();
    }

    @Override
    public void trace(boolean bl2, String string) {
        for (Feature feature : this.tc.getSupportedFeatures()) {
            if (0 != feature.toString().compareToIgnoreCase(string)) continue;
            this.tc.trace(bl2, feature);
            return;
        }
        throw new IllegalArgumentException("unknown \"" + string + "\", supported: " + Arrays.toString((Object[])this.tc.getSupportedFeatures()));
    }
}

