/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.ResultSetAccessor;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CResultSetAccessor
extends ResultSetAccessor {
    T2CResultSetAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        super(oracleStatement, n2 * 2, s2, n3, bl2);
    }

    T2CResultSetAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(oracleStatement, n2 * 2, bl2, n3, n4, n5, l2, n6, s2);
    }

    @Override
    byte[] getBytes(int n2) throws SQLException {
        byte[] byArray = null;
        if (this.isNull(n2)) {
            return null;
        }
        int n3 = this.getLength(n2);
        byte by2 = ((T2CConnection)this.statement.connection).byteAlign;
        long l2 = this.getOffset(n2) + (long)(by2 - 1) & (long)(~(by2 - 1));
        this.rowData.setPosition(l2);
        byArray = this.rowData.getBytes(n3);
        return byArray;
    }
}

