/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.CharacterSet;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OCI_INTERNAL})
class T2CVarcharAccessor
extends VarcharAccessor {
    T2CVarcharAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl2);
    }

    @Override
    @DefaultLevel(value=Logging.FINEST)
    byte[] getBytesInternal(int n2) throws SQLException {
        if (this.formOfUse == 2) {
            assert (!this.isNull(n2));
            CharacterSet characterSet = this.statement.connection.conversion.getCharacterSet(this.formOfUse);
            String string = this.rowData.getString(this.getOffset(n2), this.getLength(n2), characterSet);
            return DBConversion.stringToDriverCharBytes(string, (short)characterSet.getOracleId());
        }
        return super.getBytesInternal(n2);
    }
}

