/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CInputStream
extends OracleInputStream {
    T4CInputStream(OracleStatement oracleStatement, int n2, Accessor accessor) {
        super(oracleStatement, n2, accessor);
    }

    @Override
    public boolean isNull() throws IOException {
        if (!this.statement.isFetchStreams) {
            return super.isNull();
        }
        boolean bl2 = false;
        try {
            int n2 = this.statement.currentResultSet.getRow();
            if (n2 < 0) {
                n2 = 0;
            }
            if ((long)n2 >= this.statement.validRows) {
                return true;
            }
            bl2 = this.statement.isNull(n2, this.columnIndex);
        }
        catch (SQLException sQLException) {
            throw (IOException)DatabaseError.createIOException(sQLException).fillInStackTrace();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getBytes(int n2) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int n3 = -1;
            try {
                if (this.statement.connection.lifecycle == 1 || this.statement.connection.lifecycle == 2) {
                    n3 = this.accessor.readStream(this.resizableBuffer, this.initialBufferSize);
                }
            }
            catch (SQLException sQLException) {
                throw new IOException(sQLException.getMessage());
            }
            catch (IOException iOException) {
                try {
                    ((T4CConnection)this.statement.connection).handleIOException(iOException);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw iOException;
            }
            return n3;
        }
    }
}

