/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CSocketInputStreamWrapper;
import oracle.jdbc.driver.T4CSocketOutputStreamWrapper;
import oracle.jdbc.driver.T4CTypeRep;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ns.BreakNetException;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CMAREngineStream
extends T4CMAREngine {
    NetInputStream inStream;
    NetOutputStream outStream;
    byte[] nativeUB2Buffer = new byte[2];

    T4CMAREngineStream(Communication communication) throws SQLException, IOException {
        if (communication == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 433).fillInStackTrace();
        }
        this.net = communication;
        try {
            this.outStream = new T4CSocketOutputStreamWrapper((NetOutputStream)communication.getOutputStream());
            this.inStream = new T4CSocketInputStreamWrapper((NetInputStream)communication.getInputStream(), (T4CSocketOutputStreamWrapper)this.outStream);
        }
        catch (NetException netException) {
            throw new IOException(netException.getMessage());
        }
        this.types = new T4CTypeRep(this, false);
        this.types.setRep((byte)1, (byte)2);
    }

    void initBuffers() {
    }

    @Override
    final void marshalSB1(byte by2) throws IOException {
        this.marshalSB2(by2);
    }

    @Override
    final void marshalUB1(short s2) throws IOException {
        this.outStream.write((byte)(s2 & 0xFF));
    }

    @Override
    final void marshalSB2(short s2) throws IOException {
        if (s2 == 0) {
            this.outStream.write(0);
        } else {
            if (s2 < 0 || s2 > 256) {
                this.tmpBuffer10[0] = 2;
                this.tmpBuffer10[2] = (byte)(s2 & 0xFF);
                this.tmpBuffer10[1] = (byte)(s2 >> 8 & 0xFF);
            } else {
                this.tmpBuffer10[0] = 1;
                this.tmpBuffer10[1] = (byte)(s2 & 0xFF);
            }
            this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        }
    }

    @Override
    void marshalNativeUB2(short s2, boolean bl2) throws IOException {
        if (bl2) {
            this.nativeUB2Buffer[0] = (byte)(s2 & 0xFF);
            this.nativeUB2Buffer[1] = (byte)(s2 >>> 8 & 0xFF);
        } else {
            this.nativeUB2Buffer[1] = (byte)(s2 & 0xFF);
            this.nativeUB2Buffer[0] = (byte)(s2 >>> 8 & 0xFF);
        }
        this.outStream.write(this.nativeUB2Buffer);
    }

    @Override
    final void marshalUB2(int n2) throws IOException {
        this.marshalSB2((short)(n2 & 0xFFFF));
    }

    @Override
    final void marshalSB4(int n2) throws IOException {
        if (n2 == 0) {
            this.outStream.write(0);
        } else {
            if (n2 < 0) {
                this.tmpBuffer10[0] = 4;
                this.tmpBuffer10[1] = (byte)(n2 >> 24 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 >> 16 & 0xFF);
                this.tmpBuffer10[3] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[4] = (byte)(n2 & 0xFF);
            } else if (n2 < 256) {
                this.tmpBuffer10[0] = 1;
                this.tmpBuffer10[1] = (byte)(n2 & 0xFF);
            } else if (n2 < 65536) {
                this.tmpBuffer10[0] = 2;
                this.tmpBuffer10[1] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 & 0xFF);
            } else if (n2 < 0x1000000) {
                this.tmpBuffer10[0] = 3;
                this.tmpBuffer10[1] = (byte)(n2 >> 16 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[3] = (byte)(n2 & 0xFF);
            } else {
                this.tmpBuffer10[0] = 4;
                this.tmpBuffer10[1] = (byte)(n2 >> 24 & 0xFF);
                this.tmpBuffer10[2] = (byte)(n2 >> 16 & 0xFF);
                this.tmpBuffer10[3] = (byte)(n2 >> 8 & 0xFF);
                this.tmpBuffer10[4] = (byte)(n2 & 0xFF);
            }
            this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        }
    }

    @Override
    final void marshalUB4(long l2) throws IOException {
        this.marshalSB4((int)(l2 & 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    final void marshalSB8(long l2) throws IOException {
        if (l2 == 0L) {
            this.outStream.write(0);
        } else {
            if (l2 < 0L) {
                this.tmpBuffer10[0] = 8;
                this.tmpBuffer10[1] = (byte)(l2 >> 56 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 48 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[7] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[8] = (byte)(l2 & 0xFFL);
            } else if (l2 < 256L) {
                this.tmpBuffer10[0] = 1;
                this.tmpBuffer10[1] = (byte)(l2 & 0xFFL);
            } else if (l2 < 65536L) {
                this.tmpBuffer10[0] = 2;
                this.tmpBuffer10[1] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x1000000L) {
                this.tmpBuffer10[0] = 3;
                this.tmpBuffer10[1] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x100000000L) {
                this.tmpBuffer10[0] = 4;
                this.tmpBuffer10[1] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x10000000000L) {
                this.tmpBuffer10[0] = 5;
                this.tmpBuffer10[1] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x1000000000000L) {
                this.tmpBuffer10[0] = 6;
                this.tmpBuffer10[1] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 & 0xFFL);
            } else if (l2 < 0x100000000000000L) {
                this.tmpBuffer10[0] = 7;
                this.tmpBuffer10[1] = (byte)(l2 >> 48 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[7] = (byte)(l2 & 0xFFL);
            } else {
                this.tmpBuffer10[0] = 8;
                this.tmpBuffer10[1] = (byte)(l2 >> 56 & 0xFFL);
                this.tmpBuffer10[2] = (byte)(l2 >> 48 & 0xFFL);
                this.tmpBuffer10[3] = (byte)(l2 >> 40 & 0xFFL);
                this.tmpBuffer10[4] = (byte)(l2 >> 32 & 0xFFL);
                this.tmpBuffer10[5] = (byte)(l2 >> 24 & 0xFFL);
                this.tmpBuffer10[6] = (byte)(l2 >> 16 & 0xFFL);
                this.tmpBuffer10[7] = (byte)(l2 >> 8 & 0xFFL);
                this.tmpBuffer10[8] = (byte)(l2 & 0xFFL);
            }
            this.outStream.write(this.tmpBuffer10, 0, this.tmpBuffer10[0] + 1);
        }
    }

    @Override
    final void marshalB1Array(byte[] byArray) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray);
        }
    }

    @Override
    final void marshalB1Array(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length > 0) {
            this.outStream.write(byArray, n2, n3);
        }
    }

    @Override
    final byte unmarshalSB1() throws SQLException, IOException {
        byte by2 = (byte)this.unmarshalSB2();
        return by2;
    }

    @Override
    final short unmarshalUB1() throws SQLException, IOException {
        short s2 = 0;
        try {
            s2 = (short)this.inStream.read();
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        if (s2 < 0) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
        }
        return s2;
    }

    @Override
    final short unmarshalSB2() throws SQLException, IOException {
        boolean bl2;
        int n2 = 0;
        int n3 = this.inStream.readB1();
        boolean bl3 = bl2 = n3 > 128;
        if (bl2) {
            n3 &= 0x7F;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                n2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2);
                n2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        if (bl2) {
            n2 *= -1;
        }
        return (short)n2;
    }

    @Override
    final int unmarshalUB2() throws SQLException, IOException {
        int n2 = 0;
        switch (this.inStream.readB1()) {
            case 0: {
                break;
            }
            case 1: {
                n2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2);
                n2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            case 3: {
                this.inStream.read(this.tmpBuffer4, 0, 3);
                n2 = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        return n2 & 0xFFFF;
    }

    @Override
    final int unmarshalSB4() throws SQLException, IOException {
        boolean bl2;
        int n2 = 0;
        int n3 = this.inStream.readB1();
        boolean bl3 = bl2 = n3 > 128;
        if (bl2) {
            n3 &= 0x7F;
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                n2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2, 0, 2);
                n2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            case 3: {
                this.inStream.read(this.tmpBuffer4, 0, 3);
                n2 = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                break;
            }
            case 4: {
                this.inStream.read(this.tmpBuffer4, 0, 4);
                n2 = this.tmpBuffer4[0] << 24 & 0xFF000000 | this.tmpBuffer4[1] << 16 & 0xFF0000 | this.tmpBuffer4[2] << 8 & 0xFF00 | this.tmpBuffer4[3] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        if (bl2) {
            n2 *= -1;
        }
        return n2;
    }

    @Override
    final long unmarshalUB4() throws SQLException, IOException {
        long l2 = 0L;
        switch (this.inStream.readB1()) {
            case 0: {
                break;
            }
            case 1: {
                l2 = this.inStream.readB1() & 0xFF;
                break;
            }
            case 2: {
                this.inStream.read(this.tmpBuffer2, 0, 2);
                l2 = this.tmpBuffer2[0] << 8 & 0xFF00 | this.tmpBuffer2[1] & 0xFF;
                break;
            }
            case 3: {
                this.inStream.read(this.tmpBuffer4, 0, 3);
                l2 = this.tmpBuffer4[0] << 16 & 0xFF0000 | this.tmpBuffer4[1] << 8 & 0xFF00 | this.tmpBuffer4[2] & 0xFF;
                break;
            }
            case 4: {
                this.inStream.read(this.tmpBuffer4, 0, 4);
                l2 = this.tmpBuffer4[0] << 24 & 0xFF000000 | this.tmpBuffer4[1] << 16 & 0xFF0000 | this.tmpBuffer4[2] << 8 & 0xFF00 | this.tmpBuffer4[3] & 0xFF;
                break;
            }
            default: {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 408).fillInStackTrace();
            }
        }
        return l2;
    }

    @Override
    byte[] unmarshalNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        if (n2 > 0) {
            try {
                if (this.inStream.read(byArray) < 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                throw socketTimeoutException;
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
        }
        return byArray;
    }

    @Override
    int unmarshalNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        int n4;
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        for (n4 = 0; n4 < n3; n4 += this.getNBytes(byArray, n2 + n4, n3 - n4)) {
        }
        return n4;
    }

    @Override
    int getNBytes(byte[] byArray, int n2, int n3) throws SQLException, IOException {
        if (n2 + n3 > byArray.length) {
            n3 = byArray.length - n2;
        }
        int n4 = 0;
        try {
            n4 = this.inStream.read(byArray, n2, n3);
            if (n4 < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return n4;
    }

    @Override
    byte[] getNBytes(int n2) throws SQLException, IOException {
        byte[] byArray = new byte[n2];
        try {
            if (this.inStream.read(byArray) < 0) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
            }
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        return byArray;
    }

    @Override
    byte[] unmarshalTEXT(int n2) throws SQLException, IOException {
        byte[] byArray;
        int n3 = 0;
        byte[] byArray2 = new byte[n2];
        while (n3 < n2) {
            try {
                if (this.inStream.read(byArray2, n3, 1) < 0) {
                    throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 410).fillInStackTrace();
                }
            }
            catch (SocketTimeoutException socketTimeoutException) {
                ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
                throw socketTimeoutException;
            }
            catch (BreakNetException breakNetException) {
                this.net.sendReset();
                throw breakNetException;
            }
            if (byArray2[n3++] != 0) continue;
        }
        if (byArray2.length == --n3) {
            byArray = byArray2;
        } else {
            byArray = new byte[n3];
            System.arraycopy(byArray2, 0, byArray, 0, n3);
        }
        return byArray;
    }

    @Override
    final long buffer2Value(byte by2) throws SQLException, IOException {
        try {
            long l2 = 0L;
            int n2 = 1;
            if ((this.types.rep[by2] & 1) > 0) {
                n2 = this.inStream.readB1();
            } else {
                switch (by2) {
                    case 1: {
                        n2 = 2;
                        break;
                    }
                    case 2: {
                        n2 = 4;
                        break;
                    }
                    case 3: {
                        n2 = 8;
                    }
                }
            }
            l2 = (this.types.rep[by2] & 2) > 0 ? this.inStream.readLongLSB(n2) : this.inStream.readLongMSB(n2);
            return l2;
        }
        catch (BreakNetException breakNetException) {
            this.net.sendReset();
            throw breakNetException;
        }
        catch (SocketTimeoutException socketTimeoutException) {
            ((T4CConnection)this.getConnectionDuringExceptionHandling()).doAsynchronousClose();
            throw socketTimeoutException;
        }
    }

    @Override
    void setByteOrder(byte by2) throws IOException {
    }

    @Override
    protected void flush() throws IOException {
        ((T4CSocketOutputStreamWrapper)this.outStream).flush(true);
    }

    @Override
    void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        this.outStream.flush();
        this.outStream.writeZeroCopyIO(byArray, n2, n3);
    }

    @Override
    void clearWriteBuffer() {
        ((T4CSocketOutputStreamWrapper)this.outStream).bIndex = 0;
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

