/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.GregorianCalendar;
import oracle.jdbc.OracleResultSetMetaData;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DynamicByteArray;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.T4CAccessor;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.driver.T4CMarshaller;
import oracle.jdbc.driver.T4CTTIoer11;
import oracle.jdbc.driver.VarcharAccessor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
class T4CVarcharAccessor
extends VarcharAccessor
implements T4CAccessor {
    T4CMAREngine mare;
    static final int MAX_CALL_LENGTH_PRE102 = 4001;
    static final int MIN_SQL_LENGTH = 32;
    boolean underlyingLong = false;
    private T4CMarshaller marshaller = null;
    static final int NONE = -1;
    static final int DAY = 1;
    static final int MM_MONTH = 2;
    static final int FULL_MONTH = 3;
    static final int MON_MONTH = 4;
    static final int YY_YEAR = 5;
    static final int RR_YEAR = 6;
    static final int HH_HOUR = 7;
    static final int HH24_HOUR = 8;
    static final int MINUTE = 9;
    static final int SECOND = 10;
    static final int NSECOND = 11;
    static final int AM = 12;
    static final int TZR = 13;
    static final int TZH = 14;
    static final int TZM = 15;

    T4CVarcharAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, s2, n3, bl2);
        this.mare = t4CMAREngine;
        this.calculateSizeTmpByteArray();
    }

    T4CVarcharAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, long l2, int n6, short s2, int n7, int n8, int n9, int n10, T4CMAREngine t4CMAREngine) throws SQLException {
        super(oracleStatement, n2, bl2, n3, n4, n5, l2, n6, s2, n7);
        this.mare = t4CMAREngine;
        this.definedColumnType = n9;
        this.definedColumnSize = n10;
        this.calculateSizeTmpByteArray();
        this.oacmxl = n8;
        if (this.oacmxl == -1) {
            this.underlyingLong = true;
            this.oacmxl = 4000;
        }
    }

    @Override
    public T4CMAREngine getMAREngine() {
        return this.mare;
    }

    @Override
    public void unmarshalColumnMetadata() throws SQLException, IOException {
        if (this.statement.statementType != 2 && !this.statement.sqlKind.isPlsqlOrCall() && this.securityAttribute == OracleResultSetMetaData.SecurityAttribute.ENABLED) {
            this.setRowMetadata(this.lastRowProcessed, (byte)this.mare.unmarshalUB1());
        }
    }

    @Override
    public void processIndicator(int n2) throws IOException, SQLException {
        if (this.internalType == 1 && this.describeType == 112 || this.internalType == 23 && this.describeType == 113) {
            this.mare.unmarshalSB2();
            this.mare.unmarshalUB2();
        } else if (this.statement.connection.versionNumber < 9200) {
            this.mare.unmarshalSB2();
            if (!this.statement.sqlKind.isPlsqlOrCall()) {
                this.mare.unmarshalSB2();
            }
        } else if (this.statement.sqlKind.isPlsqlOrCall() || this.isDMLReturnedParam) {
            this.mare.processIndicator(n2 <= 0, n2);
        }
    }

    @Override
    int getPreviousRowProcessed() {
        if (this.previousRowProcessed == -1) {
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        }
        return this.previousRowProcessed;
    }

    @Override
    void reinitForResultSetCache(ByteArray byteArray, OracleStatement oracleStatement) throws SQLException {
        this.rowData = byteArray;
        this.mare = ((T4CConnection)oracleStatement.connection).mare;
        this.rowNull = null;
        this.setCapacity(oracleStatement.getFetchSize());
    }

    @Override
    void copyRow() throws SQLException, IOException {
        if (this.isNullByDescribe || this.previousRowProcessed == -1) {
            this.setNull(this.lastRowProcessed, true);
            this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
        } else if (this.lastRowProcessed == 0) {
            if (this.previousRowProcessed == -1) {
                this.previousRowProcessed = this.statement.rowPrefetchInLastFetch - 1;
            }
            long l2 = this.getOffset(this.previousRowProcessed);
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            if (!this.isNull(this.previousRowProcessed)) {
                this.setOffset(this.lastRowProcessed);
                ((DynamicByteArray)this.rowData).copyLeft(l2, this.getLength(this.previousRowProcessed));
                this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
            }
        } else if (this.lastCopyRow == this.previousRowProcessed) {
            this.setNull(this.lastRowProcessed, this.lastCopyRowIsNull);
            this.rowMetadata[this.lastRowProcessed] = this.lastCopyRowMetaData;
            this.setOffset(this.lastRowProcessed, this.lastCopyRowOffset);
            this.setLength(this.lastRowProcessed, this.lastCopyRowLength);
        } else {
            this.setNull(this.lastRowProcessed, this.isNull(this.previousRowProcessed));
            this.rowMetadata[this.lastRowProcessed] = this.rowMetadata[this.previousRowProcessed];
            this.setOffset(this.lastRowProcessed, this.getOffset(this.previousRowProcessed));
            this.setLength(this.lastRowProcessed, this.getLength(this.previousRowProcessed));
        }
        this.previousRowProcessed = this.lastRowProcessed++;
    }

    @Override
    boolean unmarshalOneRow() throws SQLException, IOException {
        return this.getMarshaller().unmarshalOneRow(this);
    }

    int readStreamFromWire(byte[] byArray, int n2, int n3, int[] nArray, boolean[] blArray, boolean[] blArray2, T4CMAREngine t4CMAREngine, T4CTTIoer11 t4CTTIoer11) throws SQLException, IOException {
        return this.getMarshaller().readStreamFromWire(byArray, n2, n3, nArray, blArray, blArray2, t4CMAREngine, t4CTTIoer11);
    }

    @Override
    NUMBER getNUMBER(int n2) throws SQLException {
        NUMBER nUMBER = null;
        if (this.definedColumnType == 0) {
            nUMBER = super.getNUMBER(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                return T4CVarcharAccessor.StringToNUMBER(string.trim());
            }
        }
        return nUMBER;
    }

    @Override
    DATE getDATE(int n2) throws SQLException {
        DATE dATE = null;
        if (this.definedColumnType == 0) {
            dATE = super.getDATE(n2);
        } else {
            Date date = this.getDate(n2);
            if (date != null) {
                dATE = new DATE(date);
            }
        }
        return dATE;
    }

    @Override
    TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        TIMESTAMP tIMESTAMP = null;
        if (this.definedColumnType == 0) {
            tIMESTAMP = super.getTIMESTAMP(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMP = new TIMESTAMP(timestamp);
            }
        }
        return tIMESTAMP;
    }

    @Override
    TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        TIMESTAMPTZ tIMESTAMPTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPTZ = super.getTIMESTAMPTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPTZ = new TIMESTAMPTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPTZ;
    }

    @Override
    TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        TIMESTAMPLTZ tIMESTAMPLTZ = null;
        if (this.definedColumnType == 0) {
            tIMESTAMPLTZ = super.getTIMESTAMPLTZ(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                Timestamp timestamp = new Timestamp(calendar.getTimeInMillis());
                timestamp.setNanos(nArray[0]);
                tIMESTAMPLTZ = new TIMESTAMPLTZ((Connection)this.statement.connection, timestamp, calendar);
            }
        }
        return tIMESTAMPLTZ;
    }

    @Override
    RAW getRAW(int n2) throws SQLException {
        RAW rAW = null;
        if (this.definedColumnType == 0) {
            rAW = super.getRAW(n2);
        } else if (!this.rowNull[n2]) {
            rAW = this.definedColumnType == -2 || this.definedColumnType == -3 || this.definedColumnType == -4 ? new RAW(this.getBytesFromHexChars(n2)) : new RAW(super.getBytes(n2));
        }
        return rAW;
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getOracleObject(n2);
        }
        Datum datum = null;
        if (this.rowNull == null) {
            throw (SQLException)DatabaseError.createSqlException(21).fillInStackTrace();
        }
        if (!this.rowNull[n2]) {
            switch (this.definedColumnType) {
                case -16: 
                case -15: 
                case -9: 
                case -1: 
                case 1: 
                case 12: {
                    return super.getOracleObject(n2);
                }
                case -7: 
                case -6: 
                case -5: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 16: {
                    return this.getNUMBER(n2);
                }
                case 91: {
                    return this.getDATE(n2);
                }
                case 92: {
                    return this.getDATE(n2);
                }
                case 93: {
                    return this.getTIMESTAMP(n2);
                }
                case -101: {
                    return this.getTIMESTAMPTZ(n2);
                }
                case -102: {
                    return this.getTIMESTAMPLTZ(n2);
                }
                case -4: 
                case -3: 
                case -2: {
                    return this.getRAW(n2);
                }
                case -8: {
                    return this.getROWID(n2);
                }
            }
            throw (SQLException)DatabaseError.createSqlException(4).fillInStackTrace();
        }
        return datum;
    }

    @Override
    byte getByte(int n2) throws SQLException {
        byte by2 = 0;
        if (this.definedColumnType == 0) {
            by2 = super.getByte(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                by2 = nUMBER.byteValue();
            }
        }
        return by2;
    }

    @Override
    int getInt(int n2) throws SQLException {
        int n3 = 0;
        if (this.definedColumnType == 0) {
            n3 = super.getInt(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                n3 = nUMBER.intValue();
            }
        }
        return n3;
    }

    @Override
    short getShort(int n2) throws SQLException {
        short s2 = 0;
        if (this.definedColumnType == 0) {
            s2 = super.getShort(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                s2 = nUMBER.shortValue();
            }
        }
        return s2;
    }

    @Override
    long getLong(int n2) throws SQLException {
        long l2 = 0L;
        if (this.definedColumnType == 0) {
            l2 = super.getLong(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                l2 = nUMBER.longValue();
            }
        }
        return l2;
    }

    @Override
    float getFloat(int n2) throws SQLException {
        float f2 = 0.0f;
        if (this.definedColumnType == 0) {
            f2 = super.getFloat(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                f2 = nUMBER.floatValue();
            }
        }
        return f2;
    }

    @Override
    double getDouble(int n2) throws SQLException {
        double d2 = 0.0;
        if (this.definedColumnType == 0) {
            d2 = super.getDouble(n2);
        } else {
            NUMBER nUMBER = this.getNUMBER(n2);
            if (nUMBER != null) {
                d2 = nUMBER.doubleValue();
            }
        }
        return d2;
    }

    @Override
    Date getDate(int n2) throws SQLException {
        Date date = null;
        if (this.definedColumnType == 0) {
            date = super.getDate(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                try {
                    date = new Date(T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCDATEFM"), nArray).getTimeInMillis());
                }
                catch (NumberFormatException numberFormatException) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)numberFormatException).fillInStackTrace();
                }
            }
        }
        return date;
    }

    @Override
    Timestamp getTimestamp(int n2) throws SQLException {
        Timestamp timestamp = null;
        if (this.definedColumnType == 0) {
            timestamp = super.getTimestamp(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                try {
                    Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTMPFM"), nArray);
                    timestamp = new Timestamp(calendar.getTimeInMillis());
                    timestamp.setNanos(nArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)numberFormatException).fillInStackTrace();
                }
            }
        }
        return timestamp;
    }

    @Override
    Time getTime(int n2) throws SQLException {
        Time time = null;
        if (this.definedColumnType == 0) {
            time = super.getTime(n2);
        } else {
            String string = this.getString(n2);
            if (string != null) {
                int[] nArray = new int[1];
                try {
                    Calendar calendar = T4CVarcharAccessor.DATEStringToCalendar(string, (String)this.statement.connection.sessionProperties.get("AUTH_NLS_LXCSTZNFM"), nArray);
                    time = new Time(calendar.getTimeInMillis());
                }
                catch (NumberFormatException numberFormatException) {
                    throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)numberFormatException).fillInStackTrace();
                }
            }
        }
        return time;
    }

    private final T4CMarshaller getMarshaller() {
        if (this.marshaller == null) {
            this.marshaller = this.describeType == 8 ? T4CMarshaller.LONG : T4CMarshaller.VARCHAR;
        }
        return this.marshaller;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.definedColumnType == 0) {
            return super.getObject(n2);
        }
        if (this.isUnexpected()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 21).fillInStackTrace();
        }
        if (this.isNull(n2)) {
            return null;
        }
        switch (this.definedColumnType) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                return this.getString(n2);
            }
            case 2: 
            case 3: {
                return this.getBigDecimal(n2);
            }
            case 4: {
                return this.getInt(n2);
            }
            case -6: {
                return this.getByte(n2);
            }
            case 5: {
                return this.getShort(n2);
            }
            case -7: 
            case 16: {
                return this.getBoolean(n2);
            }
            case -5: {
                return this.getLong(n2);
            }
            case 7: {
                return Float.valueOf(this.getFloat(n2));
            }
            case 6: 
            case 8: {
                return this.getDouble(n2);
            }
            case 91: {
                return this.getDate(n2);
            }
            case 92: {
                return this.getTime(n2);
            }
            case 93: {
                return this.getTimestamp(n2);
            }
            case -101: {
                return this.getTIMESTAMPTZ(n2);
            }
            case -102: {
                return this.getTIMESTAMPLTZ(n2);
            }
            case -4: 
            case -3: 
            case -2: {
                return this.getBytesFromHexChars(n2);
            }
            case -8: {
                return this.getROWID(n2);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    static final NUMBER StringToNUMBER(String string) throws SQLException {
        try {
            return new NUMBER(new BigDecimal(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw (SQLException)DatabaseError.createSqlException(null, 132, null, (Throwable)numberFormatException).fillInStackTrace();
        }
    }

    static final Calendar DATEStringToCalendar(String string, String string2, int[] nArray) throws SQLException {
        char[] cArray = (string2 + " ").toCharArray();
        string = string + " ";
        int n2 = Math.min(string.length(), cArray.length);
        int n3 = -1;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        String string3 = null;
        String string4 = null;
        boolean bl2 = false;
        String[] stringArray = null;
        String[] stringArray2 = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            switch (cArray[i2]) {
                case 'R': 
                case 'r': {
                    if (n3 == 6) break;
                    n3 = 6;
                    n5 = i2;
                    break;
                }
                case 'Y': 
                case 'y': {
                    if (n3 == 5) break;
                    n3 = 5;
                    n5 = i2;
                    break;
                }
                case 'D': 
                case 'd': {
                    if (n3 == 1) break;
                    n3 = 1;
                    n5 = i2;
                    break;
                }
                case 'M': 
                case 'm': {
                    if (n3 == 2 && n3 == 4 && n3 == 3 && n3 == 9) break;
                    n5 = i2;
                    if (!(i2 + 4 >= n2 || cArray[i2 + 1] != 'O' && cArray[i2 + 1] != 'o' || cArray[i2 + 2] != 'N' && cArray[i2 + 2] != 'n' || cArray[i2 + 3] != 'T' && cArray[i2 + 3] != 't' || cArray[i2 + 4] != 'H' && cArray[i2 + 4] != 'h')) {
                        n3 = 3;
                        i2 += 4;
                        break;
                    }
                    if (!(i2 + 2 >= n2 || cArray[i2 + 1] != 'O' && cArray[i2 + 1] != 'o' || cArray[i2 + 2] != 'N' && cArray[i2 + 2] != 'n')) {
                        n3 = 4;
                        i2 += 2;
                        break;
                    }
                    if (i2 + 1 < n2 && (cArray[i2 + 1] == 'M' || cArray[i2 + 1] == 'm')) {
                        n3 = 2;
                        ++i2;
                        break;
                    }
                    if (i2 + 1 >= n2 || cArray[i2 + 1] != 'I' && cArray[i2 + 1] != 'i') break;
                    n3 = 9;
                    ++i2;
                    break;
                }
                case 'H': 
                case 'h': {
                    if (n3 != 7) {
                        n3 = 7;
                        n5 = i2;
                        break;
                    }
                    if (i2 + 2 >= n2 || cArray[i2 + 1] != '2' && cArray[i2 + 4] != '4') break;
                    n3 = 8;
                    i2 += 2;
                    break;
                }
                case 'S': 
                case 's': {
                    if (i2 + 1 >= n2 || cArray[i2 + 1] != 'S' && cArray[i2 + 1] != 's') break;
                    n3 = 10;
                    n5 = i2++;
                    break;
                }
                case 'F': 
                case 'f': {
                    if (n3 == 11) break;
                    n3 = 11;
                    n5 = i2;
                    break;
                }
                case 'A': 
                case 'a': {
                    if (i2 + 1 >= n2 || cArray[i2 + 1] != 'M' && cArray[i2 + 1] != 'm') break;
                    n3 = 12;
                    n5 = i2++;
                    break;
                }
                case 'T': 
                case 't': {
                    if (i2 + 2 >= n2 || cArray[i2 + 1] != 'Z' && cArray[i2 + 1] != 'z' || cArray[i2 + 2] != 'R' && cArray[i2 + 2] != 'r') break;
                    n3 = 13;
                    n5 = i2;
                    i2 += 2;
                    break;
                }
                default: {
                    bl2 = true;
                }
            }
            if (!bl2 || n3 == -1) continue;
            int n16 = i2 - n5;
            int n17 = n5 - n6;
            n7 = n8 + n17;
            n8 = n7 + n16;
            switch (n3) {
                case 1: {
                    n9 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 2: {
                    n10 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 3: {
                    int n18 = n7;
                    n8 = n7;
                    for (n18 = n7; n18 < string.length() && string.charAt(n18) != cArray[i2]; ++n18) {
                    }
                    n8 = n18;
                    String string5 = null;
                    if (n8 == n7) break;
                    string5 = string.substring(n7, n8);
                    string5 = string5.trim();
                    if (stringArray2 == null) {
                        stringArray2 = new DateFormatSymbols().getMonths();
                    }
                    for (n10 = 0; n10 < stringArray2.length && !string5.equalsIgnoreCase(stringArray2[n10]); ++n10) {
                    }
                    if (n10 < 12) break;
                    throw (SQLException)DatabaseError.createSqlException(59).fillInStackTrace();
                }
                case 4: {
                    int n19 = n7;
                    n8 = n7;
                    for (n19 = n7; n19 < string.length() && string.charAt(n19) != cArray[i2]; ++n19) {
                    }
                    n8 = n19;
                    String string6 = null;
                    if (n8 == n7) break;
                    string6 = string.substring(n7, n8);
                    string6 = string6.trim();
                    if (stringArray == null) {
                        stringArray = new DateFormatSymbols().getShortMonths();
                    }
                    for (n10 = 0; n10 < stringArray.length && !string6.equalsIgnoreCase(stringArray[n10]); ++n10) {
                    }
                    if (n10 < 12) break;
                    throw DatabaseError.createSqlException(59);
                }
                case 5: {
                    n11 = Integer.parseInt(string.substring(n7, n8));
                    if (n16 != 2) break;
                    n11 += 2000;
                    break;
                }
                case 6: {
                    n11 = Integer.parseInt(string.substring(n7, n8));
                    if (n16 == 2 && n11 < 50) {
                        n11 += 2000;
                        break;
                    }
                    n11 += 1900;
                    break;
                }
                case 7: 
                case 8: {
                    n8 = n7 + 2;
                    n12 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 9: {
                    n13 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 10: {
                    n14 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 11: {
                    int n19;
                    int n20 = n7;
                    n8 = n7;
                    for (n20 = n7; n20 < string.length(); ++n20) {
                        char c2 = string.charAt(n20);
                        n19 = c2;
                        if (c2 < '0' || n19 > 57) break;
                    }
                    if ((n8 += n20 - n7) == n7) break;
                    n15 = Integer.parseInt(string.substring(n7, n8));
                    break;
                }
                case 12: {
                    if (n8 <= 0) break;
                    string3 = string.substring(n7, n8);
                    break;
                }
                case 13: {
                    int n19;
                    int n21 = n7;
                    n8 = n7;
                    n21 = n7;
                    while (n21 < string.length()) {
                        char c3 = string.charAt(n21);
                        n19 = c3;
                        if (!(c3 >= '0' && n19 <= 57 || n19 >= 97 && n19 <= 122 || n19 >= 65 && n19 <= 90)) break;
                        n8 = n21++;
                    }
                    if (n8 == n7) break;
                    string4 = string.substring(n7, n8);
                    break;
                }
                default: {
                    System.out.println("\n\n\n             ***** ERROR(1) ****\n");
                }
            }
            n6 = i2;
            n3 = -1;
            bl2 = false;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n11, n10, n9, n12, n13, n14);
        if (string3 != null) {
            gregorianCalendar.set(9, string3.equalsIgnoreCase("AM") ? 0 : 1);
        }
        if (string4 != null) {
            // empty if block
        }
        if (n15 != 0) {
            nArray[0] = n15;
        }
        return gregorianCalendar;
    }

    @Override
    int getBytes(int n2, byte[] byArray, int n3) throws SQLException {
        if (this.isNull(n2)) {
            return 0;
        }
        return this.rowData.getUtf8Bytes(this.getOffset(n2), this.getLength(n2), byArray, n3, this.statement.connection.conversion.getCharacterSet(this.formOfUse));
    }

    @Override
    AccessorPrototype newPrototype(int n2) {
        assert (n2 >= 0) : "numRows: " + n2;
        AccessorPrototype accessorPrototype = new AccessorPrototype(n2, this, this.statement.rowData){

            @Override
            Accessor newAccessor(OracleStatement oracleStatement) throws SQLException {
                T4CVarcharAccessor t4CVarcharAccessor = new T4CVarcharAccessor(oracleStatement, T4CVarcharAccessor.this.describeMaxLength, T4CVarcharAccessor.this.nullable, -1, T4CVarcharAccessor.this.precision, T4CVarcharAccessor.this.scale, T4CVarcharAccessor.this.contflag, -1, T4CVarcharAccessor.this.formOfUse, T4CVarcharAccessor.this.describeMaxLengthChars, T4CVarcharAccessor.this.oacmxl, T4CVarcharAccessor.this.definedColumnType, T4CVarcharAccessor.this.definedColumnSize, null);
                this.initializeRowData(t4CVarcharAccessor);
                return t4CVarcharAccessor;
            }
        };
        return accessorPrototype;
    }
}

