/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import oracle.jdbc.aq.AQAgent;
import oracle.jdbc.aq.AQDequeueOptions;
import oracle.jdbc.aq.AQMessageProperties;
import oracle.jdbc.driver.AQAgentI;
import oracle.jdbc.driver.AQMessagePropertiesI;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIaqm;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.driver.T4Ctoh;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.THIN_INTERNAL})
final class T4Caqdq
extends T4CTTIfun {
    T4CTTIaqm aqm;
    T4Ctoh toh;
    static final int AQDVER_DEFAULT = 1;
    private String queueName;
    private AQDequeueOptions dequeueOptions = null;
    private byte[] payloadToid = null;
    private byte[] queueNameBytes = null;
    private byte[] consumerNameBytes = null;
    private byte[] correlationBytes = null;
    private byte[] conditionBytes = null;
    private int nbExtensions = 0;
    private byte[][] extensionTextValues = null;
    private byte[][] extensionBinaryValues = null;
    private int[] extensionKeywords = null;
    private byte[] payload = null;
    private boolean hasAMessageBeenDequeued = false;
    private byte[] dequeuedMessageId = null;
    private int aqdver = 1;
    private boolean isRawQueue = false;
    private AQMessagePropertiesI properties = null;

    T4Caqdq(T4CConnection t4CConnection) {
        super(t4CConnection, (byte)3);
        this.setFunCode((short)122);
        this.toh = new T4Ctoh(t4CConnection);
        this.aqm = new T4CTTIaqm(this.connection, this.toh);
    }

    void doOAQDQ(String string, AQDequeueOptions aQDequeueOptions, byte[] byArray, int n2, boolean bl2, AQMessagePropertiesI aQMessagePropertiesI) throws SQLException, IOException {
        this.queueName = string;
        this.dequeueOptions = aQDequeueOptions;
        this.payloadToid = byArray;
        this.aqdver = n2;
        this.isRawQueue = bl2;
        this.properties = aQMessagePropertiesI;
        this.queueNameBytes = (byte[])(this.queueName != null && this.queueName.length() != 0 ? this.meg.conv.StringToCharBytes(this.queueName) : null);
        String string2 = this.dequeueOptions.getConsumerName();
        this.consumerNameBytes = (byte[])(string2 != null && string2.length() > 0 ? this.meg.conv.StringToCharBytes(string2) : null);
        String string3 = this.dequeueOptions.getCorrelation();
        this.correlationBytes = (byte[])(string3 != null && string3.length() != 0 ? this.meg.conv.StringToCharBytes(string3) : null);
        String string4 = this.dequeueOptions.getCondition();
        this.conditionBytes = (byte[])(string4 != null && string4.length() > 0 ? this.meg.conv.StringToCharBytes(string4) : null);
        String string5 = this.dequeueOptions.getTransformation();
        if (string5 != null && string5.length() > 0) {
            this.nbExtensions = 1;
            this.extensionTextValues = new byte[this.nbExtensions][];
            this.extensionBinaryValues = new byte[this.nbExtensions][];
            this.extensionKeywords = new int[this.nbExtensions];
            this.extensionTextValues[0] = this.meg.conv.StringToCharBytes(string5);
            this.extensionBinaryValues[0] = null;
            this.extensionKeywords[0] = 196;
        } else {
            this.nbExtensions = 0;
        }
        this.hasAMessageBeenDequeued = false;
        this.dequeuedMessageId = null;
        this.payload = null;
        this.doRPC();
    }

    @Override
    void marshal() throws IOException {
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.queueNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.consumerNameBytes != null && this.consumerNameBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.consumerNameBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalSB4(this.dequeueOptions.getDequeueMode().getCode());
        this.meg.marshalSB4(this.dequeueOptions.getNavigation().getCode());
        this.meg.marshalSB4(this.dequeueOptions.getVisibility().getCode());
        this.meg.marshalSB4(this.dequeueOptions.getWait());
        byte[] byArray = this.dequeueOptions.getDequeueMessageId();
        boolean bl2 = false;
        if (byArray != null && byArray.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(byArray.length);
            bl2 = true;
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        if (this.correlationBytes != null && this.correlationBytes.length != 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.correlationBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        this.meg.marshalPTR();
        this.meg.marshalSWORD(this.payloadToid.length);
        this.meg.marshalUB2(this.aqdver);
        this.meg.marshalPTR();
        if (this.dequeueOptions.getRetrieveMessageId()) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(16);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        int n2 = 0;
        if (this.connection.autocommit) {
            n2 = 32;
        }
        if (this.dequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.BUFFERED) {
            n2 |= 2;
        } else if (this.dequeueOptions.getDeliveryFilter() == AQDequeueOptions.DeliveryFilter.PERSISTENT_OR_BUFFERED) {
            n2 |= 0x10;
        }
        this.meg.marshalUB4(n2);
        if (this.conditionBytes != null && this.conditionBytes.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.conditionBytes.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        if (this.nbExtensions > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSWORD(this.nbExtensions);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSWORD(0);
        }
        if (this.queueNameBytes != null && this.queueNameBytes.length != 0) {
            this.meg.marshalCHR(this.queueNameBytes);
        }
        if (this.consumerNameBytes != null && this.consumerNameBytes.length != 0) {
            this.meg.marshalCHR(this.consumerNameBytes);
        }
        if (bl2) {
            this.meg.marshalB1Array(byArray);
        }
        if (this.correlationBytes != null && this.correlationBytes.length != 0) {
            this.meg.marshalCHR(this.correlationBytes);
        }
        this.meg.marshalB1Array(this.payloadToid);
        if (this.conditionBytes != null && this.conditionBytes.length > 0) {
            this.meg.marshalCHR(this.conditionBytes);
        }
        if (this.nbExtensions > 0) {
            this.meg.marshalKPDKV(this.extensionTextValues, this.extensionBinaryValues, this.extensionKeywords);
        }
    }

    byte[] getPayload() {
        return this.payload;
    }

    boolean hasAMessageBeenDequeued() {
        return this.hasAMessageBeenDequeued;
    }

    byte[] getDequeuedMessageId() {
        return this.dequeuedMessageId;
    }

    @Override
    void readRPA() throws SQLException, IOException {
        this.hasAMessageBeenDequeued = true;
        int n2 = (int)this.meg.unmarshalUB4();
        if (n2 > 0) {
            Object object;
            this.aqm.initToDefaultValues();
            this.aqm.receive();
            this.properties.setPriority(this.aqm.aqmpri);
            this.properties.setDelay(this.aqm.aqmdel);
            this.properties.setExpiration(this.aqm.aqmexp);
            if (this.aqm.aqmcorBytes != null) {
                object = this.meg.conv.CharBytesToString(this.aqm.aqmcorBytes, this.aqm.aqmcorBytesLength, true);
                this.properties.setCorrelation((String)object);
            }
            this.properties.setAttempts(this.aqm.aqmatt);
            if (this.aqm.aqmeqnBytes != null) {
                object = this.meg.conv.CharBytesToString(this.aqm.aqmeqnBytes, this.aqm.aqmeqnBytesLength, true);
                this.properties.setExceptionQueue((String)object);
            }
            this.properties.setMessageState(AQMessageProperties.MessageState.getMessageState(this.aqm.aqmsta));
            this.properties.setEnqueueTime(this.aqm.aqmeqt.timestampValue());
            object = new AQAgentI();
            if (this.aqm.senderAgentName != null) {
                ((AQAgentI)object).setName(this.meg.conv.CharBytesToString(this.aqm.senderAgentName, this.aqm.senderAgentNameLength, true));
            }
            if (this.aqm.senderAgentAddress != null) {
                ((AQAgentI)object).setAddress(this.meg.conv.CharBytesToString(this.aqm.senderAgentAddress, this.aqm.senderAgentAddressLength, true));
            }
            ((AQAgentI)object).setProtocol(this.aqm.senderAgentProtocol);
            this.properties.setSender((AQAgent)object);
            this.properties.setPreviousQueueMessageId(this.aqm.originalMsgId);
            this.properties.setDeliveryMode(AQMessageProperties.DeliveryMode.getDeliveryMode(this.aqm.aqmflg));
            if (this.aqm.aqmetiBytes != null) {
                String string = this.meg.conv.CharBytesToString(this.aqm.aqmetiBytes, this.aqm.aqmetiBytes.length, true);
                this.properties.setTransactionGroup(string);
            }
        }
        int n3 = (int)this.meg.unmarshalUB4();
        this.toh.unmarshal(this.meg);
        int n4 = this.toh.imageLength;
        if (n4 > 0) {
            int n5 = n4;
            if (this.isRawQueue) {
                if (n4 > 4) {
                    n5 -= 4;
                }
                n5 = Math.min(n5, this.dequeueOptions.getMaximumBufferLength());
                byte[] byArray = new byte[n5];
                int[] nArray = new int[1];
                if (n4 > 4) {
                    this.meg.unmarshalCLR(byArray, 0, nArray, byArray.length, 4);
                } else {
                    this.meg.unmarshalCLR(byArray, 0, nArray, byArray.length);
                }
                this.payload = byArray;
            } else {
                byte[] byArray = new byte[n5];
                int[] nArray = new int[1];
                this.meg.unmarshalCLR(byArray, 0, nArray, byArray.length);
                this.payload = byArray;
            }
        }
        if (this.dequeueOptions.getRetrieveMessageId()) {
            byte[] byArray = new byte[16];
            this.meg.unmarshalBuffer(byArray, 0, 16);
            this.dequeuedMessageId = byArray;
        }
    }

    @Override
    void processError() throws SQLException {
        if (this.oer.retCode != 25228L) {
            this.oer.processError();
        }
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

