/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.DateTimeCommonAccessor;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.Representation;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.sql.Datum;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.COLUMN_GET, Feature.RESULT_FETCH})
class TimestampAccessor
extends DateTimeCommonAccessor {
    static final int MAXLENGTH = 11;

    TimestampAccessor(OracleStatement oracleStatement, int n2, short s2, int n3, boolean bl2) throws SQLException {
        super(Representation.TIMESTAMP, oracleStatement, 11, bl2);
        this.init(oracleStatement, 180, 180, s2, bl2);
        this.initForDataAccess(n3, n2, null);
    }

    TimestampAccessor(OracleStatement oracleStatement, int n2, boolean bl2, int n3, int n4, int n5, long l2, int n6, short s2) throws SQLException {
        super(Representation.TIMESTAMP, oracleStatement, 11, false);
        this.init(oracleStatement, 180, 180, s2, false);
        this.initForDescribe(180, n2, bl2, n3, n4, n5, l2, n6, s2, null);
        this.initForDataAccess(0, n2, null);
    }

    @Override
    String getString(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        this.getBytesInternal(n2, this.tmpBytes);
        int n3 = this.getLength(n2);
        int n4 = this.oracleYear(this.tmpBytes);
        int n5 = -1;
        if (n3 == 11) {
            n5 = this.oracleNanos(this.tmpBytes);
        }
        int n6 = this.oracleHour(this.tmpBytes);
        String string = this.toText(n4, this.oracleMonth(this.tmpBytes) + 1, this.oracleDay(this.tmpBytes), n6, this.oracleMin(this.tmpBytes), this.oracleSec(this.tmpBytes), n5, n6 < 12, null);
        return string;
    }

    @Override
    Object getObject(int n2) throws SQLException {
        if (this.isUseLess || this.isNull(n2)) {
            return null;
        }
        if (this.externalType == 0) {
            if (this.statement.connection.j2ee13Compliant) {
                return this.getTimestamp(n2);
            }
            return this.getTIMESTAMP(n2);
        }
        switch (this.externalType) {
            case 93: {
                return this.getTimestamp(n2);
            }
        }
        throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4).fillInStackTrace();
    }

    @Override
    Datum getOracleObject(int n2) throws SQLException {
        return this.getTIMESTAMP(n2);
    }

    @Override
    Object getObject(int n2, Map map) throws SQLException {
        return this.getObject(n2);
    }
}

