/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.logging.runtime;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.runtime.Features;
import oracle.jdbc.logging.runtime.TraceController;

@DisableTrace
public class TraceControllerImpl
implements TraceController {
    private static final Features features;
    private RuntimeException reSuspended = new IllegalStateException("trace controller is currently suspended");
    public static long feature;
    private static long backup;
    private static int suspends;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void trace(boolean bl2, Feature ... featureArray) {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                throw this.reSuspended;
            }
            long l2 = 0L;
            for (Feature feature : featureArray) {
                l2 |= feature.bitVector();
            }
            feature = bl2 ? feature | l2 : feature & (l2 ^ 0xFFFFFFFFFFFFFFFFL);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getEnabledFeatures() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return new Feature[0];
            }
            ArrayList<Feature> arrayList = new ArrayList<Feature>();
            if (feature == Feature.ALL.bitVector()) {
                arrayList.add(Feature.ALL);
            } else {
                for (Feature feature : this.getSupportedFeatures()) {
                    if (Feature.ALL == feature) continue;
                    if (0L == (TraceControllerImpl.feature & feature.bitVector())) continue;
                    arrayList.add(feature);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return arrayList.toArray(new Feature[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Feature[] getSupportedFeatures() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            ArrayList<Feature> arrayList = new ArrayList<Feature>();
            for (Feature feature : Feature.values()) {
                arrayList.add(feature);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return arrayList.toArray(new Feature[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 == suspends++) {
                backup = feature;
                feature = 0L;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume() {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            int n2 = --suspends;
            if (0 == n2) {
                feature = backup;
            } else if (n2 < 0) {
                suspends = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isTracing(Feature ... featureArray) {
        Class<TraceControllerImpl> clazz = TraceControllerImpl.class;
        synchronized (TraceControllerImpl.class) {
            if (0 != suspends) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return false;
            }
            boolean bl2 = true;
            for (Feature feature : featureArray) {
                if (0L != (TraceControllerImpl.feature & feature.bitVector())) continue;
                bl2 = false;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return bl2;
        }
    }

    static {
        String string;
        features = new Features("oracle.jdbc.logging.annotations.Supports");
        feature = Feature.ALL_UCP.bitVector();
        String string2 = System.getProperty("oracle.jdbc.Trace");
        if (null != string2 && ("true".equals(string = string2.trim().toLowerCase()) || "on".equals(string))) {
            feature |= Feature.ALL_JDBC.bitVector();
        }
        if (null != (string = System.getProperty("java.util.logging.config.file"))) {
            Properties properties = new Properties();
            InputStream inputStream = TraceControllerImpl.class.getClassLoader().getResourceAsStream(string);
            if (null == inputStream) {
                try {
                    inputStream = new FileInputStream(string);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (null != inputStream) {
                try {
                    properties.load(inputStream);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            long l2 = 0L;
            for (Feature feature : Feature.values()) {
                String string3 = "clio.feature." + feature.toString().toLowerCase();
                String string4 = properties.getProperty(string3);
                if (null == string4) continue;
                String string5 = string4.toLowerCase().trim();
                if ("on".equals(string5) || "true".equals(string5)) {
                    l2 |= feature.bitVector();
                    continue;
                }
                if (!"off".equals(string5) && !"false".equals(string5)) continue;
                l2 &= feature.bitVector() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (0L != l2) {
                feature = l2;
            }
        }
        backup = 0L;
        suspends = 0;
    }
}

