/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Executable;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.oracore.PickleOutputStream;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.OBJECT_TYPES})
@DefaultLevel(value=Logging.FINEST)
public final class PickleContext {
    private PickleOutputStream outStream;
    byte[] image;
    int imageOffset;
    private byte[] byteBuffer = new byte[5];
    private int userCode = 0;
    static short KOPI20_LN_ELNL = (short)255;
    static short KOPI20_LN_5BLN = (short)254;
    static short KOPI20_LN_ATMN = (short)253;
    static short KOPI20_LN_IEMN = (short)252;
    static short KOPI20_LN_MAXV = (short)245;
    static short KOPI20_IF_IS81 = (short)128;
    static short KOPI20_IF_CMSB = (short)64;
    static short KOPI20_IF_CLSB = (short)32;
    static short KOPI20_IF_DEGN = (short)16;
    static short KOPI20_IF_COLL = (short)8;
    static short KOPI20_IF_NOPS = (short)4;
    static short KOPI20_IF_ANY = (short)2;
    static short KOPI20_IF_NONL = 1;
    static short KOPI20_CF_CMSB = (short)64;
    static short KOPI20_CF_CLSB = (short)32;
    static short KOPI20_CF_INDX = (short)16;
    static short KOPI20_CF_NOLN = (short)8;
    static short KOPI20_VERSION = 1;
    public static final byte KOPU_UPT_INDEX_TBL = 1;
    public static final byte KOPU_UPT_NEST_TBL = 2;
    public static final byte KOPU_UPT_VARRAY = 3;
    public static final byte KOPU_UPT_ASSOC_ARRAY = 4;
    static final byte KOPUP_INLINE_COLL = 1;
    static final byte KOPUP_TYPEINFO_NONE = 0;
    static final byte KOPUP_TYPEINFO_TOID = 4;
    static final byte KOPUP_TYPEINFO_TOBJN = 8;
    static final byte KOPUP_TYPEINFO_TDS = 12;
    static final byte KOPUP_VSN_PRESENT = 16;

    public PickleContext() {
    }

    public PickleContext(byte[] byArray) {
        this.image = byArray;
        this.imageOffset = 0;
    }

    public PickleContext(byte[] byArray, long l2) {
        this.image = byArray;
        this.imageOffset = (int)l2;
    }

    public void initStream(int n2) {
        this.outStream = new PickleOutputStream(n2);
    }

    public void initStream() {
        this.outStream = new PickleOutputStream();
    }

    public int lengthInBytes(int n2) {
        return n2 <= KOPI20_LN_MAXV ? 1 : 5;
    }

    public int writeElementNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ELNL);
        return 1;
    }

    public int writeAtomicNull() throws SQLException {
        this.outStream.write(KOPI20_LN_ATMN);
        return 1;
    }

    public int writeImmediatelyEmbeddedElementNull(byte by2) throws SQLException {
        this.byteBuffer[0] = (byte)KOPI20_LN_IEMN;
        this.byteBuffer[1] = by2;
        this.outStream.write(this.byteBuffer, 0, 2);
        return 2;
    }

    public int writeSB2(int n2) throws SQLException {
        this.byteBuffer[0] = (byte)(n2 >> 8 & 0xFF);
        this.byteBuffer[1] = (byte)(n2 & 0xFF);
        this.outStream.write(this.byteBuffer, 0, 2);
        return 2;
    }

    public int writeUB4(int n2) throws SQLException {
        this.byteBuffer[0] = (byte)(n2 >> 24 & 0xFF);
        this.byteBuffer[1] = (byte)(n2 >> 16 & 0xFF);
        this.byteBuffer[2] = (byte)(n2 >> 8 & 0xFF);
        this.byteBuffer[3] = (byte)(n2 & 0xFF);
        this.outStream.write(this.byteBuffer, 0, 4);
        return 4;
    }

    public int writeLength(int n2) throws SQLException {
        if (n2 <= KOPI20_LN_MAXV) {
            this.outStream.write((byte)n2);
            return 1;
        }
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)(n2 >> 24);
        this.byteBuffer[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(n2 &= 0xFF);
        try {
            this.outStream.write(this.byteBuffer);
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return 5;
    }

    public int writeLength(int n2, boolean bl2) throws SQLException {
        if (!bl2) {
            return this.writeLength(n2);
        }
        if (n2 <= KOPI20_LN_MAXV - 1) {
            this.outStream.write((byte)n2 + 1);
            return 1;
        }
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)((n2 += 5) >> 24);
        this.byteBuffer[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(n2 &= 0xFF);
        try {
            this.outStream.write(this.byteBuffer);
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return 5;
    }

    public byte[] to5bLengthBytes_pctx(int n2) throws SQLException {
        this.byteBuffer[0] = (byte)KOPI20_LN_5BLN;
        this.byteBuffer[1] = (byte)(n2 >> 24);
        this.byteBuffer[2] = (byte)((n2 &= 0xFFFFFF) >> 16);
        this.byteBuffer[3] = (byte)((n2 &= 0xFFFF) >> 8);
        this.byteBuffer[4] = (byte)(n2 &= 0xFF);
        return this.byteBuffer;
    }

    public int writeData(byte by2) throws SQLException {
        this.outStream.write(by2);
        return 1;
    }

    public int writeData(byte[] byArray) throws SQLException {
        try {
            this.outStream.write(byArray);
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            iOException.printStackTrace(printWriter);
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), iOException).fillInStackTrace();
        }
        return byArray.length;
    }

    public void patchImageLen(int n2, int n3) throws SQLException {
        byte[] byArray = this.to5bLengthBytes_pctx(n3);
        this.outStream.overwrite(n2, byArray, 0, byArray.length);
    }

    public int writeImageHeader(boolean bl2) throws SQLException {
        return this.writeImageHeader(KOPI20_LN_MAXV + 1, bl2);
    }

    public int writeOpaqueImageHeader(int n2) throws SQLException {
        int n3 = 2;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS | KOPI20_IF_NONL);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        return n3 += this.writeLength(n2 + 2, true);
    }

    public int writeImageHeader(int n2, boolean bl2) throws SQLException {
        int n3 = 2;
        this.byteBuffer[0] = bl2 ? (byte)KOPI20_IF_IS81 : (byte)(KOPI20_IF_IS81 | KOPI20_IF_NOPS);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        return n3 += this.writeLength(n2);
    }

    public int writeCollImageHeader(int n2, int n3) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, n2, n3);
    }

    public int writeCollImageHeader(int n2, int n3, int n4) throws SQLException {
        int n5 = 5;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_COLL);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        n5 += this.writeLength(n2);
        this.byteBuffer[0] = 1;
        this.byteBuffer[1] = 17;
        if (n4 > KOPI20_LN_MAXV) {
            this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 5);
            n5 += 5;
            this.outStream.write(this.byteBuffer, 0, 2);
            this.writeLength(n4);
        } else {
            this.byteBuffer[0] = (byte)(this.byteBuffer[0] + 2);
            n5 += 2;
            this.outStream.write(this.byteBuffer, 0, 2);
            this.writeSB2(n4);
        }
        this.byteBuffer[0] = this.userCode == 1 ? (byte)KOPI20_CF_INDX : (byte)0;
        this.outStream.write(this.byteBuffer, 0, 1);
        return n5 += this.writeLength(n3);
    }

    public int writeCollImageHeader(byte[] byArray) throws SQLException {
        return this.writeCollImageHeader(KOPI20_LN_MAXV + 1, byArray);
    }

    public int writeCollImageHeader(int n2, byte[] byArray) throws SQLException {
        int n3 = byArray.length;
        int n4 = 3 + n3;
        this.byteBuffer[0] = (byte)(KOPI20_IF_IS81 | KOPI20_IF_DEGN);
        this.byteBuffer[1] = (byte)KOPI20_VERSION;
        this.outStream.write(this.byteBuffer, 0, 2);
        n4 += this.writeLength(n2);
        this.byteBuffer[0] = 0;
        this.outStream.write(this.byteBuffer, 0, 1);
        this.outStream.write(byArray, 0, n3);
        return n4 += this.writeLength(n3 + 1);
    }

    public byte[] stream2Bytes() throws SQLException {
        return this.outStream.toByteArray();
    }

    public byte readByte() throws SQLException {
        try {
            byte by2 = this.image[this.imageOffset];
            return by2;
        }
        finally {
            ++this.imageOffset;
        }
    }

    public boolean readAndCheckVersion() throws SQLException {
        try {
            boolean bl2 = (this.image[this.imageOffset] & 0xFF) <= KOPI20_VERSION;
            return bl2;
        }
        finally {
            ++this.imageOffset;
        }
    }

    public int readLength() throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        if (n2 > KOPI20_LN_MAXV) {
            if (n2 == KOPI20_LN_ELNL) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid null flag read").fillInStackTrace();
            }
            n2 = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        return n2;
    }

    public void skipLength() throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        this.imageOffset = n2 > KOPI20_LN_MAXV ? (this.imageOffset += 5) : ++this.imageOffset;
    }

    public int readRestOfLength(byte by2) throws SQLException {
        if ((by2 & 0xFF) != KOPI20_LN_5BLN) {
            return by2 & 0xFF;
        }
        try {
            int n2 = (((this.image[this.imageOffset] & 0xFF) * 256 + (this.image[this.imageOffset + 1] & 0xFF)) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF);
            return n2;
        }
        finally {
            this.imageOffset += 4;
        }
    }

    public void skipRestOfLength(byte by2) throws SQLException {
        if ((by2 & 0xFF) > KOPI20_LN_MAXV) {
            if ((by2 & 0xFF) == KOPI20_LN_5BLN) {
                this.imageOffset += 4;
            } else {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid first length byte").fillInStackTrace();
            }
        }
    }

    public int readLength(boolean bl2) throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        if (n2 > KOPI20_LN_MAXV) {
            n2 = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            if (bl2) {
                n2 -= 5;
            }
            this.imageOffset += 5;
        } else {
            if (bl2) {
                --n2;
            }
            ++this.imageOffset;
        }
        return n2;
    }

    public byte[] readPrefixSegment() throws SQLException {
        byte[] byArray = new byte[this.readLength()];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue() throws SQLException {
        int n2 = this.image[this.imageOffset] & 0xFF;
        if (n2 == KOPI20_LN_ELNL) {
            ++this.imageOffset;
            return null;
        }
        if (n2 > KOPI20_LN_MAXV) {
            n2 = (((this.image[this.imageOffset + 1] & 0xFF) * 256 + (this.image[this.imageOffset + 2] & 0xFF)) * 256 + (this.image[this.imageOffset + 3] & 0xFF)) * 256 + (this.image[this.imageOffset + 4] & 0xFF);
            this.imageOffset += 5;
        } else {
            ++this.imageOffset;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readBytes(int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, n2);
        this.imageOffset += n2;
        return byArray;
    }

    public byte[] read1ByteDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            return null;
        }
        byte[] byArray = new byte[this.image[this.imageOffset] & 0xFF];
        System.arraycopy(this.image, this.imageOffset + 1, byArray, 0, byArray.length);
        this.imageOffset += byArray.length + 1;
        return byArray;
    }

    public byte[] readDataValue(byte by2) throws SQLException {
        byte[] byArray = new byte[this.readRestOfLength(by2)];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, byArray.length);
        this.imageOffset += byArray.length;
        return byArray;
    }

    public byte[] readDataValue(int n2) throws SQLException {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.image, this.imageOffset, byArray, 0, n2);
        this.imageOffset += n2;
        return byArray;
    }

    public long readUB4() throws SQLException {
        long l2 = (long)this.image[this.imageOffset++] << 24 & 0xFFFFFFFFFF000000L | (long)this.image[this.imageOffset++] << 16 & 0xFF0000L | (long)this.image[this.imageOffset++] << 8 & 0xFF00L | (long)this.image[this.imageOffset++] & 0xFFL;
        return l2;
    }

    public int readUB2() throws SQLException {
        int n2 = this.image[this.imageOffset++] << 8 & 0xFF00 | this.image[this.imageOffset++] & 0xFF;
        return n2;
    }

    public void skipDataValue() throws SQLException {
        if ((this.image[this.imageOffset] & 0xFF) == KOPI20_LN_ELNL) {
            ++this.imageOffset;
        } else {
            this.skipBytes(this.readLength());
        }
    }

    public void skipDataValue(byte by2) throws SQLException {
        this.skipBytes(this.readRestOfLength(by2));
    }

    public void skipBytes(int n2) throws SQLException {
        if (n2 > 0) {
            this.imageOffset += n2;
        }
    }

    public int offset() throws SQLException {
        if (this.outStream != null) {
            return this.outStream.offset();
        }
        return this.imageOffset;
    }

    public int absoluteOffset() throws SQLException {
        return this.imageOffset;
    }

    public void skipTo(long l2) throws SQLException {
        if (l2 > (long)this.imageOffset) {
            this.imageOffset = (int)l2;
        }
    }

    public byte[] image() throws SQLException {
        return this.image;
    }

    public static boolean is81format(byte by2) throws SQLException {
        return (by2 & 0xFF & KOPI20_IF_IS81) != 0;
    }

    public static boolean isCollectionImage_pctx(byte by2) throws SQLException {
        return (by2 & 0xFF & KOPI20_IF_COLL) != 0;
    }

    public static boolean isDegenerateImage_pctx(byte by2) throws SQLException {
        return (by2 & 0xFF & KOPI20_IF_DEGN) != 0;
    }

    public static boolean hasPrefix(byte by2) throws SQLException {
        return (by2 & 0xFF & KOPI20_IF_NOPS) == 0;
    }

    public static boolean isAtomicNull(byte by2) throws SQLException {
        return (by2 & 0xFF) == KOPI20_LN_ATMN;
    }

    public static boolean isImmediatelyEmbeddedNull(byte by2) throws SQLException {
        return (by2 & 0xFF) == KOPI20_LN_IEMN;
    }

    public static boolean isElementNull(byte by2) throws SQLException {
        return (by2 & 0xFF) == KOPI20_LN_ELNL;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    void setCollectionUserCode(int n2) {
        this.userCode = n2;
    }
}

