/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import oracle.sql.Datum;

class SINT32
extends Datum {
    boolean isBigEndian;

    private SINT32() {
    }

    private SINT32(byte[] byArray, boolean bl2) {
        this.setBytes(byArray);
        this.isBigEndian = bl2;
    }

    @Override
    public boolean isConvertibleTo(Class clazz) {
        return false;
    }

    @Override
    public Object toJdbc() {
        return SINT32.bytesToInt(this.shareBytes(), this.isBigEndian);
    }

    @Override
    public Object makeJdbcArray(int n2) {
        return new SINT32[n2];
    }

    static SINT32[] createArray(int n2) {
        return new SINT32[n2];
    }

    static int bytesToInt(byte[] byArray, boolean bl2) {
        int n2 = 0;
        int n3 = bl2 ? 0 : byArray.length - 1;
        for (byte by2 : byArray) {
            n2 |= (by2 & 0xFF) << n3 * 8;
            n3 += bl2 ? 1 : -1;
        }
        return n2;
    }

    static SINT32 valueOf(int n2, boolean bl2) {
        byte[] byArray = new byte[4];
        int n3 = bl2 ? 0 : byArray.length - 1;
        for (int i2 = 0; i2 < 4; ++i2) {
            byArray[i2] = (byte)(n2 >> n3 * 8 & 0xFF);
            n3 += bl2 ? 1 : -1;
        }
        return new SINT32(byArray, bl2);
    }
}

