/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.proxy;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import oracle.jdbc.logging.annotations.DisableTrace;

@DisableTrace
public class WeakIdentityHashMap<K, V>
implements Map<K, V> {
    private static final int DEFAULT_INITIAL_CAPACITY = 16;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    Entry<K, V>[] table;
    private int size;
    private int threshold;
    private final float loadFactor;
    private final ReferenceQueue<Object> queue = new ReferenceQueue();
    private static final int CALLS_BEFORE_NEXT_EXPUNGE = 10;
    private int callsBeforeNextExpunge = 10;
    volatile int modCount;
    private static final Object NULL_KEY = new Object();
    private transient Set<Map.Entry<K, V>> entrySet = null;
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;

    private Entry<K, V>[] newTable(int n2) {
        return new Entry[n2];
    }

    public WeakIdentityHashMap(int n2, float f2) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("Illegal Initial Capacity: " + n2);
        }
        if (n2 > 0x40000000) {
            n2 = 0x40000000;
        }
        if (f2 <= 0.0f || Float.isNaN(f2)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f2);
        }
        for (n3 = 1; n3 < n2; n3 <<= 1) {
        }
        this.table = this.newTable(n3);
        this.loadFactor = f2;
        this.threshold = (int)((float)n3 * f2);
    }

    public WeakIdentityHashMap(int n2) {
        this(n2, 0.75f);
    }

    public WeakIdentityHashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 16;
        this.table = this.newTable(16);
    }

    public WeakIdentityHashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        this.putAll(map);
    }

    private static Object maskNull(Object object) {
        return object == null ? NULL_KEY : object;
    }

    static Object unmaskNull(Object object) {
        return object == NULL_KEY ? null : object;
    }

    private static boolean eq(Object object, Object object2) {
        return object == object2;
    }

    private static int indexFor(int n2, int n3) {
        return n2 & n3 - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Reference<Object> reference;
        while ((reference = this.queue.poll()) != null) {
            ReferenceQueue<Object> referenceQueue = this.queue;
            synchronized (referenceQueue) {
                Entry<K, V> entry;
                Entry entry2 = (Entry)reference;
                int n2 = WeakIdentityHashMap.indexFor(entry2.hash, this.table.length);
                Entry<K, V> entry3 = entry = this.table[n2];
                while (entry3 != null) {
                    Entry entry4 = entry3.next;
                    if (entry3 == entry2) {
                        if (entry == entry2) {
                            this.table[n2] = entry4;
                        } else {
                            entry.next = entry4;
                        }
                        entry2.value = null;
                        --this.size;
                        break;
                    }
                    entry = entry3;
                    entry3 = entry4;
                }
            }
        }
    }

    private Entry<K, V>[] getTable() {
        this.expungeStaleEntries();
        return this.table;
    }

    @Override
    public int size() {
        if (this.size == 0) {
            return 0;
        }
        this.expungeStaleEntries();
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public V get(Object object) {
        if (this.callsBeforeNextExpunge-- < 0) {
            this.expungeStaleEntries();
            this.callsBeforeNextExpunge = 10;
        }
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = System.identityHashCode(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry = entryArray[n3];
        while (entry != null) {
            if (entry.hash == n2 && WeakIdentityHashMap.eq(object2, entry.get())) {
                return entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    Entry<K, V> getEntry(Object object) {
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = System.identityHashCode(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry = entryArray[n3];
        while (!(entry == null || entry.hash == n2 && WeakIdentityHashMap.eq(object2, entry.get()))) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public V put(K k2, V v2) {
        if (this.callsBeforeNextExpunge-- < 0) {
            this.expungeStaleEntries();
            this.callsBeforeNextExpunge = 10;
        }
        Object object = WeakIdentityHashMap.maskNull(k2);
        int n2 = System.identityHashCode(object);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry = entryArray[n3];
        while (entry != null) {
            if (n2 == entry.hash && WeakIdentityHashMap.eq(object, entry.get())) {
                Object v3 = entry.value;
                if (v2 != v3) {
                    entry.value = v2;
                }
                return v3;
            }
            entry = entry.next;
        }
        ++this.modCount;
        entry = entryArray[n3];
        entryArray[n3] = new Entry<K, V>(object, v2, this.queue, n2, entry);
        if (++this.size >= this.threshold) {
            this.resize(entryArray.length * 2);
        }
        return null;
    }

    void resize(int n2) {
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = entryArray.length;
        if (n3 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry<K, V>[] entryArray2 = this.newTable(n2);
        this.transfer(entryArray, entryArray2);
        this.table = entryArray2;
        if (this.size >= this.threshold / 2) {
            this.threshold = (int)((float)n2 * this.loadFactor);
        } else {
            this.expungeStaleEntries();
            this.transfer(entryArray2, entryArray);
            this.table = entryArray;
        }
    }

    private void transfer(Entry<K, V>[] entryArray, Entry<K, V>[] entryArray2) {
        for (int i2 = 0; i2 < entryArray.length; ++i2) {
            Entry<K, V> entry = entryArray[i2];
            entryArray[i2] = null;
            while (entry != null) {
                Entry entry2 = entry.next;
                Object t2 = entry.get();
                if (t2 == null) {
                    entry.next = null;
                    entry.value = null;
                    --this.size;
                } else {
                    int n2 = WeakIdentityHashMap.indexFor(entry.hash, entryArray2.length);
                    entry.next = entryArray2[n2];
                    entryArray2[n2] = entry;
                }
                entry = entry2;
            }
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        if (n2 > this.threshold) {
            int n3;
            int n4 = (int)((float)n2 / this.loadFactor + 1.0f);
            if (n4 > 0x40000000) {
                n4 = 0x40000000;
            }
            for (n3 = this.table.length; n3 < n4; n3 <<= 1) {
            }
            if (n3 > this.table.length) {
                this.resize(n3);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry;
        Object object2 = WeakIdentityHashMap.maskNull(object);
        int n2 = System.identityHashCode(object2);
        Entry<K, V>[] entryArray = this.getTable();
        int n3 = WeakIdentityHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry2 = entry = entryArray[n3];
        while (entry2 != null) {
            Entry entry3 = entry2.next;
            if (n2 == entry2.hash && WeakIdentityHashMap.eq(object2, entry2.get())) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    entryArray[n3] = entry3;
                } else {
                    entry.next = entry3;
                }
                return entry2.value;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return null;
    }

    boolean removeMapping(Object object) {
        Entry<K, V> entry;
        if (!(object instanceof Map.Entry)) {
            return false;
        }
        Entry<K, V>[] entryArray = this.getTable();
        Map.Entry entry2 = (Map.Entry)object;
        Object object2 = WeakIdentityHashMap.maskNull(entry2.getKey());
        int n2 = System.identityHashCode(object2);
        int n3 = WeakIdentityHashMap.indexFor(n2, entryArray.length);
        Entry<K, V> entry3 = entry = entryArray[n3];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (n2 == entry3.hash && entry3.equals(entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    entryArray[n3] = entry4;
                } else {
                    entry.next = entry4;
                }
                return true;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return false;
    }

    @Override
    public void clear() {
        while (this.queue.poll() != null) {
        }
        ++this.modCount;
        Arrays.fill(this.table, null);
        this.size = 0;
        while (this.queue.poll() != null) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry<K, V> entry = entryArray[n2];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry<K, V>[] entryArray = this.getTable();
        int n2 = entryArray.length;
        while (n2-- > 0) {
            Entry<K, V> entry = entryArray[n2];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Set<K> keySet() {
        KeySet keySet = this.keySet;
        return keySet != null ? keySet : (this.keySet = new KeySet());
    }

    @Override
    public Collection<V> values() {
        Values values = this.values;
        return values != null ? values : (this.values = new Values());
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet());
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                K k2 = entry.getKey();
                V v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n2 += iterator.next().hashCode();
        }
        return n2;
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<K, V> entry = iterator.next();
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            stringBuilder.append((Object)(k2 == this ? "(this Map)" : k2));
            stringBuilder.append('=');
            stringBuilder.append((Object)(v2 == this ? "(this Map)" : v2));
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
        }
    }

    protected Object clone() throws CloneNotSupportedException {
        WeakIdentityHashMap weakIdentityHashMap = (WeakIdentityHashMap)super.clone();
        weakIdentityHashMap.keySet = null;
        weakIdentityHashMap.values = null;
        return weakIdentityHashMap;
    }

    @DisableTrace
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Entry entry2 = WeakIdentityHashMap.this.getEntry(entry.getKey());
            return entry2 != null && entry2.equals(entry);
        }

        @Override
        public boolean remove(Object object) {
            return WeakIdentityHashMap.this.removeMapping(object);
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }

        private List<Map.Entry<K, V>> deepCopy() {
            ArrayList arrayList = new ArrayList(this.size());
            for (Map.Entry entry : this) {
                arrayList.add(new AbstractMap.SimpleEntry(entry));
            }
            return arrayList;
        }

        @Override
        public Object[] toArray() {
            return this.deepCopy().toArray();
        }

        @Override
        public <T> T[] toArray(T[] TArray) {
            return this.deepCopy().toArray(TArray);
        }
    }

    @DisableTrace
    private class Values
    extends AbstractCollection<V> {
        private Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakIdentityHashMap.this.containsValue(object);
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    @DisableTrace
    private class KeySet
    extends AbstractSet<K> {
        private KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return WeakIdentityHashMap.this.size();
        }

        @Override
        public boolean contains(Object object) {
            return WeakIdentityHashMap.this.containsKey(object);
        }

        @Override
        public boolean remove(Object object) {
            if (WeakIdentityHashMap.this.containsKey(object)) {
                WeakIdentityHashMap.this.remove(object);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            WeakIdentityHashMap.this.clear();
        }
    }

    @DisableTrace
    private class EntryIterator
    extends HashIterator {
        private EntryIterator() {
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    @DisableTrace
    private class KeyIterator
    extends HashIterator {
        private KeyIterator() {
        }

        @Override
        public K next() {
            return this.nextEntry().getKey();
        }
    }

    @DisableTrace
    private class ValueIterator
    extends HashIterator {
        private ValueIterator() {
        }

        @Override
        public V next() {
            return this.nextEntry().value;
        }
    }

    @DisableTrace
    private abstract class HashIterator<T>
    implements Iterator<T> {
        private int index;
        private Entry<K, V> entry = null;
        private Entry<K, V> lastReturned = null;
        private int expectedModCount;
        private Object nextKey;
        private Object currentKey;

        HashIterator() {
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.nextKey = null;
            this.currentKey = null;
            this.index = WeakIdentityHashMap.this.isEmpty() ? 0 : WeakIdentityHashMap.this.table.length;
        }

        @Override
        public boolean hasNext() {
            Entry<K, V>[] entryArray = WeakIdentityHashMap.this.table;
            while (this.nextKey == null) {
                Entry entry = this.entry;
                int n2 = this.index;
                while (entry == null && n2 > 0) {
                    entry = entryArray[--n2];
                }
                this.entry = entry;
                this.index = n2;
                if (entry == null) {
                    this.currentKey = null;
                    return false;
                }
                this.nextKey = entry.get();
                if (this.nextKey != null) continue;
                this.entry = this.entry.next;
            }
            return true;
        }

        protected Entry<K, V> nextEntry() {
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.nextKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.entry;
            this.entry = this.entry.next;
            this.currentKey = this.nextKey;
            this.nextKey = null;
            return this.lastReturned;
        }

        @Override
        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            if (WeakIdentityHashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            WeakIdentityHashMap.this.remove(this.currentKey);
            this.expectedModCount = WeakIdentityHashMap.this.modCount;
            this.lastReturned = null;
            this.currentKey = null;
        }
    }

    @DisableTrace
    private static class Entry<K, V>
    extends WeakReference<Object>
    implements Map.Entry<K, V> {
        V value;
        final int hash;
        Entry<K, V> next;

        Entry(Object object, V v2, ReferenceQueue<Object> referenceQueue, int n2, Entry<K, V> entry) {
            super(object, referenceQueue);
            this.value = v2;
            this.hash = n2;
            this.next = entry;
        }

        @Override
        public K getKey() {
            return (K)WeakIdentityHashMap.unmaskNull(this.get());
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        @Override
        public boolean equals(Object object) {
            Object v2;
            V v3;
            Object k2;
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            K k3 = this.getKey();
            return k3 == (k2 = entry.getKey()) && ((v3 = this.getValue()) == (v2 = entry.getValue()) || v3 != null && v3.equals(v2));
        }

        @Override
        public int hashCode() {
            K k2 = this.getKey();
            V v2 = this.getValue();
            return (k2 == null ? 0 : System.identityHashCode(k2)) ^ (v2 == null ? 0 : v2.hashCode());
        }

        public String toString() {
            return this.getKey() + "=" + this.getValue();
        }
    }
}

