/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.replay.driver;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.replay.driver.FailoverManager;
import oracle.jdbc.replay.driver.NonTxnReplayableBase;
import oracle.jdbc.replay.driver.NonTxnReplayableConnection;
import oracle.jdbc.replay.driver.Replayable;
import oracle.jdbc.replay.internal.ConnectionInitializationCallback;
import oracle.jdbc.replay.internal.OracleDataSource;

@DefaultLogger(value="oracle.jdbc.internal.replay")
@Supports(value={Feature.APPLICATION_CONTINUITY})
class FailoverManagerImpl
implements FailoverManager {
    private static final String MONITOR_TXN = "BEGIN DBMS_APP_CONT_PRVT.MONITOR_TXN; END;";
    private static final String BEGIN_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.BEGIN_REPLAY; END;";
    private static final String END_REPLAY = "BEGIN DBMS_APP_CONT_PRVT.END_REPLAY; END;";
    private CallHistoryEntry head;
    private CallHistoryEntry tail;
    private ReplayLifecycle lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
    private boolean replayInCurrentMode = false;
    private Object replayResult;
    private long requestStartTime;
    private long replayInitiationTimeout = 900L;
    private static final int REPLAY_RETRIES = 3;
    private int replayRetries = 0;
    private OracleDataSource replayDataSource = null;
    private NonTxnReplayableBase connectionProxy;
    private Method callCausingReplayError;
    private int replayErrorCode;
    private String replayErrorMessage;
    private static final ExecutorService executor = Executors.newSingleThreadExecutor(new ThreadFactory(){
        private static final String THREAD_NAME = "OJDBC-AC-WORKER-THREAD";

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(null, runnable, THREAD_NAME);
            thread.setPriority(5);
            thread.setDaemon(true);
            return thread;
        }
    });

    private FailoverManagerImpl(NonTxnReplayableBase nonTxnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        this.connectionProxy = nonTxnReplayableBase;
        this.replayDataSource = oracleDataSource;
        this.enableTxnMonitoring((OracleConnection)this.connectionProxy.getDelegate());
    }

    static FailoverManager getFailoverManager(NonTxnReplayableBase nonTxnReplayableBase, OracleDataSource oracleDataSource) throws SQLException {
        return new FailoverManagerImpl(nonTxnReplayableBase, oracleDataSource);
    }

    private void append(CallHistoryEntry callHistoryEntry) {
        callHistoryEntry.prevEntry = this.tail;
        callHistoryEntry.nextEntry = null;
        if (this.tail != null) {
            this.tail.nextEntry = callHistoryEntry;
        }
        this.tail = callHistoryEntry;
        if (this.head == null) {
            this.head = callHistoryEntry;
        }
        Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
        replayable.addToSameProxyList(callHistoryEntry);
    }

    private void remove(CallHistoryEntry callHistoryEntry) {
        if (callHistoryEntry.nextEntry != null) {
            callHistoryEntry.nextEntry.prevEntry = callHistoryEntry.prevEntry;
        }
        if (callHistoryEntry.prevEntry != null) {
            callHistoryEntry.prevEntry.nextEntry = callHistoryEntry.nextEntry;
        }
        if (this.head == callHistoryEntry) {
            this.head = callHistoryEntry.nextEntry;
        }
        if (this.tail == callHistoryEntry) {
            this.tail = callHistoryEntry.prevEntry;
        }
        Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
        replayable.removeFromSameProxyList(callHistoryEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallHistoryEntry record(Object object, Method method, Object[] objectArray, String string) {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            String string2 = method == null ? "NULL METHOD" : method.getName();
            StringBuilder stringBuilder = new StringBuilder();
            if (objectArray != null && objectArray.length > 0) {
                for (int i2 = 0; i2 < objectArray.length - 1; ++i2) {
                    stringBuilder.append(objectArray[i2]);
                    stringBuilder.append(",");
                }
                stringBuilder.append(objectArray[objectArray.length - 1]);
            }
            CallHistoryEntry callHistoryEntry = new CallHistoryEntry(object, method, objectArray, string);
            this.append(callHistoryEntry);
            return callHistoryEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(Object object, CallHistoryEntry callHistoryEntry, Object object2, String string, long l2, long l3, SQLException sQLException) {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            CallHistoryEntry callHistoryEntry2 = callHistoryEntry == null ? this.tail : callHistoryEntry;
            String string2 = callHistoryEntry2 == null || callHistoryEntry2.method == null ? "NULL METHOD" : callHistoryEntry2.method.getName();
            callHistoryEntry2.result = object2;
            callHistoryEntry2.checksum = l2;
            callHistoryEntry2.scn = l3;
            callHistoryEntry2.callException = sQLException;
            callHistoryEntry2.callStatus = string;
        }
    }

    synchronized void purge() {
        CallHistoryEntry callHistoryEntry = this.head;
        while (callHistoryEntry != null) {
            this.remove(callHistoryEntry);
            callHistoryEntry = callHistoryEntry.nextEntry;
        }
    }

    synchronized void purgeForSameProxy(Set<Object> set, CallHistoryEntry callHistoryEntry) {
        Object object = callHistoryEntry == null ? null : callHistoryEntry.jdbcProxy;
        CallHistoryEntry callHistoryEntry2 = callHistoryEntry;
        while (callHistoryEntry2 != null) {
            Object object2 = callHistoryEntry2.result;
            if (object2 != null && object2 instanceof Replayable && !set.contains(object2)) {
                Replayable replayable = (Replayable)object2;
                replayable.purgeSameProxyList();
                set.add(replayable);
            }
            this.remove(callHistoryEntry2);
            callHistoryEntry2 = callHistoryEntry2.nextEntrySameProxy;
        }
    }

    synchronized boolean isEmpty() {
        return this.head == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fillInAllChecksums() throws SQLException {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            HashSet<Object> hashSet = new HashSet<Object>();
            CallHistoryEntry callHistoryEntry = this.tail.prevEntry;
            while (callHistoryEntry != null) {
                if (!hashSet.contains(callHistoryEntry.jdbcProxy)) {
                    NonTxnReplayableBase nonTxnReplayableBase = (NonTxnReplayableBase)callHistoryEntry.jdbcProxy;
                    nonTxnReplayableBase.fillInChecksum(callHistoryEntry);
                    hashSet.add(callHistoryEntry.jdbcProxy);
                    if (callHistoryEntry.jdbcProxy instanceof ResultSet) {
                        hashSet.add(nonTxnReplayableBase.getCreator());
                    }
                }
                callHistoryEntry = callHistoryEntry.prevEntry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object replayAll(SQLRecoverableException sQLRecoverableException) throws SQLException {
        FailoverManagerImpl failoverManagerImpl = this;
        synchronized (failoverManagerImpl) {
            this.replayRetries = 0;
            do {
                ReplayLifecycle replayLifecycle;
                try {
                    return this.replayAllInternal(sQLRecoverableException, this.replayRetries);
                }
                catch (SQLRecoverableException sQLRecoverableException2) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case REPLAYING: 
                        case REPLAYING_CALLBACK: 
                        case REPLAYING_LASTCALL: {
                            ++this.replayRetries;
                            break;
                        }
                    }
                }
                catch (SQLException sQLException) {
                    replayLifecycle = this.lifecycle;
                    switch (replayLifecycle) {
                        case INTERNALLY_FAILED: {
                            ++this.replayRetries;
                            this.lifecycle = ReplayLifecycle.REPLAYING;
                            break;
                        }
                        case ALWAYS_DISABLED: 
                        case INTERNALLY_DISABLED: 
                        case EXTERNALLY_DISABLED: {
                            this.throwOriginalExceptionWithReplayError(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
                        }
                        case REPLAYING_LASTCALL: {
                            throw sQLException;
                        }
                    }
                }
            } while (this.replayRetries <= 3);
            this.disableReplayAndThrowOriginalError(null, 378, "Replay disabled because maximum number of retries is exceeded", sQLRecoverableException);
            return null;
        }
    }

    synchronized Object replayAllInternal(SQLRecoverableException sQLRecoverableException, int n2) throws SQLException {
        OracleConnection oracleConnection;
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
            this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
        }
        if ((oracleConnection = (OracleConnection)this.replayDataSource.getConnectionNoProxy(((NonTxnReplayableConnection)this.connectionProxy).originalConnectionBuilder)) == null) {
            this.disableReplayAndThrowException(null, 382, "Replay disabled because Failover_Retries is exceeded", sQLRecoverableException);
        }
        long l2 = System.currentTimeMillis();
        if (this.requestStartTime + this.replayInitiationTimeout * 1000L < l2) {
            this.disableReplayAndThrowException(null, 377, "Replay disabled because ReplayInitiationTimeout is exceeded", sQLRecoverableException);
        }
        this.connectionProxy.setDelegate(oracleConnection);
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
        this.lifecycle = ReplayLifecycle.REPLAYING_CALLBACK;
        ConnectionInitializationCallback connectionInitializationCallback = this.replayDataSource.getConnectionInitializationCallback();
        if (connectionInitializationCallback != null) {
            try {
                connectionInitializationCallback.initialize((Connection)((Object)this.connectionProxy));
            }
            catch (SQLException sQLException) {
                this.disableReplayAndThrowException(null, 379, "Replay disabled because Init callback failed", sQLRecoverableException);
            }
            EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
            if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED)) {
                this.disableReplayAndThrowException(null, 380, "Replay disabled because of open transaction in Init callback", sQLRecoverableException);
            }
        }
        this.lifecycle = ReplayLifecycle.REPLAYING;
        if (n2 == 0) {
            this.fillInAllChecksums();
        }
        this.beginReplay(oracleConnection, sQLRecoverableException);
        this.replayResult = this.replayAllBeforeLastCall(sQLRecoverableException);
        this.endReplay(oracleConnection, sQLRecoverableException);
        if (this.tail != null) {
            this.replayResult = ((Replayable)this.tail.jdbcProxy).replayOneCall(this.tail, sQLRecoverableException);
        }
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
        return this.replayResult;
    }

    private synchronized Object replayAllBeforeLastCall(SQLRecoverableException sQLRecoverableException) throws SQLException {
        Object object = null;
        CallHistoryEntry callHistoryEntry = this.head;
        while (callHistoryEntry != this.tail) {
            Replayable replayable = (Replayable)callHistoryEntry.jdbcProxy;
            object = replayable.replayOneCall(callHistoryEntry, sQLRecoverableException);
            if (this.lifecycle != ReplayLifecycle.ENABLED_NOT_REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING && this.lifecycle != ReplayLifecycle.REPLAYING_LASTCALL && this.lifecycle != ReplayLifecycle.REPLAYING_CALLBACK) {
                this.throwReplayExceptionInternal(this.replayErrorCode, this.replayErrorMessage, sQLRecoverableException);
            }
            callHistoryEntry = callHistoryEntry.nextEntry;
        }
        return object;
    }

    boolean isReplayInCurrentMode() {
        return this.replayInCurrentMode;
    }

    void setReplayInCurrentMode() {
        this.replayInCurrentMode = true;
    }

    ReplayLifecycle getReplayLifecycle() {
        return this.lifecycle;
    }

    void setDataSource(OracleDataSource oracleDataSource) {
        this.replayDataSource = oracleDataSource;
    }

    void setReplayInitiationTimeout(int n2) throws SQLException {
        this.replayInitiationTimeout = n2;
    }

    void beginRequest() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        if (this.lifecycle != ReplayLifecycle.INTERNALLY_DISABLED) {
            throw DatabaseError.createSqlException(391);
        }
        this.requestStartTime = System.currentTimeMillis();
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
        if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
            SQLException sQLException = DatabaseError.createSqlException(392);
            throw sQLException;
        }
        this.replayErrorCode = 0;
        this.replayErrorMessage = "";
        this.callCausingReplayError = null;
        oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.CALCULATE_CHECKSUM_ALL);
        this.lifecycle = ReplayLifecycle.ENABLED_NOT_REPLAYING;
    }

    void endRequest() throws SQLException {
        block9: {
            block8: {
                OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
                EnumSet<OracleConnection.TransactionState> enumSet = oracleConnection.getTransactionState();
                if (enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_STARTED) && !enumSet.contains((Object)OracleConnection.TransactionState.TRANSACTION_READONLY)) {
                    try {
                        oracleConnection.rollback();
                    }
                    catch (SQLException sQLException) {
                    }
                    SQLException sQLException = DatabaseError.createSqlException(393);
                    throw sQLException;
                }
                if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
                    return;
                }
                if (this.lifecycle == ReplayLifecycle.INTERNALLY_DISABLED) break block8;
                if (this.lifecycle != ReplayLifecycle.EXTERNALLY_DISABLED) break block9;
            }
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
            return;
        }
        this.disableReplayInternal(null, 381, "Replay disabled after endRequest is called", null);
    }

    void disableReplay() throws SQLException {
        if (this.lifecycle == ReplayLifecycle.ALWAYS_DISABLED) {
            return;
        }
        this.disableReplayInternal(null, 370, "Replay disabled", null);
        this.lifecycle = ReplayLifecycle.EXTERNALLY_DISABLED;
    }

    void disableReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        if (this.lifecycle != ReplayLifecycle.ALWAYS_DISABLED) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_DISABLED;
        }
        this.purge();
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
        try {
            oracleConnection.setChecksumMode(OracleConnection.ChecksumMode.NO_CHECKSUM);
        }
        catch (SQLException sQLException) {
        }
    }

    void failReplayInternal(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) {
        ReplayLifecycle replayLifecycle = this.lifecycle;
        if (this.lifecycle == ReplayLifecycle.REPLAYING || this.lifecycle == ReplayLifecycle.REPLAYING_CALLBACK || this.lifecycle == ReplayLifecycle.REPLAYING_LASTCALL) {
            this.lifecycle = ReplayLifecycle.INTERNALLY_FAILED;
        }
        this.replayErrorCode = n2;
        this.replayErrorMessage = string;
        this.callCausingReplayError = method;
    }

    void throwReplayExceptionInternal(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        if (n2 == 0) {
            return;
        }
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        throw sQLException;
    }

    void disableReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void disableReplayAndThrowOriginalError(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.disableReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwOriginalExceptionWithReplayError(n2, string, sQLRecoverableException);
    }

    void failReplayAndThrowException(Method method, int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLException {
        this.failReplayInternal(method, n2, string, sQLRecoverableException);
        this.throwReplayExceptionInternal(n2, string, sQLRecoverableException);
    }

    void throwOriginalExceptionWithReplayError(int n2, String string, SQLRecoverableException sQLRecoverableException) throws SQLRecoverableException {
        this.killConnectionBeforeReplayDisabledException();
        String string2 = this.callCausingReplayError == null ? "" : this.callCausingReplayError.getName();
        SQLException sQLException = DatabaseError.createSqlException(this.replayErrorCode, string2);
        sQLRecoverableException.setNextException(sQLException);
        throw sQLRecoverableException;
    }

    void killConnectionBeforeReplayDisabledException() {
        final OracleConnection oracleConnection = (OracleConnection)this.connectionProxy.getDelegate();
        try {
            oracleConnection.abort();
        }
        catch (SQLException sQLException) {
        }
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    FailoverManagerImpl.this.closePhysicalConnection(oracleConnection);
                }
            });
        }
        catch (Exception exception) {
        }
    }

    void enableTxnMonitoring(OracleConnection oracleConnection) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(MONITOR_TXN);
            statement.close();
        }
        catch (SQLException sQLException) {
            this.disableReplayInternal(null, 374, "Replay disabled because transaction monitoring failed to be enabled", null);
            this.lifecycle = ReplayLifecycle.ALWAYS_DISABLED;
            throw DatabaseError.createSqlException(395);
        }
    }

    void beginReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(BEGIN_REPLAY);
            statement.close();
            this.lifecycle = ReplayLifecycle.REPLAYING;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 375, "Replay disabled because server begin_replay call failed", sQLRecoverableException);
        }
    }

    void endReplay(OracleConnection oracleConnection, SQLRecoverableException sQLRecoverableException) throws SQLException {
        try {
            Statement statement = oracleConnection.createStatement();
            statement.execute(END_REPLAY);
            statement.close();
            this.lifecycle = ReplayLifecycle.REPLAYING_LASTCALL;
        }
        catch (SQLException sQLException) {
            this.disableReplayAndThrowException(null, 376, "Replay disabled because server end_replay call failed", sQLRecoverableException);
        }
    }

    Replayable getConnectionProxy() {
        return this.connectionProxy;
    }

    private boolean isReplayFailure(SQLException sQLException) {
        int n2;
        boolean bl2 = false;
        if (sQLException instanceof SQLException && (n2 = sQLException.getErrorCode()) >= 370 && n2 < 400) {
            bl2 = true;
        }
        return bl2;
    }

    private void closePhysicalConnection(Connection connection) {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
        }
    }

    static enum ReplayLifecycle {
        ENABLED_NOT_REPLAYING,
        INTERNALLY_FAILED,
        INTERNALLY_DISABLED,
        ALWAYS_DISABLED,
        EXTERNALLY_DISABLED,
        REPLAYING_CALLBACK,
        REPLAYING,
        REPLAYING_LASTCALL;

    }

    static class CallHistoryEntry {
        Object jdbcProxy;
        Method method;
        Object[] args;
        Object result;
        String callStatus;
        long scn;
        long checksum;
        SQLException callException;
        CallHistoryEntry nextEntry = null;
        CallHistoryEntry prevEntry = null;
        CallHistoryEntry nextEntrySameProxy = null;
        CallHistoryEntry prevEntrySameProxy = null;

        CallHistoryEntry(Object object, Method method, Object[] objectArray, String string) {
            this.jdbcProxy = object;
            this.method = method;
            this.args = objectArray;
            this.result = null;
            this.callStatus = string;
        }
    }
}

