/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.sql.Connection;
import java.sql.SQLException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.jdbc.xa.OracleXAResource;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public abstract class OracleXAConnection
extends OraclePooledConnection
implements oracle.jdbc.datasource.OracleXAConnection {
    protected XAResource xaResource = null;

    public OracleXAConnection() throws XAException {
        this((Connection)null);
    }

    public OracleXAConnection(Connection connection) throws XAException {
        super(connection);
    }

    @Override
    public abstract XAResource getXAResource() throws SQLException;

    @Override
    public synchronized Connection getConnection() throws SQLException {
        Connection connection = super.getConnection();
        if (this.xaResource != null) {
            ((OracleXAResource)this.xaResource).setLogicalConnection(connection);
        }
        return connection;
    }

    boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    void setAutoCommit(boolean bl2) throws SQLException {
        this.autoCommit = bl2;
    }
}

