/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.lang.reflect.Executable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.logging.annotations.DefaultLevel;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Logging;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.proxy._Proxy_;
import oracle.jdbc.replay.ReplayableConnection;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.OracleXid;

@DefaultLogger(value="oracle.jdbc")
@Supports(value={Feature.XA})
public abstract class OracleXAResource
implements XAResource {
    public static final int XA_OK = 0;
    public static final short DEFAULT_XA_TIMEOUT = 60;
    protected boolean savedConnectionAutoCommit = false;
    protected boolean savedXAConnectionAutoCommit = false;
    public static final int TMNOFLAGS = 0;
    public static final int TMNOMIGRATE = 2;
    public static final int TMENDRSCAN = 0x800000;
    public static final int TMPROMOTE = 8;
    public static final int TMFAIL = 0x20000000;
    public static final int TMMIGRATE = 0x100000;
    public static final int TMJOIN = 0x200000;
    public static final int TMONEPHASE = 0x40000000;
    public static final int TMRESUME = 0x8000000;
    public static final int TMSTARTRSCAN = 0x1000000;
    public static final int TMSUCCESS = 0x4000000;
    public static final int TMSUSPEND = 0x2000000;
    public static final int ORATMREADONLY = 256;
    public static final int ORATMREADWRITE = 512;
    public static final int ORATMSERIALIZABLE = 1024;
    public static final int ORAISOLATIONMASK = 65280;
    public static final int ORATRANSLOOSE = 65536;
    protected Connection connection = null;
    protected OracleXAConnection xaconnection = null;
    protected int timeout = 60;
    protected String dblink = null;
    private Connection logicalConnection = null;
    private String synchronizeBeforeRecoverNewCall = "BEGIN sys.dbms_xa.dist_txn_sync \n; END;";
    private String synchronizeBeforeRecoverOldCall = "BEGIN sys.dbms_system.dist_txn_sync(0) \n; END;";
    private String recoverySqlRows = "SELECT formatid, globalid, branchid FROM SYS.DBA_PENDING_TRANSACTIONS";
    protected boolean canBeMigratablySuspended = false;
    private boolean isTMRScanStarted = false;
    private static final Xid[] NO_XID = new Xid[0];
    Xid lastActiveXid = null;
    protected Xid activeXid = null;
    protected Hashtable<Xid, XidListEntry> xidHash = new Hashtable(50);

    public OracleXAResource() {
    }

    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        this.connection = connection;
        this.xaconnection = oracleXAConnection;
        if (this.connection == null) {
            throw (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
        }
    }

    public synchronized void setConnection(Connection connection) throws XAException {
        this.connection = connection;
        if (this.connection == null) {
            throw (XAException)DatabaseError.createXAException(-7).fillInStackTrace();
        }
    }

    final synchronized XidListEntry getMatchingXidListEntry(Xid xid) {
        XidListEntry xidListEntry = this.xidHash.get(xid);
        return xidListEntry;
    }

    @DefaultLevel(value=Logging.FINEST)
    protected final synchronized boolean removeXidFromList(Xid xid) {
        if (this.isSameXid(this.activeXid, xid)) {
            this.activeXid = null;
        }
        return this.xidHash.remove(xid) != null;
    }

    final boolean isSameXid(Xid xid, Xid xid2) {
        if (xid == null) {
            return xid == xid2;
        }
        return xid.equals(xid2);
    }

    @DefaultLevel(value=Logging.FINEST)
    protected final boolean isOnStack(Xid xid) throws XAException {
        return this.xidHash.containsKey(xid);
    }

    @DefaultLevel(value=Logging.FINEST)
    protected final synchronized boolean isXidListEmpty() {
        return this.xidHash.isEmpty();
    }

    protected synchronized void createOrUpdateXid(Xid xid, boolean bl2, boolean[] blArray) {
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            blArray[0] = true;
            xidListEntry.isSuspended = bl2;
        } else {
            xidListEntry = new XidListEntry(xid, bl2);
            this.xidHash.put(xid, xidListEntry);
        }
        if (bl2) {
            this.lastActiveXid = this.activeXid;
            this.activeXid = null;
        } else {
            this.enterGlobalTxnMode();
            if (this.lastActiveXid != null && this.isSameXid(xid, this.lastActiveXid)) {
                this.lastActiveXid = null;
            }
            this.activeXid = xidListEntry.xid;
        }
    }

    protected synchronized boolean updateXidList(Xid xid, boolean[] blArray) {
        boolean bl2 = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl2 = true;
            blArray[0] = true;
            blArray[1] = xidListEntry.isSuspended;
            if (xidListEntry.isSuspended) {
                this.enterGlobalTxnMode();
            } else {
                this.exitGlobalTxnMode();
            }
        }
        return bl2;
    }

    protected boolean isXidSuspended(Xid xid) throws XAException {
        boolean bl2 = false;
        XidListEntry xidListEntry = this.getMatchingXidListEntry(xid);
        if (xidListEntry != null) {
            bl2 = xidListEntry.isSuspended;
        }
        return bl2;
    }

    protected Xid suspendStacked(Xid xid) throws XAException {
        Xid xid2 = null;
        if (this.activeXid != null && !this.isSameXid(this.activeXid, xid)) {
            xid2 = this.activeXid;
            if (!this.isXidSuspended(this.activeXid)) {
                this.end(this.activeXid, 0x2000000);
                this.lastActiveXid = this.activeXid;
                this.activeXid = null;
            }
        }
        return xid2;
    }

    protected void resumeStacked(Xid xid) throws XAException {
        if (xid != null) {
            this.start(xid, 0x8000000);
            this.activeXid = xid;
        }
    }

    @Override
    public abstract void start(Xid var1, int var2) throws XAException;

    @Override
    public abstract void end(Xid var1, int var2) throws XAException;

    @Override
    public abstract void commit(Xid var1, boolean var2) throws XAException;

    @Override
    public abstract int prepare(Xid var1) throws XAException;

    @Override
    public abstract void forget(Xid var1) throws XAException;

    @Override
    public abstract void rollback(Xid var1) throws XAException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int n2) throws XAException {
        Connection connection;
        try {
            if (this.connection instanceof ReplayableConnection) {
                ((ReplayableConnection)((Object)this.connection)).disableReplay();
                connection = (Connection)((_Proxy_)((Object)this.connection))._getDelegate_();
            } else {
                connection = this.connection;
            }
        }
        catch (SQLException sQLException) {
            connection = this.connection;
            this.checkError(sQLException, -3);
        }
        Connection connection2 = connection;
        synchronized (connection2) {
            if ((n2 & 0x1800000) != n2) {
                throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
            }
            if (n2 == 0x1000000) {
                this.isTMRScanStarted = true;
            } else {
                if (this.isTMRScanStarted && n2 == 0x800000) {
                    this.isTMRScanStarted = false;
                    return NO_XID;
                }
                if (this.isTMRScanStarted && n2 == 0) {
                    return NO_XID;
                }
            }
            Statement statement = null;
            ResultSet resultSet = null;
            ArrayList<OracleXid> arrayList = new ArrayList<OracleXid>(50);
            try {
                statement = connection.createStatement();
                try {
                    statement.execute(this.synchronizeBeforeRecoverNewCall);
                }
                catch (Exception exception) {
                    statement.execute(this.synchronizeBeforeRecoverOldCall);
                }
                resultSet = statement.executeQuery(this.recoverySqlRows);
                while (resultSet.next()) {
                    arrayList.add(new OracleXid(resultSet.getInt(1), resultSet.getBytes(2), resultSet.getBytes(3)));
                }
            }
            catch (SQLException sQLException) {
                throw (XAException)DatabaseError.createXAException(-3).fillInStackTrace();
            }
            finally {
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (Exception exception) {}
            }
            int n3 = arrayList.size();
            Xid[] xidArray = new Xid[n3];
            System.arraycopy(arrayList.toArray(), 0, xidArray, 0, n3);
            return xidArray;
        }
    }

    protected void restoreAutoCommitModeForGlobalTransaction() throws XAException {
        if (this.savedConnectionAutoCommit && ((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.connection.setAutoCommit(this.savedConnectionAutoCommit);
                this.xaconnection.setAutoCommit(this.savedXAConnectionAutoCommit);
            }
            catch (SQLException sQLException) {
            }
        }
    }

    protected void saveAndAlterAutoCommitModeForGlobalTransaction() throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            try {
                this.savedConnectionAutoCommit = this.connection.getAutoCommit();
                this.connection.setAutoCommit(false);
                this.savedXAConnectionAutoCommit = this.xaconnection.getAutoCommit();
                this.xaconnection.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
            }
        }
    }

    public void resume(Xid xid) throws XAException {
        this.start(xid, 0x8000000);
    }

    public void join(Xid xid) throws XAException {
        this.start(xid, 0x200000);
    }

    public void suspend(Xid xid) throws XAException {
        this.end(xid, 0x2000000);
    }

    public void join(Xid xid, int n2) throws XAException {
        this.timeout = n2;
        this.start(xid, 0x200000);
    }

    public void resume(Xid xid, int n2) throws XAException {
        this.timeout = n2;
        this.start(xid, 0x8000000);
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    @Override
    public boolean isSameRM(XAResource xAResource) throws XAException {
        Connection connection = null;
        if (!(xAResource instanceof OracleXAResource)) {
            return false;
        }
        connection = ((OracleXAResource)xAResource).getConnection();
        try {
            if (this.connection == null || ((OracleConnection)this.connection).isClosed()) {
                return false;
            }
            String string = ((OracleConnection)this.connection).getURL();
            String string2 = ((OracleConnection)this.connection).getProtocolType();
            if (connection != null) {
                boolean bl2 = connection.equals(this.connection) || ((OracleConnection)connection).getURL().equals(string) || ((OracleConnection)connection).getProtocolType().equals(string2) && string2.equals("kprb");
                return bl2;
            }
        }
        catch (SQLException sQLException) {
            throw (XAException)DatabaseError.createXAException(-3).fillInStackTrace();
        }
        return false;
    }

    @Override
    public boolean setTransactionTimeout(int n2) throws XAException {
        if (n2 < 0) {
            throw (XAException)DatabaseError.createXAException(-5).fillInStackTrace();
        }
        this.timeout = n2;
        return true;
    }

    public String getDBLink() {
        return this.dblink;
    }

    public void setDBLink(String string) {
        this.dblink = string;
    }

    public void setLogicalConnection(Connection connection) {
        this.logicalConnection = connection;
    }

    protected void allowGlobalTxnModeOnly(int n2) throws XAException {
        if (((OracleConnection)this.connection).getTxnMode() != 1) {
            throw (XAException)DatabaseError.createXAException(n2).fillInStackTrace();
        }
    }

    protected void exitGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(0);
    }

    protected void enterGlobalTxnMode() {
        ((OracleConnection)this.connection).setTxnMode(1);
    }

    protected void checkError(int n2) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2).fillInStackTrace();
        }
    }

    protected void checkError(int n2, SQLException sQLException) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2, sQLException).fillInStackTrace();
        }
    }

    protected void checkError(int n2, int n3) throws XAException {
        if ((n2 & 0xFFFF) != 0) {
            throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n2, n3).fillInStackTrace();
        }
    }

    protected void checkError(SQLException sQLException, int n2) throws XAException {
        throw (XAException)OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), sQLException, n2).fillInStackTrace();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return (OracleConnection)this.connection;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }

    class XidListEntry {
        Xid xid;
        boolean isSuspended;

        XidListEntry(Xid xid, boolean bl2) {
            this.xid = xid;
            this.isSuspended = bl2;
        }
    }
}

