/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.NetStat;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.ano.Ano;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.ns.ClientProfile;
import oracle.net.ns.Communication;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.TimeoutInterruptHandler;
import oracle.net.resolver.AddrResolution;
import org.ietf.jgss.GSSCredential;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public abstract class NSProtocol
implements Communication,
SQLnetDef {
    protected AddrResolution addrRes;
    protected SessionAtts sAtts;
    private static final boolean ACTIVATE_ANO = true;
    boolean ACTIVATE_ANO_NIO = true;

    @Override
    public SessionAtts getSessionAttributes() {
        return this.sAtts;
    }

    @Override
    public void connect(String string, Properties properties) throws IOException, NetException {
        this.connect(string, properties, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(String string, Properties properties, GSSCredential gSSCredential) throws IOException, NetException {
        block20: {
            Object object;
            if (this.sAtts.connected) {
                throw new NetException(201);
            }
            if (string == null) {
                throw new NetException(208);
            }
            NVFactory nVFactory = new NVFactory();
            NVNavigator nVNavigator = new NVNavigator();
            Object var6_6 = null;
            Object var7_7 = null;
            this.addrRes = new AddrResolution(string, properties);
            String string2 = (String)properties.get("DISABLE_OOB");
            boolean bl2 = string2 != null && "true".equals(string2);
            String string3 = (String)properties.get("USE_ZERO_COPY_IO");
            boolean bl3 = true;
            if (string3 != null && "false".equals(string3)) {
                bl3 = false;
            }
            if (this.sAtts.networkType == NTAdapter.NetworkAdapterType.MSGQ) {
                bl3 = false;
            }
            this.sAtts.traceId = (String)properties.get("T4CConnection.hashCode");
            if (this.addrRes.connection_revised) {
                string = this.addrRes.getTNSAddress();
                properties = this.addrRes.getUp();
            }
            this.sAtts.profile = new ClientProfile(properties);
            this.sAtts.networkCompression = properties.getProperty("oracle.net.networkCompression").toLowerCase();
            this.sAtts.networkCompressionThreshold = Integer.parseInt(properties.getProperty("oracle.net.networkCompressionThreshold"));
            String string4 = properties.getProperty("oracle.net.networkCompressionLevels");
            this.sAtts.networkCompressionLevelsArray = new ArrayList();
            if (string4.equals("(high)")) {
                this.sAtts.networkCompressionLevelsArray.add("high");
            } else {
                string4 = string4.trim();
                string4 = string4.substring(1, string4.length() - 1);
                object = string4.split("\\s+|,");
                for (String string5 : object) {
                    if (string5.equals("")) continue;
                    this.sAtts.networkCompressionLevelsArray.add(string5.toLowerCase());
                }
            }
            try {
                this.establishConnection(string, true);
                object = null;
                if (this.ACTIVATE_ANO_NIO) {
                    try {
                        object = Class.forName("oracle.net.ano.Ano").newInstance();
                        this.sAtts.anoEnabled = true;
                    }
                    catch (Exception exception) {
                        this.sAtts.anoEnabled = false;
                    }
                    if (object != null) {
                        boolean bl4 = Boolean.valueOf(properties.getProperty("oracle.net.useJCEAPI", "false"));
                        ((Ano)object).init(this.sAtts, this.sAtts.isJavaNetNIO, bl4);
                        this.sAtts.ano = (Ano)object;
                        this.sAtts.anoEnabled = true;
                    }
                }
                this.negotiateConnection(nVFactory, nVNavigator, bl2, bl3);
                this.sAtts.connected = true;
                this.sAtts.nt.setReadTimeoutIfRequired(properties);
                String string6 = (String)this.sAtts.nt.getOption(106);
                if (string6 != null && string6.equalsIgnoreCase("false")) {
                    throw new NetException(405);
                }
                if (!this.ACTIVATE_ANO_NIO || this.sAtts.noAnoServices || this.sAtts.ano == null) break block20;
                this.sAtts.ano.negotiation(this.addrRes.connection_redirected, this.sAtts.isJavaNetNIO, gSSCredential);
                String string7 = (String)this.sAtts.nt.getOption(102);
                if (string7 == null || !string7.equals("TRUE")) break block20;
                try {
                    Method method = this.sAtts.ano.getClass().getMethod("getEncryptionAlg", null);
                    if (method.invoke((Object)this.sAtts.ano, (Object[])null) != null) {
                        throw new NetException(406);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            finally {
                object = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
                if (object != null && ((TimeoutInterruptHandler.InterruptTask)object).isInterrupted()) {
                    Thread.interrupted();
                    throw new NetException(503);
                }
            }
        }
        this.addrRes.connection_redirected = false;
    }

    abstract void negotiateConnection(NVFactory var1, NVNavigator var2, boolean var3, boolean var4) throws IOException, NetException;

    @Override
    public void sendBreak() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(2, (byte)1);
            }
        } else {
            this.sendMarker(1, (byte)1);
        }
    }

    @Override
    public void sendInterrupt() throws IOException, NetException {
        if ((this.sAtts.negotiatedOptions & 0x400) == 1024) {
            this.sAtts.nt.sendUrgentByte(33);
            if ((this.sAtts.negotiatedOptions & 0x800) != 2048) {
                this.sendMarker(2, (byte)3);
            }
        } else {
            this.sendMarker(1, (byte)3);
        }
    }

    protected abstract void sendMarker(int var1, byte var2) throws IOException, NetException;

    @Override
    public void setOption(int n2, Object object) throws NetException, IOException {
        if (n2 > 100 && n2 < 110) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            nTAdapter.setOption(n2, object);
        }
    }

    @Override
    public Object getOption(int n2) throws NetException, IOException {
        if (n2 > 100 && n2 < 110) {
            NTAdapter nTAdapter = this.sAtts.getNTAdapter();
            return nTAdapter.getOption(n2);
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        if (nTAdapter != null) {
            nTAdapter.abort();
        }
    }

    @Override
    public String getEncryptionName() {
        String string = null;
        NTAdapter nTAdapter = this.sAtts.getNTAdapter();
        try {
            string = (String)nTAdapter.getOption(105);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null && this.sAtts.ano != null) {
            string = this.sAtts.ano.getEncryptionName();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    @Override
    public String getAccessBanner() {
        return this.sAtts.getConnectData();
    }

    @Override
    public String getDataIntegrityName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getDataIntegrityName();
        }
        return string;
    }

    @Override
    public String getAuthenticationAdaptorName() {
        String string = "";
        if (this.sAtts.ano != null) {
            string = this.sAtts.ano.getAuthenticationAdaptorName();
        }
        return string;
    }

    public void reconnectIfRequired(boolean bl2) throws IOException {
        long l2 = System.currentTimeMillis();
        long l3 = l2 - this.sAtts.timestampLastIO;
        if (l3 > (long)this.sAtts.timeout) {
            this.reconnect(bl2);
        }
    }

    @Override
    public void setO3logSessionKey(byte[] byArray) throws NetException {
        if (byArray != null) {
            this.sAtts.ano.setO3logSessionKey(byArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconnect(boolean bl2) throws IOException {
        try {
            String string = new String(this.sAtts.reconnectAddress);
            this.sAtts.attemptingReconnect = true;
            ConnOption connOption = this.sAtts.cOption;
            this.addrRes.connection_redirected = true;
            this.sAtts.cOption.nt.disconnect();
            this.establishConnection(string, false);
            this.sAtts.cOption.restoreFromOrigCoption(connOption);
            if (bl2) {
                this.sendProbePacket();
            }
        }
        finally {
            this.sAtts.attemptingReconnect = false;
        }
    }

    SessionAtts establishConnection(String string) throws NetException, IOException {
        return this.establishConnection(string, false);
    }

    SessionAtts establishConnection(String string, boolean bl2) throws NetException, IOException {
        this.sAtts.cOption = this.addrRes.resolveAndExecute(string, bl2);
        if (this.sAtts.cOption == null) {
            return null;
        }
        this.sAtts.nt = this.sAtts.cOption.nt;
        this.sAtts.networkType = this.sAtts.nt.getNetworkAdapterType();
        this.sAtts.setTDU(this.sAtts.cOption.tdu);
        this.sAtts.setSDU(this.sAtts.cOption.sdu);
        this.initializeSessionAttributes();
        return this.sAtts;
    }

    abstract void initializeSessionAttributes() throws NetException, IOException;

    abstract void sendProbePacket() throws IOException;

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.addrRes.isConnectionSocketKeepAlive();
    }

    @Override
    public int getSocketReadTimeout() throws NetException, IOException {
        String string = (String)this.getOption(101);
        int n2 = string == null || "".equals(string) ? 0 : Integer.parseInt(string);
        return n2;
    }

    @Override
    public void setSocketReadTimeout(int n2) throws NetException, IOException {
        String string = Integer.toString(n2);
        this.setOption(101, string);
    }

    @Override
    public String getConnectionString() {
        return this.addrRes.getTNSAddress();
    }

    public Properties getSocketOptions() {
        return this.addrRes.getSocketOptions();
    }

    @Override
    public int getNegotiatedSDU() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.negotiatedSDU;
    }

    @Override
    public NetStat getNetworkStat() {
        return this.sAtts.nt.getNetStat();
    }

    @Override
    public boolean isNetworkCompressionEnabled() {
        return this.sAtts.networkCompressionEnabled;
    }

    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

