/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Executable;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NIOAcceptPacket;
import oracle.net.ns.NIOConnectPacket;
import oracle.net.ns.NIONSDataChannel;
import oracle.net.ns.NIOPacket;
import oracle.net.ns.NIORedirectPacket;
import oracle.net.ns.NIORefusePacket;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;
import oracle.net.nt.TimeoutInterruptHandler;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class NSProtocolNIO
extends NSProtocol {
    private NIONSDataChannel probePacket;
    static final int MAX_RETRIES = 10;

    public NSProtocolNIO(boolean bl2) {
        this.sAtts = new SessionAtts(this, 0x200000, 0x200000, true, bl2);
    }

    @Override
    void negotiateConnection(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl2, boolean bl3) throws IOException, NetException {
        NIOConnectPacket nIOConnectPacket = new NIOConnectPacket(this.sAtts);
        NVPair nVPair = null;
        String string = null;
        block12: while (true) {
            Object object;
            String string2;
            IOException iOException = null;
            NIOPacket nIOPacket = null;
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            try {
                nIOConnectPacket.writeToSocketChannel(this.sAtts.cOption.conn_data.toString(), !bl2, bl3, this.sAtts.nt.isCharacteristicUrgentSupported(), this.sAtts.getSDU(), this.sAtts.getTDU(), this.sAtts.getANOFlags());
                nIOPacket = NIOPacket.readNIOPacket(this.sAtts);
                n2 = nIOPacket.header.type;
            }
            catch (IOException iOException2) {
                string2 = String.format("%s, connect lapse %d ms.", iOException2.getMessage(), System.currentTimeMillis() - l2);
                object = new IOException(string2, iOException2);
                iOException = this.handleIOException(iOException2);
                n2 = 4;
            }
            switch (n2) {
                case 2: {
                    NIOAcceptPacket nIOAcceptPacket = (NIOAcceptPacket)nIOPacket;
                    this.sAtts.setNegotiatedSDUAndTDU(nIOAcceptPacket.sduSize, nIOAcceptPacket.tduSize);
                    this.sAtts.setNegotiatedOptions(nIOAcceptPacket.options);
                    this.sAtts.setConnectData(nIOAcceptPacket.connectData);
                    this.sAtts.cOption.nt.resetInetAddress();
                    this.sAtts.payloadDataBufferForRead.position(this.sAtts.payloadDataBufferForRead.limit());
                    this.sAtts.connected = true;
                    if (!nIOAcceptPacket.isOOBCheckEnabled) break block12;
                    this.sAtts.nt.sendUrgentByte(33);
                    this.sendMarker(2, (byte)3);
                    break block12;
                }
                case 5: {
                    NIORedirectPacket nIORedirectPacket = (NIORedirectPacket)nIOPacket;
                    ConnOption connOption = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption.nt.resetInetAddress();
                    string2 = nIORedirectPacket.redirectData;
                    object = null;
                    if ((nIORedirectPacket.header.flags & 2) == 2 && nIORedirectPacket.redirectData.indexOf(0) != -1) {
                        string2 = nIORedirectPacket.redirectData.substring(0, nIORedirectPacket.redirectData.indexOf(0));
                        this.sAtts.redirecting = true;
                        object = nIORedirectPacket.redirectData.substring(nIORedirectPacket.redirectData.indexOf(0) + 1, nIORedirectPacket.redirectData.length());
                    }
                    this.establishConnection(string2);
                    this.sAtts.cOption.restoreFromOrigCoption(connOption);
                    if (!this.sAtts.redirecting) continue block12;
                    this.sAtts.cOption.conn_data.setLength(0);
                    this.sAtts.cOption.conn_data.append((String)object);
                    break;
                }
                case 4: {
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
                    if (interruptTask != null && interruptTask.isInterrupted()) {
                        Thread.interrupted();
                    }
                    try {
                        this.establishConnection(null, true);
                    }
                    catch (NetException netException) {
                        // empty catch block
                    }
                    if (this.sAtts.cOption != null) continue block12;
                    if (iOException != null) {
                        throw iOException;
                    }
                    if (nIOPacket != null) {
                        NIORefusePacket nIORefusePacket = (NIORefusePacket)nIOPacket;
                        try {
                            NVPair nVPair2;
                            nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(nIORefusePacket.refuseData), "ERROR");
                            if (nVPair != null && (nVPair2 = nVNavigator.findNVPairRecurse(nVPair, "CODE")) != null) {
                                string = nVPair2.valueToString();
                            }
                        }
                        catch (NLException nLException) {
                        }
                        throw new NetException(string == null ? 206 : Integer.parseInt(string), "");
                    }
                }
                case 11: {
                    if ((nIOPacket.header.flags & 8) != 8) continue block12;
                    this.sAtts.renegotiateSSLSession();
                    break;
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
        }
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        boolean bl2 = false;
        for (int i2 = n3; i2 > 0; i2 -= n4) {
            if (i2 >= 1703910) {
                n4 = 1703910;
            } else {
                n4 = i2;
                bl2 = true;
            }
            this.sAtts.prepareWriteBuffer();
            this.sAtts.ddPacket.writeToSocketChannel(n4, bl2);
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray, n2, n4);
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.write(byteBuffer);
            }
            n2 += n4;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IOException handleIOException(IOException iOException) throws IOException {
        IOException iOException2 = iOException;
        if (iOException instanceof TimeoutInterruptHandler.IOReadTimeoutException) {
            Thread.interrupted();
            return iOException2;
        } else {
            if (iOException instanceof InterruptedIOException) {
                TimeoutInterruptHandler.InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
                if (interruptTask == null) throw iOException;
                if (!interruptTask.isInterrupted()) throw iOException;
                Thread.interrupted();
                return new NetException(503);
            }
            TimeoutInterruptHandler.cancelInterrupt(TimeoutInterruptHandler.InterruptTaskType.OUTBOUND_TIMEOUT, Thread.currentThread());
        }
        return iOException2;
    }

    @Override
    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException {
        boolean bl2 = false;
        this.sAtts.ddPacket.readFromSocketChannel(true);
        this.sAtts.ddPacket.readPayloadBuffer();
        int n3 = this.sAtts.ddPacket.totalDataLength;
        if ((this.sAtts.ddPacket.descriptorFLaG & 1) != 0) {
            bl2 = true;
        }
        if (byArray.length < n2 + n3) {
            throw new IOException("Assertion Failed");
        }
        int n4 = 0;
        ByteBuffer byteBuffer = this.sAtts.readBuffer;
        if (byteBuffer.hasRemaining()) {
            int n5 = Math.min(byteBuffer.remaining(), n3);
            byteBuffer.get(byArray, n2, n5);
            n4 += n5;
        }
        while (n4 < n3) {
            byteBuffer.clear();
            byteBuffer.limit(Math.min(byteBuffer.capacity(), n3 - n4));
            while (byteBuffer.hasRemaining()) {
                this.sAtts.socketChannel.read(byteBuffer);
            }
            byteBuffer.rewind();
            byteBuffer.get(byArray, n2 + n4, byteBuffer.limit());
            n4 += byteBuffer.limit();
        }
        nArray[0] = n4;
        return bl2;
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.dataChannel.sendEOF();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        this.sAtts.releaseWriteBuffer();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(1, (byte)2);
        while (this.sAtts.onBreakReset) {
            this.sAtts.markerPacket.readFromSocketChannel(true, false);
            this.sAtts.markerPacket.readPayloadBuffer();
            if (!this.sAtts.markerPacket.isResetPkt()) continue;
            this.sAtts.onBreakReset = false;
        }
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public InputStream getInputStream() throws NetException, IOException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException, IOException {
        throw new UnsupportedOperationException("Unsupported operation in NIO");
    }

    @Override
    public OutputStream getOutputStream() throws NetException, IOException {
        return this.getNetOutputStream();
    }

    @Override
    void initializeSessionAttributes() throws NetException, IOException {
        this.sAtts.socketChannel = this.sAtts.nt.getSocketChannel();
        this.sAtts.initializeBuffer(this.sAtts.getSDU());
        this.sAtts.dataEOF = false;
    }

    @Override
    protected void sendMarker(int n2, byte by2) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sAtts.markerPacket.writeToSocketChannel(n2, by2);
    }

    @Override
    void sendProbePacket() throws IOException {
        if (this.probePacket == null) {
            this.probePacket = new NIONSDataChannel(this.sAtts);
        } else {
            this.probePacket.reinitialize(this.sAtts);
        }
        byte[] byArray = new byte[26];
        this.probePacket.writeDataToSocketChannel(byArray);
    }

    void doSocketRead(int n2) throws IOException {
        int n3 = this.sAtts.readBuffer.position();
        int n4 = 0;
        while (this.sAtts.readBuffer.position() < n2) {
            int n5 = this.sAtts.socketChannel.read(this.sAtts.readBuffer);
            if (n5 < 0) {
                throw new NetException(0);
            }
            if (n5 == 0) {
                if (++n4 < 10) continue;
                throw new NetException(0);
            }
            n4 = 0;
        }
        this.sAtts.readBuffer.flip();
        this.sAtts.readBuffer.position(n3);
    }

    @Override
    public void sendZDP() throws IOException {
        this.sAtts.prepareWriteBuffer();
        this.sAtts.dataChannel.header.type = 6;
        this.sAtts.payloadBufferForWrite.clear();
        this.sAtts.payloadBufferForWrite.limit(2);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.payloadBufferForWrite.put((byte)0);
        this.sAtts.dataChannel.writeToSocketChannel();
    }

    @Override
    public boolean needsToBeClosed() {
        return this.sAtts.needsToBeClosed;
    }

    @Override
    public void readInbandNotification() {
        try {
            if (this.sAtts.needsToBeClosed) {
                return;
            }
            this.sAtts.dataChannel.readInbandNotificationCtlPacket();
        }
        catch (IOException iOException) {
        }
    }

    @Override
    @Log
    protected void debug(Logger logger, Level level, Executable executable, String string) {
        ClioSupport.log(logger, level, this.getClass(), executable, string);
    }
}

