/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.Set;

public abstract class SocketChannelWrapper
extends SocketChannel {
    protected SocketChannel socketChannel = null;
    protected int bufferSize = 8192;

    SocketChannelWrapper(SocketChannel socketChannel) {
        super(socketChannel != null ? socketChannel.provider() : null);
        this.socketChannel = socketChannel;
    }

    abstract void disconnect() throws IOException;

    public SocketChannel getUnderlyingChannel() {
        return this.socketChannel;
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    void setUnderlyingChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
    }

    void setSoTimeout(int n2) {
        if (!(this.socketChannel instanceof SocketChannelWrapper)) {
            throw new UnsupportedOperationException();
        }
        ((SocketChannelWrapper)this.socketChannel).setSoTimeout(n2);
    }

    int getSoTimeout() {
        if (this.socketChannel instanceof SocketChannelWrapper) {
            return ((SocketChannelWrapper)this.socketChannel).getSoTimeout();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T getOption(SocketOption<T> socketOption) throws IOException {
        return this.socketChannel.getOption(socketOption);
    }

    @Override
    public Set<SocketOption<?>> supportedOptions() {
        return this.socketChannel.supportedOptions();
    }

    @Override
    public SocketChannel bind(SocketAddress socketAddress) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> SocketChannel setOption(SocketOption<T> socketOption, T t2) throws IOException {
        return this.socketChannel.setOption((SocketOption)socketOption, (Object)t2);
    }

    @Override
    public SocketChannel shutdownInput() throws IOException {
        return this.socketChannel.shutdownInput();
    }

    @Override
    public SocketChannel shutdownOutput() throws IOException {
        return this.socketChannel.shutdownOutput();
    }

    @Override
    public Socket socket() {
        return this.socketChannel.socket();
    }

    @Override
    public boolean isConnected() {
        return this.socketChannel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.socketChannel.isConnectionPending();
    }

    @Override
    public boolean connect(SocketAddress socketAddress) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    @Override
    public SocketAddress getRemoteAddress() throws IOException {
        return this.socketChannel.getRemoteAddress();
    }

    @Override
    public long read(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long write(ByteBuffer[] byteBufferArray, int n2, int n3) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.socketChannel.getLocalAddress();
    }

    @Override
    protected void implCloseSelectableChannel() throws IOException {
        this.socketChannel.close();
    }

    @Override
    protected void implConfigureBlocking(boolean bl2) throws IOException {
        this.socketChannel.configureBlocking(bl2);
    }
}

