/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import javax.net.ssl.SSLSocketFactory;
import oracle.ons.spi.ONSSocket;
import oracle.ons.spi.SocketCallback;
import oracle.ons.spi.SocketManager;

public class DefaultSocketManager
implements SocketManager {
    @Override
    public ONSSocket createSocket(String string, int n2, int n3, SocketCallback socketCallback) throws IOException {
        DefaultSocket defaultSocket = new DefaultSocket(new Socket());
        defaultSocket.socket.connect(new InetSocketAddress(string, n2), n3);
        defaultSocket.socket.setSoTimeout(n3);
        new ListeningThread(defaultSocket, socketCallback, String.format("ONS Listener Thread to %s:%d", string, n2)).start();
        return defaultSocket;
    }

    @Override
    public ONSSocket createSocket(String string, int n2, int n3, SocketCallback socketCallback, SSLSocketFactory sSLSocketFactory) throws IOException {
        Socket socket = new Socket();
        socket.connect(new InetSocketAddress(string, n2), n3);
        DefaultSocket defaultSocket = new DefaultSocket(sSLSocketFactory.createSocket(socket, string, n2, true));
        new ListeningThread(defaultSocket, socketCallback, String.format("ONS Listener Thread to %s:%d (SSL)", string, n2)).start();
        return defaultSocket;
    }

    private static class ListeningThread
    extends Thread {
        static final int BUFFER_SIZE = 4000;
        private final byte[] buffer = new byte[4000];
        private final DefaultSocket socket;
        private final SocketCallback callback;
        private int data_len;

        public ListeningThread(DefaultSocket defaultSocket, SocketCallback socketCallback, String string) {
            super(string);
            this.socket = defaultSocket;
            this.callback = socketCallback;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            block6: {
                try {
                    InputStream inputStream = this.socket.socket.getInputStream();
                    while (this.socket.socket.isConnected()) {
                        try {
                            this.data_len = inputStream.read(this.buffer);
                        }
                        catch (SocketTimeoutException socketTimeoutException) {
                            continue;
                        }
                        if (this.data_len == -1) {
                            throw new EOFException("Socket closed by remote side");
                        }
                        this.callback.onDataAvailable(this.buffer, 0, this.data_len);
                    }
                }
                catch (Exception exception) {
                    if (this.socket.shuttingDown) break block6;
                    this.callback.hasException(exception);
                }
            }
        }
    }

    private static class DefaultSocket
    implements ONSSocket {
        public Socket socket;
        public volatile boolean shuttingDown = false;

        public DefaultSocket(Socket socket) {
            this.socket = socket;
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return this.socket.getOutputStream();
        }

        @Override
        public void close() throws IOException {
            if (!this.socket.isClosed()) {
                this.socket.close();
                this.shuttingDown = true;
            }
        }
    }
}

