/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.util.LinkedList;
import java.util.Queue;
import java.util.StringTokenizer;
import oracle.ons.Notification;
import oracle.ons.ONSConfiguration;
import oracle.ons.ServerError;

class MessageReader {
    private byte[] buffer = null;
    private Queue<Notification> messageList = new LinkedList<Notification>();
    private int bend;
    private int pos;
    private int bodypos;
    private int token_state = 0;
    private StringBuilder line;
    private Notification msg = null;
    private String headerName = null;
    private final byte[] saveBuffer = new byte[4096];
    private int tokenStart = 0;
    private int saveEnd = 0;
    private static final int TOKEN_END = 100;
    private static final int TOKEN_CONTENT = 10;
    private static final int TOKEN_HEADER = 4;
    private static final int TOKEN_INIT = 0;
    private static final int ST_REQUEST = 0;
    private static final int ST_HEADER = 2;
    private static final int ST_BODY_INIT = 3;
    private static final int ST_BODY_READ = 4;
    private static final int LS_NONE = 0;
    private static final int LS_CHECK_LF = 1;
    private static final int LS_CONTINUE = 2;
    private int line_state = 0;

    MessageReader() {
    }

    public boolean feedBuffer(byte[] byArray, int n2, int n3) {
        this.buffer = byArray;
        this.pos = n2;
        this.bend = n2 + n3;
        boolean bl2 = false;
        while (this.pos < this.bend && this.readMessageFast()) {
            this.msg.deliveryTime = System.currentTimeMillis();
            this.messageList.add(this.msg);
            this.msg = null;
            bl2 = true;
        }
        this.buffer = null;
        return bl2;
    }

    private void saveBuffer() {
        int n2 = this.pos - this.tokenStart;
        System.arraycopy(this.buffer, this.tokenStart, this.saveBuffer, this.saveEnd, n2);
        this.saveEnd += n2;
    }

    private String getLastToken() {
        if (this.saveEnd == 0) {
            String string = new String(this.buffer, this.tokenStart, this.pos - this.tokenStart - 1, ONSConfiguration.ONS_CHARSET);
            return string;
        }
        return new String(this.saveBuffer, 0, this.saveEnd, ONSConfiguration.ONS_CHARSET) + new String(this.buffer, this.tokenStart, this.pos - this.tokenStart - 1, ONSConfiguration.ONS_CHARSET);
    }

    private void startToken() {
        this.saveEnd = 0;
        this.tokenStart = this.pos;
    }

    private boolean readMessageFast() {
        if (this.msg == null) {
            this.msg = new Notification();
            this.token_state = 0;
        }
        this.tokenStart = this.pos;
        block13: while (this.pos < this.bend) {
            switch (this.token_state) {
                case 0: {
                    this.startToken();
                    ++this.token_state;
                }
                case 1: {
                    if (!this.skipTo(' ')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.msg.method = this.getLastToken();
                    this.startToken();
                    ++this.token_state;
                }
                case 2: {
                    if (!this.skipTo(' ')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.msg.verb = this.getLastToken().substring(1);
                    this.startToken();
                    ++this.token_state;
                }
                case 3: {
                    if (!this.skipTo('\r')) continue block13;
                    this.token_state = 4;
                }
                case 4: {
                    if (this.pos >= this.bend) continue block13;
                    ++this.pos;
                    ++this.token_state;
                }
                case 5: {
                    if (this.pos == this.bend) continue block13;
                    if (this.buffer[this.pos] == 13) {
                        ++this.pos;
                        this.token_state = 10;
                        continue block13;
                    }
                    this.startToken();
                    ++this.token_state;
                }
                case 6: {
                    if (!this.skipTo(':')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    this.headerName = this.getLastToken();
                    this.startToken();
                    ++this.token_state;
                }
                case 7: {
                    if (!this.skipTo('\r')) {
                        this.saveBuffer();
                        continue block13;
                    }
                    String string = this.getLastToken();
                    this.msg.put(this.headerName.trim(), string.trim());
                    this.token_state = 4;
                    continue block13;
                }
                case 10: {
                    if (this.pos >= this.bend) continue block13;
                    ++this.pos;
                    if (this.msg.readHelperContentLength > 0) {
                        this.msg.body = new byte[this.msg.readHelperContentLength];
                        this.bodypos = 0;
                        ++this.token_state;
                    } else {
                        this.token_state = 100;
                        return true;
                    }
                }
                case 11: {
                    if (this.pos == this.bend) continue block13;
                    int n2 = Math.min(this.msg.body.length - this.bodypos, this.bend - this.pos);
                    System.arraycopy(this.buffer, this.pos, this.msg.body, this.bodypos, n2);
                    this.bodypos += n2;
                    this.pos += n2;
                    if (this.bodypos != this.msg.body.length) continue block13;
                    this.token_state = 100;
                    return true;
                }
                case 100: {
                    return true;
                }
            }
            throw new ServerError("Message parsing error");
        }
        return false;
    }

    private boolean readMessage() {
        if (this.msg == null) {
            this.msg = new Notification();
        }
        if (this.token_state < 3) {
            if (this.readHeader()) {
                this.token_state = 3;
            } else {
                return false;
            }
        }
        if (this.token_state == 3) {
            String string = this.msg.internalProperties[19];
            if (string != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 > 0) {
                        this.msg.body = new byte[n2];
                        this.bodypos = 0;
                        this.token_state = 4;
                    }
                }
                catch (Exception exception) {
                    throw new ServerError("Mailformed ONS message", this.buffer);
                }
            }
            if (this.token_state != 4) {
                this.token_state = 0;
                return true;
            }
        }
        if (this.token_state == 4) {
            int n3 = Math.min(this.msg.body.length - this.bodypos, this.bend - this.pos);
            System.arraycopy(this.buffer, this.pos, this.msg.body, this.bodypos, n3);
            this.bodypos += n3;
            this.pos += n3;
            if (this.bodypos == this.msg.body.length) {
                this.token_state = 0;
                return true;
            }
        }
        return false;
    }

    private int lineEnd() {
        int n2;
        for (n2 = this.pos; n2 < this.bend && this.buffer[n2] != 13; ++n2) {
        }
        return n2;
    }

    private String tryReadLine() {
        if (this.line_state == 1 && this.pos < this.bend) {
            ++this.pos;
            this.line_state = 0;
        }
        if (this.line_state == 0) {
            this.line = new StringBuilder();
        }
        int n2 = this.lineEnd();
        this.line.append(new String(this.buffer, this.pos, n2 - this.pos, ONSConfiguration.ONS_CHARSET));
        this.pos = n2;
        if (n2 == this.bend) {
            this.line_state = 2;
            return null;
        }
        if (n2 == this.bend - 1) {
            ++this.pos;
            this.line_state = 1;
        } else {
            this.pos += 2;
            this.line_state = 0;
        }
        return this.line.toString();
    }

    private void parse(String string) {
        if (this.token_state == 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", false);
            this.msg.method = stringTokenizer.nextToken();
            this.msg.verb = stringTokenizer.nextToken().substring(1);
            this.token_state = 2;
        } else {
            int n2 = string.indexOf(58);
            if (n2 > 0) {
                this.msg.put(string.substring(0, n2).trim(), string.substring(n2 + 1, string.length()).trim());
            }
        }
    }

    private boolean skipTo(char c2) {
        while (this.pos < this.bend && this.buffer[this.pos] != c2) {
            ++this.pos;
        }
        if (this.pos != this.bend) {
            ++this.pos;
            return true;
        }
        return false;
    }

    private boolean readHeader() {
        String string;
        while (this.pos < this.bend && (string = this.tryReadLine()) != null) {
            if (string.isEmpty()) {
                return true;
            }
            this.parse(string);
        }
        return false;
    }

    public boolean available() {
        return !this.messageList.isEmpty();
    }

    public Notification peek() {
        return this.messageList.peek();
    }

    public Notification remove() {
        return this.messageList.remove();
    }
}

