/*
 * Decompiled with CFR 0.152.
 */
package oracle.ons;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import oracle.ons.Message;
import oracle.ons.MessageReader;

public class MessageReaderTest {
    private final Random random = new Random();

    public static void main(String[] stringArray) {
        new MessageReaderTest().go(Integer.parseInt(stringArray[0]));
    }

    private boolean prob(double d2) {
        return this.random.nextDouble() < d2;
    }

    private String randString(int n2, int n3) {
        int n4;
        StringBuilder stringBuilder = new StringBuilder();
        for (n4 = 0; n4 < n2; ++n4) {
            stringBuilder.append(Character.toChars(this.random.nextInt(27) + 65));
        }
        for (n4 = 0; n4 < n3 && !this.prob(1.0 / (double)n3); ++n4) {
            stringBuilder.append(Character.toChars(this.random.nextInt(27) + 65));
        }
        return stringBuilder.toString();
    }

    private void go(int n2) {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x6500000);
        int n3 = 0;
        System.out.println(String.format("Generating %d messages...", n2));
        try {
            for (int i2 = 0; i2 < n2; ++i2) {
                Message message = this.createMessage();
                if (byteArrayOutputStream.size() > 0x6400000) {
                    System.out.println(String.format("100M (%d) exceeded, new buffer", byteArrayOutputStream.size() / 1024));
                    byteArrayOutputStream.close();
                    n3 += byteArrayOutputStream.size();
                    arrayList.add(byteArrayOutputStream.toByteArray());
                    byteArrayOutputStream = new ByteArrayOutputStream();
                }
                message.send(byteArrayOutputStream);
            }
            byteArrayOutputStream.close();
            arrayList.add(byteArrayOutputStream.toByteArray());
            n3 += byteArrayOutputStream.size();
            byteArrayOutputStream = null;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        MessageReader messageReader = new MessageReader();
        System.out.println("Total length : " + Integer.toString(n3));
        System.out.println("Parsing...");
        int n4 = 0;
        long l2 = System.currentTimeMillis();
        for (byte[] byArray : arrayList) {
            int n5 = 0;
            while (n5 < byArray.length) {
                int n6 = Math.min(this.random.nextInt(8192) + 16384, byArray.length - n5);
                messageReader.feedBuffer(byArray, n5, n6);
                n5 += n6;
                while (messageReader.available()) {
                    messageReader.remove();
                    ++n4;
                }
            }
        }
        long l3 = System.currentTimeMillis();
        double d2 = 0.953674 * ((double)n3 / (double)(l3 - l2)) / 1000.0;
        System.out.println(String.format("Parsed %d messages in %d msec (%f Mb/sec)", n4, (int)(l3 - l2), d2));
    }

    private Message createMessage() {
        Message message = new Message(this.randString(5, 5));
        while (this.prob(0.7)) {
            message.put(this.randString(5, 15), this.randString(2, 20));
        }
        if (this.prob(0.2)) {
            byte[] byArray = new byte[this.random.nextInt(128)];
            this.random.nextBytes(byArray);
            try {
                message.getBodyOutputStream().write(byArray);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        message.ready();
        return message;
    }
}

